# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.patient_external_id import PatientExternalId
from ....commons.types.street_address_short_zip import StreetAddressShortZip
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.superbill_response import SuperbillResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def create_superbill(
        self,
        *,
        patient_external_id: PatientExternalId,
        date_range_min: dt.date,
        date_range_max: dt.date,
        pay_to_address: typing.Optional[StreetAddressShortZip] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuperbillResponse:
        """
        Parameters
        ----------
        patient_external_id : PatientExternalId
            Empty string not allowed

        date_range_min : dt.date
            Minimum (inclusive) date selected for the superbill

        date_range_max : dt.date
            Maximum (inclusive) date selected for the superbill

        pay_to_address : typing.Optional[StreetAddressShortZip]
            Address that will be displayed on the superbill as the 'Pay to' Address. If not provided this value will be set from available encounter data.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuperbillResponse

        Examples
        --------
        import datetime

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.superbills.v_1.create_superbill(
            patient_external_id="patient_external_id",
            date_range_min=datetime.date.fromisoformat(
                "2023-01-15",
            ),
            date_range_max=datetime.date.fromisoformat(
                "2023-01-15",
            ),
        )
        """
        _response = self._raw_client.create_superbill(
            patient_external_id=patient_external_id,
            date_range_min=date_range_min,
            date_range_max=date_range_max,
            pay_to_address=pay_to_address,
            request_options=request_options,
        )
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def create_superbill(
        self,
        *,
        patient_external_id: PatientExternalId,
        date_range_min: dt.date,
        date_range_max: dt.date,
        pay_to_address: typing.Optional[StreetAddressShortZip] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuperbillResponse:
        """
        Parameters
        ----------
        patient_external_id : PatientExternalId
            Empty string not allowed

        date_range_min : dt.date
            Minimum (inclusive) date selected for the superbill

        date_range_max : dt.date
            Maximum (inclusive) date selected for the superbill

        pay_to_address : typing.Optional[StreetAddressShortZip]
            Address that will be displayed on the superbill as the 'Pay to' Address. If not provided this value will be set from available encounter data.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuperbillResponse

        Examples
        --------
        import asyncio
        import datetime

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.superbills.v_1.create_superbill(
                patient_external_id="patient_external_id",
                date_range_min=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
                date_range_max=datetime.date.fromisoformat(
                    "2023-01-15",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_superbill(
            patient_external_id=patient_external_id,
            date_range_min=date_range_min,
            date_range_max=date_range_max,
            pay_to_address=pay_to_address,
            request_options=request_options,
        )
        return _response.data
