# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.unprocessable_entity_error import UnprocessableEntityError
from ....commons.types.patient_external_id import PatientExternalId
from ....commons.types.street_address_short_zip import StreetAddressShortZip
from ....commons.types.unprocessable_entity_error_message import UnprocessableEntityErrorMessage
from .types.superbill_response import SuperbillResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_superbill(
        self,
        *,
        patient_external_id: PatientExternalId,
        date_range_min: dt.date,
        date_range_max: dt.date,
        pay_to_address: typing.Optional[StreetAddressShortZip] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SuperbillResponse]:
        """
        Parameters
        ----------
        patient_external_id : PatientExternalId
            Empty string not allowed

        date_range_min : dt.date
            Minimum (inclusive) date selected for the superbill

        date_range_max : dt.date
            Maximum (inclusive) date selected for the superbill

        pay_to_address : typing.Optional[StreetAddressShortZip]
            Address that will be displayed on the superbill as the 'Pay to' Address. If not provided this value will be set from available encounter data.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SuperbillResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/superbill/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "patient_external_id": patient_external_id,
                "date_range_min": date_range_min,
                "date_range_max": date_range_max,
                "pay_to_address": pay_to_address,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                SuperbillResponse,
                parse_obj_as(
                    type_=SuperbillResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_superbill(
        self,
        *,
        patient_external_id: PatientExternalId,
        date_range_min: dt.date,
        date_range_max: dt.date,
        pay_to_address: typing.Optional[StreetAddressShortZip] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SuperbillResponse]:
        """
        Parameters
        ----------
        patient_external_id : PatientExternalId
            Empty string not allowed

        date_range_min : dt.date
            Minimum (inclusive) date selected for the superbill

        date_range_max : dt.date
            Maximum (inclusive) date selected for the superbill

        pay_to_address : typing.Optional[StreetAddressShortZip]
            Address that will be displayed on the superbill as the 'Pay to' Address. If not provided this value will be set from available encounter data.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SuperbillResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/superbill/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "patient_external_id": patient_external_id,
                "date_range_min": date_range_min,
                "date_range_max": date_range_max,
                "pay_to_address": pay_to_address,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                SuperbillResponse,
                parse_obj_as(
                    type_=SuperbillResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
