# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.patient_external_id import PatientExternalId


class Superbill(UniversalBaseModel):
    superbill_id: str = pydantic.Field()
    """
    Primary id of the superbill.
    """

    patient_external_id: PatientExternalId = pydantic.Field()
    """
    external_id of the patient.
    """

    authed_url: str = pydantic.Field()
    """
    Authenticated URL for downloading the generated superbill file.
    """

    date_range_min: dt.date = pydantic.Field()
    """
    Minimum (inclusive) date selected for this superbill.
    """

    date_range_max: dt.date = pydantic.Field()
    """
    Maximum (inclusive) date selected for this superbill.
    """

    file_name: str = pydantic.Field()
    """
    Original filename of the superbill.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
