# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TaskStatus(str, enum.Enum):
    FINISHED = "finished"
    ADDRESSED_BY_PROVIDER_GROUP = "addressed_by_provider_group"
    SENT_TO_PROVIDER_GROUP = "sent_to_provider_group"
    OPEN_TASK = "open"
    BLOCKED = "blocked"
    WAITING_FOR_REVIEW = "waiting_for_review"
    IN_PROGRESS = "in_progress"
    _UNKNOWN = "__TASKSTATUS_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "TaskStatus":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        finished: typing.Callable[[], T_Result],
        addressed_by_provider_group: typing.Callable[[], T_Result],
        sent_to_provider_group: typing.Callable[[], T_Result],
        open_task: typing.Callable[[], T_Result],
        blocked: typing.Callable[[], T_Result],
        waiting_for_review: typing.Callable[[], T_Result],
        in_progress: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is TaskStatus.FINISHED:
            return finished()
        if self is TaskStatus.ADDRESSED_BY_PROVIDER_GROUP:
            return addressed_by_provider_group()
        if self is TaskStatus.SENT_TO_PROVIDER_GROUP:
            return sent_to_provider_group()
        if self is TaskStatus.OPEN_TASK:
            return open_task()
        if self is TaskStatus.BLOCKED:
            return blocked()
        if self is TaskStatus.WAITING_FOR_REVIEW:
            return waiting_for_review()
        if self is TaskStatus.IN_PROGRESS:
            return in_progress()
        return _unknown_member(self._value_)
