# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TaskType(str, enum.Enum):
    CUSTOMER_DATA_REQUEST = "CUSTOMER_DATA_REQUEST"
    CLAIM_SUBMISSION_RUN_VALIDATIONS_FAILURE = "CLAIM_SUBMISSION_RUN_VALIDATIONS_FAILURE"
    CLAIM_SUBMISSION_SUBMIT_CLAIM_FAILURE = "CLAIM_SUBMISSION_SUBMIT_CLAIM_FAILURE"
    CLAIM_SUBMISSION_TRANSFORM_FAILURE = "CLAIM_SUBMISSION_TRANSFORM_FAILURE"
    CODE_CLAIM = "CODE_CLAIM"
    CODE_CLAIM_REVIEW = "CODE_CLAIM_REVIEW"
    ELIGIBILITY = "ELIGIBILITY"
    CLAIM_FOLLOW_UP = "CLAIM_FOLLOW_UP"
    REJECTION_RESOLUTION = "REJECTION_RESOLUTION"
    PAYER_CONFIGURATION_ERROR = "PAYER_CONFIGURATION_ERROR"
    DENIAL_RESOLUTION = "DENIAL_RESOLUTION"
    MISSING_ENROLLMENT = "MISSING_ENROLLMENT"
    _UNKNOWN = "__TASKTYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "TaskType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        customer_data_request: typing.Callable[[], T_Result],
        claim_submission_run_validations_failure: typing.Callable[[], T_Result],
        claim_submission_submit_claim_failure: typing.Callable[[], T_Result],
        claim_submission_transform_failure: typing.Callable[[], T_Result],
        code_claim: typing.Callable[[], T_Result],
        code_claim_review: typing.Callable[[], T_Result],
        eligibility: typing.Callable[[], T_Result],
        claim_follow_up: typing.Callable[[], T_Result],
        rejection_resolution: typing.Callable[[], T_Result],
        payer_configuration_error: typing.Callable[[], T_Result],
        denial_resolution: typing.Callable[[], T_Result],
        missing_enrollment: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is TaskType.CUSTOMER_DATA_REQUEST:
            return customer_data_request()
        if self is TaskType.CLAIM_SUBMISSION_RUN_VALIDATIONS_FAILURE:
            return claim_submission_run_validations_failure()
        if self is TaskType.CLAIM_SUBMISSION_SUBMIT_CLAIM_FAILURE:
            return claim_submission_submit_claim_failure()
        if self is TaskType.CLAIM_SUBMISSION_TRANSFORM_FAILURE:
            return claim_submission_transform_failure()
        if self is TaskType.CODE_CLAIM:
            return code_claim()
        if self is TaskType.CODE_CLAIM_REVIEW:
            return code_claim_review()
        if self is TaskType.ELIGIBILITY:
            return eligibility()
        if self is TaskType.CLAIM_FOLLOW_UP:
            return claim_follow_up()
        if self is TaskType.REJECTION_RESOLUTION:
            return rejection_resolution()
        if self is TaskType.PAYER_CONFIGURATION_ERROR:
            return payer_configuration_error()
        if self is TaskType.DENIAL_RESOLUTION:
            return denial_resolution()
        if self is TaskType.MISSING_ENROLLMENT:
            return missing_enrollment()
        return _unknown_member(self._value_)
