# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.encounter_id import EncounterId
from .....commons.types.task_id import TaskId
from .....pipeline_commons.types.configurable_rule_id import ConfigurableRuleId
from ...commons.types.task_category import TaskCategory
from ...commons.types.task_status import TaskStatus
from ...commons.types.task_type import TaskType
from .task_assignment import TaskAssignment
from .task_note import TaskNote


class Task(UniversalBaseModel):
    task_id: TaskId
    encounter_id: EncounterId
    task_type: TaskType
    description: str
    blocks_claim_submission: bool
    external_id: str
    patient_name: str
    patient_external_id: str
    payer_name: typing.Optional[str] = None
    payer_id: typing.Optional[str] = None
    status: TaskStatus
    notes: typing.List[TaskNote]
    created_at: dt.datetime
    updated_at: dt.datetime = pydantic.Field()
    """
    The time of most recent update to the task only
    """

    agg_updated_at: dt.datetime = pydantic.Field()
    """
    The time of most recent update to the task or any of its notes
    """

    date_of_service: dt.date
    assignments: typing.List[TaskAssignment]
    category: typing.Optional[TaskCategory] = None
    configurable_rule_id: typing.Optional[ConfigurableRuleId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
