# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.adjustment_id import AdjustmentId
from ....commons.types.claim_id import ClaimId
from ....commons.types.page_token import PageToken
from ....commons.types.patient_external_id import PatientExternalId
from ....commons.types.provider_id import ProviderId
from ....commons.types.service_line_id import ServiceLineId
from ....commons.types.sort_direction import SortDirection
from ....financials.types.account_type import AccountType
from ....payers.resources.v_3.types.payer_uuid import PayerUuid
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.create_write_offs_response import CreateWriteOffsResponse
from .types.write_off import WriteOff
from .types.write_off_create import WriteOffCreate
from .types.write_off_id import WriteOffId
from .types.write_off_sort_field import WriteOffSortField
from .types.write_offs_page import WriteOffsPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        claim_id: typing.Optional[ClaimId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        sort: typing.Optional[WriteOffSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        account_types: typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WriteOffsPage:
        """
        Returns all write-offs satisfying the search criteria.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        patient_external_id : typing.Optional[PatientExternalId]

        payer_uuid : typing.Optional[PayerUuid]

        service_line_id : typing.Optional[ServiceLineId]

        claim_id : typing.Optional[ClaimId]

        billing_provider_id : typing.Optional[ProviderId]

        sort : typing.Optional[WriteOffSortField]
            Defaults to write_off_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        account_types : typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]]
            Filters the returned values to include only the provided account types.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOffsPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.write_offs.v_1.get_multi()
        """
        _response = self._raw_client.get_multi(
            limit=limit,
            patient_external_id=patient_external_id,
            payer_uuid=payer_uuid,
            service_line_id=service_line_id,
            claim_id=claim_id,
            billing_provider_id=billing_provider_id,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            account_types=account_types,
            request_options=request_options,
        )
        return _response.data

    def get(self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None) -> WriteOff:
        """
        Retrieves a previously created write off by its `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOff

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.write_offs.v_1.get(
            write_off_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(write_off_id, request_options=request_options)
        return _response.data

    def create(
        self, *, write_offs: typing.Sequence[WriteOffCreate], request_options: typing.Optional[RequestOptions] = None
    ) -> CreateWriteOffsResponse:
        """
        Creates one or many write-offs applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        write_offs : typing.Sequence[WriteOffCreate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWriteOffsResponse

        Examples
        --------
        import datetime
        import uuid

        from candid import CandidApiClient
        from candid.resources.write_offs.resources.v_1 import (
            PatientWriteOffReason,
            WriteOffCreate_Patient,
        )

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.write_offs.v_1.create(
            write_offs=[
                WriteOffCreate_Patient(
                    write_off_timestamp=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    write_off_reason=PatientWriteOffReason.SMALL_BALANCE,
                    service_line_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    amount_cents=1,
                ),
                WriteOffCreate_Patient(
                    write_off_timestamp=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    write_off_reason=PatientWriteOffReason.SMALL_BALANCE,
                    service_line_id=uuid.UUID(
                        "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                    ),
                    amount_cents=1,
                ),
            ],
        )
        """
        _response = self._raw_client.create(write_offs=write_offs, request_options=request_options)
        return _response.data

    def revert(self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None) -> WriteOff:
        """
        Reverts a write off given a `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOff

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.write_offs.v_1.revert(
            write_off_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.revert(write_off_id, request_options=request_options)
        return _response.data

    def revert_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WriteOff:
        """
        Reverts an Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOff

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.write_offs.v_1.revert_insurance_balance_adjustment(
            adjustment_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.revert_insurance_balance_adjustment(adjustment_id, request_options=request_options)
        return _response.data

    def revert_era_originated_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AdjustmentId:
        """
        Reverts an ERA-originated Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AdjustmentId

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.write_offs.v_1.revert_era_originated_insurance_balance_adjustment(
            adjustment_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.revert_era_originated_insurance_balance_adjustment(
            adjustment_id, request_options=request_options
        )
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        claim_id: typing.Optional[ClaimId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        sort: typing.Optional[WriteOffSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        account_types: typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WriteOffsPage:
        """
        Returns all write-offs satisfying the search criteria.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        patient_external_id : typing.Optional[PatientExternalId]

        payer_uuid : typing.Optional[PayerUuid]

        service_line_id : typing.Optional[ServiceLineId]

        claim_id : typing.Optional[ClaimId]

        billing_provider_id : typing.Optional[ProviderId]

        sort : typing.Optional[WriteOffSortField]
            Defaults to write_off_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        account_types : typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]]
            Filters the returned values to include only the provided account types.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOffsPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.write_offs.v_1.get_multi()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_multi(
            limit=limit,
            patient_external_id=patient_external_id,
            payer_uuid=payer_uuid,
            service_line_id=service_line_id,
            claim_id=claim_id,
            billing_provider_id=billing_provider_id,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            account_types=account_types,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WriteOff:
        """
        Retrieves a previously created write off by its `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOff

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.write_offs.v_1.get(
                write_off_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(write_off_id, request_options=request_options)
        return _response.data

    async def create(
        self, *, write_offs: typing.Sequence[WriteOffCreate], request_options: typing.Optional[RequestOptions] = None
    ) -> CreateWriteOffsResponse:
        """
        Creates one or many write-offs applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        write_offs : typing.Sequence[WriteOffCreate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWriteOffsResponse

        Examples
        --------
        import asyncio
        import datetime
        import uuid

        from candid import AsyncCandidApiClient
        from candid.resources.write_offs.resources.v_1 import (
            PatientWriteOffReason,
            WriteOffCreate_Patient,
        )

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.write_offs.v_1.create(
                write_offs=[
                    WriteOffCreate_Patient(
                        write_off_timestamp=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        write_off_reason=PatientWriteOffReason.SMALL_BALANCE,
                        service_line_id=uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        amount_cents=1,
                    ),
                    WriteOffCreate_Patient(
                        write_off_timestamp=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        write_off_reason=PatientWriteOffReason.SMALL_BALANCE,
                        service_line_id=uuid.UUID(
                            "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                        ),
                        amount_cents=1,
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(write_offs=write_offs, request_options=request_options)
        return _response.data

    async def revert(
        self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WriteOff:
        """
        Reverts a write off given a `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOff

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.write_offs.v_1.revert(
                write_off_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revert(write_off_id, request_options=request_options)
        return _response.data

    async def revert_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WriteOff:
        """
        Reverts an Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WriteOff

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.write_offs.v_1.revert_insurance_balance_adjustment(
                adjustment_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revert_insurance_balance_adjustment(
            adjustment_id, request_options=request_options
        )
        return _response.data

    async def revert_era_originated_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AdjustmentId:
        """
        Reverts an ERA-originated Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AdjustmentId

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.write_offs.v_1.revert_era_originated_insurance_balance_adjustment(
                adjustment_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.revert_era_originated_insurance_balance_adjustment(
            adjustment_id, request_options=request_options
        )
        return _response.data
