# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.types.adjustment_id import AdjustmentId
from ....commons.types.claim_id import ClaimId
from ....commons.types.page_token import PageToken
from ....commons.types.patient_external_id import PatientExternalId
from ....commons.types.provider_id import ProviderId
from ....commons.types.service_line_id import ServiceLineId
from ....commons.types.sort_direction import SortDirection
from ....financials.types.account_type import AccountType
from ....payers.resources.v_3.types.payer_uuid import PayerUuid
from .types.create_write_offs_response import CreateWriteOffsResponse
from .types.write_off import WriteOff
from .types.write_off_create import WriteOffCreate
from .types.write_off_id import WriteOffId
from .types.write_off_sort_field import WriteOffSortField
from .types.write_offs_page import WriteOffsPage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        claim_id: typing.Optional[ClaimId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        sort: typing.Optional[WriteOffSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        account_types: typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WriteOffsPage]:
        """
        Returns all write-offs satisfying the search criteria.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        patient_external_id : typing.Optional[PatientExternalId]

        payer_uuid : typing.Optional[PayerUuid]

        service_line_id : typing.Optional[ServiceLineId]

        claim_id : typing.Optional[ClaimId]

        billing_provider_id : typing.Optional[ProviderId]

        sort : typing.Optional[WriteOffSortField]
            Defaults to write_off_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        account_types : typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]]
            Filters the returned values to include only the provided account types.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WriteOffsPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/write-offs/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "patient_external_id": patient_external_id,
                "payer_uuid": payer_uuid,
                "service_line_id": service_line_id,
                "claim_id": claim_id,
                "billing_provider_id": billing_provider_id,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
                "account_types": account_types,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOffsPage,
                parse_obj_as(
                    type_=WriteOffsPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WriteOff]:
        """
        Retrieves a previously created write off by its `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WriteOff]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(write_off_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOff,
                parse_obj_as(
                    type_=WriteOff,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self, *, write_offs: typing.Sequence[WriteOffCreate], request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CreateWriteOffsResponse]:
        """
        Creates one or many write-offs applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        write_offs : typing.Sequence[WriteOffCreate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateWriteOffsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/write-offs/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "write_offs": write_offs,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                CreateWriteOffsResponse,
                parse_obj_as(
                    type_=CreateWriteOffsResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def revert(
        self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WriteOff]:
        """
        Reverts a write off given a `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WriteOff]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(write_off_id)}/revert",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOff,
                parse_obj_as(
                    type_=WriteOff,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def revert_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WriteOff]:
        """
        Reverts an Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WriteOff]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(adjustment_id)}/revert",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOff,
                parse_obj_as(
                    type_=WriteOff,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def revert_era_originated_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[AdjustmentId]:
        """
        Reverts an ERA-originated Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AdjustmentId]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(adjustment_id)}/revert-era-originated",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                AdjustmentId,
                parse_obj_as(
                    type_=AdjustmentId,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_multi(
        self,
        *,
        limit: typing.Optional[int] = None,
        patient_external_id: typing.Optional[PatientExternalId] = None,
        payer_uuid: typing.Optional[PayerUuid] = None,
        service_line_id: typing.Optional[ServiceLineId] = None,
        claim_id: typing.Optional[ClaimId] = None,
        billing_provider_id: typing.Optional[ProviderId] = None,
        sort: typing.Optional[WriteOffSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        account_types: typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WriteOffsPage]:
        """
        Returns all write-offs satisfying the search criteria.

        Parameters
        ----------
        limit : typing.Optional[int]
            Defaults to 100. The value must be greater than 0 and less than 1000.

        patient_external_id : typing.Optional[PatientExternalId]

        payer_uuid : typing.Optional[PayerUuid]

        service_line_id : typing.Optional[ServiceLineId]

        claim_id : typing.Optional[ClaimId]

        billing_provider_id : typing.Optional[ProviderId]

        sort : typing.Optional[WriteOffSortField]
            Defaults to write_off_timestamp

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        account_types : typing.Optional[typing.Union[AccountType, typing.Sequence[AccountType]]]
            Filters the returned values to include only the provided account types.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WriteOffsPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/write-offs/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "patient_external_id": patient_external_id,
                "payer_uuid": payer_uuid,
                "service_line_id": service_line_id,
                "claim_id": claim_id,
                "billing_provider_id": billing_provider_id,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
                "account_types": account_types,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOffsPage,
                parse_obj_as(
                    type_=WriteOffsPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WriteOff]:
        """
        Retrieves a previously created write off by its `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WriteOff]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(write_off_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOff,
                parse_obj_as(
                    type_=WriteOff,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self, *, write_offs: typing.Sequence[WriteOffCreate], request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CreateWriteOffsResponse]:
        """
        Creates one or many write-offs applied toward a specific service line,
        claim, or billing provider.

        Parameters
        ----------
        write_offs : typing.Sequence[WriteOffCreate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateWriteOffsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/write-offs/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "write_offs": write_offs,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                CreateWriteOffsResponse,
                parse_obj_as(
                    type_=CreateWriteOffsResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def revert(
        self, write_off_id: WriteOffId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WriteOff]:
        """
        Reverts a write off given a `write_off_id`.

        Parameters
        ----------
        write_off_id : WriteOffId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WriteOff]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(write_off_id)}/revert",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOff,
                parse_obj_as(
                    type_=WriteOff,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def revert_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WriteOff]:
        """
        Reverts an Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WriteOff]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(adjustment_id)}/revert",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                WriteOff,
                parse_obj_as(
                    type_=WriteOff,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def revert_era_originated_insurance_balance_adjustment(
        self, adjustment_id: AdjustmentId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[AdjustmentId]:
        """
        Reverts an ERA-originated Insurance Balance Adjustment given an `adjustment_id`

        Parameters
        ----------
        adjustment_id : AdjustmentId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AdjustmentId]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/write-offs/v1/{jsonable_encoder(adjustment_id)}/revert-era-originated",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                AdjustmentId,
                parse_obj_as(
                    type_=AdjustmentId,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
