# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class PatientWriteOffReason(str, enum.Enum):
    SMALL_BALANCE = "SMALL_BALANCE"
    CHARITY_OR_FINANCIAL_ASSISTANCE = "CHARITY_OR_FINANCIAL_ASSISTANCE"
    PATIENT_EXPERIENCE_OR_SERVICE_RECOVERY = "PATIENT_EXPERIENCE_OR_SERVICE_RECOVERY"
    OON_COURTESY_ADJUSTMENT = "OON_COURTESY_ADJUSTMENT"
    PROMPT_PAY_DISCOUNT = "PROMPT_PAY_DISCOUNT"
    BAD_DEBT = "BAD_DEBT"
    COLLECTION_AGENCY = "COLLECTION_AGENCY"
    OTHER = "OTHER"
    UNKNOWN = "UNKNOWN"
    UNCOLLECTIBLE_OR_NON_BILLABLE = "UNCOLLECTIBLE_OR_NON_BILLABLE"
    DECEASED = "DECEASED"
    BANKRUPTCY = "BANKRUPTCY"
    _UNKNOWN = "__PATIENTWRITEOFFREASON_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "PatientWriteOffReason":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        small_balance: typing.Callable[[], T_Result],
        charity_or_financial_assistance: typing.Callable[[], T_Result],
        patient_experience_or_service_recovery: typing.Callable[[], T_Result],
        oon_courtesy_adjustment: typing.Callable[[], T_Result],
        prompt_pay_discount: typing.Callable[[], T_Result],
        bad_debt: typing.Callable[[], T_Result],
        collection_agency: typing.Callable[[], T_Result],
        other: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
        uncollectible_or_non_billable: typing.Callable[[], T_Result],
        deceased: typing.Callable[[], T_Result],
        bankruptcy: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is PatientWriteOffReason.SMALL_BALANCE:
            return small_balance()
        if self is PatientWriteOffReason.CHARITY_OR_FINANCIAL_ASSISTANCE:
            return charity_or_financial_assistance()
        if self is PatientWriteOffReason.PATIENT_EXPERIENCE_OR_SERVICE_RECOVERY:
            return patient_experience_or_service_recovery()
        if self is PatientWriteOffReason.OON_COURTESY_ADJUSTMENT:
            return oon_courtesy_adjustment()
        if self is PatientWriteOffReason.PROMPT_PAY_DISCOUNT:
            return prompt_pay_discount()
        if self is PatientWriteOffReason.BAD_DEBT:
            return bad_debt()
        if self is PatientWriteOffReason.COLLECTION_AGENCY:
            return collection_agency()
        if self is PatientWriteOffReason.OTHER:
            return other()
        if self is PatientWriteOffReason.UNKNOWN:
            return unknown()
        if self is PatientWriteOffReason.UNCOLLECTIBLE_OR_NON_BILLABLE:
            return uncollectible_or_non_billable()
        if self is PatientWriteOffReason.DECEASED:
            return deceased()
        if self is PatientWriteOffReason.BANKRUPTCY:
            return bankruptcy()
        return _unknown_member(self._value_)
