# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.claim_id import ClaimId
from .....commons.types.patient_external_id import PatientExternalId
from .....commons.types.service_line_id import ServiceLineId
from .....non_insurance_payers.resources.v_1.types.non_insurance_payer import NonInsurancePayer
from .....payers.resources.v_3.types.payer import Payer
from .insurance_write_off_reason import InsuranceWriteOffReason
from .insurance_write_off_target import InsuranceWriteOffTarget
from .patient_write_off_reason import PatientWriteOffReason
from .write_off_id import WriteOffId


class WriteOff_Patient(UniversalBaseModel):
    type: typing.Literal["patient"] = "patient"
    write_off_id: WriteOffId
    write_off_timestamp: dt.datetime
    write_off_note: typing.Optional[str] = None
    write_off_reason: PatientWriteOffReason
    patient_external_id: PatientExternalId
    claim_id: ClaimId
    service_line_id: ServiceLineId
    reverts_write_off_id: typing.Optional[WriteOffId] = None
    reverted_by_write_off_id: typing.Optional[WriteOffId] = None
    amount_cents: int

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WriteOff_Insurance(UniversalBaseModel):
    type: typing.Literal["insurance"] = "insurance"
    write_off_id: WriteOffId
    payer: Payer
    write_off_target: InsuranceWriteOffTarget
    write_off_timestamp: dt.datetime
    write_off_note: typing.Optional[str] = None
    write_off_reason: InsuranceWriteOffReason
    reverts_write_off_id: typing.Optional[WriteOffId] = None
    reverted_by_write_off_id: typing.Optional[WriteOffId] = None
    amount_cents: int

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WriteOff_NonInsurancePayer(UniversalBaseModel):
    type: typing.Literal["non_insurance_payer"] = "non_insurance_payer"
    write_off_id: WriteOffId
    non_insurance_payer: NonInsurancePayer
    service_line_id: ServiceLineId
    write_off_timestamp: dt.datetime
    write_off_note: typing.Optional[str] = None
    write_off_reason: InsuranceWriteOffReason
    reverts_write_off_id: typing.Optional[WriteOffId] = None
    reverted_by_write_off_id: typing.Optional[WriteOffId] = None
    amount_cents: int

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


WriteOff = typing.Union[WriteOff_Patient, WriteOff_Insurance, WriteOff_NonInsurancePayer]
