# finbourne-access-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.2955
- Package version: 0.0.2955
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import finbourne_access
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import finbourne_access
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import finbourne_access
from finbourne_access.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://fbn-ci.lusid.com/access
# See configuration.py for a list of all supported configuration parameters.
configuration = finbourne_access.Configuration(
    host = "https://fbn-ci.lusid.com/access"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oauth2
configuration = finbourne_access.Configuration(
    host = "https://fbn-ci.lusid.com/access"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with finbourne_access.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = finbourne_access.ApplicationMetadataApi(api_client)
    
    try:
        # [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
        api_response = api_instance.list_access_controlled_resources()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationMetadataApi->list_access_controlled_resources: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-ci.lusid.com/access*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
*PoliciesApi* | [**add_to_policy_collection**](docs/PoliciesApi.md#add_to_policy_collection) | **POST** /api/policycollections/{code}/add | [EARLY ACCESS] AddToPolicyCollection: Add To PolicyCollection
*PoliciesApi* | [**create_policy**](docs/PoliciesApi.md#create_policy) | **POST** /api/policies | [EARLY ACCESS] CreatePolicy: Create Policy
*PoliciesApi* | [**create_policy_collection**](docs/PoliciesApi.md#create_policy_collection) | **POST** /api/policycollections | [EARLY ACCESS] CreatePolicyCollection: Create PolicyCollection
*PoliciesApi* | [**delete_policy**](docs/PoliciesApi.md#delete_policy) | **DELETE** /api/policies/{code} | [EARLY ACCESS] DeletePolicy: Delete Policy
*PoliciesApi* | [**delete_policy_collection**](docs/PoliciesApi.md#delete_policy_collection) | **DELETE** /api/policycollections/{code} | [EARLY ACCESS] DeletePolicyCollection: Delete PolicyCollection
*PoliciesApi* | [**evaluate**](docs/PoliciesApi.md#evaluate) | **POST** /api/me | [EARLY ACCESS] Evaluate: Run one or more evaluations
*PoliciesApi* | [**get_own_policies**](docs/PoliciesApi.md#get_own_policies) | **GET** /api/me | GetOwnPolicies: Get policies of requesting user
*PoliciesApi* | [**get_policy**](docs/PoliciesApi.md#get_policy) | **GET** /api/policies/{code} | [EARLY ACCESS] GetPolicy: Get Policy
*PoliciesApi* | [**get_policy_collection**](docs/PoliciesApi.md#get_policy_collection) | **GET** /api/policycollections/{code} | [EARLY ACCESS] GetPolicyCollection: Get PolicyCollection
*PoliciesApi* | [**list_policies**](docs/PoliciesApi.md#list_policies) | **GET** /api/policies | [EARLY ACCESS] ListPolicies: List Policies
*PoliciesApi* | [**list_policy_collections**](docs/PoliciesApi.md#list_policy_collections) | **GET** /api/policycollections | [EARLY ACCESS] ListPolicyCollections: List PolicyCollections
*PoliciesApi* | [**page_policies**](docs/PoliciesApi.md#page_policies) | **GET** /api/policies/page | [EARLY ACCESS] PagePolicies: Page Policies
*PoliciesApi* | [**page_policy_collections**](docs/PoliciesApi.md#page_policy_collections) | **GET** /api/policycollections/page | [EARLY ACCESS] PagePolicyCollections: Page PolicyCollections
*PoliciesApi* | [**remove_from_policy_collection**](docs/PoliciesApi.md#remove_from_policy_collection) | **POST** /api/policycollections/{code}/remove | [EARLY ACCESS] RemoveFromPolicyCollection: Remove From PolicyCollection
*PoliciesApi* | [**update_policy**](docs/PoliciesApi.md#update_policy) | **PUT** /api/policies/{code} | [EARLY ACCESS] UpdatePolicy: Update Policy
*PoliciesApi* | [**update_policy_collection**](docs/PoliciesApi.md#update_policy_collection) | **PUT** /api/policycollections/{code} | [EARLY ACCESS] UpdatePolicyCollection: Update PolicyCollection
*RolesApi* | [**add_policy_collection_to_role**](docs/RolesApi.md#add_policy_collection_to_role) | **POST** /api/roles/{scope}/{code}/policycollections | [EARLY ACCESS] AddPolicyCollectionToRole: Add policy collections to a role
*RolesApi* | [**create_role**](docs/RolesApi.md#create_role) | **POST** /api/roles | [EARLY ACCESS] CreateRole: Create Role
*RolesApi* | [**delete_role**](docs/RolesApi.md#delete_role) | **DELETE** /api/roles/{code} | [EARLY ACCESS] DeleteRole: Delete Role
*RolesApi* | [**get_role**](docs/RolesApi.md#get_role) | **GET** /api/roles/{code} | [EARLY ACCESS] GetRole: Get Role
*RolesApi* | [**list_roles**](docs/RolesApi.md#list_roles) | **GET** /api/roles | [EARLY ACCESS] ListRoles: List Roles
*RolesApi* | [**remove_policy_collection_from_role**](docs/RolesApi.md#remove_policy_collection_from_role) | **DELETE** /api/roles/{scope}/{code}/policycollections/{policycollectionscope}/{policycollectioncode} | [EARLY ACCESS] RemovePolicyCollectionFromRole: Remove policy collection from role
*RolesApi* | [**update_role**](docs/RolesApi.md#update_role) | **PUT** /api/roles/{code} | [EARLY ACCESS] UpdateRole: Update Role
*UserRolesApi* | [**add_policy_collection_to_user_role**](docs/UserRolesApi.md#add_policy_collection_to_user_role) | **POST** /api/userroles/{userid}/policycollections | [EXPERIMENTAL] AddPolicyCollectionToUserRole: Add a policy collection to a user-role
*UserRolesApi* | [**add_policy_to_user_role**](docs/UserRolesApi.md#add_policy_to_user_role) | **POST** /api/userroles/{userid}/policies | [EXPERIMENTAL] AddPolicyToUserRole: Add a policy to a user-role
*UserRolesApi* | [**create_user_role**](docs/UserRolesApi.md#create_user_role) | **POST** /api/userroles | [EXPERIMENTAL] CreateUserRole: Create a user-role
*UserRolesApi* | [**delete_user_role**](docs/UserRolesApi.md#delete_user_role) | **DELETE** /api/userroles/{userid} | [EXPERIMENTAL] DeleteUserRole: Delete a user-role
*UserRolesApi* | [**get_user_role**](docs/UserRolesApi.md#get_user_role) | **GET** /api/userroles/{userid} | [EXPERIMENTAL] GetUserRole: Get a user-role
*UserRolesApi* | [**list_user_roles**](docs/UserRolesApi.md#list_user_roles) | **GET** /api/userroles | [EXPERIMENTAL] ListUserRoles: List user-roles
*UserRolesApi* | [**remove_policy_collection_from_user_role**](docs/UserRolesApi.md#remove_policy_collection_from_user_role) | **DELETE** /api/userroles/{userid}/policycollections/{policyCollectionScope}/{policyCollectionCode} | [EXPERIMENTAL] RemovePolicyCollectionFromUserRole: Remove a policy collection from a user-role
*UserRolesApi* | [**remove_policy_from_user_role**](docs/UserRolesApi.md#remove_policy_from_user_role) | **DELETE** /api/userroles/{userid}/policies/{policyScope}/{policyCode} | [EXPERIMENTAL] RemovePolicyFromUserRole: Remove a policy from a user-role
*UserRolesApi* | [**update_user_role**](docs/UserRolesApi.md#update_user_role) | **POST** /api/userroles/{userid}/update | [EXPERIMENTAL] UpdateUserRole: Update a user-role


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [ActionId](docs/ActionId.md)
 - [AddPolicyCollectionToRoleRequest](docs/AddPolicyCollectionToRoleRequest.md)
 - [AddPolicyToRoleRequest](docs/AddPolicyToRoleRequest.md)
 - [AddToPolicyCollectionRequest](docs/AddToPolicyCollectionRequest.md)
 - [AsAtPredicateContract](docs/AsAtPredicateContract.md)
 - [AsAtRangeForSpec](docs/AsAtRangeForSpec.md)
 - [AsAtRelative](docs/AsAtRelative.md)
 - [AttachedPolicyDefinitionResponse](docs/AttachedPolicyDefinitionResponse.md)
 - [DateQuality](docs/DateQuality.md)
 - [DateUnit](docs/DateUnit.md)
 - [EffectiveDateHasQuality](docs/EffectiveDateHasQuality.md)
 - [EffectiveDateRelative](docs/EffectiveDateRelative.md)
 - [EffectiveRange](docs/EffectiveRange.md)
 - [EntitlementMetadata](docs/EntitlementMetadata.md)
 - [EvaluationRequest](docs/EvaluationRequest.md)
 - [EvaluationResponse](docs/EvaluationResponse.md)
 - [EvaluationResult](docs/EvaluationResult.md)
 - [ForSpec](docs/ForSpec.md)
 - [Grant](docs/Grant.md)
 - [HowSpec](docs/HowSpec.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [IfExpression](docs/IfExpression.md)
 - [IfFeatureChainExpression](docs/IfFeatureChainExpression.md)
 - [IfIdentityClaimExpression](docs/IfIdentityClaimExpression.md)
 - [IfIdentityScopeExpression](docs/IfIdentityScopeExpression.md)
 - [IfRequestHeaderExpression](docs/IfRequestHeaderExpression.md)
 - [KeyValuePairOfStringToString](docs/KeyValuePairOfStringToString.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [MatchAllSelectorDefinition](docs/MatchAllSelectorDefinition.md)
 - [MetadataExpression](docs/MetadataExpression.md)
 - [MetadataSelectorDefinition](docs/MetadataSelectorDefinition.md)
 - [NonTransitiveSupervisorRoleResource](docs/NonTransitiveSupervisorRoleResource.md)
 - [Operator](docs/Operator.md)
 - [PointInTimeSpecification](docs/PointInTimeSpecification.md)
 - [PolicyCollectionCreationRequest](docs/PolicyCollectionCreationRequest.md)
 - [PolicyCollectionId](docs/PolicyCollectionId.md)
 - [PolicyCollectionResponse](docs/PolicyCollectionResponse.md)
 - [PolicyCollectionUpdateRequest](docs/PolicyCollectionUpdateRequest.md)
 - [PolicyCreationRequest](docs/PolicyCreationRequest.md)
 - [PolicyId](docs/PolicyId.md)
 - [PolicyIdRoleResource](docs/PolicyIdRoleResource.md)
 - [PolicyResponse](docs/PolicyResponse.md)
 - [PolicySelectorDefinition](docs/PolicySelectorDefinition.md)
 - [PolicyType](docs/PolicyType.md)
 - [PolicyUpdateRequest](docs/PolicyUpdateRequest.md)
 - [RelativeToDateTime](docs/RelativeToDateTime.md)
 - [RemoveFromPolicyCollectionRequest](docs/RemoveFromPolicyCollectionRequest.md)
 - [RequestDetails](docs/RequestDetails.md)
 - [RequestedActionKey](docs/RequestedActionKey.md)
 - [ResourceDetails](docs/ResourceDetails.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [ResourceListOfPolicyCollectionResponse](docs/ResourceListOfPolicyCollectionResponse.md)
 - [ResourceListOfPolicyResponse](docs/ResourceListOfPolicyResponse.md)
 - [ResourceListOfUserRoleResponse](docs/ResourceListOfUserRoleResponse.md)
 - [RoleCreationRequest](docs/RoleCreationRequest.md)
 - [RoleId](docs/RoleId.md)
 - [RoleResourceRequest](docs/RoleResourceRequest.md)
 - [RoleResponse](docs/RoleResponse.md)
 - [RoleUpdateRequest](docs/RoleUpdateRequest.md)
 - [SelectorDefinition](docs/SelectorDefinition.md)
 - [TextOperator](docs/TextOperator.md)
 - [UserRoleCreationRequest](docs/UserRoleCreationRequest.md)
 - [UserRoleResponse](docs/UserRoleResponse.md)
 - [UserRoleUpdateRequest](docs/UserRoleUpdateRequest.md)
 - [WhenSpec](docs/WhenSpec.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


