# coding: utf-8

"""
    FINBOURNE Access Management API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.0.2955
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from finbourne_access.api_client import ApiClient
from finbourne_access.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from finbourne_access.models.add_to_policy_collection_request import AddToPolicyCollectionRequest
from finbourne_access.models.attached_policy_definition_response import AttachedPolicyDefinitionResponse
from finbourne_access.models.evaluation_request import EvaluationRequest
from finbourne_access.models.evaluation_response import EvaluationResponse
from finbourne_access.models.lusid_problem_details import LusidProblemDetails
from finbourne_access.models.lusid_validation_problem_details import LusidValidationProblemDetails
from finbourne_access.models.policy_collection_creation_request import PolicyCollectionCreationRequest
from finbourne_access.models.policy_collection_response import PolicyCollectionResponse
from finbourne_access.models.policy_collection_update_request import PolicyCollectionUpdateRequest
from finbourne_access.models.policy_creation_request import PolicyCreationRequest
from finbourne_access.models.policy_response import PolicyResponse
from finbourne_access.models.policy_update_request import PolicyUpdateRequest
from finbourne_access.models.remove_from_policy_collection_request import RemoveFromPolicyCollectionRequest
from finbourne_access.models.resource_list_of_policy_collection_response import ResourceListOfPolicyCollectionResponse
from finbourne_access.models.resource_list_of_policy_response import ResourceListOfPolicyResponse


class PoliciesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_to_policy_collection(self, code, add_to_policy_collection_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] AddToPolicyCollection: Add To PolicyCollection  # noqa: E501

        Add Policies and/or PolicyCollections to a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_to_policy_collection(code, add_to_policy_collection_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param add_to_policy_collection_request: Ids of the PolicyCollections and/or Policies to add to the PolicyCollection (required)
        :type add_to_policy_collection_request: AddToPolicyCollectionRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyCollectionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.add_to_policy_collection_with_http_info(code, add_to_policy_collection_request, **kwargs)  # noqa: E501

    def add_to_policy_collection_with_http_info(self, code, add_to_policy_collection_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] AddToPolicyCollection: Add To PolicyCollection  # noqa: E501

        Add Policies and/or PolicyCollections to a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_to_policy_collection_with_http_info(code, add_to_policy_collection_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param add_to_policy_collection_request: Ids of the PolicyCollections and/or Policies to add to the PolicyCollection (required)
        :type add_to_policy_collection_request: AddToPolicyCollectionRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyCollectionResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'add_to_policy_collection_request',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_to_policy_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `add_to_policy_collection`")  # noqa: E501
        # verify the required parameter 'add_to_policy_collection_request' is set
        if self.api_client.client_side_validation and ('add_to_policy_collection_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_to_policy_collection_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_to_policy_collection_request` when calling `add_to_policy_collection`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `add_to_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `add_to_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_to_policy_collection_request' in local_var_params:
            body_params = local_var_params['add_to_policy_collection_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PolicyCollectionResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections/{code}/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_policy(self, policy_creation_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] CreatePolicy: Create Policy  # noqa: E501

        Creates a Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_policy(policy_creation_request, async_req=True)
        >>> result = thread.get()

        :param policy_creation_request: The definition of the Policy (required)
        :type policy_creation_request: PolicyCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_policy_with_http_info(policy_creation_request, **kwargs)  # noqa: E501

    def create_policy_with_http_info(self, policy_creation_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] CreatePolicy: Create Policy  # noqa: E501

        Creates a Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_policy_with_http_info(policy_creation_request, async_req=True)
        >>> result = thread.get()

        :param policy_creation_request: The definition of the Policy (required)
        :type policy_creation_request: PolicyCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'policy_creation_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_creation_request' is set
        if self.api_client.client_side_validation and ('policy_creation_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_creation_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_creation_request` when calling `create_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy_creation_request' in local_var_params:
            body_params = local_var_params['policy_creation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "PolicyResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_policy_collection(self, policy_collection_creation_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] CreatePolicyCollection: Create PolicyCollection  # noqa: E501

        Creates a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_policy_collection(policy_collection_creation_request, async_req=True)
        >>> result = thread.get()

        :param policy_collection_creation_request: The definition of the PolicyCollection (required)
        :type policy_collection_creation_request: PolicyCollectionCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyCollectionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_policy_collection_with_http_info(policy_collection_creation_request, **kwargs)  # noqa: E501

    def create_policy_collection_with_http_info(self, policy_collection_creation_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] CreatePolicyCollection: Create PolicyCollection  # noqa: E501

        Creates a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_policy_collection_with_http_info(policy_collection_creation_request, async_req=True)
        >>> result = thread.get()

        :param policy_collection_creation_request: The definition of the PolicyCollection (required)
        :type policy_collection_creation_request: PolicyCollectionCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyCollectionResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'policy_collection_creation_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policy_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'policy_collection_creation_request' is set
        if self.api_client.client_side_validation and ('policy_collection_creation_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_collection_creation_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_collection_creation_request` when calling `create_policy_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy_collection_creation_request' in local_var_params:
            body_params = local_var_params['policy_collection_creation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "PolicyCollectionResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_policy(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeletePolicy: Delete Policy  # noqa: E501

        Deletes an identified Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_policy(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Policy (required)
        :type code: str
        :param scope: Optional. Will use the default scope if not provided. The scope of the Policy
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_policy_with_http_info(code, **kwargs)  # noqa: E501

    def delete_policy_with_http_info(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeletePolicy: Delete Policy  # noqa: E501

        Deletes an identified Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_policy_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Policy (required)
        :type code: str
        :param scope: Optional. Will use the default scope if not provided. The scope of the Policy
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'code',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `delete_policy`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_policy`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_policy`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/policies/{code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_policy_collection(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeletePolicyCollection: Delete PolicyCollection  # noqa: E501

        Deletes an identified PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_policy_collection(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_policy_collection_with_http_info(code, **kwargs)  # noqa: E501

    def delete_policy_collection_with_http_info(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeletePolicyCollection: Delete PolicyCollection  # noqa: E501

        Deletes an identified PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_policy_collection_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'code',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `delete_policy_collection`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/policycollections/{code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def evaluate(self, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Evaluate: Run one or more evaluations  # noqa: E501

        Given a dictionary of evaluation requests (keyed by any arbitrary correlation identifier), each will be evaluated according to the current user's policies (deduced from the provided OAuth token).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.evaluate(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: A dictionary of evaluations, keyed using any arbitrary correlation id (it will be returned with the response for that evaluation). (required)
        :type request_body: dict(str, EvaluationRequest)
        :param applications: Optional. The application type of the roles and policies to use when evaluating.
        :type applications: list[str]
        :param as_at: Optional. The requested AsAt date of the entitlements
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, EvaluationResponse)
        """
        kwargs['_return_http_data_only'] = True
        return self.evaluate_with_http_info(request_body, **kwargs)  # noqa: E501

    def evaluate_with_http_info(self, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] Evaluate: Run one or more evaluations  # noqa: E501

        Given a dictionary of evaluation requests (keyed by any arbitrary correlation identifier), each will be evaluated according to the current user's policies (deduced from the provided OAuth token).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.evaluate_with_http_info(request_body, async_req=True)
        >>> result = thread.get()

        :param request_body: A dictionary of evaluations, keyed using any arbitrary correlation id (it will be returned with the response for that evaluation). (required)
        :type request_body: dict(str, EvaluationRequest)
        :param applications: Optional. The application type of the roles and policies to use when evaluating.
        :type applications: list[str]
        :param as_at: Optional. The requested AsAt date of the entitlements
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (dict(str, EvaluationResponse), int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'request_body',
            'applications',
            'as_at'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method evaluate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `evaluate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'applications' in local_var_params and local_var_params['applications'] is not None:  # noqa: E501
            query_params.append(('applications', local_var_params['applications']))  # noqa: E501
            collection_formats['applications'] = 'multi'  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "dict(str, EvaluationResponse)",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/me', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_own_policies(self, **kwargs):  # noqa: E501
        """GetOwnPolicies: Get policies of requesting user  # noqa: E501

        Gets all Policies for the current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_policies(async_req=True)
        >>> result = thread.get()

        :param applications: Optional. Filter on the applications that the policies apply to
        :type applications: list[str]
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AttachedPolicyDefinitionResponse]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_own_policies_with_http_info(**kwargs)  # noqa: E501

    def get_own_policies_with_http_info(self, **kwargs):  # noqa: E501
        """GetOwnPolicies: Get policies of requesting user  # noqa: E501

        Gets all Policies for the current user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_own_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param applications: Optional. Filter on the applications that the policies apply to
        :type applications: list[str]
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[AttachedPolicyDefinitionResponse], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'applications',
            'as_at',
            'sort_by',
            'start',
            'limit',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_own_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_own_policies`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_own_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_own_policies`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'applications' in local_var_params and local_var_params['applications'] is not None:  # noqa: E501
            query_params.append(('applications', local_var_params['applications']))  # noqa: E501
            collection_formats['applications'] = 'multi'  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[AttachedPolicyDefinitionResponse]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_policy(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPolicy: Get Policy  # noqa: E501

        Gets an identified Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_policy(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Policy (required)
        :type code: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param scope: Optional. Will use the default scope if not provided. The scope of the Policy
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_policy_with_http_info(code, **kwargs)  # noqa: E501

    def get_policy_with_http_info(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPolicy: Get Policy  # noqa: E501

        Gets an identified Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_policy_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Policy (required)
        :type code: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param scope: Optional. Will use the default scope if not provided. The scope of the Policy
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'as_at',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_policy`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_policy`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_policy`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PolicyResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policies/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_policy_collection(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPolicyCollection: Get PolicyCollection  # noqa: E501

        Gets an identified PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_policy_collection(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyCollectionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_policy_collection_with_http_info(code, **kwargs)  # noqa: E501

    def get_policy_collection_with_http_info(self, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetPolicyCollection: Get PolicyCollection  # noqa: E501

        Gets an identified PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_policy_collection_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyCollectionResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'as_at',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_policy_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_policy_collection`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PolicyCollectionResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_policies(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListPolicies: List Policies  # noqa: E501

        Gets all Policies in a scope. For pagination support, use PagePolicies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policies(async_req=True)
        >>> result = thread.get()

        :param scope: Optional. Will use the default scope if not provided. The requested scope
        :type scope: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[PolicyResponse]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_policies_with_http_info(**kwargs)  # noqa: E501

    def list_policies_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListPolicies: List Policies  # noqa: E501

        Gets all Policies in a scope. For pagination support, use PagePolicies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param scope: Optional. Will use the default scope if not provided. The requested scope
        :type scope: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[PolicyResponse], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'as_at',
            'sort_by',
            'start',
            'limit',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_policies`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_policies`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_policies`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[PolicyResponse]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_policy_collections(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListPolicyCollections: List PolicyCollections  # noqa: E501

        Gets all PolicyCollections in a scope. For pagination support, use PagePolicyCollections  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policy_collections(async_req=True)
        >>> result = thread.get()

        :param scope: Optional. Will use the default scope if not provided. The requested scope
        :type scope: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. 2000 if not provided. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[PolicyCollectionResponse]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_policy_collections_with_http_info(**kwargs)  # noqa: E501

    def list_policy_collections_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListPolicyCollections: List PolicyCollections  # noqa: E501

        Gets all PolicyCollections in a scope. For pagination support, use PagePolicyCollections  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_policy_collections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param scope: Optional. Will use the default scope if not provided. The requested scope
        :type scope: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. 2000 if not provided. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[PolicyCollectionResponse], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'as_at',
            'sort_by',
            'start',
            'limit',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policy_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_policy_collections`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_policy_collections`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_policy_collections`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_policy_collections`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[PolicyCollectionResponse]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def page_policies(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] PagePolicies: Page Policies  # noqa: E501

        Gets all Policies with pagination support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.page_policies(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Not currently used. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: str
        :param limit: Optional. 2000 if not provided. When paginating, limit the number of returned results to this many
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param page: Optional. Paging token returned from a previous result
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPolicyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.page_policies_with_http_info(**kwargs)  # noqa: E501

    def page_policies_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] PagePolicies: Page Policies  # noqa: E501

        Gets all Policies with pagination support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.page_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Not currently used. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: str
        :param limit: Optional. 2000 if not provided. When paginating, limit the number of returned results to this many
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param page: Optional. Paging token returned from a previous result
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfPolicyResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'as_at',
            'sort_by',
            'limit',
            'filter',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method page_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('sort_by' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sort_by']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `page_policies`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('sort_by' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sort_by']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `page_policies`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'sort_by' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['sort_by']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `page_policies`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `page_policies`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `page_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `page_policies`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `page_policies`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `page_policies`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `page_policies`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `page_policies`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `page_policies`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfPolicyResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policies/page', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def page_policy_collections(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] PagePolicyCollections: Page PolicyCollections  # noqa: E501

        Gets all PolicyCollections with pagination support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.page_policy_collections(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Not currently used. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: str
        :param limit: Optional. 2000 if not provided. When paginating, limit the number of returned results to this many
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param page: Optional. Paging token returned from a previous result
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfPolicyCollectionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.page_policy_collections_with_http_info(**kwargs)  # noqa: E501

    def page_policy_collections_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] PagePolicyCollections: Page PolicyCollections  # noqa: E501

        Gets all PolicyCollections with pagination support.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.page_policy_collections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Not currently used. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: str
        :param limit: Optional. 2000 if not provided. When paginating, limit the number of returned results to this many
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param page: Optional. Paging token returned from a previous result
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfPolicyCollectionResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'as_at',
            'sort_by',
            'limit',
            'filter',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method page_policy_collections" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('sort_by' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sort_by']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `page_policy_collections`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('sort_by' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sort_by']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `page_policy_collections`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'sort_by' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['sort_by']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `page_policy_collections`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `page_policy_collections`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `page_policy_collections`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `page_policy_collections`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `page_policy_collections`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `page_policy_collections`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `page_policy_collections`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `page_policy_collections`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `page_policy_collections`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfPolicyCollectionResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections/page', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_from_policy_collection(self, code, remove_from_policy_collection_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] RemoveFromPolicyCollection: Remove From PolicyCollection  # noqa: E501

        Remove Policies and/or PolicyCollections from a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_from_policy_collection(code, remove_from_policy_collection_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param remove_from_policy_collection_request: Ids of the PolicyCollections and/or Policies to remove from the PolicyCollection (required)
        :type remove_from_policy_collection_request: RemoveFromPolicyCollectionRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyCollectionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_from_policy_collection_with_http_info(code, remove_from_policy_collection_request, **kwargs)  # noqa: E501

    def remove_from_policy_collection_with_http_info(self, code, remove_from_policy_collection_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] RemoveFromPolicyCollection: Remove From PolicyCollection  # noqa: E501

        Remove Policies and/or PolicyCollections from a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_from_policy_collection_with_http_info(code, remove_from_policy_collection_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param remove_from_policy_collection_request: Ids of the PolicyCollections and/or Policies to remove from the PolicyCollection (required)
        :type remove_from_policy_collection_request: RemoveFromPolicyCollectionRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyCollectionResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'remove_from_policy_collection_request',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_from_policy_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `remove_from_policy_collection`")  # noqa: E501
        # verify the required parameter 'remove_from_policy_collection_request' is set
        if self.api_client.client_side_validation and ('remove_from_policy_collection_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['remove_from_policy_collection_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `remove_from_policy_collection_request` when calling `remove_from_policy_collection`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `remove_from_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `remove_from_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'remove_from_policy_collection_request' in local_var_params:
            body_params = local_var_params['remove_from_policy_collection_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PolicyCollectionResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections/{code}/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_policy(self, code, policy_update_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdatePolicy: Update Policy  # noqa: E501

        Updates a Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_policy(code, policy_update_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Policy (required)
        :type code: str
        :param policy_update_request: The updated definition of the Policy (required)
        :type policy_update_request: PolicyUpdateRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the Policy
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_policy_with_http_info(code, policy_update_request, **kwargs)  # noqa: E501

    def update_policy_with_http_info(self, code, policy_update_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdatePolicy: Update Policy  # noqa: E501

        Updates a Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_policy_with_http_info(code, policy_update_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Policy (required)
        :type code: str
        :param policy_update_request: The updated definition of the Policy (required)
        :type policy_update_request: PolicyUpdateRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the Policy
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'policy_update_request',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `update_policy`")  # noqa: E501
        # verify the required parameter 'policy_update_request' is set
        if self.api_client.client_side_validation and ('policy_update_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_update_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_update_request` when calling `update_policy`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `update_policy`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `update_policy`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy_update_request' in local_var_params:
            body_params = local_var_params['policy_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PolicyResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policies/{code}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_policy_collection(self, code, policy_collection_update_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdatePolicyCollection: Update PolicyCollection  # noqa: E501

        Updates a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_policy_collection(code, policy_collection_update_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param policy_collection_update_request: The updated definition of the PolicyCollection (required)
        :type policy_collection_update_request: PolicyCollectionUpdateRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PolicyCollectionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_policy_collection_with_http_info(code, policy_collection_update_request, **kwargs)  # noqa: E501

    def update_policy_collection_with_http_info(self, code, policy_collection_update_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpdatePolicyCollection: Update PolicyCollection  # noqa: E501

        Updates a PolicyCollection  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_policy_collection_with_http_info(code, policy_collection_update_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the PolicyCollection (required)
        :type code: str
        :param policy_collection_update_request: The updated definition of the PolicyCollection (required)
        :type policy_collection_update_request: PolicyCollectionUpdateRequest
        :param scope: Optional. Will use the default scope if not provided. The scope of the PolicyCollection
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PolicyCollectionResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'policy_collection_update_request',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_policy_collection" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `update_policy_collection`")  # noqa: E501
        # verify the required parameter 'policy_collection_update_request' is set
        if self.api_client.client_side_validation and ('policy_collection_update_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_collection_update_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_collection_update_request` when calling `update_policy_collection`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `update_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `update_policy_collection`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy_collection_update_request' in local_var_params:
            body_params = local_var_params['policy_collection_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.2955'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PolicyCollectionResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/policycollections/{code}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
