"""Convenience re-exports for the public API."""

__all__ = [
    "AssetsDistribution",
    "PortfolioFrontier",
    "PortfolioWrapper",
    "estimate_sample_moments",
    "estimate_moments",
    "shrink_mean_jorion",
    "shrink_mean_james_stein",
    "robust_mean_huber",
    "robust_mean_median_of_means",
    "shrink_covariance_ledoit_wolf",
    "shrink_covariance_oas",
    "shrink_covariance_nls",
    "factor_covariance_poet",
    "robust_covariance_tyler",
    "sparse_precision_glasso",
    "posterior_moments_black_litterman",
    "posterior_moments_niw",
    "generate_uniform_probabilities",
    "generate_exp_decay_probabilities",
    "silverman_bandwidth",
    "generate_gaussian_kernel_probabilities",
    "compute_effective_number_scenarios",
    "entropy_pooling",
    "FlexibleViewsProcessor",
    "BlackLittermanProcessor",
    # "Optimization",
    "MeanVariance",
    "MeanCVaR",
    "RelaxedRiskParity",
    "RobustOptimizer",
    "build_G_h_A_b",
    "discretize_weights",
    "allocate_greedy",
    "allocate_mip",
    "DiscreteAllocationInput",
    "DiscreteAllocationResult",
    "average_exposures",
    "exposure_stacking",
    "average_frontiers",
    "exposure_stack_frontiers",
    "assemble_portfolio_ensemble",
    "make_portfolio_spec",
    "stack_portfolios",
    "plot_frontiers",
    "stress_test",
    "exp_decay_stress",
    "kernel_focus_stress",
    "entropy_pooling_stress",
    "linear_map",
    "scenario_pnl",
    "performance_report",
]

from .portfolioapi import AssetsDistribution, PortfolioFrontier, PortfolioWrapper
from .moments import (
    estimate_sample_moments,
    estimate_moments,
    factor_covariance_poet,
    posterior_moments_black_litterman,
    posterior_moments_niw,
    robust_covariance_tyler,
    robust_mean_huber,
    robust_mean_median_of_means,
    shrink_covariance_nls,
    shrink_covariance_ledoit_wolf,
    shrink_covariance_oas,
    shrink_mean_james_stein,
    shrink_mean_jorion,
    sparse_precision_glasso,
)
from .optimization import MeanCVaR, MeanVariance, RelaxedRiskParity, RobustOptimizer
from .probabilities import (
    compute_effective_number_scenarios,
    generate_exp_decay_probabilities,
    generate_gaussian_kernel_probabilities,
    generate_uniform_probabilities,
    silverman_bandwidth,
)
from .views import BlackLittermanProcessor, FlexibleViewsProcessor, entropy_pooling
from .discrete_allocation import (
    DiscreteAllocationInput,
    DiscreteAllocationResult,
    allocate_greedy,
    allocate_mip,
    discretize_weights,
)
from .ensembles import (
    average_exposures,
    average_frontiers,
    assemble_portfolio_ensemble,
    exposure_stack_frontiers,
    exposure_stacking,
    stack_portfolios,
    make_portfolio_spec,
)
from .plotting import plot_frontiers
from .stress import (
    entropy_pooling_stress,
    exp_decay_stress,
    kernel_focus_stress,
    linear_map,
    stress_test,
)
from .utils.performance import performance_report, scenario_pnl
