# `cyberdrop-dl`

**Bulk downloader for multiple file hosts**

[![PyPI version](https://badge.fury.io/py/cyberdrop-dl.svg)](https://badge.fury.io/py/cyberdrop-dl)
[![Downloads](https://static.pepy.tech/badge/cyberdrop-dl)](https://pepy.tech/project/cyberdrop-dl)
[![Downloads](https://static.pepy.tech/badge/cyberdrop-dl/month)](https://pepy.tech/project/cyberdrop-dl)
[![Downloads](https://static.pepy.tech/badge/cyberdrop-dl/week)](https://pepy.tech/project/cyberdrop-dl)

[![Discord Banner 3](https://discordapp.com/api/guilds/1070206871564197908/widget.png?style=banner3)](https://discord.com/invite/kbZCxz22Qp)

Brand new and improved! Cyberdrop-DL now has an updated paint job, fantastic new look. On top of this it also downloads from different domains simultaneously.

![Screenshot 2023-02-19 183052](https://user-images.githubusercontent.com/61347133/219989561-759bd8b1-34d2-4d61-8fa7-0d0b3680e83f.png)

## Support Cyberdrop-DL Development

<a href="https://www.buymeacoffee.com/juleswinnft" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/default-orange.png" alt="Buy Me A Coffee" height="41" width="174"></a>

If you want to support me and my effort you can buy me a coffee or send me some crypto:

BTC: bc1qzw7l9d8ju2qnag3skfarrd0t5mkn0zyapnrcsn

ETH: 0xf36ef155C43Ed220BfBb2CBe9c5Ae172A8640e9B

XMR: 46vMP5MXVZqQeGzkA1mbX9WQKU8fbWRBJGAktDcjYkCMRDY7HMdLzi1DFsHCPLgms968cyUz1gCWVhy9cZir9Ae7M6anQ8Q

## More Information

Read the [Wiki](https://github.com/Jules-WinnfieldX/CyberDropDownloader/wiki/)!

## Supported Sites

| Website                                 | Supported Link Types                                                                                                                                                                                                                   |
|-----------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Anonfiles                               | Download page: Anonfiles.com/...                                                                                                                                                                                                       |
| Bayfiles                                | Download page: Bayfiles.com/...                                                                                                                                                                                                        |
| Bunkr (ru/su/la)                        | Albums: bunkr.ru/a/... <br> Direct Videos: stream.bunkr.ru/v/... <br> Direct links: cdn.bunkr.ru/... <br> Direct links: i.bunkr.ru/... <br> Direct links: files.bunkr.ru/... <br> Direct links: media-files.bunkr.ru/...               |
| Coomer.party                            | Profiles: coomer.party/... <br> Thumbnail Links: coomer.party/thumbnail/... <br> Data Links: coomer.party/data/... <br> coomer.party/.../post/...                                                                                      |
| Cyberdrop                               | Albums: cyberdrop.me/a/... <br> Direct Videos: fs-0#.cyberdrop.me/... <br> Direct Videos: f.cyberdrop.me/... <br> Direct Images: img-0#.cyberdrop.me/... <br> Direct Images: f.cyberdrop.me/... <br> Also works with .cc, .to, and .nl |
| Cyberfile                               | folders: cyberfile.su/folder/... <br> shared: cyberfile.su/shared/... <br> Direct: cyberfile.su/...                                                                                                                                    |
| E-Hentai                                | Albums: e-hentai.org/g/... <br> Posts: e-hentai.org/s/...                                                                                                                                                                              |
| Erome                                   | Albums: erome.com/a/...                                                                                                                                                                                                                |
| Fapello                                 | Models: fapello.com/...                                                                                                                                                                                                                |
| Gallery.DeltaPorno.com                  | Albums: Gallery.DeltaPorno.com/album/... <br> Direct Images: Gallery.DeltaPorno.com/image/... <br> User Profile: Gallery.DeltaPorno.com/#USER# <br> All User Albums: Gallery.DeltaPorno.com/#USER#/albums                              |
| GoFile                                  | Albums: gofile.io/d/...                                                                                                                                                                                                                |
| Gfycat                                  | Gif: gfycat.com/...                                                                                                                                                                                                                    |
| HGameCG                                 | Albums: hgamecg.com/.../index.html                                                                                                                                                                                                     |
| ImgBox                                  | Albums: imgbox.com/g/... <br> Direct Images: images#.imgbox.com/... <br> Single Files: imgbox.com/...                                                                                                                                  |
| IMG.Kiwi                                | Albums: img.kiwi/album/... <br> Direct Images: img.kiwi/image/... <br> User Profile: img.kiwi/#USER# <br> All User Albums: img.kiwi/#USER#/albums                                                                                      |
| jpg.church<br/>jpg.fish<br/>jpg.fishing<br/>jpg.pet | Albums: jpg.church/album/... <br> Direct Images: jpg.church/image/... <br> User Profile: jpg.church/#USER# <br> All User Albums: jpg.church/#USER#/albums                                                                              |
| LoveFap                                 | Albums: lovefap.com/a/... <br> Direct Images: s*.lovefap.com/content/photos/... <br> Videos: lovefap.com/video/...                                                                                                                     |
| NSFW.XXX                                | Profile: nsfw.xxx/user/... <br> Post: nsfw.xxx/post/...                                                                                                                                                                                |
| PimpAndHost                             | Albums: pimpandhost.com/album/... <br> Single Files: pimpandhost.com/image/...                                                                                                                                                         |
| PixelDrain                              | Albums: Pixeldrain.com/l/... <br> Single Files: Pixeldrain.com/u/...                                                                                                                                                                   |
| Pixl                                    | Albums: pixl.li/album/... <br> Direct Images: pixl.li/image/...  <br> User Profile: pixl.li/#USER# <br> All User Albums: pixl.li/#USER#/albums                                                                                         |
| Postimg.cc                              | Albums: postimg.cc/gallery/... <br> Direct Images: postimg.cc/...                                                                                                                                                                      |
| NudoStar                                | Thread: nudostar.com/forum/threads/...  <br> Continue from (will download this post and after): nudostar.com/forum/threads/...post-NUMBER                                                                                              |
| SimpCity                                | Thread: simpcity.st/threads/...  <br> Continue from (will download this post and after): simpcity.st/threads/...post-NUMBER                                                                                                            |
| SocialMediaGirls                        | Thread: forum.socialmediagirls.com/threads/...  <br> Continue from (will download this post and after): forum.socialmediagirls.com/threads/...post-NUMBER                                                                              |
| XBunker                                 | Thread: xbunker.nu/threads/...  <br> Continue from (will download this post and after): xbunker.nu/threads/...post-NUMBER                                                                                                              |
| XBunkr                                  | Album: xbunkr.com/a/... <br> Direct Links: media.xbunkr.com/...                                                                                                                                                                        |

Reminder to leave the link full (include the https://)

## Information

**Requires Python 3.7 or higher (3.10 recommended)**

You can get Python from here: <https://www.python.org/downloads/>

Make sure you tick the check box for "Add python to path"
![alt text](https://simp2.jpg.church/PATHe426c23371048def.png)

Mac users will also likely need to open terminal and execute the following command: `xcode-select --install`

## Script Method

Go to the [releases page](https://github.com/Jules-WinnfieldX/CyberDropDownloader/releases) and download the Cyberdrop_DL.zip file. Extract it to wherever you want the program to be.

Put the links in the URLs.txt file then run `Start Windows.bat` (Windows) or `Start Mac.command` (OS X) or `Start Linux.sh` (Linux).

** Mac users will need to run the command `chmod +x 'Start Mac.command'` to make the file executable.

## CLI Method

Run `pip3 install cyberdrop-dl` in command prompt/terminal

Advanced users may want to use virtual environments (via `pipx`), but it's **NOT** required.

**pipx is now required for some linux distros.**

1. Run `cyberdrop-dl` once to generate an empty `URLs.txt` file.
2. Copy and paste your links into `URLs.txt`.
Each link you add has to go on its own line (paste link, press enter, repeat).
3. Run `cyberdrop-dl` again.
It will begin to download everything.
4. Enjoy!

### Arguments & Config

If you know what you're doing, you can use the available options to adjust how the program runs.

You can read more about all of these options [here](https://github.com/Jules-WinnfieldX/CyberDropDownloader/wiki/Config-Options). As they directly correlate with the config options.

```raw
$ cyberdrop-dl -h
usage: cyberdrop-dl [-h] [-V] [-i INPUT_FILE] [-o OUTPUT_FOLDER] [--log-file LOG_FILE] [--threads THREADS] [--attempts ATTEMPTS] [--include-id] [--exclude-videos] [--exclude-images] [--exclude-audio] [--exclude-other] [--ignore-history] [--simpcity-username "USERNAME"] [--simpcity-password "PASSWORD"] [--skip SITE] [link ...]

Bulk downloader for multiple file hosts

positional arguments:
  link                  link to content to download (passing multiple links is supported)

optional arguments:
-h, --help                                         show this help message and exit
-V, --version                                      show program's version number and exit
-i INPUT_FILE, --input-file INPUT_FILE             file containing links to download
-o OUTPUT_FOLDER, --output-folder OUTPUT_FOLDER    folder to download files to

--config-file                   config file to read arguments from
--db-file                       history database file to write to
--errored-download-urls-file    csv file to write failed download information to
--errored-scrape-urls-file      csv file to write failed scrape information to
--log-file                      log file to write to
--output-last-forum-post-file   text file to output last scraped post from a forum thread for re-feeding into CDL
--unsupported-urls-file         csv file to output unsupported links into
--variable-cache-file           internal variables for CDL are stored here

--exclude-audio         skip downloading of audio files
--exclude-images        skip downloading of image files
--exclude-other         skip downloading of images
--exclude-videos        skip downloading of video files
--ignore-cache          ignores previous runs cached scrape history
--ignore-history        ignores previous download history
--only-hosts            only allows downloads and scraping from these hosts
--skip-hosts            doesn't allow downloads and scraping from these hosts

--allow-insecure-connections            allows insecure connections from content hosts
--attempts                              number of attempts to download each file
--block-sub-folders                     block sub folders from being created
--disable-attempt-limit                 disables the attempt limitation
--filesize-maximum-images               maximum filesize for images (in bytes)
--filesize-maximum-videos               maximum filesize for videos (in bytes)
--filesize-maximum-other                maximum filesize for other files (in bytes)
--filesize-minimum-images               minimum filesize for images (in bytes)
--filesize-minimum-videos               minimum filesize for videos (in bytes)
--filesize-minimum-other                minimum filesize for other files (in bytes)
--include-id                            include the ID in the download folder name
--max-concurrent-threads                number of threads to download simultaneously
--max-concurrent-domains                number of domains to download simultaneously
--max-concurrent-albums                 number of albums to download simultaneously
--max-concurrent-downloads-per-domain   number of simultaneous downloads per domain
--max-filename-length                   maximum filename length
--max-folder-name-length                maximum folder name length
--skip-download-mark-completed          sets the scraped files as downloaded without downloading
--output-errored-urls                   sets the failed urls to be output to the errored urls file
--output-unsupported-urls               sets the unsupported urls to be output to the unsupported urls file
--proxy                                 HTTP/HTTPS proxy used for downloading, format [protocol]://[ip]:[port]
--remove-bunkr-identifier               removes the bunkr added identifier from output filenames
--required-free-space                   required free space (in gigabytes) for the program to run

--sort-downloads        sorts downloaded files after downloads have finished
--sort-directory        folder to download files to
--sorted-audio          schema to sort audio
--sorted-images         schema to sort images
--sorted-others         schema to sort other
--sorted-videos         schema to sort videos

--connection-timeout    number of seconds to wait attempting to connect to a URL during the downloading phase
--ratelimit             this applies to requests made in the program during scraping, the number you provide is in requests/seconds
--read-timeout          number of seconds to wait for data to be read from a URL during the downloading phase
--throttle              this is a throttle between requests during the downloading phase, the number is in seconds

--output-last-forum-post        outputs the last post of a forum scrape to use as a starting point for future runs
--scrape-single-post            scrapes a single post from a forum thread
--separate-posts                separates forum scraping into folders by post number

--gofile-api-key                api key for premium gofile
--gofile-website-token          website token for gofile
--pixeldrain-api-key            api key for premium pixeldrain
--nudostar-username             username to login to nudostar
--nudostar-password             password to login to nudostar
--simpcity-username             username to login to simpcity
--simpcity-password             password to login to simpcity
--socialmediagirls-username     username to login to socialmediagirls
--socialmediagirls-password     password to login to socialmediagirls
--xbunker-username              username to login to xbunker
--xbunker-password              password to login to xbunker

--apply-jdownloader     enables sending unsupported URLs to a running jdownloader2 instance to download
--jdownloader-username  username to login to jdownloader
--jdownloader-password  password to login to jdownloader
--jdownloader-device    device name to login to for jdownloader

--hide-new-progress             disables the new rich progress entirely and uses older methods
--hide-overall-progress         removes overall progress section while downloading
--hide-forum-progress           removes forum progress section while downloading
--hide-thread-progress          removes thread progress section while downloading
--hide-domain-progress          removes domain progress section while downloading
--hide-album-progress           removes album progress section while downloading
--hide-file-progress            removes file progress section while downloading
--refresh-rate                  changes the refresh rate of the progress table
--visible-rows-threads          number of visible rows to use for the threads table
--visible-rows-domains          number of visible rows to use for the domains table
--visible-rows-albums           number of visible rows to use for the albums table
--visible-rows-files            number of visible rows to use for the files table
```

`--only-hosts` and `--skip-hosts` can use: `"anonfiles", "bayfiles", "bunkr", "coomer.party", "coomer.su", "cyberdrop", "cyberfile", "e-hentai", "erome", "fapello", "gfycat", "gallery.deltaporno.com", "gofile", "hgamecg", "img.kiwi", "imgbox", "jpg.church", "jpg.fish", "jpg.fishing", "jpg.pet", "kemono.party", "lovefap", "nsfw.xxx", "nudostar", "pimpandhost", "pixeldrain", "pixl.li", "postimg", "saint", "simpcity", "socialmediagirls", "xbunker", "xbunkr"`
