"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstance = exports.DBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "DBInstanceProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosDBInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GPDB::DBInstance`, which is used to create an AnalyticDB for PostgreSQL instance in reserved storage mode.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-gpdb-dbinstance
 */
class DBInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBInstance = new gpdb_generated_1.RosDBInstance(this, id, {
            masterNodeNum: props.masterNodeNum,
            standbyZoneId: props.standbyZoneId,
            instanceSpec: props.instanceSpec,
            privateIpAddress: props.privateIpAddress,
            idleTime: props.idleTime,
            segNodeNum: props.segNodeNum,
            segStorageType: props.segStorageType,
            encryptionKey: props.encryptionKey,
            dbInstanceGroupCount: props.dbInstanceGroupCount,
            standbyVSwitchId: props.standbyVSwitchId,
            dbInstanceCategory: props.dbInstanceCategory,
            vectorConfigurationStatus: props.vectorConfigurationStatus,
            deployMode: props.deployMode,
            securityIpList: props.securityIpList,
            serverlessResource: props.serverlessResource,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            encryptionType: props.encryptionType,
            serverlessMode: props.serverlessMode,
            engineVersion: props.engineVersion,
            createSampleData: props.createSampleData,
            zoneId: props.zoneId,
            vpcId: props.vpcId,
            dbInstanceClass: props.dbInstanceClass,
            prodType: props.prodType === undefined || props.prodType === null ? 'standard' : props.prodType,
            vSwitchId: props.vSwitchId,
            period: props.period,
            storageSize: props.storageSize,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceMode: props.dbInstanceMode,
            segDiskPerformanceLevel: props.segDiskPerformanceLevel,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstance;
        this.attrConnectionString = rosDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosDBInstance.attrDbInstanceId;
        this.attrOrderId = rosDBInstance.attrOrderId;
        this.attrPort = rosDBInstance.attrPort;
    }
}
exports.DBInstance = DBInstance;
//# sourceMappingURL=data:application/json;base64,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