"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticDBInstance = exports.ElasticDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "ElasticDBInstanceProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosElasticDBInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GPDB::ElasticDBInstance`, which is used to create an AnalyticDB for PostgreSQL instance in elastic storage mode.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosElasticDBInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-gpdb-elasticdbinstance
 */
class ElasticDBInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosElasticDBInstance = new gpdb_generated_1.RosElasticDBInstance(this, id, {
            masterNodeNum: props.masterNodeNum,
            encryptionType: props.encryptionType,
            instanceSpec: props.instanceSpec,
            engineVersion: props.engineVersion,
            privateIpAddress: props.privateIpAddress,
            zoneId: props.zoneId,
            vpcId: props.vpcId,
            vSwitchId: props.vSwitchId,
            segNodeNum: props.segNodeNum,
            period: props.period,
            segStorageType: props.segStorageType,
            storageSize: props.storageSize,
            encryptionKey: props.encryptionKey,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbInstanceCategory: props.dbInstanceCategory,
            securityIpList: props.securityIpList,
            dbInstanceMode: props.dbInstanceMode,
            dbInstanceDescription: props.dbInstanceDescription,
            tags: props.tags,
            periodUnit: props.periodUnit === undefined || props.periodUnit === null ? 'Month' : props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosElasticDBInstance;
        this.attrConnectionString = rosElasticDBInstance.attrConnectionString;
        this.attrDbInstanceId = rosElasticDBInstance.attrDbInstanceId;
        this.attrOrderId = rosElasticDBInstance.attrOrderId;
        this.attrPort = rosElasticDBInstance.attrPort;
    }
}
exports.ElasticDBInstance = ElasticDBInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWxhc3RpY2RiaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbGFzdGljZGJpbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMscURBQXdEO0FBRXZCLDBHQUZ4QixxQ0FBb0IsT0FFNkI7QUFvSjFEOzs7O0dBSUc7QUFDSCxNQUFhLGlCQUFrQixTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBMEIvQzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE2QixFQUFFLG1DQUEyQyxJQUFJO1FBQ3hILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDYixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsZ0NBQWdDLEdBQUcsZ0NBQWdDLENBQUM7UUFFekUsTUFBTSxvQkFBb0IsR0FBRyxJQUFJLHFDQUFvQixDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDN0QsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLE9BQU8sS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE9BQU87WUFDM0Ysa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1lBQ3BDLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxxQkFBcUI7WUFDbEQsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsVUFBVSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsVUFBVTtTQUN2RyxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLG9CQUFvQixDQUFDO1FBQ3JDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxvQkFBb0IsQ0FBQyxvQkFBb0IsQ0FBQztRQUN0RSxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsb0JBQW9CLENBQUMsZ0JBQWdCLENBQUM7UUFDOUQsSUFBSSxDQUFDLFdBQVcsR0FBRyxvQkFBb0IsQ0FBQyxXQUFXLENBQUM7UUFDcEQsSUFBSSxDQUFDLFFBQVEsR0FBRyxvQkFBb0IsQ0FBQyxRQUFRLENBQUM7SUFDbEQsQ0FBQztDQUNKO0FBbEVELDhDQWtFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0VsYXN0aWNEQkluc3RhbmNlIH0gZnJvbSAnLi9ncGRiLmdlbmVyYXRlZCc7XG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cbmV4cG9ydCB7IFJvc0VsYXN0aWNEQkluc3RhbmNlIGFzIEVsYXN0aWNEQkluc3RhbmNlUHJvcGVydHkgfTtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBFbGFzdGljREJJbnN0YW5jZWAuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1ncGRiLWVsYXN0aWNkYmluc3RhbmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRWxhc3RpY0RCSW5zdGFuY2VQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlbmdpbmVWZXJzaW9uOiBUaGUgdmVyc2lvbiBvZiB0aGUgZGF0YWJhc2UgZW5naW5lLiBGb3IgZXhhbXBsZTogNi4w44CBNy4wXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5naW5lVmVyc2lvbjogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW5zdGFuY2VTcGVjOiBUaGUgc3BlY2lmaWNhdGlvbiBvZiBzZWdtZW50IG5vZGVzLiBGb3IgZXhhbXBsZTogMkMxNkcsIDRDMzJHLCAxNkMxMjhHLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlU3BlYzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc2VnTm9kZU51bTogVGhlIG51bWJlciBvZiBzZWdtZW50IG5vZGVzLlxuICAgICAqIEZvciB0aGUgaGlnaCBhdmFpbGFiaWxpdHkgdmVyc2lvbiwgdGhlIHZhbHVlIHJhbmdlcyBmcm9tIDQgdG8gNTEyLlxuICAgICAqIFRoZSBiYXNpYyB2ZXJzaW9uIHJhbmdlcyBmcm9tIDIgdG8gNTEyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlZ05vZGVOdW06IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHNlZ1N0b3JhZ2VUeXBlOiBUaGUgZGlzayB0eXBlIG9mIHNlZ21lbnQgbm9kZXMuIEZvciBleGFtcGxlOiBjbG91ZF9lc3NkLCBjbG91ZF9lZmZpY2llbmN5LlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlZ1N0b3JhZ2VUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzdG9yYWdlU2l6ZTogVGhlIHN0b3JhZ2UgY2FwYWNpdHkgb2YgcGVyIHNlZ21lbnQgbm9kZS4gVW5pdDogR0IuIE1pbmltdW0gaXMgNTAsIG1heCBpcyA0MDAwLCBzdGVwIGlzIDUwLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0b3JhZ2VTaXplOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB2U3dpdGNoSWQ6IFRoZSB2U3dpdGNoIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSB2U3dpdGNoSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHpvbmVJZDogVGhlIHpvbmUgSUQgb2YgdGhlIGluc3RhbmNlLCBzdWNoIGFzIGNuLWhhbmd6aG91LWQuIFlvdSBjYW4gY2FsbCB0aGUgRGVzY3JpYmVSZWdpb25zXG4gICAgICogb3BlcmF0aW9uIHRvIHF1ZXJ5IHRoZSBtb3N0IHJlY2VudCB6b25lIGxpc3QuXG4gICAgICovXG4gICAgcmVhZG9ubHkgem9uZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYkluc3RhbmNlQ2F0ZWdvcnk6IERCIGluc3RhbmNlIGNhdGVnb3J5LCB2YWxpZCB2YWx1ZXM6IEJhc2ljLCBIaWdoQXZhaWxhYmlsaXR5LlxuICAgICAqIFRoaXMgcGFyYW1ldGVyIG11c3QgYmUgcGFzc2VkIGluIHRvIGNyZWF0ZSBhIHN0b3JhZ2UgcmVzZXJ2YXRpb24gbW9kZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYkluc3RhbmNlQ2F0ZWdvcnk/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYkluc3RhbmNlRGVzY3JpcHRpb246IFRoZSBkZXNjcmlwdGlvbiBvZiB0aGUgaW5zdGFuY2UuIFRoZSBkZXNjcmlwdGlvbiBjYW5ub3QgZXhjZWVkIDI1NiBjaGFyYWN0ZXJzIGluIGxlbmd0aC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkYkluc3RhbmNlRGVzY3JpcHRpb24/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYkluc3RhbmNlTW9kZTogVGhlIGRiIGluc3RhbmNlIG1vZGUuIFZhbGlkIHZhbHVlczogU3RvcmFnZUVsYXN0aWMsIFNlcnZlcmxlc3MsIENsYXNzaWMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJJbnN0YW5jZU1vZGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBlbmNyeXB0aW9uS2V5OiBJZiB0aGUgRW5jcnlwdGlvblR5cGUgcGFyYW1ldGVyIGlzIHNldCB0byBDbG91ZERpc2ssIHlvdSBtdXN0IHNwZWNpZnkgdGhpcyBwYXJhbWV0ZXIgdG8gdGhlIGVuY3J5cHRpb24ga2V5IHRoYXQgaXMgaW4gdGhlIHNhbWUgcmVnaW9uIHdpdGggdGhlIGRpc2tzIHRoYXQgaXMgc3BlY2lmaWVkIGJ5IHRoZSBFbmNyeXB0aW9uVHlwZSBwYXJhbWV0ZXIuIE90aGVyd2lzZSwgbGVhdmUgdGhpcyBwYXJhbWV0ZXIgZW1wdHkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZW5jcnlwdGlvbktleT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGVuY3J5cHRpb25UeXBlOiBUaGUgdHlwZSBvZiB0aGUgZW5jcnlwdGlvbi4gRGVmYXVsdCB2YWx1ZTogTlVMTC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIE5VTEw6IEVuY3J5cHRpb24gaXMgZGlzYWJsZWQuXG4gICAgICogQ2xvdWREaXNrOiBFbmNyeXB0aW9uIGlzIGVuYWJsZWQgb24gZGlza3MgYW5kIHRoZSBlbmNyeXB0aW9uIGtleSBpcyBzcGVjaWZpZWQgYnkgdXNpbmcgdGhlIEVuY3J5cHRpb25LZXkgcGFyYW1ldGVyLlxuICAgICAqIE5vdGU6IERpc2sgZW5jcnlwdGlvbiBjYW5ub3QgYmUgZGlzYWJsZWQgYWZ0ZXIgaXQgaXMgZW5hYmxlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBlbmNyeXB0aW9uVHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG1hc3Rlck5vZGVOdW06IFRoZSBudW1iZXIgb2YgbWFzdGVyIG5vZGVzLiBNaW5pbXVtIGlzIDEsIG1heCBpcyAyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1hc3Rlck5vZGVOdW0/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXlUeXBlOiBUaGUgYmlsbGluZyBtZXRob2Qgb2YgdGhlIGluc3RhbmNlLiBEZWZhdWx0IHZhbHVlOiBQb3N0cGFpZC4gVmFsaWQgdmFsdWVzOlxuICAgICAqIFBvc3RwYWlkOiBwYXktYXMteW91LWdvXG4gICAgICogUHJlcGFpZDogc3Vic2NyaXB0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGF5VHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHBlcmlvZDogVGhlIHN1YnNjcmlwdGlvbiBwZXJpb2QuIFdoaWxlIGNob29zZSBieSBwYXkgYnkgbW9udGgsIGl0IGNvdWxkIGJlIGZyb20gMSB0byAxMS4gV2hpbGUgY2hvb3NlIHBheSBieSB5ZWFyLCBpdCBjb3VsZCBiZSBmcm9tIDEgdG8gMy5cbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJpb2Q/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwZXJpb2RVbml0OiBVbml0IG9mIHN1YnNjcmlwdGlvbiBwZXJpb2QsIGl0IGNvdWxkIGJlIE1vbnRoXFwvWWVhci4gRGVmYXVsdCB2YWx1ZSBpcyBNb250aC5cbiAgICAgKi9cbiAgICByZWFkb25seSBwZXJpb2RVbml0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcHJpdmF0ZUlwQWRkcmVzczogUHJpdmF0ZSBJUCBhZGRyZXNzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHByaXZhdGVJcEFkZHJlc3M/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzZWN1cml0eUlwTGlzdDogVGhlIHdoaXRlbGlzdCBvZiBJUCBhZGRyZXNzZXMgdGhhdCBhcmUgYWxsb3dlZCB0byBhY2Nlc3MgdGhlIGluc3RhbmNlLiBEZWZhdWx0IHZhbHVlOlxuICAgICAqIDEyNy4wLjAuMS5cbiAgICAgKi9cbiAgICByZWFkb25seSBzZWN1cml0eUlwTGlzdD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHRhZ3M6IFRoZSBsaXN0IG9mIGluc3RhbmNlIHRhZ3MgaW4gdGhlIGZvcm0gb2Yga2V5XFwvdmFsdWUgcGFpcnMuXG4gICAgICogWW91IGNhbiBkZWZpbmUgYSBtYXhpbXVtIG9mIDIwIHRhZ3MgZm9yIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBSb3NFbGFzdGljREJJbnN0YW5jZS5UYWdzUHJvcGVydHlbXTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IHZwY0lkOiBUaGUgVlBDIElEIG9mIHRoZSBpbnN0YW5jZS4gSWYgeW91IHNldCB0aGUgSW5zdGFuY2VOZXR3b3JrVHlwZSBwYXJhbWV0ZXIgdG8gVlBDLCB5b3VcbiAgICAgKiBtdXN0IGFsc28gc3BlY2lmeSB0aGUgVlBDSWQgcGFyYW1ldGVyLiBUaGUgc3BlY2lmaWVkIHJlZ2lvbiBvZiB0aGUgVlBDIG11c3QgYmUgdGhlXG4gICAgICogc2FtZSBhcyB0aGUgUmVnaW9uSWQgdmFsdWUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdnBjSWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGBFbGFzdGljREJJbnN0YW5jZWAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUVsYXN0aWNEQkluc3RhbmNlIGV4dGVuZHMgcm9zLklSZXNvdXJjZSB7XG4gICAgcmVhZG9ubHkgcHJvcHM6IEVsYXN0aWNEQkluc3RhbmNlUHJvcHM7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgQ29ubmVjdGlvblN0cmluZzogVGhlIGVuZHBvaW50IG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyQ29ubmVjdGlvblN0cmluZzogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIERCSW5zdGFuY2VJZDogVGhlIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyRGJJbnN0YW5jZUlkOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgT3JkZXJJZDogVGhlIG9yZGVyIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyT3JkZXJJZDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFBvcnQ6IFRoZSBwb3J0IHVzZWQgdG8gY29ubmVjdCB0byB0aGUgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0clBvcnQ6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcbn1cbi8qKlxuICogVGhpcyBjbGFzcyBlbmNhcHN1bGF0ZXMgYW5kIGV4dGVuZHMgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkdQREI6OkVsYXN0aWNEQkluc3RhbmNlYCwgd2hpY2ggaXMgdXNlZCB0byBjcmVhdGUgYW4gQW5hbHl0aWNEQiBmb3IgUG9zdGdyZVNRTCBpbnN0YW5jZSBpbiBlbGFzdGljIHN0b3JhZ2UgbW9kZS5cbiAqIEBOb3RlIFRoaXMgY2xhc3MgbWF5IGhhdmUgc29tZSBuZXcgZnVuY3Rpb25zIHRvIGZhY2lsaXRhdGUgZGV2ZWxvcG1lbnQsIHNvIGl0IGlzIHJlY29tbWVuZGVkIHRvIHVzZSB0aGlzIGNsYXNzIGluc3RlYWQgb2YgYFJvc0VsYXN0aWNEQkluc3RhbmNlYGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tZ3BkYi1lbGFzdGljZGJpbnN0YW5jZVxuICovXG5leHBvcnQgY2xhc3MgRWxhc3RpY0RCSW5zdGFuY2UgZXh0ZW5kcyByb3MuUmVzb3VyY2UgaW1wbGVtZW50cyBJRWxhc3RpY0RCSW5zdGFuY2Uge1xuICAgIHByb3RlY3RlZCBzY29wZTogcm9zLkNvbnN0cnVjdDtcbiAgICBwcm90ZWN0ZWQgaWQ6IHN0cmluZztcbiAgICBwdWJsaWMgcmVhZG9ubHkgcHJvcHM6IEVsYXN0aWNEQkluc3RhbmNlUHJvcHM7XG4gICAgcHJvdGVjdGVkIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIENvbm5lY3Rpb25TdHJpbmc6IFRoZSBlbmRwb2ludCBvZiB0aGUgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJDb25uZWN0aW9uU3RyaW5nOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgREJJbnN0YW5jZUlkOiBUaGUgSUQgb2YgdGhlIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyRGJJbnN0YW5jZUlkOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgT3JkZXJJZDogVGhlIG9yZGVyIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck9yZGVySWQ6IHJvcy5JUmVzb2x2YWJsZSB8IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBQb3J0OiBUaGUgcG9ydCB1c2VkIHRvIGNvbm5lY3QgdG8gdGhlIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUG9ydDogcm9zLklSZXNvbHZhYmxlIHwgc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBQYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBQYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVsYXN0aWNEQkluc3RhbmNlUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgICAgIHRoaXMuc2NvcGUgPSBzY29wZTtcbiAgICAgICAgdGhpcy5pZCA9IGlkO1xuICAgICAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gICAgICAgIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgPSBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDtcblxuICAgICAgICBjb25zdCByb3NFbGFzdGljREJJbnN0YW5jZSA9IG5ldyBSb3NFbGFzdGljREJJbnN0YW5jZSh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIG1hc3Rlck5vZGVOdW06IHByb3BzLm1hc3Rlck5vZGVOdW0sXG4gICAgICAgICAgICBlbmNyeXB0aW9uVHlwZTogcHJvcHMuZW5jcnlwdGlvblR5cGUsXG4gICAgICAgICAgICBpbnN0YW5jZVNwZWM6IHByb3BzLmluc3RhbmNlU3BlYyxcbiAgICAgICAgICAgIGVuZ2luZVZlcnNpb246IHByb3BzLmVuZ2luZVZlcnNpb24sXG4gICAgICAgICAgICBwcml2YXRlSXBBZGRyZXNzOiBwcm9wcy5wcml2YXRlSXBBZGRyZXNzLFxuICAgICAgICAgICAgem9uZUlkOiBwcm9wcy56b25lSWQsXG4gICAgICAgICAgICB2cGNJZDogcHJvcHMudnBjSWQsXG4gICAgICAgICAgICB2U3dpdGNoSWQ6IHByb3BzLnZTd2l0Y2hJZCxcbiAgICAgICAgICAgIHNlZ05vZGVOdW06IHByb3BzLnNlZ05vZGVOdW0sXG4gICAgICAgICAgICBwZXJpb2Q6IHByb3BzLnBlcmlvZCxcbiAgICAgICAgICAgIHNlZ1N0b3JhZ2VUeXBlOiBwcm9wcy5zZWdTdG9yYWdlVHlwZSxcbiAgICAgICAgICAgIHN0b3JhZ2VTaXplOiBwcm9wcy5zdG9yYWdlU2l6ZSxcbiAgICAgICAgICAgIGVuY3J5cHRpb25LZXk6IHByb3BzLmVuY3J5cHRpb25LZXksXG4gICAgICAgICAgICBwYXlUeXBlOiBwcm9wcy5wYXlUeXBlID09PSB1bmRlZmluZWQgfHwgcHJvcHMucGF5VHlwZSA9PT0gbnVsbCA/ICdQb3N0cGFpZCcgOiBwcm9wcy5wYXlUeXBlLFxuICAgICAgICAgICAgZGJJbnN0YW5jZUNhdGVnb3J5OiBwcm9wcy5kYkluc3RhbmNlQ2F0ZWdvcnksXG4gICAgICAgICAgICBzZWN1cml0eUlwTGlzdDogcHJvcHMuc2VjdXJpdHlJcExpc3QsXG4gICAgICAgICAgICBkYkluc3RhbmNlTW9kZTogcHJvcHMuZGJJbnN0YW5jZU1vZGUsXG4gICAgICAgICAgICBkYkluc3RhbmNlRGVzY3JpcHRpb246IHByb3BzLmRiSW5zdGFuY2VEZXNjcmlwdGlvbixcbiAgICAgICAgICAgIHRhZ3M6IHByb3BzLnRhZ3MsXG4gICAgICAgICAgICBwZXJpb2RVbml0OiBwcm9wcy5wZXJpb2RVbml0ID09PSB1bmRlZmluZWQgfHwgcHJvcHMucGVyaW9kVW5pdCA9PT0gbnVsbCA/ICdNb250aCcgOiBwcm9wcy5wZXJpb2RVbml0LFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc0VsYXN0aWNEQkluc3RhbmNlO1xuICAgICAgICB0aGlzLmF0dHJDb25uZWN0aW9uU3RyaW5nID0gcm9zRWxhc3RpY0RCSW5zdGFuY2UuYXR0ckNvbm5lY3Rpb25TdHJpbmc7XG4gICAgICAgIHRoaXMuYXR0ckRiSW5zdGFuY2VJZCA9IHJvc0VsYXN0aWNEQkluc3RhbmNlLmF0dHJEYkluc3RhbmNlSWQ7XG4gICAgICAgIHRoaXMuYXR0ck9yZGVySWQgPSByb3NFbGFzdGljREJJbnN0YW5jZS5hdHRyT3JkZXJJZDtcbiAgICAgICAgdGhpcy5hdHRyUG9ydCA9IHJvc0VsYXN0aWNEQkluc3RhbmNlLmF0dHJQb3J0O1xuICAgIH1cbn1cbiJdfQ==