"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstancePublicConnection = exports.InstancePublicConnectionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gpdb_generated_1 = require("./gpdb.generated");
Object.defineProperty(exports, "InstancePublicConnectionProperty", { enumerable: true, get: function () { return gpdb_generated_1.RosInstancePublicConnection; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::GPDB::InstancePublicConnection`, which is used to allocate a public connection string to an instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosInstancePublicConnection`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-gpdb-instancepublicconnection
 */
class InstancePublicConnection extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosInstancePublicConnection = new gpdb_generated_1.RosInstancePublicConnection(this, id, {
            dbInstanceId: props.dbInstanceId,
            port: props.port,
            connectionStringPrefix: props.connectionStringPrefix,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstancePublicConnection;
        this.attrConnectionString = rosInstancePublicConnection.attrConnectionString;
        this.attrDbInstanceId = rosInstancePublicConnection.attrDbInstanceId;
    }
}
exports.InstancePublicConnection = InstancePublicConnection;
//# sourceMappingURL=data:application/json;base64,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