# Generated by Django 4.2.1 on 2023-06-07 12:10

from django.conf import settings
import django.contrib.gis.db.models.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import django_extensions.db.fields
import geomanager.fields
import geomanager.models.raster_file
import modelcluster.fields
import uuid
import wagtail.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtail_color_panel.blocks
import wagtail_color_panel.fields
import wagtailiconchooser.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('wagtailcore', '0083_workflowcontenttype'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(help_text='Title of the category', max_length=16, verbose_name='title')),
                ('icon', models.CharField(blank=True, max_length=255, null=True, verbose_name='icon')),
                ('active', models.BooleanField(default=True, help_text='Is the category active ?', verbose_name='active')),
                ('public', models.BooleanField(default=True, help_text='Is the category public ?', verbose_name='public')),
            ],
            options={
                'verbose_name_plural': 'Categories',
                'ordering': ['order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CountryBoundary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name_0', models.CharField(blank=True, max_length=100, null=True)),
                ('name_1', models.CharField(blank=True, max_length=100, null=True)),
                ('name_2', models.CharField(blank=True, max_length=100, null=True)),
                ('gid_0', models.CharField(blank=True, max_length=100, null=True)),
                ('gid_1', models.CharField(blank=True, max_length=100, null=True)),
                ('gid_2', models.CharField(blank=True, max_length=100, null=True)),
                ('level', models.IntegerField(blank=True, null=True)),
                ('size', models.CharField(blank=True, max_length=100, null=True)),
                ('geom', django.contrib.gis.db.models.fields.MultiPolygonField(srid=4326)),
            ],
            options={
                'verbose_name_plural': 'Country Boundaries',
            },
        ),
        migrations.CreateModel(
            name='Dataset',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='The Dataset title as will appear to the public', max_length=255, verbose_name='title')),
                ('summary', models.CharField(blank=True, help_text='Short summary of less than 100 characters', max_length=100, null=True, verbose_name='summary')),
                ('layer_type', models.CharField(choices=[('file', 'Raster'), ('wms', 'WMS'), ('vector', 'Vector')], default='file', max_length=100, verbose_name='layer_type')),
                ('published', models.BooleanField(default=True, help_text='Should the dataset be available for visualization ? If unchecked, the dataset is assumed to be in draft mode and thus not ready', verbose_name='published')),
                ('public', models.BooleanField(default=True, help_text='Should the dataset be visible to everyone ? If unchecked, only authorized users can view', verbose_name='public')),
                ('initial_visible', models.BooleanField(default=False, help_text='Make the dataset visible on the map by default', verbose_name='Initially visible on Map by default')),
                ('multi_temporal', models.BooleanField(default=True, help_text='The dataset is multi-temporal', verbose_name='multi-temporal')),
                ('multi_layer', models.BooleanField(default=False, help_text='The dataset has more than one layer, to be displayed together', verbose_name='multi-layer')),
                ('near_realtime', models.BooleanField(default=False, help_text='Is the layer near realtime?, for example updates every 10 minutes', verbose_name='near realtime')),
                ('current_time_method', models.CharField(choices=[('latest_from_source', 'Latest From Source'), ('previous_to_now', 'Previous to now'), ('next_to_now', 'Next to Now')], default='latest_from_source', help_text='How to pick default time and for updates, for Multi-Temporal data', max_length=100, verbose_name='current time method')),
                ('auto_update_interval', models.IntegerField(blank=True, help_text='After how many minutes should the layer auto update on the map to show current data, if multi-temporal. Leave empty to disable auto updating', null=True, verbose_name='Auto Update interval in minutes')),
                ('can_clip', models.BooleanField(default=False, help_text='Check to enable clipping by boundary or drawn shapes, for raster and vector datasets. Not implemented for WMS types', verbose_name='Enable Clipping by shape')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='geomanager.category', verbose_name='category')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Geostore',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('iso', models.CharField(blank=True, max_length=100, null=True)),
                ('id1', models.CharField(blank=True, max_length=100, null=True)),
                ('id2', models.CharField(blank=True, max_length=100, null=True)),
                ('name_0', models.CharField(blank=True, max_length=100, null=True)),
                ('name_1', models.CharField(blank=True, max_length=100, null=True)),
                ('name_2', models.CharField(blank=True, max_length=100, null=True)),
                ('geom', django.contrib.gis.db.models.fields.MultiPolygonField(srid=4326)),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MBTSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name', models.CharField(help_text='Style Name', max_length=255, verbose_name='name')),
                ('slug', models.CharField(editable=False, max_length=255, unique=True)),
                ('file', models.FileField(upload_to='mbtiles', verbose_name='file')),
                ('use_default_style', models.BooleanField(default=True, verbose_name='Use default style')),
                ('open_map_style_json', models.JSONField(blank=True, help_text="OpenMapTiles JSON Style. See schema here: <a href='https://openmaptiles.org/schema' target='_blank' rel='noopener noreferrer'>https://openmaptiles.org/schema</a>", null=True, verbose_name='OpenMapTiles style')),
            ],
            options={
                'verbose_name': 'Basemap Source',
            },
        ),
        migrations.CreateModel(
            name='Metadata',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='Title of the dataset', max_length=255, verbose_name='title')),
                ('subtitle', models.CharField(blank=True, help_text='Subtitle if any', max_length=255, null=True, verbose_name='subtitle')),
                ('function', models.TextField(blank=True, help_text='Short summary of what the dataset shows. Keep it short.', max_length=255, null=True, verbose_name='Dataset summary')),
                ('resolution', models.CharField(blank=True, help_text='The Spatial resolution of the dataset, for example 10km by 10 km', max_length=255, null=True, verbose_name='resolution')),
                ('geographic_coverage', models.CharField(blank=True, help_text='The geographic coverage of the dataset. For example East Africa or specific country name like Ethiopia, or Africa', max_length=255, null=True, verbose_name='Geographic coverage')),
                ('source', models.CharField(blank=True, help_text='The source of the data where was it generated or produced', max_length=255, null=True, verbose_name='source')),
                ('license', models.CharField(blank=True, help_text='Any licensing information for the dataset', max_length=255, null=True, verbose_name='license')),
                ('frequency_of_update', models.CharField(blank=True, help_text='How frequent is the dataset updated. For example daily, weekly, monthly etc', max_length=255, null=True, verbose_name='Frequency of updates')),
                ('overview', wagtail.fields.RichTextField(blank=True, help_text='Detail description of the dataset, including the methodology, references or any other relevant information', null=True, verbose_name='detail')),
                ('cautions', wagtail.fields.RichTextField(blank=True, help_text='What things should users be aware as they use and interpret this dataset', null=True, verbose_name='cautions')),
                ('citation', wagtail.fields.RichTextField(blank=True, help_text='Scientific citation for this dataset if any. For example the citation for a scientific paper for the dataset', null=True, verbose_name='citation')),
                ('download_data', models.URLField(blank=True, help_text='External link to where the source data can be found and downloaded', null=True, verbose_name='Data download link')),
                ('learn_more', models.URLField(blank=True, help_text='External link to where more detail about the dataset can be found', null=True, verbose_name='Learn more link')),
            ],
            options={
                'verbose_name_plural': 'Metadata',
            },
        ),
        migrations.CreateModel(
            name='RasterStyle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('name', models.CharField(help_text='Style name for identification', max_length=256, verbose_name='name')),
                ('unit', models.CharField(blank=True, help_text='Data unit', max_length=100, null=True, verbose_name='data unit')),
                ('min', models.IntegerField(default=0, help_text='minimum value', verbose_name='minimum value')),
                ('max', models.IntegerField(default=100, help_text='maximum value', verbose_name='maximum value')),
                ('steps', models.IntegerField(blank=True, default=5, help_text='Number of steps', null=True, validators=[django.core.validators.MinValueValidator(3), django.core.validators.MaxValueValidator(20)], verbose_name='steps')),
                ('use_custom_colors', models.BooleanField(default=False, verbose_name='Use Custom Colors')),
                ('palette', models.TextField(blank=True, null=True, verbose_name='Color Palette')),
                ('interpolate', models.BooleanField(default=False, help_text='Interpolate colorscale', verbose_name='interpolate')),
                ('custom_color_for_rest', wagtail_color_panel.fields.ColorField(blank=True, default='#ff0000', help_text='Color for values greater than the values defined above, as well as values greater than the maximum value', max_length=7, null=True, verbose_name='Color for the rest of values')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WmsLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('base_url', models.CharField(max_length=500, verbose_name='base url for WMS')),
                ('version', models.CharField(choices=[('1.1.1', '1.1.1'), ('1.3.0', '1.3.0')], default='1.1.1', max_length=50, verbose_name='WMS Version')),
                ('width', models.IntegerField(default=256, help_text='The size of the map image in pixels along the i axis', verbose_name='Pixel Width')),
                ('height', models.IntegerField(default=256, help_text='The size of the map image in pixels along the j axis', verbose_name='Pixel Height')),
                ('transparent', models.BooleanField(default=True, help_text='Ability of underlying maps to be visible or not', verbose_name='Transparency')),
                ('srs', models.CharField(default='EPSG:3857', help_text='WMS Spatial Reference e.g EPSG:3857', max_length=50, verbose_name='Spatial Reference System')),
                ('format', models.CharField(choices=[('image/png', 'PNG'), ('image/jpeg', 'JPEG'), ('image/gif', 'GIF')], default='image/png', help_text='Allowed map formats are either “picture” formats or “graphic element” formats.', max_length=50, verbose_name='Output Format')),
                ('wms_query_params_selectable', wagtail.fields.StreamField([('param', wagtail.blocks.StructBlock([('name', wagtail.blocks.CharBlock(label='name')), ('label', wagtail.blocks.CharBlock(label='label', required=False)), ('type', wagtail.blocks.ChoiceBlock(choices=[('radio', 'Radio'), ('dropdown', 'Dropdown')], label='Selector Type')), ('options', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('label', wagtail.blocks.CharBlock(label='label')), ('value', wagtail.blocks.CharBlock(label='value')), ('default', wagtail.blocks.BooleanBlock(help_text='Check to make default option', label='default', required=False))]), label='Options', min_num=1))], label='Query Parameter'))], blank=True, help_text='This should provide a list of options that users can choose to change the query parameter of the url', null=True, use_json_field=True, verbose_name='WMS Query Params With selectable Options')),
                ('params_selectors_side_by_side', models.BooleanField(default=False, verbose_name='Arrange Param Selectors side by side')),
                ('legend', wagtail.fields.StreamField([('legend', wagtail.blocks.StructBlock([('type', wagtail.blocks.ChoiceBlock(choices=[('basic', 'Basic'), ('gradient', 'Gradient'), ('choropleth', 'Choropleth')], label='Legend Type')), ('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('value', wagtail.blocks.CharBlock(help_text="Can be a number or text e.g '10' or '10-20' or 'Vegetation'", label='value')), ('color', wagtail.blocks.CharBlock(help_text='Color value e.g rgb(73,73,73) or #494949', label='color'))]), label='Legend Items', min_num=1))], label='Custom Legend')), ('legend_image', wagtail.images.blocks.ImageChooserBlock(label='Custom Image'))], blank=True, null=True, use_json_field=True, verbose_name='Legend')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='wms_layers', to='geomanager.dataset', verbose_name='dataset')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WmsRequestStyle',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(help_text="The style's Name is used in the Map request STYLES parameter", max_length=250, verbose_name='name')),
                ('layer', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='wms_request_styles', to='geomanager.wmslayer', verbose_name='WMS Request Styles')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WmsRequestParam',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(help_text='Name of the parameter', max_length=250, verbose_name='name')),
                ('value', models.CharField(help_text='Value of the parameter', max_length=250)),
                ('layer', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='wms_request_params', to='geomanager.wmslayer', verbose_name='WMS Requests Additional Parameters')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='WmsRequestLayer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('name', models.CharField(help_text='WMS Layer is requested by using this name in the LAYERS parameter of a GetMap request.', max_length=250, verbose_name='name')),
                ('layer', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='wms_request_layers', to='geomanager.wmslayer', verbose_name='WMS Request Layers')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VectorUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('file', models.FileField(upload_to='vector_uploads')),
                ('vector_metadata', models.JSONField(blank=True, null=True)),
                ('dataset', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.dataset')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VectorLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('render_layers', wagtail.fields.StreamField([('fill', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('fill_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='fill color', required=False)), ('fill_opacity', wagtail.blocks.FloatBlock(default=1.0, label='fill opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('fill_outline_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='fill outline color', required=False)), ('fill_antialias', wagtail.blocks.BooleanBlock(default=True, label='fill antialias', required=False))], label='Paint Properties')), ('filter', wagtail.blocks.CharBlock(label='filter', required=False)), ('maxzoom', wagtail.blocks.IntegerBlock(label='maxzoom', required=False)), ('minzoom', wagtail.blocks.IntegerBlock(label='minzoom', required=False))], label='Polygon Layer')), ('line', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('line_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Line color', required=False)), ('line_dasharray', wagtail.blocks.CharBlock(label='Line dasharray', required=False)), ('line_gap_width', wagtail.blocks.FloatBlock(default=0.0, label='Line gap width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('line_opacity', wagtail.blocks.FloatBlock(default=1.0, label='line opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('line_width', wagtail.blocks.FloatBlock(default=1.0, label='Line width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('line_offset', wagtail.blocks.FloatBlock(default=0, label='Line offset', required=False, validators=[django.core.validators.MinValueValidator(0)]))], label='Paint Properties')), ('layout', wagtail.blocks.StructBlock([('line_cap', wagtail.blocks.ChoiceBlock(choices=[('butt', 'Butt'), ('round', 'Round'), ('square', 'Square')], label='Line cap', required=False)), ('line_join', wagtail.blocks.ChoiceBlock(choices=[('miter', 'Miter'), ('bevel', 'Bevel'), ('round', 'Round')], label='Line join', required=False)), ('line_miter_limit', wagtail.blocks.FloatBlock(default=2.0, label='line miter limit', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('line_round_limit', wagtail.blocks.FloatBlock(default=1.05, label='line round limit', required=False, validators=[django.core.validators.MinValueValidator(0)]))], label='Layout Properties')), ('filter', wagtail.blocks.CharBlock(label='filter', required=False)), ('maxzoom', wagtail.blocks.IntegerBlock(label='maxzoom', required=False)), ('minzoom', wagtail.blocks.IntegerBlock(label='minzoom', required=False))], label='Line Layer')), ('circle', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('circle_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='circle color', required=False)), ('circle_opacity', wagtail.blocks.FloatBlock(default=1.0, label='circle opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('circle_radius', wagtail.blocks.FloatBlock(default=5.0, label='circle radius', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('circle_stroke_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='circle stroke color', required=False)), ('circle_stroke_width', wagtail.blocks.FloatBlock(default=0.0, label='circle_stroke_width', required=False, validators=[django.core.validators.MinValueValidator(0)]))], label='Paint Properties')), ('filter', wagtail.blocks.CharBlock(label='filter', required=False)), ('maxzoom', wagtail.blocks.IntegerBlock(label='maxzoom', required=False)), ('minzoom', wagtail.blocks.IntegerBlock(label='minzoom', required=False))], label='Point Layer')), ('icon', wagtail.blocks.StructBlock([('layout', wagtail.blocks.StructBlock([('icon_image', wagtailiconchooser.blocks.IconChooserBlock(label='Icon Image')), ('icon_allow_overlap', wagtail.blocks.BooleanBlock(default=False, label='Icon allow overlap', required=False)), ('icon_anchor', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('top', 'Top'), ('bottom', 'Bottom'), ('top-left', 'Top Left'), ('top-right', 'Top Right'), ('bottom-left', 'Bottom Left'), ('bottom-right', 'Bottom Right')], label='Icon anchor', required=False)), ('icon_ignore_placement', wagtail.blocks.BooleanBlock(default=False, label='Icon ignore placement', required=False)), ('icon_keep_upright', wagtail.blocks.BooleanBlock(default=False, label='Icon keep upright', required=False)), ('icon_offset', wagtail.blocks.CharBlock(label='Icon offset', required=False)), ('icon_optional', wagtail.blocks.BooleanBlock(default=False, label='Icon optional', required=False)), ('icon_padding', wagtail.blocks.FloatBlock(default=2.0, label='Icon padding', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('icon_pitch_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Icon pitch alignment', required=False)), ('icon_rotate', wagtail.blocks.IntegerBlock(default=0, label='icon rotate', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)])), ('icon_rotation_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Icon rotation alignment', required=False)), ('icon_size', wagtail.blocks.FloatBlock(default=1, label='icon size', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('icon_text_fit', wagtail.blocks.ChoiceBlock(choices=[('none', 'None'), ('width', 'Width'), ('height', 'Height'), ('both', 'Both')], label='Icon text fit', required=False))], label='Layout Properties')), ('paint', wagtail.blocks.StructBlock([('icon_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Icon color', required=False)), ('icon_halo_blur', wagtail.blocks.FloatBlock(default=0.0, label='Icon halo blur', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('icon_halo_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Icon halo color', required=False)), ('icon_halo_width', wagtail.blocks.FloatBlock(default=0.0, label='icon halo width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('icon_opacity', wagtail.blocks.FloatBlock(default=1.0, label='icon opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)]))], label='Paint Properties'))], label='Icon Layer')), ('text', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('text_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Text color', required=False)), ('text_halo_blur', wagtail.blocks.FloatBlock(default=0.0, label='Text halo blur', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_halo_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Text halo color', required=False)), ('text_halo_width', wagtail.blocks.FloatBlock(default=0.0, label='text halo width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_translate', wagtail.blocks.CharBlock(label='Text translate', required=False)), ('text_translate_anchor', wagtail.blocks.ChoiceBlock(choices=[('map', 'Map'), ('viewport', 'Viewport')], label='Text translate anchor', required=False))], label='Paint Properties')), ('layout', wagtail.blocks.StructBlock([('symbol_placement', wagtail.blocks.ChoiceBlock(choices=[('point', 'Point'), ('line', 'Line'), ('line-center', 'Line Center')], label='Text Placement', required=False)), ('text_allow_overlap', wagtail.blocks.BooleanBlock(default=False, label='Text allow overlap', required=False)), ('text_anchor', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('top', 'Top'), ('bottom', 'Bottom'), ('top-left', 'Top Left'), ('top-right', 'Top Right'), ('bottom-left', 'Bottom Left'), ('bottom-right', 'Bottom Right')], label='Text anchor', required=False)), ('text_field', wagtail.blocks.CharBlock(label='Text field')), ('text_size', wagtail.blocks.IntegerBlock(default=16, label='Text size', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_transform', wagtail.blocks.ChoiceBlock(choices=[('none', 'None'), ('uppercase', 'Uppercase'), ('lowercase', 'Lowercase')], label='Text transform', required=False)), ('text_ignore_placement', wagtail.blocks.BooleanBlock(default=False, label='Text ignore placement', required=False)), ('text_justify', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('auto', 'Auto')], label='Text justify', required=False)), ('text_keep_upright', wagtail.blocks.BooleanBlock(default=False, label='Text keep upright', required=False)), ('text_letter_spacing', wagtail.blocks.FloatBlock(default=0.0, label='Text letter spacing', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_line_height', wagtail.blocks.FloatBlock(default=1.2, label='Text line height', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_max_angle', wagtail.blocks.IntegerBlock(default=45, label='Text max angle', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)])), ('text_max_width', wagtail.blocks.IntegerBlock(default=10, label='Text max width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_offset', wagtail.blocks.CharBlock(label='Text offset', required=False)), ('text_opacity', wagtail.blocks.FloatBlock(default=1.0, label='text opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('text_padding', wagtail.blocks.IntegerBlock(default=2, label='Text  padding', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_pitch_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Text pitch alignment', required=False)), ('text_radial_offset', wagtail.blocks.IntegerBlock(default=0, label='Text radial offset', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_rotate', wagtail.blocks.IntegerBlock(default=0, label='Text rotate', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)])), ('text_rotation_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Text rotation alignment', required=False)), ('text_variable_anchor', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('top', 'Top'), ('bottom', 'Bottom'), ('top-left', 'Top Left'), ('top-right', 'Top Right'), ('bottom-left', 'Bottom Left'), ('bottom-right', 'Bottom Right')], label='Text variable anchor', required=False))], label='Layout Properties'))], label='Text Label Layer'))], blank=True, null=True, use_json_field=True, verbose_name='Render Layers')),
                ('legend', wagtail.fields.StreamField([('legend', wagtail.blocks.StructBlock([('type', wagtail.blocks.ChoiceBlock(choices=[('basic', 'Basic'), ('gradient', 'Gradient'), ('choropleth', 'Choropleth')], label='Legend Type')), ('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('value', wagtail.blocks.CharBlock(help_text="Can be a number or text e.g '10' or '10-20' or 'Vegetation'", label='value')), ('color', wagtail.blocks.CharBlock(help_text='Color value e.g rgb(73,73,73) or #494949', label='color'))]), label='Legend Items', min_num=1))], label='Legend')), ('legend_image', wagtail.images.blocks.ImageChooserBlock(label='Legend Image')), ('legend_icon', wagtail.blocks.StructBlock([('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('icon_image', wagtailiconchooser.blocks.IconChooserBlock(label='Icon Image')), ('icon_label', wagtail.blocks.CharBlock(label='Icon Label')), ('icon_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Icon color', required=False))]), label='Legend Icons', min_num=1))], label='Legend Icon'))], blank=True, null=True, use_json_field=True, verbose_name='Legend')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vector_layers', to='geomanager.dataset', verbose_name='dataset')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SubCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('title', models.CharField(max_length=256, verbose_name='title')),
                ('active', models.BooleanField(default=True, verbose_name='active')),
                ('public', models.BooleanField(default=True, verbose_name='public')),
                ('category', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='sub_categories', to='geomanager.category')),
            ],
            options={
                'ordering': ['sort_order'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RasterUpload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('file', models.FileField(upload_to='raster_uploads', verbose_name='file')),
                ('raster_metadata', models.JSONField(blank=True, null=True)),
                ('dataset', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.dataset', verbose_name='dataset')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GeoManagerUserProfile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('gender', models.CharField(max_length=50, verbose_name='Gender')),
                ('country', models.CharField(max_length=50, verbose_name='Country')),
                ('city', models.CharField(max_length=255, verbose_name='City')),
                ('sector', models.TextField(verbose_name='Sector')),
                ('organization', models.CharField(max_length=255, verbose_name='Organization')),
                ('organization_type', models.TextField(max_length=255, verbose_name='Organization Type')),
                ('scale_of_operations', models.CharField(max_length=255, verbose_name='Scale of Operations')),
                ('position', models.CharField(max_length=255, verbose_name='Position')),
                ('how_do_you_use', models.CharField(blank=True, max_length=255, null=True, verbose_name='How do you Use')),
                ('interests', models.TextField(blank=True, null=True, verbose_name='Interests')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GeomanagerSettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('max_upload_size_mb', models.IntegerField(default=10, help_text='Maximum raster file size that can be uploaded in MegaBytes. Default is 10Mbs.', verbose_name='Maximum upload size in MegaBytes')),
                ('cap_base_url', models.URLField(blank=True, max_length=256, null=True, verbose_name='cap base url')),
                ('cap_auto_refresh_interval', models.IntegerField(blank=True, help_text='Refresh cap alerts on the map after this minutes. Leave blank to disable auto refreshing', null=True, verbose_name='Auto Refresh interval in minutes')),
                ('cap_shown_by_default', models.BooleanField(default=True, help_text='CAP Layer shown on map by default', verbose_name='CAP layer shown by default')),
                ('country', django_countries.fields.CountryField(max_length=2, verbose_name='country')),
                ('gadm_version', models.CharField(choices=[('4.1', '4.1')], default='4.1', help_text='It is encouraged to use the latest version. See available versions here: https://gadm.org/old_versions.html', max_length=50, verbose_name='GADM Boundary Data Version')),
                ('tile_gl_fonts_url', models.URLField(default='https://fonts.openmaptiles.org/{fontstack}/{range}.pbf', help_text='GL Styles Font Url', max_length=256, verbose_name='GL Styles Font Url')),
                ('base_maps', wagtail.fields.StreamField([('basemap', wagtail.blocks.StructBlock([('label', wagtail.blocks.CharBlock(label='label')), ('backgroundColor', wagtail.blocks.CharBlock(label='background color')), ('image', wagtail.images.blocks.ImageChooserBlock(label='image', required=False)), ('basemapGroup', wagtail.blocks.CharBlock(label='basemap group')), ('labelsGroup', wagtail.blocks.CharBlock(label='labels group')), ('url', wagtail.blocks.URLBlock(label='url', required=False)), ('default', wagtail.blocks.BooleanBlock(help_text='Is default style ?', label='default', required=False))]))], blank=True, null=True, use_json_field=True)),
                ('cap_metadata', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.metadata', verbose_name='Metadata')),
                ('cap_sub_category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.subcategory', verbose_name='cap layer sub category')),
                ('site', models.OneToOneField(editable=False, on_delete=django.db.models.deletion.CASCADE, to='wagtailcore.site')),
                ('tile_gl_source', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.mbtsource', verbose_name='Open Map Tiles Source')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FileImageLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('analysis', wagtail.fields.StreamField([('point_analysis', wagtail.blocks.StructBlock([('instance_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show data for point', required=False)), ('timeseries_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show timeseries data for point', required=False)), ('unit', wagtail.blocks.CharBlock(label='Data unit', required=False)), ('timeseries_chart_type', wagtail.blocks.ChoiceBlock(choices=[('lines', 'Line Chart'), ('bars', 'Bar Chart')], label='Chart Type')), ('timeseries_chart_color', wagtail_color_panel.blocks.NativeColorBlock(default='#367DA4', label='Chart Line/Bar Color', required=True))], label='Point Analysis')), ('area_analysis', wagtail.blocks.StructBlock([('instance_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show data for area', required=False)), ('instance_value_type', wagtail.blocks.ChoiceBlock(choices=[('mean', 'Mean of pixel values'), ('sum', 'Sum of pixel values'), ('minmax', 'Minimum, Maximum pixel values'), ('minmeanmax', 'Minimum, Mean, Maximum pixel values')], help_text='The value type that should be displayed', label='Area value type')), ('unit', wagtail.blocks.CharBlock(label='Data unit', required=False)), ('timeseries_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show timeseries data for area', required=False)), ('timeseries_aggregation_method', wagtail.blocks.ChoiceBlock(choices=[('mean', 'By Mean'), ('sum', 'By Sum')], help_text='How should the region data be aggregated ?', label='Area timeseries data aggregation Method')), ('timeseries_chart_type', wagtail.blocks.ChoiceBlock(choices=[('lines', 'Line Chart'), ('bars', 'Bar Chart')], label='Chart Type')), ('timeseries_chart_color', wagtail_color_panel.blocks.NativeColorBlock(default='#367DA4', label='circle stroke color', required=True))], label='Area Analysis'))], blank=True, null=True, use_json_field=True, verbose_name='Analysis')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='file_layers', to='geomanager.dataset', verbose_name='dataset')),
                ('style', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.rasterstyle', verbose_name='style')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='dataset',
            name='metadata',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.metadata', verbose_name='metadata'),
        ),
        migrations.AddField(
            model_name='dataset',
            name='sub_category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='geomanager.subcategory', verbose_name='sub_category'),
        ),
        migrations.CreateModel(
            name='ColorValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, editable=False, null=True)),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('threshold', models.FloatField(verbose_name='threshold')),
                ('color', wagtail_color_panel.fields.ColorField(default='#ff0000', max_length=7, verbose_name='color')),
                ('label', models.CharField(blank=True, max_length=100, null=True, verbose_name='label')),
                ('layer', modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='color_values', to='geomanager.rasterstyle')),
            ],
            options={
                'verbose_name': 'Color Value',
                'verbose_name_plural': 'Color Values',
            },
        ),
        migrations.CreateModel(
            name='AreaOfInterest',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('adm_0', models.CharField(blank=True, max_length=255, null=True, verbose_name='Adm 0')),
                ('adm_1', models.CharField(blank=True, max_length=255, null=True, verbose_name='Adm 1')),
                ('adm_2', models.CharField(blank=True, max_length=255, null=True, verbose_name='Adm 2')),
                ('adm_3', models.CharField(blank=True, max_length=255, null=True, verbose_name='Adm 3')),
                ('public', models.BooleanField(default=False, verbose_name='Public')),
                ('type', models.CharField(blank=True, max_length=255, null=True, verbose_name='Type')),
                ('products', models.TextField(blank=True, null=True, verbose_name='Products')),
                ('tags', models.TextField(blank=True, null=True, verbose_name='Tags')),
                ('webhook_url', models.URLField(blank=True, null=True, verbose_name='Webhook Url')),
                ('geostore_id', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.geostore', verbose_name='Geostore Id')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PgVectorTable',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('table_name', models.CharField(max_length=256, unique=True)),
                ('full_table_name', models.CharField(max_length=256)),
                ('description', models.TextField(blank=True, null=True)),
                ('time', models.DateTimeField(help_text='time for the dataset')),
                ('properties', models.JSONField()),
                ('geometry_type', models.CharField(max_length=100)),
                ('bounds', geomanager.fields.ListField(max_length=256)),
                ('layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vector_tables', to='geomanager.vectorlayer')),
            ],
            options={
                'ordering': ['-time'],
                'unique_together': {('layer', 'time')},
            },
        ),
        migrations.CreateModel(
            name='LayerRasterFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('file', models.FileField(editable=False, upload_to=geomanager.models.raster_file.layer_raster_file_dir_path, verbose_name='file')),
                ('time', models.DateTimeField(help_text='Time for the raster file. This can be the time the data was acquired, or the date and time for which the data applies', verbose_name='time')),
                ('layer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='raster_files', to='geomanager.fileimagelayer', verbose_name='layer')),
            ],
            options={
                'ordering': ['time'],
                'unique_together': {('layer', 'time')},
            },
        ),
    ]
