# Generated by Django 4.1.10 on 2023-09-27 12:31

from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import uuid
import wagtail.blocks
import wagtail.fields
import wagtail.images.blocks


class Migration(migrations.Migration):

    dependencies = [
        ('geomanager', '0019_wmslayer_get_capabilities_layer_name_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='TmsLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('base_url', models.CharField(max_length=500, verbose_name='Base url for TMS')),
                ('query_params_static', wagtail.fields.StreamField([('param', wagtail.blocks.StructBlock([('key', wagtail.blocks.CharBlock(label='Key')), ('value', wagtail.blocks.CharBlock(label='Value'))], label='Query Parameter'))], blank=True, help_text='Static query params to be added to the url', null=True, use_json_field=True, verbose_name='Static Query Params')),
                ('query_params_selectable', wagtail.fields.StreamField([('param', wagtail.blocks.StructBlock([('name', wagtail.blocks.CharBlock(label='name')), ('label', wagtail.blocks.CharBlock(label='label', required=False)), ('type', wagtail.blocks.ChoiceBlock(choices=[('radio', 'Radio'), ('dropdown', 'Dropdown')], label='Selector Type')), ('options', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('label', wagtail.blocks.CharBlock(label='label')), ('value', wagtail.blocks.CharBlock(label='value')), ('default', wagtail.blocks.BooleanBlock(help_text='Check to make default option', label='default', required=False))]), label='Options', min_num=1))], label='Selectable Query Parameter'))], blank=True, help_text='This should provide a list of options that users can choose to change the query parameter of the url', null=True, use_json_field=True, verbose_name='Query Params With selectable Options')),
                ('params_selectors_side_by_side', models.BooleanField(default=False, verbose_name='Arrange Param Selectors side by side')),
                ('legend', wagtail.fields.StreamField([('legend', wagtail.blocks.StructBlock([('type', wagtail.blocks.ChoiceBlock(choices=[('basic', 'Basic'), ('gradient', 'Gradient'), ('choropleth', 'Choropleth')], label='Legend Type')), ('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('value', wagtail.blocks.CharBlock(help_text="Can be a number or text e.g '10' or '10-20' or 'Vegetation'", label='value')), ('color', wagtail.blocks.CharBlock(help_text='Color value e.g rgb(73,73,73) or #494949', label='color'))]), label='Legend Items', min_num=1))], label='Custom Legend')), ('legend_image', wagtail.images.blocks.ImageChooserBlock(label='Custom Image'))], blank=True, null=True, use_json_field=True, verbose_name='Legend')),
                ('more_info', wagtail.fields.StreamField([('more_info', wagtail.blocks.StructBlock([('link_text', wagtail.blocks.CharBlock(label='Link text', required=True)), ('link_url', wagtail.blocks.URLBlock(label='Link Url', required=True)), ('text', wagtail.blocks.TextBlock(label='Short description text', required=False)), ('is_button', wagtail.blocks.BooleanBlock(default=True, label='Format link as action button', required=False)), ('show_arrow', wagtail.blocks.BooleanBlock(default=True, label='Show arrow in button', required=False))], label='Info link'))], blank=True, null=True, use_json_field=True, verbose_name='More Info')),
                ('dataset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tms_layers', to='geomanager.dataset', verbose_name='dataset')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
    ]
