# Generated by Django 4.1.10 on 2023-10-02 09:50

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import modelcluster.fields
import uuid
import wagtail.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtail_color_panel.blocks
import wagtailiconchooser.blocks


class Migration(migrations.Migration):

    dependencies = [
        ('geomanager', '0020_tmslayer'),
    ]

    operations = [
        migrations.CreateModel(
            name='RasterFileLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('analysis', wagtail.fields.StreamField([('point_analysis', wagtail.blocks.StructBlock([('instance_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show data for point', required=False)), ('timeseries_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show timeseries data for point', required=False)), ('unit', wagtail.blocks.CharBlock(label='Data unit', required=False)), ('timeseries_chart_type', wagtail.blocks.ChoiceBlock(choices=[('lines', 'Line Chart'), ('bars', 'Bar Chart')], label='Chart Type')), ('timeseries_chart_color', wagtail_color_panel.blocks.NativeColorBlock(default='#367DA4', label='Chart Line/Bar Color', required=True))], label='Point Analysis')), ('area_analysis', wagtail.blocks.StructBlock([('instance_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show data for area', required=False)), ('instance_value_type', wagtail.blocks.ChoiceBlock(choices=[('mean', 'Mean of pixel values'), ('sum', 'Sum of pixel values'), ('minmax', 'Minimum, Maximum pixel values'), ('minmeanmax', 'Minimum, Mean, Maximum pixel values')], help_text='The value type that should be displayed', label='Area value type')), ('unit', wagtail.blocks.CharBlock(label='Data unit', required=False)), ('timeseries_data_enabled', wagtail.blocks.BooleanBlock(default=True, label='Show timeseries data for area', required=False)), ('timeseries_aggregation_method', wagtail.blocks.ChoiceBlock(choices=[('mean', 'By Mean'), ('sum', 'By Sum')], help_text='How should the region data be aggregated ?', label='Area timeseries data aggregation Method')), ('timeseries_chart_type', wagtail.blocks.ChoiceBlock(choices=[('lines', 'Line Chart'), ('bars', 'Bar Chart')], label='Chart Type')), ('timeseries_chart_color', wagtail_color_panel.blocks.NativeColorBlock(default='#367DA4', label='circle stroke color', required=True))], label='Area Analysis'))], blank=True, null=True, use_json_field=True, verbose_name='Analysis')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RasterTileLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('base_url', models.CharField(max_length=500, verbose_name='Base raster tile url')),
                ('query_params_static', wagtail.fields.StreamField([('param', wagtail.blocks.StructBlock([('key', wagtail.blocks.CharBlock(label='Key')), ('value', wagtail.blocks.CharBlock(label='Value'))], label='Query Parameter'))], blank=True, help_text='Static query params to be added to the url', null=True, use_json_field=True, verbose_name='Static Query Params')),
                ('query_params_selectable', wagtail.fields.StreamField([('param', wagtail.blocks.StructBlock([('name', wagtail.blocks.CharBlock(label='name')), ('label', wagtail.blocks.CharBlock(label='label', required=False)), ('type', wagtail.blocks.ChoiceBlock(choices=[('radio', 'Radio'), ('dropdown', 'Dropdown')], label='Selector Type')), ('options', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('label', wagtail.blocks.CharBlock(label='label')), ('value', wagtail.blocks.CharBlock(label='value')), ('default', wagtail.blocks.BooleanBlock(help_text='Check to make default option', label='default', required=False))]), label='Options', min_num=1))], label='Selectable Query Parameter'))], blank=True, help_text='This should provide a list of options that users can choose to change the query parameter of the url', null=True, use_json_field=True, verbose_name='Query Params With selectable Options')),
                ('params_selectors_side_by_side', models.BooleanField(default=False, verbose_name='Arrange Param Selectors side by side')),
                ('legend', wagtail.fields.StreamField([('legend', wagtail.blocks.StructBlock([('type', wagtail.blocks.ChoiceBlock(choices=[('basic', 'Basic'), ('gradient', 'Gradient'), ('choropleth', 'Choropleth')], label='Legend Type')), ('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('value', wagtail.blocks.CharBlock(help_text="Can be a number or text e.g '10' or '10-20' or 'Vegetation'", label='value')), ('color', wagtail.blocks.CharBlock(help_text='Color value e.g rgb(73,73,73) or #494949', label='color'))]), label='Legend Items', min_num=1))], label='Custom Legend')), ('legend_image', wagtail.images.blocks.ImageChooserBlock(label='Custom Image'))], blank=True, null=True, use_json_field=True, verbose_name='Legend')),
                ('more_info', wagtail.fields.StreamField([('more_info', wagtail.blocks.StructBlock([('link_text', wagtail.blocks.CharBlock(label='Link text', required=True)), ('link_url', wagtail.blocks.URLBlock(label='Link Url', required=True)), ('text', wagtail.blocks.TextBlock(label='Short description text', required=False)), ('is_button', wagtail.blocks.BooleanBlock(default=True, label='Format link as action button', required=False)), ('show_arrow', wagtail.blocks.BooleanBlock(default=True, label='Show arrow in button', required=False))], label='Info link'))], blank=True, null=True, use_json_field=True, verbose_name='More Info')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VectorFileLayer',
            fields=[
                ('created', django_extensions.db.fields.CreationDateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified', django_extensions.db.fields.ModificationDateTimeField(auto_now=True, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(help_text='layer title', max_length=255, verbose_name='title')),
                ('default', models.BooleanField(default=False, help_text='Is Default Layer', verbose_name='default')),
                ('render_layers', wagtail.fields.StreamField([('fill', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('fill_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='fill color', required=False)), ('fill_opacity', wagtail.blocks.FloatBlock(default=1.0, label='fill opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('fill_outline_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='fill outline color', required=False)), ('fill_antialias', wagtail.blocks.BooleanBlock(default=True, label='fill antialias', required=False))], label='Paint Properties')), ('filter', wagtail.blocks.CharBlock(label='filter', required=False)), ('maxzoom', wagtail.blocks.IntegerBlock(label='maxzoom', required=False)), ('minzoom', wagtail.blocks.IntegerBlock(label='minzoom', required=False))], label='Polygon Layer')), ('line', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('line_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Line color', required=False)), ('line_dasharray', wagtail.blocks.CharBlock(label='Line dasharray', required=False)), ('line_gap_width', wagtail.blocks.FloatBlock(default=0.0, label='Line gap width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('line_opacity', wagtail.blocks.FloatBlock(default=1.0, label='line opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('line_width', wagtail.blocks.FloatBlock(default=1.0, label='Line width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('line_offset', wagtail.blocks.FloatBlock(default=0, label='Line offset', required=False, validators=[django.core.validators.MinValueValidator(0)]))], label='Paint Properties')), ('layout', wagtail.blocks.StructBlock([('line_cap', wagtail.blocks.ChoiceBlock(choices=[('butt', 'Butt'), ('round', 'Round'), ('square', 'Square')], label='Line cap', required=False)), ('line_join', wagtail.blocks.ChoiceBlock(choices=[('miter', 'Miter'), ('bevel', 'Bevel'), ('round', 'Round')], label='Line join', required=False)), ('line_miter_limit', wagtail.blocks.FloatBlock(default=2.0, label='line miter limit', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('line_round_limit', wagtail.blocks.FloatBlock(default=1.05, label='line round limit', required=False, validators=[django.core.validators.MinValueValidator(0)]))], label='Layout Properties')), ('filter', wagtail.blocks.CharBlock(label='filter', required=False)), ('maxzoom', wagtail.blocks.IntegerBlock(label='maxzoom', required=False)), ('minzoom', wagtail.blocks.IntegerBlock(label='minzoom', required=False))], label='Line Layer')), ('circle', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('circle_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='circle color', required=False)), ('circle_opacity', wagtail.blocks.FloatBlock(default=1.0, label='circle opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('circle_radius', wagtail.blocks.FloatBlock(default=5.0, label='circle radius', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('circle_stroke_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='circle stroke color', required=False)), ('circle_stroke_width', wagtail.blocks.FloatBlock(default=0.0, label='circle_stroke_width', required=False, validators=[django.core.validators.MinValueValidator(0)]))], label='Paint Properties')), ('filter', wagtail.blocks.CharBlock(label='filter', required=False)), ('maxzoom', wagtail.blocks.IntegerBlock(label='maxzoom', required=False)), ('minzoom', wagtail.blocks.IntegerBlock(label='minzoom', required=False))], label='Point Layer')), ('icon', wagtail.blocks.StructBlock([('layout', wagtail.blocks.StructBlock([('icon_image', wagtailiconchooser.blocks.IconChooserBlock(label='Icon Image')), ('icon_allow_overlap', wagtail.blocks.BooleanBlock(default=False, label='Icon allow overlap', required=False)), ('icon_anchor', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('top', 'Top'), ('bottom', 'Bottom'), ('top-left', 'Top Left'), ('top-right', 'Top Right'), ('bottom-left', 'Bottom Left'), ('bottom-right', 'Bottom Right')], label='Icon anchor', required=False)), ('icon_ignore_placement', wagtail.blocks.BooleanBlock(default=False, label='Icon ignore placement', required=False)), ('icon_keep_upright', wagtail.blocks.BooleanBlock(default=False, label='Icon keep upright', required=False)), ('icon_offset', wagtail.blocks.CharBlock(label='Icon offset', required=False)), ('icon_optional', wagtail.blocks.BooleanBlock(default=False, label='Icon optional', required=False)), ('icon_padding', wagtail.blocks.FloatBlock(default=2.0, label='Icon padding', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('icon_pitch_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Icon pitch alignment', required=False)), ('icon_rotate', wagtail.blocks.IntegerBlock(default=0, label='icon rotate', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)])), ('icon_rotation_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Icon rotation alignment', required=False)), ('icon_size', wagtail.blocks.FloatBlock(default=1, label='icon size', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('icon_text_fit', wagtail.blocks.ChoiceBlock(choices=[('none', 'None'), ('width', 'Width'), ('height', 'Height'), ('both', 'Both')], label='Icon text fit', required=False))], label='Layout Properties')), ('paint', wagtail.blocks.StructBlock([('icon_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Icon color', required=False)), ('icon_halo_blur', wagtail.blocks.FloatBlock(default=0.0, label='Icon halo blur', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('icon_halo_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Icon halo color', required=False)), ('icon_halo_width', wagtail.blocks.FloatBlock(default=0.0, label='icon halo width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('icon_opacity', wagtail.blocks.FloatBlock(default=1.0, label='icon opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)]))], label='Paint Properties'))], label='Icon Layer')), ('text', wagtail.blocks.StructBlock([('paint', wagtail.blocks.StructBlock([('text_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Text color', required=False)), ('text_halo_blur', wagtail.blocks.FloatBlock(default=0.0, label='Text halo blur', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_halo_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Text halo color', required=False)), ('text_halo_width', wagtail.blocks.FloatBlock(default=0.0, label='text halo width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_translate', wagtail.blocks.CharBlock(label='Text translate', required=False)), ('text_translate_anchor', wagtail.blocks.ChoiceBlock(choices=[('map', 'Map'), ('viewport', 'Viewport')], label='Text translate anchor', required=False))], label='Paint Properties')), ('layout', wagtail.blocks.StructBlock([('symbol_placement', wagtail.blocks.ChoiceBlock(choices=[('point', 'Point'), ('line', 'Line'), ('line-center', 'Line Center')], label='Text Placement', required=False)), ('text_allow_overlap', wagtail.blocks.BooleanBlock(default=False, label='Text allow overlap', required=False)), ('text_anchor', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('top', 'Top'), ('bottom', 'Bottom'), ('top-left', 'Top Left'), ('top-right', 'Top Right'), ('bottom-left', 'Bottom Left'), ('bottom-right', 'Bottom Right')], label='Text anchor', required=False)), ('text_field', wagtail.blocks.CharBlock(label='Text field')), ('text_size', wagtail.blocks.IntegerBlock(default=16, label='Text size', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_transform', wagtail.blocks.ChoiceBlock(choices=[('none', 'None'), ('uppercase', 'Uppercase'), ('lowercase', 'Lowercase')], label='Text transform', required=False)), ('text_ignore_placement', wagtail.blocks.BooleanBlock(default=False, label='Text ignore placement', required=False)), ('text_justify', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('auto', 'Auto')], label='Text justify', required=False)), ('text_keep_upright', wagtail.blocks.BooleanBlock(default=False, label='Text keep upright', required=False)), ('text_letter_spacing', wagtail.blocks.FloatBlock(default=0.0, label='Text letter spacing', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_line_height', wagtail.blocks.FloatBlock(default=1.2, label='Text line height', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_max_angle', wagtail.blocks.IntegerBlock(default=45, label='Text max angle', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)])), ('text_max_width', wagtail.blocks.IntegerBlock(default=10, label='Text max width', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_offset', wagtail.blocks.CharBlock(label='Text offset', required=False)), ('text_opacity', wagtail.blocks.FloatBlock(default=1.0, label='text opacity', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)])), ('text_padding', wagtail.blocks.IntegerBlock(default=2, label='Text  padding', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_pitch_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Text pitch alignment', required=False)), ('text_radial_offset', wagtail.blocks.IntegerBlock(default=0, label='Text radial offset', required=False, validators=[django.core.validators.MinValueValidator(0)])), ('text_rotate', wagtail.blocks.IntegerBlock(default=0, label='Text rotate', required=False, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(360)])), ('text_rotation_alignment', wagtail.blocks.ChoiceBlock(choices=[('auto', 'Auto'), ('map', 'Map'), ('viewport', 'Viewport')], label='Text rotation alignment', required=False)), ('text_variable_anchor', wagtail.blocks.ChoiceBlock(choices=[('center', 'Center'), ('left', 'Left'), ('right', 'Right'), ('top', 'Top'), ('bottom', 'Bottom'), ('top-left', 'Top Left'), ('top-right', 'Top Right'), ('bottom-left', 'Bottom Left'), ('bottom-right', 'Bottom Right')], label='Text variable anchor', required=False))], label='Layout Properties'))], label='Text Label Layer'))], blank=True, null=True, use_json_field=True, verbose_name='Render Layers')),
                ('legend', wagtail.fields.StreamField([('legend', wagtail.blocks.StructBlock([('type', wagtail.blocks.ChoiceBlock(choices=[('basic', 'Basic'), ('gradient', 'Gradient'), ('choropleth', 'Choropleth')], label='Legend Type')), ('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('value', wagtail.blocks.CharBlock(help_text="Can be a number or text e.g '10' or '10-20' or 'Vegetation'", label='value')), ('color', wagtail.blocks.CharBlock(help_text='Color value e.g rgb(73,73,73) or #494949', label='color'))]), label='Legend Items', min_num=1))], label='Legend')), ('legend_image', wagtail.images.blocks.ImageChooserBlock(label='Legend Image')), ('legend_icon', wagtail.blocks.StructBlock([('items', wagtail.blocks.ListBlock(wagtail.blocks.StructBlock([('icon_image', wagtailiconchooser.blocks.IconChooserBlock(label='Icon Image')), ('icon_label', wagtail.blocks.CharBlock(label='Icon Label')), ('icon_color', wagtail_color_panel.blocks.NativeColorBlock(default='#000000', label='Icon color', required=False))]), label='Legend Icons', min_num=1))], label='Legend Icon'))], blank=True, null=True, use_json_field=True, verbose_name='Legend')),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='fileimagelayer',
            name='dataset',
        ),
        migrations.RemoveField(
            model_name='fileimagelayer',
            name='style',
        ),
        migrations.RemoveField(
            model_name='vectorlayer',
            name='dataset',
        ),
        migrations.AlterField(
            model_name='dataset',
            name='layer_type',
            field=models.CharField(choices=[('raster_file', 'Raster File - NetCDF/GeoTiff'), ('vector_file', 'Vector File - Shapefile, Geojson'), ('wms', 'Web Map Service - WMS Layer'), ('raster_tile', 'XYZ Raster Tile Layer'), ('vector_tile', 'XYZ Vector Tile Layer')], default='raster_file', max_length=100, verbose_name='Layer type'),
        ),
        migrations.AlterField(
            model_name='dataset',
            name='multi_layer',
            field=models.BooleanField(default=False, help_text='The dataset has more than one layer, to be displayed together', verbose_name='Multi-layer'),
        ),
        migrations.AlterField(
            model_name='dataset',
            name='multi_temporal',
            field=models.BooleanField(default=True, help_text='The dataset is multi-temporal', verbose_name='Multi-temporal'),
        ),
        migrations.AlterField(
            model_name='dataset',
            name='near_realtime',
            field=models.BooleanField(default=False, help_text='Is the layer near realtime?, for example updates every 10 minutes', verbose_name='Near realtime'),
        ),
        migrations.AlterField(
            model_name='dataset',
            name='sub_category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='geomanager.subcategory', verbose_name='Sub category'),
        ),
        migrations.DeleteModel(
            name='TmsLayer',
        ),
        migrations.AddField(
            model_name='vectorfilelayer',
            name='dataset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vector_file_layers', to='geomanager.dataset', verbose_name='dataset'),
        ),
        migrations.AddField(
            model_name='rastertilelayer',
            name='dataset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='raster_tile_layers', to='geomanager.dataset', verbose_name='dataset'),
        ),
        migrations.AddField(
            model_name='rasterfilelayer',
            name='dataset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='raster_file_layers', to='geomanager.dataset', verbose_name='dataset'),
        ),
        migrations.AddField(
            model_name='rasterfilelayer',
            name='style',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='geomanager.rasterstyle', verbose_name='style'),
        ),
        migrations.AlterField(
            model_name='layerrasterfile',
            name='layer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='raster_files', to='geomanager.rasterfilelayer', verbose_name='layer'),
        ),
        migrations.AlterField(
            model_name='pgvectortable',
            name='layer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vector_tables', to='geomanager.vectorfilelayer'),
        ),
        migrations.AlterField(
            model_name='vectorlayericon',
            name='layer',
            field=modelcluster.fields.ParentalKey(on_delete=django.db.models.deletion.CASCADE, related_name='icons', to='geomanager.vectorfilelayer'),
        ),
        migrations.DeleteModel(
            name='FileImageLayer',
        ),
        migrations.DeleteModel(
            name='VectorLayer',
        ),
    ]
