from ...utils import StrEnum


class Retenciones(StrEnum):
    SERVICIOS_PROFESIONALES = '01'
    REGALIAS_POR_DERECHOS_DE_AUTOR = '02'
    AUTOTRANSPORTE_TERRESTRE_DE_CARGA = '03'
    SERVICIOS_PRESTADOS_POR_COMISIONISTAS = '04'
    ARRENDAMIENTO = '05'
    ENAJENACION_DE_ACCIONES = '06'
    ENAJENACION_DE_BIENES_OBJETO_DE_LA_LIEPS_A_TRAVES_DE_MEDIADORES_AGENTES_REPRESENTANTES_CORREDORES_CONSIGNATARIOS_O_DISTRIBUIDORES = '07'
    ENAJENACION_DE_BIENES_INMUEBLES_CONSIGNADA_EN_ESCRITURA_PUBLICA = '08'
    ENAJENACION_DE_OTROS_BIENES_NO_CONSIGNADA_EN_ESCRITURA_PUBLICA = '09'
    ADQUISICION_DE_DESPERDICIOS_INDUSTRIALES = '10'
    ADQUISICION_DE_BIENES_CONSIGNADA_EN_ESCRITURA_PUBLICA = '11'
    ADQUISICION_DE_OTROS_BIENES_NO_CONSIGNADA_EN_ESCRITURA_PUBLICA = '12'
    OTROS_RETIROS_DE_AFORE = '13'
    DIVIDENDOS_O_UTILIDADES_DISTRIBUIDAS = '14'
    REMANENTE_DISTRIBUIBLE = '15'
    INTERESES = '16'
    ARRENDAMIENTO_EN_FIDEICOMISO = '17'
    PAGOS_REALIZADOS_A_FAVOR_DE_RESIDENTES_EN_EL_EXTRANJERO = '18'
    ENAJENACION_DE_ACCIONES_U_OPERACIONES_EN_BOLSA_DE_VALORES = '19'
    OBTENCION_DE_PREMIOS = '20'
    FIDEICOMISOS_QUE_NO_REALIZAN_ACTIVIDADES_EMPRESARIALES = '21'
    PLANES_PERSONALES_DE_RETIRO = '22'
    INTERESES_REALES_DEDUCIBLES_POR_CREDITOS_HIPOTECARIOS = '23'
    OPERACIONES_FINANCIERAS_DERIVADAS_DE_CAPITAL = '24'
    OTRO_TIPO_DE_RETENCIONES = '25'
    SERVICIOS_MEDIANTE_PLATAFORMAS_TECNOLOGICAS = '26'


class TipoContribuyenteSujetoRetencion(StrEnum):
    ARTISTAS_DEPORTISTAS_Y_ESPECTACULOS_PUBLICOS = '1'
    OTRAS_PERSONAS_FISICAS = '2'
    PERSONA_MORAL = '3'
    FIDEICOMISO = '4'
    ASOCIACION_EN_PARTICIPACION = '5'
    ORGANIZACIONES_INTERNACIONALES_O_DE_GOBIERNO = '6'
    ORGANIZACIONES_EXENTAS = '7'
    AGENTES_PAGADORES = '8'
    OTROS = '9'


class TipoDividendoOUtilidadDistribuida(StrEnum):
    PROVIENE_DE_CUFIN = '01'
    NO_PROVIENE_DE_CUFIN = '02'
    REEMBOLSO_O_REDUCCION_DE_CAPITAL = '03'
    LIQUIDACION_DE_LA_PERSONA_MORAL = '04'
    CUFINRE = '05'
    PROVIENE_DE_CUFIN_AL_31_DE_DICIEMBRE_2013 = '06'


class TipoImpuesto(StrEnum):
    ISR = '01'
    IVA = '02'
    IEPS = '03'


class TipoPagoRet(StrEnum):
    PAGO_DEFINITIVO_IVA = '01'
    PAGO_DEFINITIVO_IEPS = '02'
    PAGO_DEFINITIVO_ISR = '03'
    PAGO_PROVISIONAL_ISR = '04'


class TipoAportODep(StrEnum):
    APORTACIONES_VOLUNTARIAS_O_COMPLEMENTARIAS_EFECTUADAS_EN_TERMINOS_DEL_ARTICULO_151_FRACCION_V_DE_LA_LISR = 'a'
    DEPOSITOS_A_CUENTAS_ESPECIALES_PRIMA_DE_SEGUROS_O_ADQUISICION_DE_ACCIONES_EFECTUADAS_EN_TERMINOS_AL_ARTICULO_185_DE_LA_LISR = 'b'
    APORTACIONES_ADICIONALES_EFECTUADAS_EN_TERMINOS_DEL_ARTICULO_258 = 'c'


