<!--
SPDX-FileCopyrightText: Contributors to the Power Grid Model project <powergridmodel@lfenergy.org>

SPDX-License-Identifier: MPL-2.0
-->

[![PyPI version](https://badge.fury.io/py/power-grid-model-io.svg?no-cache)](https://badge.fury.io/py/power-grid-model-io)
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/power-grid-model-io/badges/version.svg?no-cache)](https://anaconda.org/conda-forge/power-grid-model-io)
[![License: MIT](https://img.shields.io/badge/License-MPL2.0-informational.svg)](https://github.com/PowerGridModel/power-grid-model-io/blob/main/LICENSE)
[![Build and Test Python](https://github.com/PowerGridModel/power-grid-model-io/actions/workflows/build-test-and-sonar.yml/badge.svg)](https://github.com/PowerGridModel/power-grid-model-io/actions/workflows/build-test-and-sonar.yml)
[![Check Code Quality](https://github.com/PowerGridModel/power-grid-model-io/actions/workflows/check-code-quality.yml/badge.svg)](https://github.com/PowerGridModel/power-grid-model-io/actions/workflows/check-code-quality.yml)
[![REUSE Compliance Check](https://github.com/PowerGridModel/power-grid-model-io/actions/workflows/reuse-compliance.yml/badge.svg)](https://github.com/PowerGridModel/power-grid-model-io/actions/workflows/reuse-compliance.yml)
[![docs](https://readthedocs.org/projects/power-grid-model-io/badge/)](https://power-grid-model-io.readthedocs.io/en/stable/)

[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=PowerGridModel_power-grid-model-io&metric=alert_status)](https://sonarcloud.io/summary/new_code?id=PowerGridModel_power-grid-model-io)
[![Coverage](https://sonarcloud.io/api/project_badges/measure?project=PowerGridModel_power-grid-model-io&metric=coverage)](https://sonarcloud.io/summary/new_code?id=PowerGridModel_power-grid-model-io)
[![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=PowerGridModel_power-grid-model-io&metric=sqale_rating)](https://sonarcloud.io/summary/new_code?id=PowerGridModel_power-grid-model-io)
[![Reliability Rating](https://sonarcloud.io/api/project_badges/measure?project=PowerGridModel_power-grid-model-io&metric=reliability_rating)](https://sonarcloud.io/summary/new_code?id=PowerGridModel_power-grid-model-io)
[![Security Rating](https://sonarcloud.io/api/project_badges/measure?project=PowerGridModel_power-grid-model-io&metric=security_rating)](https://sonarcloud.io/summary/new_code?id=PowerGridModel_power-grid-model-io)
[![Vulnerabilities](https://sonarcloud.io/api/project_badges/measure?project=PowerGridModel_power-grid-model-io&metric=vulnerabilities)](https://sonarcloud.io/summary/new_code?id=PowerGridModel_power-grid-model-io)

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.8059257.svg)](https://zenodo.org/record/8059257)

[![](https://github.com/PowerGridModel/.github/blob/main/artwork/svg/color.svg)](#)

# Power Grid Model Input/Output

`power-grid-model-io` can be used for various conversions to the [power-grid-model](https://github.com/PowerGridModel/power-grid-model).
For detailed documentation, see [Read the Docs](https://power-grid-model-io.readthedocs.io/en/stable/index.html).

## Installation

### Install from PyPI

You can directly install the package from PyPI.

```
pip install power-grid-model-io
```

### Install from Conda

If you are using `conda`, you can directly install the package from `conda-forge` channel.

```
conda install -c conda-forge power-grid-model-io
```

## Examples

* [PGM JSON Example](https://github.com/PowerGridModel/power-grid-model-io/tree/main/docs/examples)

## License

This project is licensed under the Mozilla Public License, version 2.0 - see [LICENSE](https://github.com/PowerGridModel/power-grid-model-io/blob/main/LICENSE) for details.

## Contributing

Please read [CODE_OF_CONDUCT](https://github.com/PowerGridModel/.github/blob/main/CODE_OF_CONDUCT.md) and [CONTRIBUTING](https://github.com/PowerGridModel/.github/blob/main/CONTRIBUTING.md) for details on the process 
for submitting pull requests to us.

Visit [Contribute](https://github.com/PowerGridModel/power-grid-model-io/contribute) for a list of good first issues in this repo.

## Citations

If you are using Power Grid Model IO in your research work, please consider citing our library using the following references.

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.8059257.svg)](https://zenodo.org/record/8059257)

```bibtex
@software{Xiang_PowerGridModel_power-grid-model-io,
  author = {Xiang, Yu and Salemink, Peter and Bharambe, Nitish and Govers, Martinus and van den Bogaard, Jonas and Stoeller, Bram and Wang, Zhen and Guo, Jerry and Jagutis, Laurynas and Wang, Chenguang and {Contributors to the LF Energy project Power Grid Model}},
  doi = {10.5281/zenodo.8059257},
  license = {MPL-2.0},
  title = {{PowerGridModel/power-grid-model-io}},
  url = {https://github.com/PowerGridModel/power-grid-model-io}
}
@software{Xiang_PowerGridModel_power-grid-model,
  author = {Xiang, Yu and Salemink, Peter and Bharambe, Nitish and Govers, Martinus and van den Bogaard, Jonas and Stoeller, Bram and Wang, Zhen and Guo, Jerry and Jagutis, Laurynas and Wang, Chenguang and van Raalte, Marc and {Contributors to the LF Energy project Power Grid Model}},
  doi = {10.5281/zenodo.8054429},
  license = {MPL-2.0},
  title = {{PowerGridModel/power-grid-model}},
  url = {https://github.com/PowerGridModel/power-grid-model}
}
@inproceedings{Xiang2023,
  author = {Xiang, Yu and Salemink, Peter and Stoeller, Bram and Bharambe, Nitish and van Westering, Werner},
  booktitle = {CIRED 2023 - The 27th International Conference and Exhibition on Electricity Distribution},
  title = {Power grid model: A high-performance distribution grid calculation library},
  year = {2023},
  volume={2023},
  number = {},
  pages={1-5}
}
```

## Contact

Please read [SUPPORT](https://github.com/PowerGridModel/.github/blob/main/SUPPORT.md) for how to connect and get into contact with the Power Gird Model IO project.
