# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pymisp',
 'pymisp.data.misp-objects',
 'pymisp.data.misp-objects.tools',
 'pymisp.tools']

package_data = \
{'': ['*'],
 'pymisp': ['data/*'],
 'pymisp.data.misp-objects': ['docs/*',
                              'objects/ail-leak/*',
                              'objects/ais-info/*',
                              'objects/android-permission/*',
                              'objects/annotation/*',
                              'objects/anonymisation/*',
                              'objects/asn/*',
                              'objects/attack-pattern/*',
                              'objects/authentication-failure-report/*',
                              'objects/authenticode-signerinfo/*',
                              'objects/av-signature/*',
                              'objects/bank-account/*',
                              'objects/bgp-hijack/*',
                              'objects/blog/*',
                              'objects/boleto/*',
                              'objects/btc-transaction/*',
                              'objects/btc-wallet/*',
                              'objects/cap-alert/*',
                              'objects/cap-info/*',
                              'objects/cap-resource/*',
                              'objects/coin-address/*',
                              'objects/command-line/*',
                              'objects/command/*',
                              'objects/cookie/*',
                              'objects/cortex-taxonomy/*',
                              'objects/cortex/*',
                              'objects/course-of-action/*',
                              'objects/covid19-csse-daily-report/*',
                              'objects/covid19-dxy-live-city/*',
                              'objects/covid19-dxy-live-province/*',
                              'objects/cowrie/*',
                              'objects/credential/*',
                              'objects/credit-card/*',
                              'objects/crypto-material/*',
                              'objects/cytomic-orion-file/*',
                              'objects/cytomic-orion-machine/*',
                              'objects/dark-pattern-item/*',
                              'objects/ddos/*',
                              'objects/device/*',
                              'objects/diameter-attack/*',
                              'objects/dns-record/*',
                              'objects/domain-crawled/*',
                              'objects/domain-ip/*',
                              'objects/elf-section/*',
                              'objects/elf/*',
                              'objects/email/*',
                              'objects/employee/*',
                              'objects/exploit-poc/*',
                              'objects/facebook-account/*',
                              'objects/facebook-group/*',
                              'objects/facebook-page/*',
                              'objects/facebook-post/*',
                              'objects/facial-composite/*',
                              'objects/fail2ban/*',
                              'objects/file/*',
                              'objects/forensic-case/*',
                              'objects/forensic-evidence/*',
                              'objects/forged-document/*',
                              'objects/ftm-Airplane/*',
                              'objects/ftm-Assessment/*',
                              'objects/ftm-Asset/*',
                              'objects/ftm-Associate/*',
                              'objects/ftm-Audio/*',
                              'objects/ftm-BankAccount/*',
                              'objects/ftm-Call/*',
                              'objects/ftm-Company/*',
                              'objects/ftm-Contract/*',
                              'objects/ftm-ContractAward/*',
                              'objects/ftm-CourtCase/*',
                              'objects/ftm-CourtCaseParty/*',
                              'objects/ftm-Debt/*',
                              'objects/ftm-Directorship/*',
                              'objects/ftm-Document/*',
                              'objects/ftm-Documentation/*',
                              'objects/ftm-EconomicActivity/*',
                              'objects/ftm-Email/*',
                              'objects/ftm-Event/*',
                              'objects/ftm-Family/*',
                              'objects/ftm-Folder/*',
                              'objects/ftm-HyperText/*',
                              'objects/ftm-Image/*',
                              'objects/ftm-Land/*',
                              'objects/ftm-LegalEntity/*',
                              'objects/ftm-License/*',
                              'objects/ftm-Membership/*',
                              'objects/ftm-Message/*',
                              'objects/ftm-Organization/*',
                              'objects/ftm-Ownership/*',
                              'objects/ftm-Package/*',
                              'objects/ftm-Page/*',
                              'objects/ftm-Pages/*',
                              'objects/ftm-Passport/*',
                              'objects/ftm-Payment/*',
                              'objects/ftm-Person/*',
                              'objects/ftm-PlainText/*',
                              'objects/ftm-PublicBody/*',
                              'objects/ftm-RealEstate/*',
                              'objects/ftm-Representation/*',
                              'objects/ftm-Row/*',
                              'objects/ftm-Sanction/*',
                              'objects/ftm-Succession/*',
                              'objects/ftm-Table/*',
                              'objects/ftm-TaxRoll/*',
                              'objects/ftm-UnknownLink/*',
                              'objects/ftm-UserAccount/*',
                              'objects/ftm-Vehicle/*',
                              'objects/ftm-Vessel/*',
                              'objects/ftm-Video/*',
                              'objects/ftm-Workbook/*',
                              'objects/geolocation/*',
                              'objects/git-vuln-finder/*',
                              'objects/gtp-attack/*',
                              'objects/http-request/*',
                              'objects/ilr-impact/*',
                              'objects/ilr-notification-incident/*',
                              'objects/image/*',
                              'objects/impersonation/*',
                              'objects/imsi-catcher/*',
                              'objects/instant-message-group/*',
                              'objects/instant-message/*',
                              'objects/intelmq_event/*',
                              'objects/intelmq_report/*',
                              'objects/internal-reference/*',
                              'objects/interpol-notice/*',
                              'objects/iot-device/*',
                              'objects/iot-firmware/*',
                              'objects/ip-api-address/*',
                              'objects/ip-port/*',
                              'objects/irc/*',
                              'objects/ja3/*',
                              'objects/leaked-document/*',
                              'objects/legal-entity/*',
                              'objects/lnk/*',
                              'objects/macho-section/*',
                              'objects/macho/*',
                              'objects/mactime-timeline-analysis/*',
                              'objects/malware-config/*',
                              'objects/meme-image/*',
                              'objects/microblog/*',
                              'objects/mutex/*',
                              'objects/narrative/*',
                              'objects/netflow/*',
                              'objects/network-connection/*',
                              'objects/network-socket/*',
                              'objects/news-agency/*',
                              'objects/news-media/*',
                              'objects/organization/*',
                              'objects/original-imported-file/*',
                              'objects/passive-dns/*',
                              'objects/paste/*',
                              'objects/pcap-metadata/*',
                              'objects/pe-section/*',
                              'objects/pe/*',
                              'objects/person/*',
                              'objects/pgp-meta/*',
                              'objects/phishing-kit/*',
                              'objects/phishing/*',
                              'objects/phone/*',
                              'objects/process/*',
                              'objects/publication/*',
                              'objects/python-etvx-event-log/*',
                              'objects/r2graphity/*',
                              'objects/reddit-account/*',
                              'objects/reddit-comment/*',
                              'objects/reddit-post/*',
                              'objects/reddit-subreddit/*',
                              'objects/regexp/*',
                              'objects/registry-key/*',
                              'objects/regripper-NTUser/*',
                              'objects/regripper-sam-hive-single-user/*',
                              'objects/regripper-sam-hive-user-group/*',
                              'objects/regripper-software-hive-BHO/*',
                              'objects/regripper-software-hive-appInit-DLLS/*',
                              'objects/regripper-software-hive-application-paths/*',
                              'objects/regripper-software-hive-applications-installed/*',
                              'objects/regripper-software-hive-command-shell/*',
                              'objects/regripper-software-hive-software-run/*',
                              'objects/regripper-software-hive-userprofile-winlogon/*',
                              'objects/regripper-software-hive-windows-general-info/*',
                              'objects/regripper-system-hive-firewall-configuration/*',
                              'objects/regripper-system-hive-general-configuration/*',
                              'objects/regripper-system-hive-network-information/*',
                              'objects/regripper-system-hive-services-drivers/*',
                              'objects/report/*',
                              'objects/research-scanner/*',
                              'objects/rogue-dns/*',
                              'objects/rtir/*',
                              'objects/sandbox-report/*',
                              'objects/sb-signature/*',
                              'objects/scheduled-event/*',
                              'objects/scrippsco2-c13-daily/*',
                              'objects/scrippsco2-c13-monthly/*',
                              'objects/scrippsco2-co2-daily/*',
                              'objects/scrippsco2-co2-monthly/*',
                              'objects/scrippsco2-o18-daily/*',
                              'objects/scrippsco2-o18-monthly/*',
                              'objects/script/*',
                              'objects/shell-commands/*',
                              'objects/shodan-report/*',
                              'objects/short-message-service/*',
                              'objects/shortened-link/*',
                              'objects/social-media-group/*',
                              'objects/splunk/*',
                              'objects/ss7-attack/*',
                              'objects/ssh-authorized-keys/*',
                              'objects/stix2-pattern/*',
                              'objects/suricata/*',
                              'objects/target-system/*',
                              'objects/threatgrid-report/*',
                              'objects/timecode/*',
                              'objects/timesketch-timeline/*',
                              'objects/timesketch_message/*',
                              'objects/timestamp/*',
                              'objects/tor-hiddenservice/*',
                              'objects/tor-node/*',
                              'objects/tracking-id/*',
                              'objects/transaction/*',
                              'objects/translation/*',
                              'objects/trustar_report/*',
                              'objects/tsk-chats/*',
                              'objects/tsk-web-bookmark/*',
                              'objects/tsk-web-cookie/*',
                              'objects/tsk-web-downloads/*',
                              'objects/tsk-web-history/*',
                              'objects/tsk-web-search-query/*',
                              'objects/twitter-account/*',
                              'objects/twitter-list/*',
                              'objects/twitter-post/*',
                              'objects/url/*',
                              'objects/user-account/*',
                              'objects/vehicle/*',
                              'objects/victim/*',
                              'objects/virustotal-graph/*',
                              'objects/virustotal-report/*',
                              'objects/vulnerability/*',
                              'objects/weakness/*',
                              'objects/whois/*',
                              'objects/x509/*',
                              'objects/yabin/*',
                              'objects/yara/*',
                              'objects/youtube-channel/*',
                              'objects/youtube-comment/*',
                              'objects/youtube-playlist/*',
                              'objects/youtube-video/*',
                              'relationships/*'],
 'pymisp.tools': ['pdf_fonts/*']}

install_requires = \
['deprecated>=1.2.7,<2.0.0',
 'jsonschema>=3.2.0,<4.0.0',
 'python-dateutil>=2.8.1,<3.0.0',
 'requests>=2.22.0,<3.0.0']

extras_require = \
{'docs': ['sphinx-autodoc-typehints>=1.10.3,<2.0.0',
          'recommonmark>=0.6.0,<0.7.0'],
 'fileobjects': ['python-magic>=0.4.15,<0.5.0',
                 'pydeep>=0.4,<0.5',
                 'lief>=0.10.1,<0.11.0'],
 'openioc': ['beautifulsoup4>=4.8.2,<5.0.0'],
 'pdfexport': ['reportlab>=3.5.34,<4.0.0'],
 'url': ['pyfaup>=1.2,<2.0'],
 'virustotal': ['validators>=0.14.2,<0.15.0']}

setup_kwargs = {
    'name': 'pymisp',
    'version': '2.4.127.1',
    'description': 'Python API for MISP.',
    'long_description': '**IMPORTANT NOTE**: This library will require **at least** python 3.6 starting the 1st of January 2020. If you have to legacy versions of python, please use PyMISP v2.4.119.1, and consider updating your system(s). Anything released within the last 2 years will do, starting with Ubuntu 18.04.\n\nREADME\n======\n\n[![Documentation Status](https://readthedocs.org/projects/pymisp/badge/?version=latest)](http://pymisp.readthedocs.io/?badge=latest)\n[![Build Status](https://travis-ci.org/MISP/PyMISP.svg?branch=main)](https://travis-ci.org/MISP/PyMISP)\n[![Coverage Status](https://coveralls.io/repos/github/MISP/PyMISP/badge.svg?branch=main)](https://coveralls.io/github/MISP/PyMISP?branch=main)\n[![Python 3.6](https://img.shields.io/badge/python-3.6+-blue.svg)](https://www.python.org/downloads/release/python-360/)\n[![PyPi version](https://img.shields.io/pypi/v/pymisp.svg)](https://pypi.python.org/pypi/pymisp/)\n[![Number of PyPI downloads](https://img.shields.io/pypi/dm/pymisp.svg)](https://pypi.python.org/pypi/pymisp/)\n\n# PyMISP - Python Library to access MISP\n\nPyMISP is a Python library to access [MISP](https://github.com/MISP/MISP) platforms via their REST API.\n\nPyMISP allows you to fetch events, add or update events/attributes, add or update samples or search for attributes.\n\n## Install from pip\n\n**It is strongly recommended to use a virtual environment**\n\nIf you want to know more about virtual environments, [python has you covered](https://docs.python.org/3/tutorial/venv.html)\n\nOnly basic dependencies:\n```\npip3 install pymisp\n```\n\nWith optional dependencies:\n```\npip3 install pymisp[fileobjects,openioc,virustotal]\n```\n\n## Install the latest version from repo from development purposes\n\n**Note**: poetry is required\n\n```\ngit clone https://github.com/MISP/PyMISP.git && cd PyMISP\ngit submodule update --init\npoetry install -E fileobjects -E openioc -E virustotal -E docs -E pdfexport\n```\n\n### Running the tests\n\n```bash\npoetry run nosetests-3.4 --with-coverage --cover-package=pymisp,tests --cover-tests tests/test_*.py\n```\n\nIf you have a MISP instance to test against, you can also run the live ones:\n\n**Note**: You need to update the key in `tests/testlive_comprehensive.py` to the automation key of your admin account.\n\n```bash\npoetry run nosetests-3.4 --with-coverage --cover-package=pymisp,tests --cover-tests tests/testlive_comprehensive.py\n```\n\n## Samples and how to use PyMISP\n\nVarious examples and samples scripts are in the [examples/](examples/) directory.\n\nIn the examples directory, you will need to change the keys.py.sample to enter your MISP url and API key.\n\n```\ncd examples\ncp keys.py.sample keys.py\nvim keys.py\n```\n\nThe API key of MISP is available in the Automation section of the MISP web interface.\n\nTo test if your URL and API keys are correct, you can test with examples/last.py to\nfetch the events published in the last x amount of time (supported time indicators: days (d), hours (h) and minutes (m)).\nlast.py\n```\ncd examples\npython3 last.py -l 10h # 10 hours\npython3 last.py -l 5d  #  5 days\npython3 last.py -l 45m # 45 minutes\n```\n\n\n## Debugging\n\nYou have two options there:\n\n1. Pass `debug=True` to `PyMISP` and it will enable logging.DEBUG to stderr on the whole module\n\n2. Use the python logging module directly:\n\n```python\n\nimport logging\nlogger = logging.getLogger(\'pymisp\')\n\n# Configure it as you whish, for example, enable DEBUG mode:\nlogger.setLevel(logging.DEBUG)\n```\n\nOr if you want to write the debug output to a file instead of stderr:\n\n```python\nimport pymisp\nimport logging\n\nlogger = logging.getLogger(\'pymisp\')\nlogging.basicConfig(level=logging.DEBUG, filename="debug.log", filemode=\'w\', format=pymisp.FORMAT)\n```\n\n## Test cases\n\n1. The content of `mispevent.py` is tested on every commit\n2. The tests cases that require a running MISP instance can be run the following way:\n\n\n```bash\n# From poetry\n\nnosetests-3.4 -s --with-coverage --cover-package=pymisp,tests --cover-tests tests/testlive_comprehensive.py:TestComprehensive.[test_name]\n\n```\n\n## Documentation\n\n[PyMISP API documentation is available](https://media.readthedocs.org/pdf/pymisp/latest/pymisp.pdf).\n\nDocumentation can be generated with epydoc:\n\n```\nepydoc --url https://github.com/MISP/PyMISP --graph all --name PyMISP --pdf pymisp -o doc\n```\n\n### Jupyter notebook\n\nA series of [Jupyter notebooks for PyMISP tutorial](https://github.com/MISP/PyMISP/tree/master/docs/tutorial) are available in the repository.\n\n## Everything is a Mutable Mapping\n\n... or at least everything that can be imported/exported from/to a json blob\n\n`AbstractMISP` is the master class, and inherit `collections.MutableMapping` which means\nthe class can be represented as a python dictionary.\n\nThe abstraction assumes every property that should not be seen in the dictionary is prepended with a `_`,\nor its name is added to the private list `__not_jsonable` (accessible through `update_not_jsonable` and `set_not_jsonable`.\n\nThis master class has helpers that will make it easy to load, and export, to, and from, a json string.\n\n`MISPEvent`, `MISPAttribute`, `MISPObjectReference`, `MISPObjectAttribute`, and `MISPObject`\nare subclasses of AbstractMISP, which mean that they can be handled as python dictionaries.\n\n## MISP Objects\n\nCreating a new MISP object generator should be done using a pre-defined template and inherit `AbstractMISPObjectGenerator`.\n\nYour new MISPObject generator need to generate attributes, and add them as class properties using `add_attribute`.\n\nWhen the object is sent to MISP, all the class properties will be exported to the JSON export.\n',
    'author': 'Raphaël Vinot',
    'author_email': 'raphael.vinot@circl.lu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/MISP/PyMISP',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
