# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 1.1.41
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from lusid.configuration import Configuration


class IndexProjectionDependencyAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
      required_map (dict): The key is attribute name
                           and the value is whether it is 'required' or 'optional'.
    """
    openapi_types = {
        'currency': 'str',
        'tenor': 'str',
        'index_name': 'str',
        'date': 'datetime',
        'dependency_type': 'str'
    }

    attribute_map = {
        'currency': 'currency',
        'tenor': 'tenor',
        'index_name': 'indexName',
        'date': 'date',
        'dependency_type': 'dependencyType'
    }

    required_map = {
        'currency': 'required',
        'tenor': 'required',
        'index_name': 'required',
        'date': 'required',
        'dependency_type': 'required'
    }

    def __init__(self, currency=None, tenor=None, index_name=None, date=None, dependency_type=None, local_vars_configuration=None):  # noqa: E501
        """IndexProjectionDependencyAllOf - a model defined in OpenAPI"
        
        :param currency:  The currency of the corresponding IndexConvention. E.g. this would be USD for a convention named USD.6M.LIBOR (required)
        :type currency: str
        :param tenor:  The tenor of the corresponding IndexConvention. E.g. this would be \"6M\" for a convention named USD.6M.LIBOR (required)
        :type tenor: str
        :param index_name:  The IndexName of the corresponding IndexConvention. E.g. this would be \"LIBOR\" for a convention named USD.6M.LIBOR (required)
        :type index_name: str
        :param date:  The effectiveDate of the entity that this is a dependency for.  Unless there is an obvious date this should be, like for a historic reset, then this is the valuation date. (required)
        :type date: datetime
        :param dependency_type:  The available values are: OpaqueDependency, CashDependency, DiscountingDependency, EquityCurveDependency, EquityVolDependency, FxDependency, FxForwardsDependency, FxVolDependency, IndexProjectionDependency, IrVolDependency, QuoteDependency, Vendor, CalendarDependency, InflationFixingDependency (required)
        :type dependency_type: str

        """  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._currency = None
        self._tenor = None
        self._index_name = None
        self._date = None
        self._dependency_type = None
        self.discriminator = None

        self.currency = currency
        self.tenor = tenor
        self.index_name = index_name
        self.date = date
        self.dependency_type = dependency_type

    @property
    def currency(self):
        """Gets the currency of this IndexProjectionDependencyAllOf.  # noqa: E501

        The currency of the corresponding IndexConvention. E.g. this would be USD for a convention named USD.6M.LIBOR  # noqa: E501

        :return: The currency of this IndexProjectionDependencyAllOf.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this IndexProjectionDependencyAllOf.

        The currency of the corresponding IndexConvention. E.g. this would be USD for a convention named USD.6M.LIBOR  # noqa: E501

        :param currency: The currency of this IndexProjectionDependencyAllOf.  # noqa: E501
        :type currency: str
        """
        if self.local_vars_configuration.client_side_validation and currency is None:  # noqa: E501
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def tenor(self):
        """Gets the tenor of this IndexProjectionDependencyAllOf.  # noqa: E501

        The tenor of the corresponding IndexConvention. E.g. this would be \"6M\" for a convention named USD.6M.LIBOR  # noqa: E501

        :return: The tenor of this IndexProjectionDependencyAllOf.  # noqa: E501
        :rtype: str
        """
        return self._tenor

    @tenor.setter
    def tenor(self, tenor):
        """Sets the tenor of this IndexProjectionDependencyAllOf.

        The tenor of the corresponding IndexConvention. E.g. this would be \"6M\" for a convention named USD.6M.LIBOR  # noqa: E501

        :param tenor: The tenor of this IndexProjectionDependencyAllOf.  # noqa: E501
        :type tenor: str
        """
        if self.local_vars_configuration.client_side_validation and tenor is None:  # noqa: E501
            raise ValueError("Invalid value for `tenor`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                tenor is not None and len(tenor) > 50):
            raise ValueError("Invalid value for `tenor`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                tenor is not None and len(tenor) < 0):
            raise ValueError("Invalid value for `tenor`, length must be greater than or equal to `0`")  # noqa: E501

        self._tenor = tenor

    @property
    def index_name(self):
        """Gets the index_name of this IndexProjectionDependencyAllOf.  # noqa: E501

        The IndexName of the corresponding IndexConvention. E.g. this would be \"LIBOR\" for a convention named USD.6M.LIBOR  # noqa: E501

        :return: The index_name of this IndexProjectionDependencyAllOf.  # noqa: E501
        :rtype: str
        """
        return self._index_name

    @index_name.setter
    def index_name(self, index_name):
        """Sets the index_name of this IndexProjectionDependencyAllOf.

        The IndexName of the corresponding IndexConvention. E.g. this would be \"LIBOR\" for a convention named USD.6M.LIBOR  # noqa: E501

        :param index_name: The index_name of this IndexProjectionDependencyAllOf.  # noqa: E501
        :type index_name: str
        """
        if self.local_vars_configuration.client_side_validation and index_name is None:  # noqa: E501
            raise ValueError("Invalid value for `index_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                index_name is not None and len(index_name) > 50):
            raise ValueError("Invalid value for `index_name`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                index_name is not None and len(index_name) < 0):
            raise ValueError("Invalid value for `index_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._index_name = index_name

    @property
    def date(self):
        """Gets the date of this IndexProjectionDependencyAllOf.  # noqa: E501

        The effectiveDate of the entity that this is a dependency for.  Unless there is an obvious date this should be, like for a historic reset, then this is the valuation date.  # noqa: E501

        :return: The date of this IndexProjectionDependencyAllOf.  # noqa: E501
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this IndexProjectionDependencyAllOf.

        The effectiveDate of the entity that this is a dependency for.  Unless there is an obvious date this should be, like for a historic reset, then this is the valuation date.  # noqa: E501

        :param date: The date of this IndexProjectionDependencyAllOf.  # noqa: E501
        :type date: datetime
        """
        if self.local_vars_configuration.client_side_validation and date is None:  # noqa: E501
            raise ValueError("Invalid value for `date`, must not be `None`")  # noqa: E501

        self._date = date

    @property
    def dependency_type(self):
        """Gets the dependency_type of this IndexProjectionDependencyAllOf.  # noqa: E501

        The available values are: OpaqueDependency, CashDependency, DiscountingDependency, EquityCurveDependency, EquityVolDependency, FxDependency, FxForwardsDependency, FxVolDependency, IndexProjectionDependency, IrVolDependency, QuoteDependency, Vendor, CalendarDependency, InflationFixingDependency  # noqa: E501

        :return: The dependency_type of this IndexProjectionDependencyAllOf.  # noqa: E501
        :rtype: str
        """
        return self._dependency_type

    @dependency_type.setter
    def dependency_type(self, dependency_type):
        """Sets the dependency_type of this IndexProjectionDependencyAllOf.

        The available values are: OpaqueDependency, CashDependency, DiscountingDependency, EquityCurveDependency, EquityVolDependency, FxDependency, FxForwardsDependency, FxVolDependency, IndexProjectionDependency, IrVolDependency, QuoteDependency, Vendor, CalendarDependency, InflationFixingDependency  # noqa: E501

        :param dependency_type: The dependency_type of this IndexProjectionDependencyAllOf.  # noqa: E501
        :type dependency_type: str
        """
        if self.local_vars_configuration.client_side_validation and dependency_type is None:  # noqa: E501
            raise ValueError("Invalid value for `dependency_type`, must not be `None`")  # noqa: E501
        allowed_values = ["OpaqueDependency", "CashDependency", "DiscountingDependency", "EquityCurveDependency", "EquityVolDependency", "FxDependency", "FxForwardsDependency", "FxVolDependency", "IndexProjectionDependency", "IrVolDependency", "QuoteDependency", "Vendor", "CalendarDependency", "InflationFixingDependency"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and dependency_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `dependency_type` ({0}), must be one of {1}"  # noqa: E501
                .format(dependency_type, allowed_values)
            )

        self._dependency_type = dependency_type

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IndexProjectionDependencyAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IndexProjectionDependencyAllOf):
            return True

        return self.to_dict() != other.to_dict()
