### Changelog

All notable changes to this project will be documented in this file. Dates are displayed in UTC.

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

#### [v2.6.1](https://github.com/nexios-labs/Nexios/compare/v2.6.0...v2.6.1)

> 3 July 2025

- feat: implement configuration file support for Nexios CLI, allowing app and server options to be defined in `nexios.config.py`, and enhance command functionality to load configurations seamlessly [`#151`](https://github.com/nexios-labs/Nexios/pull/151)
- refactor: simplify CLI structure by removing unused utility and validation functions, consolidating command implementations, and enhancing app loading from main module [`fb28f17`](https://github.com/nexios-labs/Nexios/commit/fb28f173357bb3c305209d98a77204d320c6a7d5)
- docs: update CLI guide to reflect new configuration structure in `nexios.config.py`, streamline examples for development and production setups, and enhance clarity on command usage and supported variables [`94f2daf`](https://github.com/nexios-labs/Nexios/commit/94f2daf6f8e6b226141138caaf752de61b6104ac)
- Auto-format Python code with isort, Black, and Ruff [`bf1f032`](https://github.com/nexios-labs/Nexios/commit/bf1f03266fb144e90a484528e8fac1e200a9e905)

#### [v2.6.0](https://github.com/nexios-labs/Nexios/compare/v2.5.3...v2.6.0)

> 30 June 2025

- Dev [`#149`](https://github.com/nexios-labs/Nexios/pull/149)
- Dev [`#148`](https://github.com/nexios-labs/Nexios/pull/148)
- chore: clean up release workflow by removing unused changelog generation steps [`d27d84f`](https://github.com/nexios-labs/Nexios/commit/d27d84ff50b79d9d71229e9d77e60cc0c62dc2cc)
- chore: update version to 2.6.0 in pyproject.toml and __main__.py [`d3d0af1`](https://github.com/nexios-labs/Nexios/commit/d3d0af1b37b55b240297200e2fe77d6d6edc05ac)
- remove: delete unused pytest configuration file [`59942ea`](https://github.com/nexios-labs/Nexios/commit/59942ea62344665582aeb4ebcd0fee6d1022daf2)

#### [v2.5.3](https://github.com/nexios-labs/Nexios/compare/v2.5.2...v2.5.3)

> 30 June 2025

- refactor: remove main function and update version constraints for pytest in uv.lock [`e55c5e0`](https://github.com/nexios-labs/Nexios/commit/e55c5e08570d994e36a00d4bebafc965f5f028af)
- docs: update Day 1 and Day 2 course materials to enhance clarity and structure, including improved explanations of Nexios features, routing concepts, and practical examples for building applications [`877aeff`](https://github.com/nexios-labs/Nexios/commit/877aeff6b678eae1b07f89878ec70392b3bd5bcf)
- docs: revise Day 3 and Day 4 course materials to improve clarity and organization, focusing on asynchronous programming, request/response handling, and the introduction of class-based views with APIHandler for better code management [`277e930`](https://github.com/nexios-labs/Nexios/commit/277e930186a2d5441b287bb02bc76e62a442e3b6)

#### [v2.5.2](https://github.com/nexios-labs/Nexios/compare/v2.5.1...v2.5.2)

> 29 June 2025

- fix: correct spelling of 'exclude_from_schema' in application and routing modules [`#147`](https://github.com/nexios-labs/Nexios/pull/147)
- Merge pull request #145 from nexios-labs/dev [`#146`](https://github.com/nexios-labs/Nexios/pull/146)
- refactor: update error handling UI and enhance JavaScript functionality [`#145`](https://github.com/nexios-labs/Nexios/pull/145)
- fix: update header encoding in StreamingResponse for compatibility  - Added encoding for headers in the StreamingResponse class to ensure proper handling of header values in Latin-1 format. - This change enhances compatibility with various clients and servers that may expect headers in this encoding. [`#144`](https://github.com/nexios-labs/Nexios/pull/144)
- docs: enhance async-python, authentication, and configuration guides for clarity and completeness [`8ee453b`](https://github.com/nexios-labs/Nexios/commit/8ee453b42809e1f21745d43fa968745fd521176e)
- feat: enhance NexiosApp.run method to support Granian server [`a218b0b`](https://github.com/nexios-labs/Nexios/commit/a218b0b6dadf653ff74831970be40af345d90aac)
- chore: remove auto-changelog configuration file and update release workflow to include changelog generation [`19a2b07`](https://github.com/nexios-labs/Nexios/commit/19a2b07fee069e85c99aa3338d4d19a45ac41121)

#### [v2.5.1](https://github.com/nexios-labs/Nexios/compare/v2.5.0...v2.5.1)

> 26 June 2025

- Dev [`#143`](https://github.com/nexios-labs/Nexios/pull/143)
- Merge from #main  [`#142`](https://github.com/nexios-labs/Nexios/pull/142)
- chore(deps-dev): update pytest requirement from &lt;8.4.0,&gt;=8.3.4 to &gt;=8.3.4,&lt;8.5.0 [`#139`](https://github.com/nexios-labs/Nexios/pull/139)
- feat: add request verification and enhance locust tests [`2a50d82`](https://github.com/nexios-labs/Nexios/commit/2a50d826dd4c7c5c09ef1545d056c1047a292119)
- feat: introduce context-aware dependency injection system for request-scoped data access [`a52ea4f`](https://github.com/nexios-labs/Nexios/commit/a52ea4f81eceeb6b1d69f91d478a84a6596233f5)
- chore: update release workflow to include auto-changelog generation and ensure all tags are fetched [`60cd00a`](https://github.com/nexios-labs/Nexios/commit/60cd00ab238538dd69942db013141d7d5dd70d3f)

#### [v2.5.0](https://github.com/nexios-labs/Nexios/compare/v2.4.14...v2.5.0)

> 21 June 2025

- fix: allow optional status code in response methods and default to in… [`#140`](https://github.com/nexios-labs/Nexios/pull/140)
- chore: update CHANGELOG.md for v2.4.14 release, including recent fixes, documentation enhancements, and dependency updates [`25080a4`](https://github.com/nexios-labs/Nexios/commit/25080a41443a005a36bfaa9f2700515f123a5825)
- fix: allow optional status code in response methods and default to instance status code [`e4f1b15`](https://github.com/nexios-labs/Nexios/commit/e4f1b15151304e65e914541ce2e46ce40324ad6c)
- chore: bump version to 2.5.0 in pyproject.toml and __main__.py [`3176921`](https://github.com/nexios-labs/Nexios/commit/31769219c467fe0afb816c12c0227c58cb01ccd1)

#### [v2.4.14](https://github.com/nexios-labs/Nexios/compare/v2.4.13...v2.4.14)

> 20 June 2025

- Merge pull request #137 from nexios-labs/main [`#138`](https://github.com/nexios-labs/Nexios/pull/138)
- fix: handle directory initialization and path formatting in StaticFiles class for improved file serving, closes #136 [`#137`](https://github.com/nexios-labs/Nexios/pull/137)
- Merge pull request #137 from nexios-labs/main [`#136`](https://github.com/nexios-labs/Nexios/issues/136)
- fix: handle directory initialization and path formatting in StaticFiles class for improved file serving, closes #136 [`#136`](https://github.com/nexios-labs/Nexios/issues/136)
- docs: enhance documentation across multiple guides with fundamental concepts, best practices, and structured tips for authentication, configuration, dependency injection, error handling, routing, and WebSocket usage [`219286b`](https://github.com/nexios-labs/Nexios/commit/219286b4a9ebfc98cd24eaedf74c891e7eeb3641)
- docs: remove outdated team and community sections from team.md to streamline documentation [`7ad0f66`](https://github.com/nexios-labs/Nexios/commit/7ad0f661006bb08cc1ab2fa82d620f45e6696720)
- chore: update CHANGELOG.md for v2.4.13 release with recent fixes, documentation updates, and dependency changes [`0343a67`](https://github.com/nexios-labs/Nexios/commit/0343a67f6e514f11cbb6daae258656992077ee0a)

#### [v2.4.13](https://github.com/nexios-labs/Nexios/compare/v2.4.12...v2.4.13)

> 18 June 2025

- fix: update endpoint path formatting to simplify parameter representation in application.py [`#135`](https://github.com/nexios-labs/Nexios/pull/135)
- fix: update endpoint path formatting to simplify parameter representation in application.py [`#134`](https://github.com/nexios-labs/Nexios/pull/134)
- Dev [`#133`](https://github.com/nexios-labs/Nexios/pull/133)
- Merge branch 'main' of https://github.com/nexios-labs/Nexios [`#132`](https://github.com/nexios-labs/Nexios/pull/132)
- chore: update flake8 configuration and improve type hinting across the codebase [`#131`](https://github.com/nexios-labs/Nexios/pull/131)
- Dev [`#127`](https://github.com/nexios-labs/Nexios/pull/127)
- chore: add seaborn and update Python version requirements in project dependencies [`bb3889d`](https://github.com/nexios-labs/Nexios/commit/bb3889d5f6fb6103254b9e4de591d441c5436d0f)
- docs: add comprehensive API reference documentation for core components, request, response, and routing [`6ebfb16`](https://github.com/nexios-labs/Nexios/commit/6ebfb16b388d722a3f40f6a6bbbe5357397f9573)
- docs: update API reference documentation to include new authentication, dependencies, and middleware sections, and enhance application setup examples [`330b983`](https://github.com/nexios-labs/Nexios/commit/330b9835cb3666137a54a98d435ac0677c4becd1)

#### [v2.4.12](https://github.com/nexios-labs/Nexios/compare/v2.4.11...v2.4.12)

> 15 June 2025

- chore: update project version to 2.4.12 in pyproject.toml and __main__.py [`83895bf`](https://github.com/nexios-labs/Nexios/commit/83895bf6d46ae4299deebc88355617119fc0e501)
- chore: update project version to 2.4.11 in pyproject.toml [`1c37b05`](https://github.com/nexios-labs/Nexios/commit/1c37b05ab50a4d8b585cddbab688fb91e9f36ef0)

#### [v2.4.11](https://github.com/nexios-labs/Nexios/compare/v2.4.10...v2.4.11)

> 15 June 2025

- chore: add step to clean old builds and simplify PyPI publishing in GitHub Actions workflow [`e8af5b9`](https://github.com/nexios-labs/Nexios/commit/e8af5b9f642a3ac9e75cfefa7487abfea040c7ff)
- chore: add step to clean old builds in GitHub Actions workflow [`008e774`](https://github.com/nexios-labs/Nexios/commit/008e7747128c628ece5cf65c5b58fd3a520326f1)

#### [v2.4.10](https://github.com/nexios-labs/Nexios/compare/v2.4.9...v2.4.10)

> 14 June 2025

- Dev [`#126`](https://github.com/nexios-labs/Nexios/pull/126)
- Merge from main [`#125`](https://github.com/nexios-labs/Nexios/pull/125)
- Dev [`#124`](https://github.com/nexios-labs/Nexios/pull/124)
- Dev [`#122`](https://github.com/nexios-labs/Nexios/pull/122)
- Dev [`#121`](https://github.com/nexios-labs/Nexios/pull/121)
- docs: overhaul API examples and documentation structure to enhance clarity, introduce best practices, and provide comprehensive code snippets for common use cases [`3ed020c`](https://github.com/nexios-labs/Nexios/commit/3ed020c75fb08371d0ca9ca6d74462e0cc76539a)
- docs: add 'Examples' section link to navigation for enhanced user access to practical implementations [`7b1eb52`](https://github.com/nexios-labs/Nexios/commit/7b1eb52c9d902bb03bfac4b0f0bccdeeafc32f78)
- docs: add 'Course' section to navigation and expand course content with detailed day-by-day topics for enhanced learning experience [`951e257`](https://github.com/nexios-labs/Nexios/commit/951e2574a6fd866f632479fe65b6eae82de16413)

#### [v2.4.9](https://github.com/nexios-labs/Nexios/compare/v2.4.8...v2.4.9)

> 6 June 2025

- feat(openapi): enhance API documentation routes with customizable URLs for Swagger and ReDoc; add ReDoc UI generation [`d11085c`](https://github.com/nexios-labs/Nexios/commit/d11085c20886429b2eccd6f4d50e5a243eda8a1b)
- chore: update CHANGELOG for v2.4.8 release, detailing recent changes and improvements [`13dca44`](https://github.com/nexios-labs/Nexios/commit/13dca44dd1e264f796b0ce0c0ee8149dceef6832)
- refactor(MakeConfig): update constructor to accept optional config and kwargs, merging them with defaults for improved flexibility [`850fe78`](https://github.com/nexios-labs/Nexios/commit/850fe78443acf92f1aacb76bb3cafb35160138ca)

#### [v2.4.8](https://github.com/nexios-labs/Nexios/compare/v2.4.7...v2.4.8)

> 5 June 2025

- Dev [`#120`](https://github.com/nexios-labs/Nexios/pull/120)
- Merge from main [`#119`](https://github.com/nexios-labs/Nexios/pull/119)
- Dev [`#118`](https://github.com/nexios-labs/Nexios/pull/118)
- Dev [`#116`](https://github.com/nexios-labs/Nexios/pull/116)
- fix(docs): improve clarity in concurrency guide and update examples for better understanding [`d790c96`](https://github.com/nexios-labs/Nexios/commit/d790c967282b3bca49d550dc05c773f92c123cb9)
- chore: remove unused cached dependencies and temporary files from VitePress build [`df80893`](https://github.com/nexios-labs/Nexios/commit/df8089306dab58d44b38e161f3a5848b0436b833)
- feat(templating): add templating guide link in documentation; refactor TemplateEngine for improved configuration handling and error management; update TemplateContextMiddleware for better type hints; remove unused utility functions [`5f7138d`](https://github.com/nexios-labs/Nexios/commit/5f7138dc3ac62ad06f66bcf4e13d9d7bc9848efe)

#### [v2.4.7](https://github.com/nexios-labs/Nexios/compare/v2.4.6...v2.4.7)

> 1 June 2025

- Dev [`#114`](https://github.com/nexios-labs/Nexios/pull/114)
- feat(routes): enhance add_route method to support optional path and handler parameters [`999eefe`](https://github.com/nexios-labs/Nexios/commit/999eefe6a9383a266caa20f3da508507ecada4bc)
- feat(icon): redesign SVG icon with gradients, shadows, and new shapes [`caba18c`](https://github.com/nexios-labs/Nexios/commit/caba18cf56221949cbdac6cba6e1495b53c82514)
- Auto-format Python code with Black [`881d3cd`](https://github.com/nexios-labs/Nexios/commit/881d3cd9ef3e49ebddf6ed6f360d276a44089132)

#### [v2.4.6](https://github.com/nexios-labs/Nexios/compare/v2.4.5...v2.4.6)

> 30 May 2025

- chore: update CHANGELOG for v2.4.5 release with recent fixes and enhancements [`36e8c27`](https://github.com/nexios-labs/Nexios/commit/36e8c2783815935a96374c204d7358c29ffa2539)
- fix(openapi): implement OpenAPI setup during application shutdown and improve JSON property typing [`9fa250f`](https://github.com/nexios-labs/Nexios/commit/9fa250fe159f2f1ed00d2445fa3f2bdd0fbaad63)
- chore(versioning): Bump version from 2.4.5 to 2.4.6 [`bd17397`](https://github.com/nexios-labs/Nexios/commit/bd173977f0875e093e456292193a9e0130704f6c)

#### [v2.4.5](https://github.com/nexios-labs/Nexios/compare/v2.4.4...v2.4.5)

> 27 May 2025

- Fix : Fix openapi  setup in NexiosApp in lifespan handling [`#112`](https://github.com/nexios-labs/Nexios/pull/112)
- chore: Update CHANGELOG for v2.4.4 release with new features, refactors, and tests [`dda7f90`](https://github.com/nexios-labs/Nexios/commit/dda7f9056b78b06807f8a3b46a983ce16b6ec5be)
- fix: Remove debug print statements and clean up lifespan event handling [`477fd63`](https://github.com/nexios-labs/Nexios/commit/477fd6392ca831409398194fcfbfacc00243fcc5)
- chore: bump version to 2.4.5 in __main__.py and pyproject.toml [`fcda8aa`](https://github.com/nexios-labs/Nexios/commit/fcda8aa1e5f1c81a1d5aaf9f4db8d444853e30d0)

#### [v2.4.4](https://github.com/nexios-labs/Nexios/compare/v2.4.3...v2.4.4)

> 25 May 2025

- Dev [`#110`](https://github.com/nexios-labs/Nexios/pull/110)
- feat: implement form parsing and routing enhancements with new internal modules [`0a3f3ac`](https://github.com/nexios-labs/Nexios/commit/0a3f3ac7cbe46b0acaf78c9c5d634052a3bfe495)
- refactor:Update router registration and type hints in NexiosApp [`9aeb2ff`](https://github.com/nexios-labs/Nexios/commit/9aeb2ffdd7ad111dc6f4a65c2dd6fb890f6b3849)
- test: Enhance routing tests for Group class with multiple scenarios [`a3d156c`](https://github.com/nexios-labs/Nexios/commit/a3d156ce52567f548503c9ac00a5851a8fa0974a)

#### [v2.4.3](https://github.com/nexios-labs/Nexios/compare/v2.4.2...v2.4.3)

> 20 May 2025

- Dev [`#109`](https://github.com/nexios-labs/Nexios/pull/109)
- feat: add examples for authentication, exception handling, middleware… [`#108`](https://github.com/nexios-labs/Nexios/pull/108)
- fix: correct heading formatting in getting started guide [`#107`](https://github.com/nexios-labs/Nexios/pull/107)
- feat: add examples for authentication, exception handling, middleware, request inputs, responses, and routing [`dfd1c84`](https://github.com/nexios-labs/Nexios/commit/dfd1c84bfa26ff54b2ac59d5a6d59777c70bc6b7)
- feat: add handler hooks documentation and implement before/after request decorators [`5aa3038`](https://github.com/nexios-labs/Nexios/commit/5aa30380110433f416a4ad147f3b669a107d2c07)
- feat: enhance server error template with improved layout and request information section [`b1bc951`](https://github.com/nexios-labs/Nexios/commit/b1bc951e92bb00c707b0c1f1ef74e8cf3d9a1e74)

#### [v2.4.2](https://github.com/nexios-labs/Nexios/compare/v2.4.1...v2.4.2)

> 15 May 2025

- Dev [`#106`](https://github.com/nexios-labs/Nexios/pull/106)
- Merge pull request #104 from nexios-labs/dev [`#105`](https://github.com/nexios-labs/Nexios/pull/105)
- Dev [`#104`](https://github.com/nexios-labs/Nexios/pull/104)
- chore(release): bump version to 2.4.1 and update changelog, documentation, and README [`#103`](https://github.com/nexios-labs/Nexios/issues/103)
- feat: add ASGI and Async Python guides to documentation [`a20ff88`](https://github.com/nexios-labs/Nexios/commit/a20ff888c6448bebfa0910c3aa20189156631641)
- feat: add File Router guide to documentation and update config for navigation [`6857813`](https://github.com/nexios-labs/Nexios/commit/6857813cdcaaaedc567115334ccdea64e9c96fe0)
- refactor: update VitePress config for improved structure and clarity [`538e6b0`](https://github.com/nexios-labs/Nexios/commit/538e6b0758d374e59537288b572d5a4f82a36131)

#### [v2.4.1](https://github.com/nexios-labs/Nexios/compare/v2.4.0...v2.4.1)

> 14 May 2025

- feat(ci): add GitHub Actions workflow for automated release on tag push [`#103`](https://github.com/nexios-labs/Nexios/pull/103)
- fix(docs): remove redundant phrasing in framework description  [`#102`](https://github.com/nexios-labs/Nexios/pull/102)
- Dev [`#101`](https://github.com/nexios-labs/Nexios/pull/101)
- docs: update tips in getting-started and add reverse routing section … [`#100`](https://github.com/nexios-labs/Nexios/pull/100)
- fix(cli): update warning message for clarity on Granian integration [`#123`](https://github.com/nexios-labs/Nexios/issues/123)
- Refactor documentation for consistency and clarity [`86b9d1f`](https://github.com/nexios-labs/Nexios/commit/86b9d1f8f47185079bec146f404df6fa8da678d0)
- feat(router): add base_app reference to scope for improved access in request handling [`84c2c23`](https://github.com/nexios-labs/Nexios/commit/84c2c23714dde850dd35349f0b7dc0c7ce7566e9)
- docs: update tips in getting-started and add reverse routing section in routing [`409f727`](https://github.com/nexios-labs/Nexios/commit/409f727c07ce2f46958325049b24a4bc63d5d865)

#### [v2.4.0](https://github.com/nexios-labs/Nexios/compare/v2.3.1...v2.4.0)

> 11 May 2025

- fix: update install command in GitHub Actions workflow for consistency [`#123`](https://github.com/nexios-labs/Nexios/issues/123)
- Implements user authentication feature [`#789`](https://github.com/nexios-labs/Nexios/issues/789)
- Refactor code structure for improved readability and maintainability [`#789`](https://github.com/nexios-labs/Nexios/issues/789)
- refactor(openapi)  : Refactor code structure for improved readability and maintainability [`#123`](https://github.com/nexios-labs/Nexios/issues/123)
- fix(static): improve directory handling and validation in StaticFilesHandler [`#96`](https://github.com/nexios-labs/Nexios/issues/96)
- chore(docs) :Refactor code structure and remove redundant code blocks for improved readability and maintainability. [`2687fe0`](https://github.com/nexios-labs/Nexios/commit/2687fe0f3ce768a71d05662157542d3770446f73)
- Remove legacy documentation files for static files, templating, Tortoise ORM, WebSockets, and general Nexios overview to streamline the project and focus on updated content. [`0ea37f5`](https://github.com/nexios-labs/Nexios/commit/0ea37f5530be0602ec71d26d5979ce4df3726ceb)
- GITBOOK-23: No subject [`f414a54`](https://github.com/nexios-labs/Nexios/commit/f414a54db6d419d933f9ef4d7567f47a97e2b0de)

#### [v2.3.1](https://github.com/nexios-labs/Nexios/compare/v2.3.0-rc.1...v2.3.1)

> 14 April 2025

- refactor(transport): rename request_with_retries to handle_request and improve error handling; update WebSocket connection management [`24f1327`](https://github.com/nexios-labs/Nexios/commit/24f1327dee9cf8b97d7753fa30e92995e1b217f0)
- chore(readme):Refactor code structure for improved readability and maintainability [`09cad24`](https://github.com/nexios-labs/Nexios/commit/09cad2476e0f6af9f6f8f9d7167bb1bcd2196573)
- refactor(middleware): update middleware integration and improve ASGI compatibility [`309f2a4`](https://github.com/nexios-labs/Nexios/commit/309f2a444f0da94aa51c700b33f708b6a0a16ef4)

#### v2.3.0-rc.1

> 5 April 2025

- Beta/v2.1 [`#75`](https://github.com/nexios-labs/Nexios/pull/75)
- Merge pull request #73 from nexios-labs/beta/v2.1 [`#74`](https://github.com/nexios-labs/Nexios/pull/74)
- Beta/v2.1 [`#73`](https://github.com/nexios-labs/Nexios/pull/73)
- 🐛 fix: update response handling in FileResponse and StreamingResponse, add cookie setting functionality in NexiosResponse [`#72`](https://github.com/nexios-labs/Nexios/pull/72)
- 🚀 chore: bump version to 2.1.0b1 in __main__.py and pyproject.toml [`#71`](https://github.com/nexios-labs/Nexios/pull/71)
- 🐛 fix: remove logging middleware and update error handling to use logger [`#70`](https://github.com/nexios-labs/Nexios/pull/70)
- Beta/v2.1 [`#69`](https://github.com/nexios-labs/Nexios/pull/69)
- 🐛 fix: prevent double wrapping of handler in allowed_methods decorator [`#68`](https://github.com/nexios-labs/Nexios/pull/68)
- Merge pull request [#1](https://github.com/TechWithDunamix/Nexios/issues/1) from nexios-labs/main  Merge pull request [#66](https://github.com/TechWithDunamix/Nexios/issues/66) from TechWithDunamix/main [`#67`](https://github.com/nexios-labs/Nexios/pull/67)
- Merge pull request #66 from TechWithDunamix/main [`#1`](https://github.com/nexios-labs/Nexios/pull/1)
- 🔧 chore: update GitHub Actions workflows for permissions and Python version, adjust poetry install command, and refine README links [`#66`](https://github.com/nexios-labs/Nexios/pull/66)
- 🔧 chore: update MkDocs deployment command to specify config file and adjust poetry install command for dev dependencies [`#65`](https://github.com/nexios-labs/Nexios/pull/65)
- Merge branch 'main' of https://github.com/TechWithDunamix/Nexios [`#64`](https://github.com/nexios-labs/Nexios/pull/64)
- Merge branch 'nexios-labs:main' into main [`#63`](https://github.com/nexios-labs/Nexios/pull/63)
- ♻️ refactor: enhance path normalization logic with configurable optio… [`#62`](https://github.com/nexios-labs/Nexios/pull/62)
- logo editz [`#61`](https://github.com/nexios-labs/Nexios/pull/61)
- Dev [`#60`](https://github.com/nexios-labs/Nexios/pull/60)
- Dev [`#59`](https://github.com/nexios-labs/Nexios/pull/59)
- fix : fixed issues issues  with shared value amongs schema instance [`#58`](https://github.com/nexios-labs/Nexios/pull/58)
- fix : fix validators [`#56`](https://github.com/nexios-labs/Nexios/pull/56)
- Dev [`#55`](https://github.com/nexios-labs/Nexios/pull/55)
- merge [`#54`](https://github.com/nexios-labs/Nexios/pull/54)
- feat :web socket middleware [`#53`](https://github.com/nexios-labs/Nexios/pull/53)
- Dev [`#52`](https://github.com/nexios-labs/Nexios/pull/52)
- Merge pull request #50 from TechWithDunamix/dev [`#51`](https://github.com/nexios-labs/Nexios/pull/51)
- Dev [`#50`](https://github.com/nexios-labs/Nexios/pull/50)
- Merge [`#49`](https://github.com/nexios-labs/Nexios/pull/49)
- Dev [`#48`](https://github.com/nexios-labs/Nexios/pull/48)
- Integrated websocket, created status helpers, fix issues for routers … [`#47`](https://github.com/nexios-labs/Nexios/pull/47)
- feat :web socket integration [`#46`](https://github.com/nexios-labs/Nexios/pull/46)
- feat : working on websocker connection [`#45`](https://github.com/nexios-labs/Nexios/pull/45)
- Dev [`#44`](https://github.com/nexios-labs/Nexios/pull/44)
- fix : fix url params error [`#43`](https://github.com/nexios-labs/Nexios/pull/43)
- Dev [`#42`](https://github.com/nexios-labs/Nexios/pull/42)
- Deployment [`#41`](https://github.com/nexios-labs/Nexios/pull/41)
- Dev [`#40`](https://github.com/nexios-labs/Nexios/pull/40)
- Dev [`#39`](https://github.com/nexios-labs/Nexios/pull/39)
- Merge pull request #34 from TechWithDunamix/dev [`#35`](https://github.com/nexios-labs/Nexios/pull/35)
- Dev [`#34`](https://github.com/nexios-labs/Nexios/pull/34)
- few changes [`#33`](https://github.com/nexios-labs/Nexios/pull/33)
- Dev [`#32`](https://github.com/nexios-labs/Nexios/pull/32)
- New features [`#31`](https://github.com/nexios-labs/Nexios/pull/31)
- Dev [`#30`](https://github.com/nexios-labs/Nexios/pull/30)
- Dev [`#29`](https://github.com/nexios-labs/Nexios/pull/29)
- Dev [`#28`](https://github.com/nexios-labs/Nexios/pull/28)
- implemented request validation mixins [`#27`](https://github.com/nexios-labs/Nexios/pull/27)
- Validators [`#26`](https://github.com/nexios-labs/Nexios/pull/26)
- Merge [`#25`](https://github.com/nexios-labs/Nexios/pull/25)
- Validators [`#24`](https://github.com/nexios-labs/Nexios/pull/24)
- Validators [`#23`](https://github.com/nexios-labs/Nexios/pull/23)
- Merge pull request #21 from TechWithDunamix/validators [`#22`](https://github.com/nexios-labs/Nexios/pull/22)
- Validators [`#21`](https://github.com/nexios-labs/Nexios/pull/21)
- a [`#20`](https://github.com/nexios-labs/Nexios/pull/20)
- feat : bilding the command line tool [`#19`](https://github.com/nexios-labs/Nexios/pull/19)
- Validators [`#18`](https://github.com/nexios-labs/Nexios/pull/18)
- merge [`#17`](https://github.com/nexios-labs/Nexios/pull/17)
- more moderations [`#16`](https://github.com/nexios-labs/Nexios/pull/16)
- Validators [`#15`](https://github.com/nexios-labs/Nexios/pull/15)
- Fix issues [`#14`](https://github.com/nexios-labs/Nexios/pull/14)
- Validators [`#12`](https://github.com/nexios-labs/Nexios/pull/12)
- addeed cusom validation [`#11`](https://github.com/nexios-labs/Nexios/pull/11)
- added validation [`#10`](https://github.com/nexios-labs/Nexios/pull/10)
- feat  : validation [`#9`](https://github.com/nexios-labs/Nexios/pull/9)
- add custom validator options [`#8`](https://github.com/nexios-labs/Nexios/pull/8)
- initial clommit on feat: validators [`#7`](https://github.com/nexios-labs/Nexios/pull/7)
- fix : fix few issues from the request object [`#6`](https://github.com/nexios-labs/Nexios/pull/6)
- Merge pull request #4 from TechWithDunamix/main [`#5`](https://github.com/nexios-labs/Nexios/pull/5)
- few changes [`#4`](https://github.com/nexios-labs/Nexios/pull/4)
- Sessions [`#3`](https://github.com/nexios-labs/Nexios/pull/3)
- Sessions [`#2`](https://github.com/nexios-labs/Nexios/pull/2)
- trying to implement lifespan [`#1`](https://github.com/nexios-labs/Nexios/pull/1)
- cleanup [`35262ba`](https://github.com/nexios-labs/Nexios/commit/35262ba4598e28a4f70b00805939df30f296696c)
- refactor(models): simplify parameter type annotations in OpenAPI models [`362a41f`](https://github.com/nexios-labs/Nexios/commit/362a41f556094aa4c63a133f464d609794b753a6)
- chore(git): add coverage.xml to .gitignore [`44e8e40`](https://github.com/nexios-labs/Nexios/commit/44e8e404ac1a7b8a5687489acdf57baba3be88a5)
