from nexios import NexiosApp
from nexios.templating import TemplateConfig, render

app = NexiosApp()

# Configure templating with custom settings
template_config = TemplateConfig(
    template_dir="templates",  # Directory for templates
    auto_reload=True,  # Auto-reload templates in development
    enable_async=True,  # Enable async rendering
)

# Apply template configuration
app.config.templating = template_config


@app.get("/")
async def index(request, response):
    # Simple template rendering with context
    return await render(
        "index.html",
        {"title": "Welcome to Nexios", "message": "Hello from the template engine!"},
    )


@app.get("/user/{username}")
async def user_profile(request, response, username: str):
    # Template rendering with URL parameters
    return await render(
        "user_profile.html",
        {"username": username, "profile_data": {"joined": "2024-01-01", "posts": 42}},
    )


if __name__ == "__main__":
    import uvicorn

    uvicorn.run(app, host="0.0.0.0", port=8000)
