"""
TotalCloud call schema
"""

from frozendict import frozendict

TOTALCLOUD_SCHEMA = frozendict(
    {
        "cloudview": {  # TOTALCLOUD
            "url_type": "base",
            "get_connectors": {
                "endpoint": "/cloudview-api/rest/v1/{cloudprovider}/connectors",
                "method": ["GET"],
                "valid_params": [
                    "pageNo",
                    "pageSize",
                    "filter",
                    "sort",
                    "cloudprovider",
                ],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": True,
                "auth_type": "basic",
            },
            "get_connector_details": {
                "endpoint": "/cloudview-api/rest/v1/{cloudprovider}/connectors/{placeholder}",
                "method": ["GET"],
                "valid_params": ["placeholder", "cloudprovider"],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": False,
                "auth_type": "basic",
            },
            "get_aws_base_account": {
                "endpoint": "/cloudview-api/rest/v1/aws/connectors/awsBaseAccountId",
                "method": ["GET"],
                "valid_params": [],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": False,
                "auth_type": "basic",
            },
            "get_control_metadata": {
                "endpoint": "/cloudview-api/rest/v1/controls/metadata/list",
                "method": ["GET"],
                "valid_params": ["pageNo", "pageSize", "filter"],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": True,
                "auth_type": "basic",
            },
            "get_control_stats_by_resouce": {
                "endpoint": "/cloudview-api/rest/v1/{cloudprovider}/evaluations/stats/{controlid}/{connectorid}",
                "method": ["GET"],
                "valid_params": [
                    "controlid",
                    "connectorid",
                    "cloudprovider",
                    "resourceId",
                    "provider",
                ],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": False,
                "auth_type": "basic",
            },
            "get_inventory": {
                "endpoint": "/cloudview-api/rest/v1/resource/{placeholder}/{cloudprovider}",
                "method": ["GET"],
                "valid_params": [
                    "cloudprovider",
                    "placeholder",
                    "filter",
                    "pageNo",
                    "pageSize",
                    "sort",
                    "updated",
                ],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": True,
                "auth_type": "basic",
            },
            "get_resource_details": {
                "endpoint": "/cloudview-api/rest/v1/resource/{placeholder}/uuid/{resourceid}/{cloudprovider}",
                "method": ["GET"],
                "valid_params": [
                    "cloudprovider",
                    "placeholder",
                    "resourceid",
                    "pageNo",
                    "pageSize",
                    "filter",
                    "sort",
                    "updated",
                ],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": False,
                "auth_type": "basic",
            },
            "get_account_evaluation": {
                "endpoint": "/cloudview-api/rest/v1/{cloudprovider}/evaluations/{placeholder}",
                "method": ["GET"],
                "valid_params": ["filter", "placeholder", "cloudprovider", "accountId"],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": False,
                "auth_type": "basic",
            },
            "get_resources_evaluated_by_control": {
                "endpoint": "/cloudview-api/rest/v1/{cloudprovider}/evaluations/{placeholder}/resources/{controlid}",
                "method": ["GET"],
                "valid_params": [
                    "accountId",  # placeholder ⬇️
                    "controlid",
                    "filter",
                    "placeholder",
                    "cloudprovider",
                ],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": False,
                "auth_type": "basic",
            },
            "get_remediation_activities": {
                "endpoint": "/cloudview-api/rest/v1/remediation/activity",
                "method": ["GET"],
                "valid_params": ["pageNo", "pageSize", "filter", "cloudType"],
                "valid_POST_data": [],
                "use_requests_json_data": False,
                "return_type": "json",
                "pagination": True,
                "auth_type": "basic",
            },
        },
    }
)
