"""
Web Application Scanning call schema
"""

from frozendict import frozendict

WAS_SCHEMA = frozendict(
    {
        "was": {
            "url_type": "api",
            "call_webapp_api": {
                "endpoint": "/qps/rest/3.0/{placeholder}/was/webapp/{webappId}",
                "method": ["POST", "GET"],
                "valid_params": ["placeholder", "webappId", "_xml_data", "action"],
                "valid_POST_data": [
                    "_xml_data",
                    "id",
                    "name",
                    "url",
                    "tags.name",
                    "tags.id",
                    "createdDate",
                    "updatedDate",
                    "isScheduled",
                    "isScanned",
                    "lastScan.status",
                    "lastScan.date",
                    "verbose",
                ],
                "use_requests_json_data": False,
                "return_type": "xml",
                "pagination": True,
                "auth_type": "basic",
                "_xml_data": True,
            },
            "call_auth_api": {
                "endpoint": "/qps/rest/3.0/{placeholder}/was/webappauthrecord/{webappAuthRecordId}",
                "method": ["POST", "GET"],
                "valid_params": [
                    "placeholder",
                    "webappAuthRecordId",
                    "_xml_data",
                    "action",
                ],
                "valid_POST_data": [
                    "_xml_data",
                    "id",
                    "name",
                    "tags",
                    "tags.name",
                    "tags.id",
                    "createdDate",
                    "updatedDate",
                    "lastScan.date",
                    "lastScan.authStatus",
                    "isUsed",
                    "contents",
                ],
                "use_requests_json_data": False,
                "return_type": "xml",
                "pagination": True,
                "auth_type": "basic",
                "_xml_data": True,
            },
            "call_findings_api": {
                "endpoint": "/qps/rest/3.0/{placeholder}/was/finding/{findingId}",
                "method": ["POST", "GET"],
                "valid_params": ["placeholder", "findingId", "_xml_data", "action"],
                "valid_POST_data": [
                    "_xml_data",
                    "id",
                    "uniqueId",
                    "qid",
                    "name",
                    "type",
                    "url",
                    "webApp.tags.id",
                    "webApp.tags.name",
                    "status",
                    "patch",
                    "webApp.id",
                    "webApp.name",
                    "severity",
                    "externalRef",
                    "ignoredDate",
                    "ignoredReason",
                    "group",
                    "owasp.name",
                    "owasp.code",
                    "cwe.id",
                    "firstDetectedDate",
                    "lastDetectedDate",
                    "lastTestedDate",
                    "timesDetected",
                    "severity level",
                ],
                "use_requests_json_data": False,
                "return_type": "xml",
                "pagination": True,
                "auth_type": "basic",
                "_xml_data": True,
            },
            "call_scans_api": {
                "endpoint": "/qps/rest/3.0/{placeholder}/was/wasscan/{scanId}",
                "method": ["POST", "GET"],
                "valid_params": ["placeholder", "_xml_data", "action", "scanId"],
                "valid_POST_data": ["_xml_data", "scanId"],
                "use_requests_json_data": False,
                "return_type": "xml",
                "pagination": True,
                "auth_type": "basic",
                "_xml_data": True,
            },
            "scan_again": {
                "endpoint": "/qps/rest/3.0/scanagain/was/scan/{scanId}",
                "method": ["POST"],
                "valid_params": ["scanId"],
                "valid_POST_data": ["_xml_data"],
                "use_requests_json_data": False,
                "return_type": "xml",
                "pagination": False,
                "auth_type": "basic",
                "_xml_data": True,
            },
        },
    }
)
