"""
Contains the PMVulnerability data class.
"""

from dataclasses import dataclass
from typing import Union
from datetime import datetime

from ...base.base_list import BaseList
from ...base.base_class import BaseClass
from ...base import DONT_EXPAND


@dataclass
class PMVulnerability(BaseClass):
    """
    Represents a QID with CVE details underneath
    in Patch Management.
    """

    id: int = None
    title: str = ""
    cves: BaseList[str] = None
    detectedDate: Union[int, datetime] = None
    severity: int = None
    vulnType: str = None

    def __post_init__(self):
        if getattr(self, "detectedDate"):
            # Attempt to convert the detectedDate to a datetime object
            try:
                setattr(
                    self,
                    "detectedDate",
                    datetime.fromtimestamp(self.detectedDate / 1000),
                )
            # Unless a TypeError or OSError, indicating a way
            # off timestamp. Yes, this is a thing.
            except (TypeError, OSError, ValueError):
                setattr(self, "detectedDate", None)

        if not DONT_EXPAND.flag:
            if getattr(self, "cves"):
                setattr(self, "cves", BaseList(self.cves))

    def __int__(self):
        return self.id

    def __str__(self):
        return self.title
