"""
Contains the resource name mappings and the class mappings for resources
"""

from .AWSResources import *
from .AzureResources import *

VALID_RESOURCETYPES = {
    "aws": [
        "RDS",
        "NETWORK_ACL",
        "BUCKET",
        "IAM_USER",
        "VPC",
        "VPC_SECURITY_GROUP",
        "LAMBDA",
        "SUBNET",
        "INTERNET_GATEWAY",
        "LOAD_BALANCER",
        "EC2_INSTANCE",
        "ROUTE_TABLE",
        "EBS",
        "AUTO_SCALING_GROUP",
        "EKS_CLUSTER",
        "EKS_NODEGROUP",
        "EKS_FARGATE_PROFILE",
        "VPC_ENDPOINT",
        "VPC_ENDPOINT_SERVICE",
        "IAM_GROUP",
        "IAM_POLICY",
        "IAM_ROLE",
        "SAGEMAKER_NOTEBOOK",
        "CLOUDFRONT_DISTRIBUTION",
    ],
    "azure": [
        "SQL_SERVER",
        "FUNCTION_APP",
        "SQL_SERVER_DATABASE",
        "RESOURCE_GROUP",
        "VIRTUAL_NETWORK",
        "VIRTUAL_MACHINE",
        "NETWORK_SECURITY_GROUP",
        "WEB_APP",
        "NETWORK_INTERFACES",
        "POSTGRE_SINGLE_SERVER",
        "LOAD_BALANCER",
        "FIREWALL",
        "MYSQL",
        "STORAGE_ACCOUNT",
        "APPLICATION_GATEWAYS",
        "SECRETS",
        "MARIADB",
        "COSMODB",
        "NAT_GATEWAYS",
    ],
}

# Common names for resources to substitute for the user's convenience
COMMON_NAMES = {
    "aws": {
        "NETWORK_ACL": ["ACL"],
        "BUCKET": ["S3_BUCKET", "S3"],
        "IAM_USER": ["IAM", "IAMUSER"],
        "VPC_SECURITY_GROUP": ["SECURITY_GROUP", "SG"],
        "LAMBDA": ["LAMBDA_FUNCTION"],
        "INTERNET_GATEWAY": ["IG", "IGW", "GATEWAY"],
        "LOAD_BALANCER": ["ELB", "LB"],
        "EC2_INSTANCE": ["EC2", "INSTANCE"],
        "ROUTE_TABLE": ["ROUTE", "ROUTES"],
        "EBS": ["VOLUME", "VOLUMES", "EBS_VOLUME", "EBS_VOLUMES"],
        "AUTO_SCALING_GROUP": ["ASG", "AUTO_SCALING"],
        "EKS_CLUSTER": ["EKS"],
        "EKS_NODEGROUP": ["NODE_GROUP", "EKSNG", "EKS_NODE_GROUP"],
        "EKS_FARGATE_PROFILE": ["FARGATE_PROFILE", "EKS_FARGATE", "FARGATE"],
        "VPC_ENDPOINT_SERVICE": ["ENDPOINT_SERVICE"],
        "IAM_GROUP": ["IAMGROUP"],
        "IAM_POLICY": ["POLICY", "IAMPOLICY"],
        "IAM_ROLE": ["ROLE", "IAMROLE"],
        "SAGEMAKER_NOTEBOOK": ["NOTEBOOK", "SAGEMAKER"],
        "CLOUDFRONT_DISTRIBUTION": ["CLOUDFRONT"],
    },
    "azure": {
        "SQL_SERVER": ["MSSQL"],
        "FUNCTION_APP": ["FUNCTION"],
        "SQL_SERVER_DATABASE": ["MSSQL_DATABASE", "MSSQL_DB", "MSSQLDB"],
        "RESOURCE_GROUP": ["RG"],
        "VIRTUAL_NETWORK": ["VNET"],
        "VIRTUAL_MACHINE": ["VM"],
        "NETWORK_SECURITY_GROUP": ["NSG", "SECURITY_GROUP"],
        "WEB_APP": ["WEBAPP"],
        "NETWORK_INTERFACES": ["NIC", "INTERFACE"],
        "POSTGRE_SINGLE_SERVER": ["POSTGRE", "POSTGRES", "POSTGRESQL"],
        "LOAD_BALANCER": ["LB"],
        "FIREWALL": ["FW"],
        "MYSQL": ["MYSQL_DB", "MYSQLDB"],
        "STORAGE_ACCOUNT": ["STORAGE"],
        "APPLICATION_GATEWAYS": ["AG"],
        "SECRETS": ["SECRET"],
        "MARIADB": ["MARIA_DB", "MARIA"],
        "COSMODB": ["COSMOS", "COSMOS_DB"],
        "NAT_GATEWAYS": ["NAT"],
    },
}

# For dynamically creating the resource object based on the resource type
resource_map = {
    "RDS": AWSRDS,
    "NETWORK_ACL": AWSNetworkACL,
    "BUCKET": AWSBucket,
    "IAM_USER": AWSIAMUser,
    "VPC": AWSVPC,
    "VPC_SECURITY_GROUP": AWSSecurityGroup,
    "LAMBDA": AWSLambdaFunction,
    "SUBNET": AWSSubnet,
    "INTERNET_GATEWAY": AWSInternetGateway,
    "LOAD_BALANCER": AWSLoadBalancer,
    "EC2_INSTANCE": AWSEC2Instance,
    "ROUTE_TABLE": AWSRouteTable,
    "EBS": AWSEBSVolume,
    "AUTO_SCALING_GROUP": AWSAutoScalingGroup,
    "EKS_CLUSTER": AWSEKSCluster,
    "EKS_NODEGROUP": AWSEKSNodeGroup,
    "EKS_FARGATE_PROFILE": AWSEKSFargateProfile,
    "VPC_ENDPOINT": AWSVPCEndpoint,
    "VPC_ENDPOINT_SERVICE": AWSVPCEndpointService,
    "IAM_GROUP": AWSIAMGroup,
    "IAM_POLICY": AWSIAMPolicy,
    "IAM_ROLE": AWSIAMRole,
    "SAGEMAKER_NOTEBOOK": AWSSagemakerNotebook,
    "CLOUDFRONT_DISTRIBUTION": AWSCloudfrontDistribution,
    "VIRTUAL_MACHINE": AzureVM,
    "WEB_APP": AzureWebApp,
    "STORAGE_ACCOUNT": AzureStorageAccount,
}
