# mypy-boto3-emr

[![PyPI - mypy-boto3-emr](https://img.shields.io/pypi/v/mypy-boto3-emr.svg?color=blue)](https://pypi.org/project/mypy-boto3-emr)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-emr.svg?color=blue)](https://pypi.org/project/mypy-boto3-emr)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.EMR 1.14.36](https://boto3.amazonaws.com/v1/documentation/api/1.14.36/reference/services/emr.html#EMR) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `EMR` service.

```bash
python -m pip install boto3-stubs[emr]
```

## How to use

### Client annotations

`EMRClient` provides annotations for `boto3.client("emr")`.

```python
import boto3

from mypy_boto3_emr import EMRClient
from mypy_boto3_emr.paginator import (
    ListBootstrapActionsPaginator,
    ListClustersPaginator,
    ListInstanceFleetsPaginator,
    ListInstanceGroupsPaginator,
    ListInstancesPaginator,
    ListSecurityConfigurationsPaginator,
    ListStepsPaginator,
)
from mypy_boto3_emr.type_defs import ApplicationTypeDef, ...
from mypy_boto3_emr.waiter import ClusterRunningWaiter, ClusterTerminatedWaiter, StepCompleteWaiter

client: EMRClient = boto3.client("emr")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EMRClient = session.client("emr")
```

### Paginators annotations

`mypy_boto3_emr.paginator` module contains type annotations for all paginators.

```python

client: EMRClient = boto3.client("emr")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_bootstrap_actions_paginator: ListBootstrapActionsPaginator = client.get_paginator("list_bootstrap_actions")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_instance_fleets_paginator: ListInstanceFleetsPaginator = client.get_paginator("list_instance_fleets")
list_instance_groups_paginator: ListInstanceGroupsPaginator = client.get_paginator("list_instance_groups")
list_instances_paginator: ListInstancesPaginator = client.get_paginator("list_instances")
list_security_configurations_paginator: ListSecurityConfigurationsPaginator = client.get_paginator("list_security_configurations")
list_steps_paginator: ListStepsPaginator = client.get_paginator("list_steps")
```


### Waiters annotations

`mypy_boto3_emr.waiter` module contains type annotations for all waiters.

```python

client: EMRClient = boto3.client("emr")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
cluster_running_waiter: ClusterRunningWaiter = client.get_waiter("cluster_running")
cluster_terminated_waiter: ClusterTerminatedWaiter = client.get_waiter("cluster_terminated")
step_complete_waiter: StepCompleteWaiter = client.get_waiter("step_complete")
```





### Typed dictionations

`mypy_boto3_emr.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> ApplicationTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_emr` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("emr")

session_client = boto3.Session().client("emr")
```
