%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%                                                                  %%%%%
%%%%    IEEE PES Power Grid Library - Optimal Power Flow - v23.07     %%%%%
%%%%          (https://github.com/power-grid-lib/pglib-opf)           %%%%%
%%%%               Benchmark Group - Typical Operations               %%%%%
%%%%                         23 - July - 2023                         %%%%%
%%%%                                                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   This case was prepared as part of PSERC M-21, "Technical and Economic
%   Implications of Greenhouse Gas Regulation in a Transmission Constrained
%   Restructured Electricity Market", which is available at https://pserc.wisc.edu
%   This dataset only includes the network model, the original report has a
%   variety of additional data, which are discussed in the following technical
%   report,
%
%   Price, J. & Goodin, J.
%   "Reduced Network Modeling of WECC as a Market Design Prototype"
%   Power and Energy Society General Meeting
%   Detroit, MI, July, 2011
%
%   Copyright (c) 2011, Power Systems Engineering Research Center (PSERC)
%   Licensed under the Creative Commons Attribution 4.0 International license,
%   http://creativecommons.org/licenses/by/4.0/
%
function mpc = pglib_opf_case240_pserc
mpc.version = '2';
mpc.baseMVA = 100.0;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1001	 1	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1002	 1	 226.8419	 -37.472	 0.0	 0.0	 10	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	1003	 1	 2153.3224	 366.856	 0.0	 0.0	 10	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	1004	 1	 1037.9499	 5.521	 0.0	 0.0	 10	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	1032	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	1034	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	1101	 1	 4527.3661	 -137.044	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1102	 1	 176.4436	 23.004	 0.0	 0.0	 10	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	1131	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	1201	 1	 166.9882	 -2.012	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1202	 1	 875.61	 287.131	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1232	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	1301	 1	 2704.7793	 352.826	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1302	 1	 17.5556	 2.304	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1303	 1	 6235.136	 813.349	 0.0	 0.0	 10	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	1331	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	1333	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	1401	 1	 6535.5365	 1524.594	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1402	 1	 5366.6305	 -600.162	 0.0	 0.0	 10	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	1403	 1	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	1431	 2	 0.0	 0.0	 0.0	 0.0	 10	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2000	 1	 2207.188	 287.916	 0.0	 0.0	 20	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2030	 2	 0.0	 0.0	 0.0	 0.0	 20	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2100	 1	 281.1513	 54.83	 0.0	 0.0	 21	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2130	 2	 0.0	 0.0	 0.0	 0.0	 21	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2201	 1	 0.0	 0.0	 0.0	 0.0	 22	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2202	 1	 1545.949	 268.565	 0.0	 0.0	 22	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2203	 1	 1708.5525	 278.273	 0.0	 0.0	 22	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2233	 2	 0.0	 0.0	 0.0	 0.0	 22	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2301	 1	 0.0	 0.0	 0.0	 0.0	 22	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2302	 1	 0.0	 0.0	 0.0	 0.0	 22	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2332	 2	 0.0	 0.0	 0.0	 0.0	 22	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2400	 1	 843.2926	 76.663	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2401	 1	 882.3636	 105.214	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2402	 1	 1080.0201	 81.979	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2403	 1	 1050.004	 38.543	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2404	 1	 0.0	 0.0	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2405	 1	 824.6826	 22.901	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2406	 1	 737.4036	 -40.751	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2407	 1	 1732.771	 -36.535	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2408	 1	 1743.2768	 -72.623	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2409	 1	 1601.7777	 -86.698	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2410	 1	 1576.7872	 58.184	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2411	 1	 1087.6239	 75.955	 0.0	 0.0	 24	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2438	 2	 0.0	 0.0	 0.0	 0.0	 24	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2501	 1	 0.0	 0.0	 0.0	 0.0	 25	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2502	 1	 2369.1531	 -91.905	 0.0	 0.0	 25	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2503	 1	 1845.9256	 201.991	 0.0	 0.0	 25	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2533	 2	 0.0	 0.0	 0.0	 0.0	 25	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2600	 1	 -1863.9044	 0.0	 0.0	 0.0	 90	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2601	 1	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2602	 1	 99.2784	 12.955	 0.0	 0.0	 26	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2603	 1	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2604	 1	 2050.7816	 0.0	 0.0	 0.0	 90	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	2605	 1	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 287.0	 1	    1.10000	    0.90000;
	2606	 1	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 287.0	 1	    1.10000	    0.90000;
	2607	 1	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 287.0	 1	    1.10000	    0.90000;
	2608	 1	 99.2784	 12.955	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2609	 1	 134.0261	 26.805	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2610	 1	 99.2784	 12.955	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2611	 1	 99.2784	 12.955	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2612	 1	 120.1277	 24.819	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2613	 1	 317.693	 64.532	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2614	 1	 137.0047	 27.798	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2615	 1	 801.9756	 131.148	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2616	 1	 116.1565	 23.827	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2617	 1	 120.1277	 24.819	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2618	 1	 881.2994	 -6.155	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2619	 1	 -2773.8339	 0.0	 0.0	 0.0	 90	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2620	 1	 203.7206	 17.473	 0.0	 0.0	 26	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	2621	 1	 235.4897	 -62.745	 0.0	 0.0	 26	    1.00000	    0.00000	 138.0	 1	    1.10000	    0.90000;
	2630	 2	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2631	 2	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2634	 2	 0.0	 0.0	 0.0	 0.0	 90	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2637	 2	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2638	 2	 0.0	 0.0	 0.0	 0.0	 26	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	2901	 1	 0.0	 0.0	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	2902	 1	 0.0	 0.0	 0.0	 0.0	 24	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3101	 1	 341.3057	 52.828	 0.0	 0.0	 31	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3102	 1	 159.4648	 24.929	 0.0	 0.0	 31	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3103	 1	 419.6109	 59.777	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3104	 1	 309.9718	 40.133	 0.0	 0.0	 31	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	3105	 1	 239.3018	 49.091	 0.0	 0.0	 31	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	3133	 2	 0.0	 0.0	 0.0	 0.0	 32	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3135	 2	 0.0	 0.0	 0.0	 0.0	 31	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3201	 1	 462.4769	 97.849	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3202	 1	 586.1795	 83.473	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3203	 1	 657.1046	 158.476	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3204	 1	 668.7879	 95.313	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3205	 1	 546.0609	 77.782	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3234	 2	 0.0	 0.0	 0.0	 0.0	 32	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3301	 1	 0.0	 0.0	 0.0	 0.0	 32	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3302	 1	 345.3259	 85.791	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3303	 1	 625.4106	 150.715	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3304	 1	 533.4822	 122.616	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3305	 1	 430.3196	 61.225	 0.0	 0.0	 32	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3333	 2	 0.0	 0.0	 0.0	 0.0	 32	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3401	 1	 557.7071	 135.909	 0.0	 0.0	 34	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3402	 1	 0.0	 0.0	 0.0	 0.0	 34	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3403	 1	 515.9687	 73.583	 0.0	 0.0	 34	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3404	 1	 438.461	 62.075	 0.0	 0.0	 34	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3405	 1	 448.8976	 63.723	 0.0	 0.0	 34	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3432	 2	 0.0	 0.0	 0.0	 0.0	 34	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3433	 2	 0.0	 0.0	 0.0	 0.0	 34	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3501	 1	 625.0164	 89.015	 0.0	 0.0	 35	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3531	 2	 0.0	 0.0	 0.0	 0.0	 35	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3601	 1	 104.8564	 14.844	 0.0	 0.0	 36	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	3631	 2	 0.0	 0.0	 0.0	 0.0	 36	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3701	 1	 317.0506	 15.847	 0.0	 0.0	 37	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	3731	 2	 0.0	 0.0	 0.0	 0.0	 37	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3801	 1	 191.2229	 47.411	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3802	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3803	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3804	 1	 223.6404	 55.318	 0.0	 0.0	 38	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3805	 1	 499.3888	 163.106	 0.0	 0.0	 38	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3806	 1	 289.5858	 41.366	 0.0	 0.0	 38	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3831	 2	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3835	 2	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3836	 2	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3891	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3892	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3893	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3894	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3895	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3896	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3897	 1	 0.0	 0.0	 0.0	 0.0	 38	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3901	 1	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3902	 1	 152.9913	 38.248	 0.0	 0.0	 39	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3903	 1	 213.2478	 30.269	 0.0	 0.0	 39	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3904	 1	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3905	 1	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3906	 1	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	3907	 1	 461.3573	 63.071	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3908	 1	 200.2788	 24.716	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3909	 1	 170.957	 39.785	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3910	 1	 241.8392	 34.44	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3911	 1	 233.1345	 47.114	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3912	 1	 174.5029	 -0.634	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3913	 1	 329.5484	 43.435	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3914	 1	 227.7536	 52.549	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3915	 1	 254.4589	 53.402	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3916	 1	 155.0024	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3917	 1	 238.1882	 43.995	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3918	 1	 319.2809	 75.464	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3919	 1	 184.5093	 24.094	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3920	 1	 172.5018	 23.677	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3921	 1	 150.8902	 34.821	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3922	 1	 253.4454	 31.919	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3923	 1	 399.0618	 67.021	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3924	 1	 332.4879	 47.165	 0.0	 0.0	 39	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	3925	 1	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	3926	 1	 267.3529	 16.668	 0.0	 0.0	 39	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	3931	 2	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3932	 2	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	3933	 3	 0.0	 0.0	 0.0	 0.0	 39	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4001	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4002	 1	 168.6841	 21.998	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4003	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4004	 1	 270.4505	 35.297	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4005	 1	 480.1144	 157.418	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4006	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4007	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4008	 1	 285.1446	 37.198	 0.0	 0.0	 40	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	4009	 1	 2208.7429	 431.395	 0.0	 0.0	 40	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	4010	 1	 3133.6101	 0.0	 0.0	 0.0	 90	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	4031	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4035	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4039	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4090	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4091	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4092	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4093	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4094	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4095	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4096	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4097	 1	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4101	 1	 995.0275	 129.784	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4102	 1	 480.649	 68.664	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4103	 1	 11.6269	 1.509	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4104	 1	 2527.7724	 329.74	 0.0	 0.0	 40	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	4131	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4132	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4201	 1	 5762.6589	 461.013	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4202	 1	 4558.2389	 594.626	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4203	 1	 4379.6262	 571.331	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4204	 1	 1014.5202	 132.34	 0.0	 0.0	 40	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	4231	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	4232	 2	 0.0	 0.0	 0.0	 0.0	 40	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	5001	 1	 7574.0522	 1721.375	 0.0	 0.0	 50	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	5002	 1	 9003.9839	 1174.359	 0.0	 0.0	 50	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	5003	 1	 615.2178	 80.253	 0.0	 0.0	 50	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	5004	 1	 0.0	 0.0	 0.0	 0.0	 50	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	5031	 2	 0.0	 0.0	 0.0	 0.0	 50	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	5032	 2	 0.0	 0.0	 0.0	 0.0	 50	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6101	 1	 0.0	 0.0	 0.0	 0.0	 61	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	6102	 1	 1053.1441	 -345.277	 0.0	 0.0	 61	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6103	 1	 391.888	 51.111	 0.0	 0.0	 61	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6104	 1	 1694.958	 221.085	 0.0	 0.0	 61	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6132	 2	 0.0	 0.0	 0.0	 0.0	 61	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6201	 1	 205.82	 26.857	 0.0	 0.0	 60	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	6202	 1	 88.7215	 13.528	 0.0	 0.0	 60	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	6203	 1	 1112.3464	 145.093	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6204	 1	 1199.2957	 156.461	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6205	 1	 489.2825	 86.344	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6231	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6235	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6301	 1	 516.3779	 67.362	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6302	 1	 591.8185	 77.219	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6303	 1	 746.6019	 97.404	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6304	 1	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6305	 1	 60.2324	 19.752	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6333	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6335	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6401	 1	 1672.3727	 218.148	 0.0	 0.0	 64	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6402	 1	 272.5124	 35.566	 0.0	 0.0	 64	    1.00000	    0.00000	 115.0	 1	    1.10000	    0.90000;
	6403	 1	 2.1985	 0.272	 0.0	 0.0	 64	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6404	 1	 28.98	 3.775	 0.0	 0.0	 64	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6433	 2	 0.0	 0.0	 0.0	 0.0	 64	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	6501	 1	 195.5463	 64.128	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6502	 1	 1555.5773	 277.672	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6503	 1	 441.1533	 144.603	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6504	 1	 296.9666	 38.73	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6505	 1	 6.7947	 2.231	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6506	 1	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6507	 1	 540.775	 -61.354	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6508	 1	 131.8343	 43.208	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6509	 1	 8.5932	 2.817	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	6510	 1	 1946.0167	 -103.877	 0.0	 0.0	 60	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	6533	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	7001	 1	 7453.9144	 972.35	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	7002	 1	 2554.8345	 -138.069	 0.0	 0.0	 60	    1.00000	    0.00000	 345.0	 1	    1.10000	    0.90000;
	7031	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	7032	 2	 0.0	 0.0	 0.0	 0.0	 60	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	8001	 1	 0.0	 0.0	 0.0	 0.0	 80	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	8002	 1	 0.0	 0.0	 0.0	 0.0	 80	    1.00000	    0.00000	 500.0	 1	    1.10000	    0.90000;
	8003	 1	 652.6717	 85.141	 0.0	 0.0	 80	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	8004	 1	 3787.8915	 494.11	 0.0	 0.0	 80	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	8005	 1	 1321.2379	 172.37	 0.0	 0.0	 80	    1.00000	    0.00000	 230.0	 1	    1.10000	    0.90000;
	8033	 2	 0.0	 0.0	 0.0	 0.0	 80	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
	8034	 2	 0.0	 0.0	 0.0	 0.0	 80	    1.00000	    0.00000	 20.0	 1	    1.10000	    0.90000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin
mpc.gen = [
	1032	 1030.0	 0.0	 1030.0	 -1030.0	 1.0	 100.0	 1	 2060.0	 0.0; % COW
	1032	 357.0	 0.0	 357.0	 -357.0	 1.0	 100.0	 1	 714.0	 0.0; % COW
	1034	 2293.5	 0.0	 2294.0	 -2294.0	 1.0	 100.0	 1	 4587.0	 0.0; % NG
	1034	 917.5	 0.0	 918.0	 -918.0	 1.0	 100.0	 1	 1835.0	 0.0; % NUC
	1034	 700.0	 0.0	 700.0	 -700.0	 1.0	 100.0	 1	 1400.0	 0.0; % NUC
	1131	 307.5	 0.0	 308.0	 -308.0	 1.0	 100.0	 1	 615.0	 0.0; % COW
	1131	 1915.4	 0.0	 1916.0	 -1916.0	 1.0	 100.0	 1	 3830.8	 0.0; % COW
	1131	 120.0	 0.0	 120.0	 -120.0	 1.0	 100.0	 1	 240.0	 0.0; % NG
	1232	 1207.5	 0.0	 1208.0	 -1208.0	 1.0	 100.0	 1	 2415.0	 0.0; % COW
	1232	 628.0	 0.0	 628.0	 -628.0	 1.0	 100.0	 1	 1256.0	 0.0; % COW
	1331	 841.0	 0.0	 841.0	 -841.0	 1.0	 100.0	 1	 1682.0	 0.0; % COW
	1331	 1219.0	 0.0	 1219.0	 -1219.0	 1.0	 100.0	 1	 2438.0	 0.0; % COW
	1333	 302.5	 0.0	 303.0	 -303.0	 1.0	 100.0	 1	 605.0	 0.0; % COW
	1333	 2745.5	 0.0	 2746.0	 -2746.0	 1.0	 100.0	 1	 5491.0	 0.0; % NUC
	1333	 37.5	 0.0	 38.0	 -38.0	 1.0	 100.0	 1	 75.0	 0.0; % PEL
	1431	 3559.35	 0.0	 3559.0	 -3559.0	 1.0	 100.0	 1	 7118.7	 0.0; % COW
	1431	 2056.5	 0.0	 2057.0	 -2057.0	 1.0	 100.0	 1	 4113.0	 0.0; % COW
	1431	 15.0	 0.0	 15.0	 -15.0	 1.0	 100.0	 1	 30.0	 0.0; % PEL
	2030	 1070.0	 0.0	 1070.0	 -1070.0	 1.0	 100.0	 1	 2140.0	 0.0; % NUC
	2030	 349.5	 0.0	 350.0	 -350.0	 1.0	 100.0	 1	 699.0	 0.0; % COW
	2130	 200.0	 0.0	 200.0	 -200.0	 1.0	 100.0	 1	 400.0	 0.0; % COW
	2130	 253.5	 0.0	 254.0	 -254.0	 1.0	 100.0	 1	 507.0	 0.0; % NG
	2130	 250.0	 0.0	 250.0	 -250.0	 1.0	 100.0	 1	 500.0	 0.0; % NG
	2130	 86.0	 0.0	 86.0	 -86.0	 1.0	 100.0	 1	 172.0	 0.0; % NG
	2233	 353.0	 93.0	 304.0	 -118.0	 1.0	 100.0	 1	 706.0	 0.0; % COW
	2233	 626.5	 215.0	 611.0	 -181.0	 1.0	 100.0	 1	 1253.0	 0.0; % COW
	2233	 250.0	 25.5	 206.0	 -155.0	 1.0	 100.0	 1	 500.0	 0.0; % NG
	2332	 559.0	 113.0	 590.0	 -364.0	 1.0	 100.0	 1	 1118.0	 0.0; % COW
	2438	 781.5	 137.0	 728.0	 -454.0	 1.0	 100.0	 1	 1563.0	 0.0; % COW
	2438	 1859.0	 367.0	 1902.0	 -1168.0	 1.0	 100.0	 1	 3718.0	 0.0; % PEL
	2438	 1401.5	 624.0	 2301.0	 -1053.0	 1.0	 100.0	 1	 2803.0	 0.0; % COW
	2438	 670.0	 68.0	 659.0	 -523.0	 1.0	 100.0	 1	 1340.0	 0.0; % COW
	2438	 473.0	 119.5	 436.0	 -197.0	 1.0	 100.0	 1	 946.0	 0.0; % COW
	2438	 636.5	 4.0	 561.0	 -553.0	 1.0	 100.0	 1	 1273.0	 0.0; % COW
	2438	 1983.5	 380.0	 1910.0	 -1150.0	 1.0	 100.0	 1	 3967.0	 0.0; % COW
	2438	 -503.0	 0.25	 0.5	 0.0	 1.0	 100.0	 1	 0.0	 -1006.0; % SYNC
	2533	 1116.0	 140.0	 1100.0	 -820.0	 1.0	 100.0	 1	 2232.0	 0.0; % COW
	2630	 1346.0	 0.0	 1346.0	 -1346.0	 1.0	 100.0	 1	 2692.0	 0.0; % COW
	2631	 159.0	 0.0	 159.0	 -159.0	 1.0	 100.0	 1	 318.0	 0.0; % COW
	2634	 950.0	 0.0	 950.0	 -950.0	 1.0	 100.0	 1	 1900.0	 0.0; % NG
	2637	 55.0	 0.0	 110.0	 -110.0	 1.0	 100.0	 1	 110.0	 0.0; % NG
	2638	 0.0	 0.0	 100.0	 -100.0	 1.0	 100.0	 1	 1272.0	 -1272.0; % COW
	3133	 21.0	 6.5	 42.0	 -29.0	 1.0	 100.0	 1	 42.0	 0.0; % NG
	3133	 0.05	 0.0	 500.0	 -500.0	 1.0	 100.0	 1	 0.1	 0.0; % PEL
	3135	 184.5	 19.0	 239.0	 -201.0	 1.0	 100.0	 1	 369.0	 0.0; % NG
	3135	 13.0	 7.5	 100.0	 -85.0	 1.0	 100.0	 1	 26.0	 0.0; % PEL
	3234	 60.5	 13.0	 101.0	 -75.0	 1.0	 100.0	 1	 121.0	 0.0; % NG
	3234	 1314.0	 5.0	 1244.0	 -1234.0	 1.0	 100.0	 1	 2628.0	 0.0; % COW
	3234	 353.5	 85.0	 382.0	 -212.0	 1.0	 100.0	 1	 707.0	 0.0; % COW
	3234	 345.0	 10.0	 75.0	 -55.0	 1.0	 100.0	 1	 690.0	 0.0; % NG
	3333	 345.0	 86.0	 398.0	 -226.0	 1.0	 100.0	 1	 690.0	 0.0; % COW
	3333	 106.5	 29.5	 202.0	 -143.0	 1.0	 100.0	 1	 213.0	 0.0; % NG
	3432	 147.0	 102.0	 510.0	 -306.0	 1.0	 100.0	 1	 1218.0	 -924.0; % COW
	3433	 314.0	 28.0	 231.0	 -175.0	 1.0	 100.0	 1	 628.0	 0.0; % COW
	3433	 1008.0	 188.5	 939.0	 -562.0	 1.0	 100.0	 1	 2016.0	 0.0; % COW
	3531	 434.0	 202.5	 1004.0	 -599.0	 1.0	 100.0	 1	 868.0	 0.0; % COW
	3531	 162.5	 36.0	 253.0	 -181.0	 1.0	 100.0	 1	 325.0	 0.0; % NG
	3531	 15.0	 1.5	 13.0	 -10.0	 1.0	 100.0	 1	 30.0	 0.0; % PEL
	3631	 26.5	 3.0	 20.0	 -14.0	 1.0	 100.0	 1	 53.0	 0.0; % NG
	3631	 71.5	 20.0	 74.0	 -34.0	 1.0	 100.0	 1	 143.0	 0.0; % NG
	3731	 127.5	 39.5	 200.0	 -121.0	 1.0	 100.0	 1	 255.0	 0.0; % NG
	3831	 1133.5	 97.5	 1175.0	 -980.0	 1.0	 100.0	 1	 2267.0	 0.0; % COW
	3835	 690.5	 91.5	 662.0	 -479.0	 1.0	 100.0	 1	 1381.0	 0.0; % COW
	3835	 -255.0	 0.25	 0.5	 0.0	 1.0	 100.0	 1	 0.0	 -510.0; % SYNC
	3836	 510.5	 62.0	 476.0	 -352.0	 1.0	 100.0	 1	 1021.0	 0.0; % COW
	3931	 157.0	 18.0	 151.0	 -115.0	 1.0	 100.0	 1	 314.0	 0.0; % NG
	3931	 1848.0	 169.0	 1284.0	 -946.0	 1.0	 100.0	 1	 3696.0	 0.0; % COW
	3932	 739.0	 325.0	 1150.0	 -500.0	 1.0	 100.0	 1	 1478.0	 0.0; % COW
	3933	 295.0	 140.5	 363.0	 -82.0	 1.0	 100.0	 1	 590.0	 0.0; % COW
	3933	 95.5	 11.0	 77.0	 -55.0	 1.0	 100.0	 1	 191.0	 0.0; % NG
	3933	 657.0	 96.5	 500.0	 -307.0	 1.0	 100.0	 1	 1314.0	 0.0; % NG
	3933	 1752.5	 107.5	 1256.0	 -1041.0	 1.0	 100.0	 1	 3505.0	 0.0; % COW
	3933	 146.5	 1.0	 13.0	 -11.0	 1.0	 100.0	 1	 293.0	 0.0; % NG
	3933	 -224.5	 0.25	 0.5	 0.0	 1.0	 100.0	 1	 0.0	 -449.0; % NUC
	4039	 102.0	 0.0	 102.0	 -102.0	 1.0	 100.0	 1	 204.0	 0.0; % COW
	4039	 1459.0	 0.0	 1459.0	 -1459.0	 1.0	 100.0	 1	 2918.0	 0.0; % COW
	4039	 187.5	 0.0	 188.0	 -188.0	 1.0	 100.0	 1	 375.0	 0.0; % NG
	4031	 501.5	 0.0	 502.0	 -502.0	 1.0	 100.0	 1	 1003.0	 0.0; % COW
	4031	 489.0	 0.0	 489.0	 -489.0	 1.0	 100.0	 1	 978.0	 0.0; % NUC
	4031	 37.5	 0.0	 38.0	 -38.0	 1.0	 100.0	 1	 75.0	 0.0; % NG
	4031	 120.0	 0.0	 120.0	 -120.0	 1.0	 100.0	 1	 240.0	 0.0; % NG
	4035	 255.0	 0.0	 255.0	 -255.0	 1.0	 100.0	 1	 510.0	 0.0; % NG
	4035	 306.5	 0.0	 307.0	 -307.0	 1.0	 100.0	 1	 613.0	 0.0; % COW
	4035	 1835.5	 0.0	 1836.0	 -1836.0	 1.0	 100.0	 1	 3671.0	 0.0; % COW
	4035	 488.0	 0.0	 488.0	 -488.0	 1.0	 100.0	 1	 976.0	 0.0; % NG
	4131	 6481.5	 0.0	 6482.0	 -6482.0	 1.0	 100.0	 1	 12963.0	 0.0; % COW
	4131	 120.0	 0.0	 120.0	 -120.0	 1.0	 100.0	 1	 240.0	 0.0; % NG
	4132	 1472.5	 0.0	 1473.0	 -1473.0	 1.0	 100.0	 1	 2945.0	 0.0; % COW
	4132	 2846.5	 0.0	 2847.0	 -2847.0	 1.0	 100.0	 1	 5693.0	 0.0; % COW
	4132	 580.0	 0.0	 580.0	 -580.0	 1.0	 100.0	 1	 1160.0	 0.0; % COW
	4132	 230.5	 0.0	 231.0	 -231.0	 1.0	 100.0	 1	 461.0	 0.0; % NG
	4132	 87.5	 0.0	 88.0	 -88.0	 1.0	 100.0	 1	 175.0	 0.0; % NG
	4231	 728.0	 0.0	 728.0	 -728.0	 1.0	 100.0	 1	 1456.0	 0.0; % COW
	4231	 658.5	 0.0	 659.0	 -659.0	 1.0	 100.0	 1	 1317.0	 0.0; % NG
	4231	 1807.5	 0.0	 1808.0	 -1808.0	 1.0	 100.0	 1	 3615.0	 0.0; % COW
	4231	 23.5	 0.0	 24.0	 -24.0	 1.0	 100.0	 1	 47.0	 0.0; % NG
	4232	 592.0	 0.0	 592.0	 -592.0	 1.0	 100.0	 1	 1184.0	 0.0; % COW
	4232	 286.5	 0.0	 287.0	 -287.0	 1.0	 100.0	 1	 573.0	 0.0; % COW
	4232	 107.5	 0.0	 108.0	 -108.0	 1.0	 100.0	 1	 215.0	 0.0; % NG
	5031	 605.0	 0.0	 605.0	 -605.0	 1.0	 100.0	 1	 1210.0	 0.0; % NG
	5031	 4399.4	 0.0	 4399.0	 -4399.0	 1.0	 100.0	 1	 8798.8	 0.0; % COW
	5032	 2977.0	 0.0	 2977.0	 -2977.0	 1.0	 100.0	 1	 5954.0	 0.0; % COW
	5032	 2200.0	 0.0	 2200.0	 -2200.0	 1.0	 100.0	 1	 4400.0	 0.0; % COW
	5032	 2205.1	 0.0	 2205.0	 -2205.0	 1.0	 100.0	 1	 4410.2	 0.0; % COW
	5032	 54.0	 0.0	 54.0	 -54.0	 1.0	 100.0	 1	 108.0	 0.0; % NG
	5032	 270.5	 0.0	 271.0	 -271.0	 1.0	 100.0	 1	 541.0	 0.0; % COW
	6132	 7.5	 0.0	 8.0	 -8.0	 1.0	 100.0	 1	 15.0	 0.0; % NG
	6132	 146.5	 0.0	 147.0	 -147.0	 1.0	 100.0	 1	 293.0	 0.0; % NG
	6132	 1072.0	 0.0	 1072.0	 -1072.0	 1.0	 100.0	 1	 2144.0	 0.0; % NG
	6132	 17.5	 0.0	 18.0	 -18.0	 1.0	 100.0	 1	 35.0	 0.0; % PEL
	6132	 118.0	 0.0	 118.0	 -118.0	 1.0	 100.0	 1	 236.0	 0.0; % NG
	6231	 1255.5	 0.0	 1256.0	 -1256.0	 1.0	 100.0	 1	 2511.0	 0.0; % COW
	6231	 70.0	 0.0	 70.0	 -70.0	 1.0	 100.0	 1	 140.0	 0.0; % NG
	6235	 63.5	 0.0	 64.0	 -64.0	 1.0	 100.0	 1	 127.0	 0.0; % COW
	6235	 346.5	 0.0	 347.0	 -347.0	 1.0	 100.0	 1	 693.0	 0.0; % COW
	6235	 95.0	 0.0	 95.0	 -95.0	 1.0	 100.0	 1	 190.0	 0.0; % NG
	6333	 1671.0	 0.0	 1671.0	 -1671.0	 1.0	 100.0	 1	 3342.0	 0.0; % COW
	6333	 124.0	 0.0	 124.0	 -124.0	 1.0	 100.0	 1	 248.0	 0.0; % COW
	6335	 967.5	 0.0	 968.0	 -968.0	 1.0	 100.0	 1	 1935.0	 0.0; % COW
	6335	 329.5	 0.0	 330.0	 -330.0	 1.0	 100.0	 1	 659.0	 0.0; % COW
	6335	 406.0	 0.0	 406.0	 -406.0	 1.0	 100.0	 1	 812.0	 0.0; % COW
	6433	 282.5	 0.0	 283.0	 -283.0	 1.0	 100.0	 1	 565.0	 0.0; % COW
	6433	 59.0	 0.0	 59.0	 -59.0	 1.0	 100.0	 1	 118.0	 0.0; % NG
	6433	 536.0	 0.0	 536.0	 -536.0	 1.0	 100.0	 1	 1072.0	 0.0; % PEL
	6433	 11.5	 0.0	 12.0	 -12.0	 1.0	 100.0	 1	 23.0	 0.0; % COW
	6433	 25.0	 0.0	 25.0	 -25.0	 1.0	 100.0	 1	 50.0	 0.0; % NG
	6533	 1923.5	 0.0	 1924.0	 -1924.0	 1.0	 100.0	 1	 3847.0	 0.0; % COW
	6533	 18.5	 0.0	 19.0	 -19.0	 1.0	 100.0	 1	 37.0	 0.0; % NG
	6533	 880.0	 0.0	 880.0	 -880.0	 1.0	 100.0	 1	 1760.0	 0.0; % COW
	6533	 19.5	 0.0	 20.0	 -20.0	 1.0	 100.0	 1	 39.0	 0.0; % NG
	6533	 30.5	 0.0	 31.0	 -31.0	 1.0	 100.0	 1	 61.0	 0.0; % NG
	7031	 1418.5	 0.0	 1419.0	 -1419.0	 1.0	 100.0	 1	 2837.0	 0.0; % COW
	7031	 2092.0	 0.0	 2092.0	 -2092.0	 1.0	 100.0	 1	 4184.0	 0.0; % NUC
	7031	 0.0	 0.0	 167.0	 -167.0	 1.0	 100.0	 1	 333.0	 -333.0; % COW
	7031	 298.5	 0.0	 299.0	 -299.0	 1.0	 100.0	 1	 597.0	 0.0; % COW
	7031	 0.05	 0.0	 1000.0	 -1000.0	 1.0	 100.0	 1	 0.1	 0.0; % NG
	7032	 826.0	 0.0	 826.0	 -826.0	 1.0	 100.0	 1	 1652.0	 0.0; % NG
	7032	 489.0	 0.0	 489.0	 -489.0	 1.0	 100.0	 1	 978.0	 0.0; % COW
	7032	 345.5	 0.0	 346.0	 -346.0	 1.0	 100.0	 1	 691.0	 0.0; % COW
	7032	 0.0	 0.0	 23.0	 -23.0	 1.0	 100.0	 1	 200.0	 -200.0; % COW
	8033	 786.0	 0.0	 786.0	 -786.0	 1.0	 100.0	 1	 1572.0	 0.0; % PEL
	8034	 1280.0	 0.0	 1280.0	 -1280.0	 1.0	 100.0	 1	 2560.0	 0.0; % COW
	8034	 344.0	 0.0	 344.0	 -344.0	 1.0	 100.0	 1	 688.0	 0.0; % COW
];

%% generator cost data
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	 0.0	 0.0	 3	   0.000000	  23.552530	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  17.525740	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  50.253548	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   7.784540	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	   7.164105	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  32.436958	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  31.156469	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  22.737499	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  19.952184	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  31.242137	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  24.807784	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  28.383968	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  34.755431	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   7.698014	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	 105.404954	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  40.082606	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  25.630090	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	 103.348768	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	   6.769987	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  11.508310	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  37.856831	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  36.108116	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  49.860247	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  19.863282	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  28.216009	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  25.247027	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  39.435718	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  22.418634	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  25.395707	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	 112.919983	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  29.447096	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  27.360187	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  43.054554	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  21.954880	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  21.935047	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  32.738635	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  24.642891	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  17.386501	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  25.623984	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  36.008261	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  33.638878	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  60.295192	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 115.784252	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  19.747758	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 139.406671	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  40.626840	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  33.390411	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   9.116809	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  22.599236	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  36.557379	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  29.600547	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  23.127115	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  19.029025	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  26.628665	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  23.069170	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  19.755158	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 111.468783	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  37.364330	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  29.305594	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  43.487946	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  18.009089	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  27.186796	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  39.855613	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  52.291471	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  32.821502	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  22.434142	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  35.060251	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  58.640953	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  40.111583	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  10.724076	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  29.604602	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   7.148098	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  14.120280	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  32.489744	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  32.920521	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  28.879314	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   7.795262	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  14.495790	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  33.529629	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  14.148633	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  22.360086	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  23.153973	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  32.076694	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  31.799668	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  48.375219	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  20.048511	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  13.581555	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  31.584790	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  45.195796	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  39.759127	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  14.530332	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  15.136833	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  42.828324	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  14.389570	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  38.966466	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  15.486578	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  41.492611	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  28.466295	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  27.255650	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  24.837547	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  28.019241	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  11.786936	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  29.985739	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  28.815976	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  37.698432	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  48.831293	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  32.211888	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 105.104656	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  37.879273	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  33.634935	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  30.107834	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  37.793235	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  31.239418	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  28.663274	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  24.405861	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  38.016670	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  32.247846	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  24.388960	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  11.816160	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  29.852868	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  28.252173	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 102.698216	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  23.707527	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  26.935133	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  19.266401	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  27.889540	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  20.456741	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  26.092954	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  37.210311	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  27.338561	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   7.157129	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  38.956112	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  40.642352	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  18.781578	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  43.330859	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  31.905335	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   9.594434	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  25.215165	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	 114.365663	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  24.149150	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  24.948779	   0.000000; % COW
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	1001	 1201	 0.00177	 0.03169	 3.3446	 996	 996	 996	 0.0	 0.0	 1	 -30.0	 30.0;
	1001	 1202	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	1002	 1004	 0.0005	 0.0053	 0.0882	 5934	 5934	 5934	 0.0	 0.0	 1	 -30.0	 30.0;
	1002	 1102	 0.00179	 0.01988	 2.576	 1583	 1583	 1583	 0.0	 0.0	 1	 -30.0	 30.0;
	1002	 1102	 0.00179	 0.01988	 2.576	 1583	 1583	 1583	 0.0	 0.0	 1	 -30.0	 30.0;
	1002	 6506	 0.0048	 0.0436	 0.7078	 721	 721	 721	 0.0	 0.0	 1	 -30.0	 30.0;
	1004	 7001	 0.03903	 0.27403	 2.0	 115	 115	 115	 0.0	 0.0	 1	 -30.0	 30.0;
	1004	 7002	 0.00977	 0.11	 2.0	 287	 287	 287	 0.0	 0.0	 1	 -30.0	 30.0;
	1101	 1401	 0.0028	 0.0211	 1.0194	 1485	 1485	 1485	 0.0	 0.0	 1	 -30.0	 30.0;
	1101	 1401	 0.0028	 0.0211	 1.0194	 1485	 1485	 1485	 0.0	 0.0	 1	 -30.0	 30.0;
	1201	 1202	 0.00077	 0.00536	 1.39842	 5834	 5834	 5834	 0.0	 0.0	 1	 -30.0	 30.0;
	1201	 1402	 0.00179	 0.02592	 3.3922	 1216	 1216	 1216	 0.0	 0.0	 1	 -30.0	 30.0;
	1201	 2901	 0.00207	 0.01369	 3.9516	 2282	 2282	 2282	 0.0	 0.0	 1	 -30.0	 30.0;
	1202	 1302	 0.0028	 0.0211	 1.0194	 1485	 1485	 1485	 0.0	 0.0	 1	 -30.0	 30.0;
	1202	 1402	 0.00241	 0.03489	 4.8656	 904	 904	 904	 0.0	 0.0	 1	 -30.0	 30.0;
	1301	 1302	 0.0028	 0.0211	 1.0194	 1485	 1485	 1485	 0.0	 0.0	 1	 -30.0	 30.0;
	1301	 1402	 0.0028	 0.0211	 1.0194	 1485	 1485	 1485	 0.0	 0.0	 1	 -30.0	 30.0;
	1301	 1402	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	1301	 2603	 0.00179	 0.02524	 0.53546	 1249	 1249	 1249	 0.0	 0.0	 1	 -30.0	 30.0;
	1301	 2901	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	1303	 6507	 0.00811	 0.1369	 1.1156	 231	 231	 231	 0.0	 0.0	 1	 -30.0	 30.0;
	1401	 1402	 0.0004	 0.0096	 0.9038	 3288	 3288	 3288	 0.0	 0.0	 1	 -30.0	 30.0;
	1401	 1402	 0.0004	 0.0096	 0.9038	 3288	 3288	 3288	 0.0	 0.0	 1	 -30.0	 30.0;
	1401	 2301	 0.00259	 0.02967	 2.153	 1061	 1061	 1061	 0.0	 0.0	 1	 -30.0	 30.0;
	1401	 2400	 0.00259	 0.02967	 2.153	 1061	 1061	 1061	 0.0	 0.0	 1	 -30.0	 30.0;
	1403	 2100	 0.00845	 0.07034	 0.15954	 446	 446	 446	 0.0	 0.0	 1	 -30.0	 30.0;
	2000	 2202	 0.00138	 0.05399	 0.15252	 585	 585	 585	 0.0	 0.0	 1	 -30.0	 30.0;
	2000	 2302	 0.00138	 0.05399	 0.15252	 585	 585	 585	 0.0	 0.0	 1	 -30.0	 30.0;
	2100	 2302	 0.00845	 0.07034	 0.15954	 446	 446	 446	 0.0	 0.0	 1	 -30.0	 30.0;
	2201	 2301	 0.00179	 0.02524	 2.153	 1249	 1249	 1249	 0.0	 0.0	 1	 -30.0	 30.0;
	2202	 2203	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2202	 2203	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2202	 2503	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2203	 2503	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2203	 2503	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2400	 2403	 0.00042	 0.00905	 0.66794	 3487	 3487	 3487	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2402	 0.00028	 0.00753	 0.51736	 4192	 4192	 4192	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2402	 0.00035	 0.0075	 0.5536	 4208	 4208	 4208	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2404	 0.00044	 0.01125	 0.8292	 2806	 2806	 2806	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2404	 0.00044	 0.01125	 0.8292	 2806	 2806	 2806	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2501	 0.0006	 0.0128	 0.9462	 2466	 2466	 2466	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2603	 0.0002	 0.0041	 0.2962	 7696	 7696	 7696	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2901	 0.00193	 0.02779	 4.6712	 1134	 1134	 1134	 0.0	 0.0	 1	 -30.0	 30.0;
	2401	 2902	 0.0019	 0.031	 4.1402	 1018	 1018	 1018	 0.0	 0.0	 1	 -30.0	 30.0;
	2402	 2501	 0.00021	 0.00457	 0.32336	 6905	 6905	 6905	 0.0	 0.0	 1	 -30.0	 30.0;
	2403	 2501	 0.0004	 0.0093	 0.6856	 3394	 3394	 3394	 0.0	 0.0	 1	 -30.0	 30.0;
	2404	 3893	 0.0	 -0.00935	 0.0	 3379	 3379	 3379	 0.0	 0.0	 1	 -30.0	 30.0;
	2404	 3895	 0.0	 -0.00935	 0.0	 3379	 3379	 3379	 0.0	 0.0	 1	 -30.0	 30.0;
	2404	 3897	 0.0	 -0.0084	 0.0	 3761	 3761	 3761	 0.0	 0.0	 1	 -30.0	 30.0;
	2405	 2406	 0.0014	 0.0264	 0.102	 1195	 1195	 1195	 0.0	 0.0	 1	 -30.0	 30.0;
	2405	 2410	 0.00065	 0.01187	 0.04672	 2658	 2658	 2658	 0.0	 0.0	 1	 -30.0	 30.0;
	2405	 2410	 0.00065	 0.01187	 0.04672	 2658	 2658	 2658	 0.0	 0.0	 1	 -30.0	 30.0;
	2406	 2408	 0.0019	 0.0258	 0.0984	 1222	 1222	 1222	 0.0	 0.0	 1	 -30.0	 30.0;
	2406	 2410	 0.00845	 0.07034	 0.15954	 446	 446	 446	 0.0	 0.0	 1	 -30.0	 30.0;
	2407	 2408	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	2408	 2409	 0.00138	 0.05399	 0.15252	 585	 585	 585	 0.0	 0.0	 1	 -30.0	 30.0;
	2408	 2409	 0.00138	 0.05399	 0.15252	 585	 585	 585	 0.0	 0.0	 1	 -30.0	 30.0;
	2408	 2411	 0.0032	 0.0395	 0.144	 798	 798	 798	 0.0	 0.0	 1	 -30.0	 30.0;
	2408	 2502	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2409	 2502	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2409	 2503	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2410	 2411	 0.00285	 0.03649	 0.12656	 864	 864	 864	 0.0	 0.0	 1	 -30.0	 30.0;
	2410	 2411	 0.00138	 0.03399	 0.11252	 929	 929	 929	 0.0	 0.0	 1	 -30.0	 30.0;
	2502	 2503	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2502	 2503	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	2901	 2902	 0.00056	 0.01415	 1.0429	 2231	 2231	 2231	 0.0	 0.0	 1	 -30.0	 30.0;
	2600	 2602	 0.00082	 0.01668	 1.18802	 1892	 1892	 1892	 0.0	 0.0	 1	 -30.0	 30.0;
	2600	 2603	 0.0	 0.00159	 0.12002	 19867	 19867	 19867	 0.0	 0.0	 1	 -30.0	 30.0;
	2600	 2603	 0.0	 0.00159	 0.12002	 19867	 19867	 19867	 0.0	 0.0	 1	 -30.0	 30.0;
	2600	 2601	 0.00074	 0.01861	 1.40264	 1696	 1696	 1696	 0.0	 0.0	 1	 -30.0	 30.0;
	2601	 2603	 0.00083	 0.01884	 1.66668	 1675	 1675	 1675	 0.0	 0.0	 1	 -30.0	 30.0;
	2603	 2901	 0.00179	 0.02524	 0.53546	 1249	 1249	 1249	 0.0	 0.0	 1	 -30.0	 30.0;
	2604	 6404	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	2604	 6504	 0.0018	 0.0245	 0.4392	 1286	 1286	 1286	 0.0	 0.0	 1	 -30.0	 30.0;
	2604	 6504	 0.0018	 0.0245	 0.4392	 1286	 1286	 1286	 0.0	 0.0	 1	 -30.0	 30.0;
	2605	 2607	 0.0107	 0.07905	 0.3667	 396	 396	 396	 0.0	 0.0	 1	 -30.0	 30.0;
	2606	 2607	 0.0107	 0.07905	 0.3667	 396	 396	 396	 0.0	 0.0	 1	 -30.0	 30.0;
	2608	 2611	 0.00221	 0.03346	 0.07338	 942	 942	 942	 0.0	 0.0	 1	 -30.0	 30.0;
	2608	 2612	 0.0029	 0.038	 0.0824	 829	 829	 829	 0.0	 0.0	 1	 -30.0	 30.0;
	2608	 2618	 0.00309	 0.04677	 0.1008	 674	 674	 674	 0.0	 0.0	 1	 -30.0	 30.0;
	2608	 2619	 0.00226	 0.03422	 0.07506	 922	 922	 922	 0.0	 0.0	 1	 -30.0	 30.0;
	2609	 2615	 0.00047	 0.00723	 0.01624	 4360	 4360	 4360	 0.0	 0.0	 1	 -30.0	 30.0;
	2609	 2617	 0.00035	 0.00536	 0.01204	 5881	 5881	 5881	 0.0	 0.0	 1	 -30.0	 30.0;
	2610	 2613	 0.0022	 0.03422	 0.07716	 922	 922	 922	 0.0	 0.0	 1	 -30.0	 30.0;
	2610	 2613	 0.00238	 0.03669	 0.08284	 860	 860	 860	 0.0	 0.0	 1	 -30.0	 30.0;
	2610	 2616	 0.00201	 0.03074	 0.06886	 1026	 1026	 1026	 0.0	 0.0	 1	 -30.0	 30.0;
	2610	 2617	 0.00281	 0.04296	 0.09648	 734	 734	 734	 0.0	 0.0	 1	 -30.0	 30.0;
	2611	 2612	 0.00029	 0.00434	 0.0095	 7262	 7262	 7262	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2615	 0.00229	 0.01583	 0.0306	 1975	 1975	 1975	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2615	 0.00229	 0.01583	 0.0306	 1975	 1975	 1975	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2618	 0.00141	 0.00967	 0.0194	 3233	 3233	 3233	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2618	 0.00141	 0.00967	 0.0194	 3233	 3233	 3233	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2618	 0.00161	 0.00971	 0.01928	 3210	 3210	 3210	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2618	 0.00161	 0.00971	 0.01928	 3210	 3210	 3210	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2619	 0.00027	 0.00393	 0.00918	 8019	 8019	 8019	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2619	 0.00027	 0.00393	 0.00918	 8019	 8019	 8019	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2619	 0.00027	 0.00393	 0.00918	 8019	 8019	 8019	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2620	 0.00138	 0.01116	 0.0247	 2810	 2810	 2810	 0.0	 0.0	 1	 -30.0	 30.0;
	2612	 2620	 0.00138	 0.01116	 0.0247	 2810	 2810	 2810	 0.0	 0.0	 1	 -30.0	 30.0;
	2613	 2616	 0.00037	 0.00366	 0.0083	 8587	 8587	 8587	 0.0	 0.0	 1	 -30.0	 30.0;
	2613	 2617	 0.00055	 0.00586	 0.01246	 5367	 5367	 5367	 0.0	 0.0	 1	 -30.0	 30.0;
	2614	 2616	 0.00073	 0.01025	 0.02558	 3074	 3074	 3074	 0.0	 0.0	 1	 -30.0	 30.0;
	2614	 2616	 0.00073	 0.01025	 0.02558	 3074	 3074	 3074	 0.0	 0.0	 1	 -30.0	 30.0;
	2615	 2617	 0.00119	 0.01244	 0.02798	 2528	 2528	 2528	 0.0	 0.0	 1	 -30.0	 30.0;
	2615	 2617	 0.00119	 0.01244	 0.02798	 2528	 2528	 2528	 0.0	 0.0	 1	 -30.0	 30.0;
	2615	 2620	 0.00128	 0.00979	 0.0212	 3200	 3200	 3200	 0.0	 0.0	 1	 -30.0	 30.0;
	2616	 2617	 0.0011	 0.01189	 0.02514	 2646	 2646	 2646	 0.0	 0.0	 1	 -30.0	 30.0;
	3101	 3102	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3101	 3102	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3102	 3103	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3102	 3103	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3102	 3103	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3102	 3302	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3103	 3204	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3103	 3204	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3103	 3305	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3103	 3305	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3104	 3105	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3202	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3202	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3203	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3203	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3924	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3201	 3924	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3202	 3203	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3202	 3203	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3202	 3204	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3202	 3205	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3202	 3924	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3202	 3924	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3203	 3204	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3203	 3303	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3203	 3303	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3203	 3305	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3203	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3203	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3204	 3205	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3204	 3205	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3204	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3204	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3205	 3914	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3205	 3915	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3301	 3902	 0.00053	 0.01297	 0.0	 2434	 2434	 2434	 0.0	 0.0	 1	 -30.0	 30.0;
	3301	 3903	 1e-05	 -0.00755	 0.0	 4184	 4184	 4184	 0.0	 0.0	 1	 -30.0	 30.0;
	3302	 3304	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3302	 3304	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3303	 3304	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3303	 3304	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3303	 3304	 0.0011	 0.0127	 0.048	 2478	 2478	 2478	 0.0	 0.0	 1	 -30.0	 30.0;
	3303	 3918	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3303	 3918	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3305	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3401	 3402	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3401	 3402	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3401	 3404	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3401	 3405	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3401	 3405	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3401	 3804	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3403	 3404	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3403	 3804	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3404	 3804	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3404	 3804	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3404	 3917	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3404	 3918	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3405	 3907	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3405	 3907	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3501	 3914	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3501	 3915	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3601	 3925	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3701	 3926	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3701	 3926	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3801	 3802	 0.00079	 0.01937	 1.3285	 1630	 1630	 1630	 0.0	 0.0	 1	 -30.0	 30.0;
	3801	 3803	 0.00087	 0.02087	 1.4571	 1513	 1513	 1513	 0.0	 0.0	 1	 -30.0	 30.0;
	3801	 3803	 0.00087	 0.02087	 1.4571	 1513	 1513	 1513	 0.0	 0.0	 1	 -30.0	 30.0;
	3802	 3891	 0.00072	 0.016	 1.0879	 1973	 1973	 1973	 0.0	 0.0	 1	 -30.0	 30.0;
	3802	 3901	 0.00083	 0.01985	 0.0	 1590	 1590	 1590	 0.0	 0.0	 1	 -30.0	 30.0;
	3803	 3891	 2e-05	 -0.00998	 0.0	 3166	 3166	 3166	 0.0	 0.0	 1	 -30.0	 30.0;
	3803	 3892	 0.0	 -0.00935	 0.0	 3379	 3379	 3379	 0.0	 0.0	 1	 -30.0	 30.0;
	3803	 3894	 0.0	 -0.00944	 0.0	 3347	 3347	 3347	 0.0	 0.0	 1	 -30.0	 30.0;
	3803	 3896	 0.0	 -0.00935	 0.0	 3379	 3379	 3379	 0.0	 0.0	 1	 -30.0	 30.0;
	3803	 3901	 0.00153	 0.0147	 0.0	 2138	 2138	 2138	 0.0	 0.0	 1	 -30.0	 30.0;
	3804	 3806	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3805	 3806	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3892	 3893	 0.00123	 0.02659	 1.98702	 1187	 1187	 1187	 0.0	 0.0	 1	 -30.0	 30.0;
	3894	 3895	 0.00123	 0.02662	 1.9888	 1186	 1186	 1186	 0.0	 0.0	 1	 -30.0	 30.0;
	3896	 3897	 0.00112	 0.02517	 1.83586	 1254	 1254	 1254	 0.0	 0.0	 1	 -30.0	 30.0;
	3901	 3902	 0.00053	 0.01297	 0.0	 2434	 2434	 2434	 0.0	 0.0	 1	 -30.0	 30.0;
	3901	 3903	 0.00093	 0.03644	 1.3895	 867	 867	 867	 0.0	 0.0	 1	 -30.0	 30.0;
	3901	 8002	 2e-05	 -0.01331	 0.0	 2374	 2374	 2374	 0.0	 0.0	 1	 -30.0	 30.0;
	3903	 3904	 1e-05	 -0.01098	 0.0	 2877	 2877	 2877	 0.0	 0.0	 1	 -30.0	 30.0;
	3903	 3905	 0.00098	 0.01035	 0.0	 3039	 3039	 3039	 0.0	 0.0	 1	 -30.0	 30.0;
	3903	 8002	 0.00165	 0.05719	 2.4774	 553	 553	 553	 0.0	 0.0	 1	 -30.0	 30.0;
	3904	 3905	 0.0016	 0.01229	 0.0	 2549	 2549	 2549	 0.0	 0.0	 1	 -30.0	 30.0;
	3905	 3906	 0.00072	 0.00346	 0.0	 8938	 8938	 8938	 0.0	 0.0	 1	 -30.0	 30.0;
	3906	 4001	 0.00053	 0.00456	 0.0	 6881	 6881	 6881	 0.0	 0.0	 1	 -30.0	 30.0;
	3906	 4001	 0.00053	 0.00456	 0.0	 6881	 6881	 6881	 0.0	 0.0	 1	 -30.0	 30.0;
	3907	 3908	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3907	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3907	 8004	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	3908	 3920	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3909	 3919	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3909	 3920	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3910	 3911	 0.02482	 0.16938	 0.20232	 185	 185	 185	 0.0	 0.0	 1	 -30.0	 30.0;
	3910	 3924	 0.0148	 0.10101	 0.12066	 310	 310	 310	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 3912	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 3916	 0.01668	 0.11381	 0.13608	 275	 275	 275	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 3921	 0.01113	 0.06678	 0.07286	 467	 467	 467	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 3921	 0.0105	 0.0654	 0.0686	 477	 477	 477	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 3921	 0.01105	 0.06642	 0.0716	 470	 470	 470	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 3924	 0.03903	 0.27403	 0.31072	 115	 115	 115	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 8003	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	3911	 8003	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	3912	 3924	 0.03058	 0.2046	 0.24472	 153	 153	 153	 0.0	 0.0	 1	 -30.0	 30.0;
	3913	 3920	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3913	 3920	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3913	 3923	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3913	 8004	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	3915	 3924	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3916	 3924	 0.02235	 0.16106	 0.18342	 195	 195	 195	 0.0	 0.0	 1	 -30.0	 30.0;
	3919	 3922	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3920	 3922	 0.00312	 0.02886	 0.15252	 1089	 1089	 1089	 0.0	 0.0	 1	 -30.0	 30.0;
	3923	 8005	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	3923	 8005	 0.01382	 0.09268	 0.1106	 338	 338	 338	 0.0	 0.0	 1	 -30.0	 30.0;
	4001	 4204	 0.00078	 0.00239	 1.1381	 12565	 12565	 12565	 0.0	 0.0	 1	 -30.0	 30.0;
	4001	 4090	 0.00072	 0.01382	 1.27572	 2283	 2283	 2283	 0.0	 0.0	 1	 -30.0	 30.0;
	4001	 4094	 0.00078	 0.01502	 1.1381	 2101	 2101	 2101	 0.0	 0.0	 1	 -30.0	 30.0;
	4001	 4097	 0.00074	 0.01413	 1.06634	 2233	 2233	 2233	 0.0	 0.0	 1	 -30.0	 30.0;
	4001	 8001	 0.00106	 0.01293	 0.0	 2435	 2435	 2435	 0.0	 0.0	 1	 -30.0	 30.0;
	4002	 4003	 0.00122	 0.02373	 2.2071	 1330	 1330	 1330	 0.0	 0.0	 1	 -30.0	 30.0;
	4002	 4090	 0.00012	 0.00238	 0.21926	 13256	 13256	 13256	 0.0	 0.0	 1	 -30.0	 30.0;
	4002	 4091	 0.0006	 0.01036	 1.01456	 3044	 3044	 3044	 0.0	 0.0	 1	 -30.0	 30.0;
	4003	 6101	 0.00264	 0.02689	 5.29066	 1170	 1170	 1170	 0.0	 0.0	 1	 -30.0	 30.0;
	4004	 4005	 0.00063	 0.01412	 1.09756	 2235	 2235	 2235	 0.0	 0.0	 1	 -30.0	 30.0;
	4004	 4005	 0.00109	 0.02408	 1.55542	 1311	 1311	 1311	 0.0	 0.0	 1	 -30.0	 30.0;
	4004	 4005	 0.00108	 0.02409	 1.55348	 1310	 1310	 1310	 0.0	 0.0	 1	 -30.0	 30.0;
	4004	 4091	 0.00041	 0.00737	 0.72694	 4280	 4280	 4280	 0.0	 0.0	 1	 -30.0	 30.0;
	4004	 4092	 0.00066	 0.01266	 0.95976	 2492	 2492	 2492	 0.0	 0.0	 1	 -30.0	 30.0;
	4004	 4095	 0.00066	 0.01266	 0.95976	 2492	 2492	 2492	 0.0	 0.0	 1	 -30.0	 30.0;
	4005	 4006	 0.00023	 0.00451	 0.3332	 6995	 6995	 6995	 0.0	 0.0	 1	 -30.0	 30.0;
	4005	 4006	 0.0002	 0.00446	 0.305	 7076	 7076	 7076	 0.0	 0.0	 1	 -30.0	 30.0;
	4005	 4102	 0.0012	 0.02316	 1.7152	 1363	 1363	 1363	 0.0	 0.0	 1	 -30.0	 30.0;
	4005	 4102	 0.0003	 0.02	 3.6	 1580	 1580	 1580	 0.0	 0.0	 1	 -30.0	 30.0;
	4005	 4202	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4005	 6202	 0.00196	 0.03304	 1.88	 955	 955	 955	 0.0	 0.0	 1	 -30.0	 30.0;
	4006	 4007	 1e-05	 0.0003	 0.01434	 105233	 105233	 105233	 0.0	 0.0	 1	 -30.0	 30.0;
	4006	 4007	 1e-05	 0.0003	 0.01844	 105233	 105233	 105233	 0.0	 0.0	 1	 -30.0	 30.0;
	4006	 4202	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4008	 6401	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	4009	 4010	 6e-05	 0.00131	 0.00378	 24088	 24088	 24088	 0.0	 0.0	 1	 -30.0	 30.0;
	4009	 4010	 6e-05	 0.00116	 0.00332	 27195	 27195	 27195	 0.0	 0.0	 1	 -30.0	 30.0;
	4009	 4104	 0.002	 0.02	 0.8	 1572	 1572	 1572	 0.0	 0.0	 1	 -30.0	 30.0;
	4092	 4093	 0.0	 0.00165	 0.0	 19144	 19144	 19144	 0.0	 0.0	 1	 -30.0	 30.0;
	4093	 4094	 0.0	 -0.01263	 0.0	 2501	 2501	 2501	 0.0	 0.0	 1	 -30.0	 30.0;
	4095	 4096	 0.0	 0.00165	 0.0	 19144	 19144	 19144	 0.0	 0.0	 1	 -30.0	 30.0;
	4096	 4097	 0.0	 -0.01263	 0.0	 2501	 2501	 2501	 0.0	 0.0	 1	 -30.0	 30.0;
	4101	 4102	 0.00113	 0.02069	 1.85526	 1525	 1525	 1525	 0.0	 0.0	 1	 -30.0	 30.0;
	4101	 4102	 0.00113	 0.02069	 1.85526	 1525	 1525	 1525	 0.0	 0.0	 1	 -30.0	 30.0;
	4101	 4103	 0.0007	 0.074	 4.87	 427	 427	 427	 0.0	 0.0	 1	 -30.0	 30.0;
	4101	 4103	 0.002	 0.02	 0.8	 1572	 1572	 1572	 0.0	 0.0	 1	 -30.0	 30.0;
	4101	 4201	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4101	 4201	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4102	 4201	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4102	 4201	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4102	 4202	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4102	 4202	 0.0002	 0.0082	 1.3	 3851	 3851	 3851	 0.0	 0.0	 1	 -30.0	 30.0;
	4102	 6202	 0.00142	 0.02258	 1.88	 1397	 1397	 1397	 0.0	 0.0	 1	 -30.0	 30.0;
	4103	 6202	 0.0007	 0.074	 4.87	 427	 427	 427	 0.0	 0.0	 1	 -30.0	 30.0;
	4104	 5004	 0.002	 0.02	 0.8	 1572	 1572	 1572	 0.0	 0.0	 1	 -30.0	 30.0;
	4201	 4202	 0.00109	 0.02408	 1.55542	 1311	 1311	 1311	 0.0	 0.0	 1	 -30.0	 30.0;
	4201	 5001	 0.00083	 0.0239	 3.3	 1321	 1321	 1321	 0.0	 0.0	 1	 -30.0	 30.0;
	4202	 4203	 0.00066	 0.00165	 0.95976	 17775	 17775	 17775	 0.0	 0.0	 1	 -30.0	 30.0;
	4203	 4204	 0.00074	 0.01266	 1.0822	 2491	 2491	 2491	 0.0	 0.0	 1	 -30.0	 30.0;
	5001	 5002	 0.0035	 0.07	 4.606	 451	 451	 451	 0.0	 0.0	 1	 -30.0	 30.0;
	5003	 5004	 0.002	 0.02	 0.8	 1572	 1572	 1572	 0.0	 0.0	 1	 -30.0	 30.0;
	6102	 6103	 0.0012	 0.02316	 1.7152	 1363	 1363	 1363	 0.0	 0.0	 1	 -30.0	 30.0;
	6102	 6301	 0.0	 0.0046	 0.0	 6867	 6867	 6867	 0.0	 0.0	 1	 -30.0	 30.0;
	6102	 6403	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	6103	 6301	 0.0	 0.0046	 0.0	 6867	 6867	 6867	 0.0	 0.0	 1	 -30.0	 30.0;
	6103	 6301	 0.0	 0.0046	 0.0	 6867	 6867	 6867	 0.0	 0.0	 1	 -30.0	 30.0;
	6103	 6501	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	6103	 6501	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	6104	 6204	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6104	 6305	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6201	 6202	 0.00179	 0.01405	 3.68	 2231	 2231	 2231	 0.0	 0.0	 1	 -30.0	 30.0;
	6203	 6205	 0.0007	 0.074	 4.87	 427	 427	 427	 0.0	 0.0	 1	 -30.0	 30.0;
	6204	 6205	 0.0007	 0.025	 4.87	 1263	 1263	 1263	 0.0	 0.0	 1	 -30.0	 30.0;
	6203	 6303	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6203	 6303	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6203	 6304	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6302	 7001	 0.0	 0.0046	 0.0	 6867	 6867	 6867	 0.0	 0.0	 1	 -30.0	 30.0;
	6303	 6304	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6303	 6305	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6303	 6305	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6305	 6510	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6305	 6510	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6401	 6403	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	6401	 6403	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	6401	 6404	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6403	 6404	 0.0062	 0.0673	 1.1156	 468	 468	 468	 0.0	 0.0	 1	 -30.0	 30.0;
	6404	 6507	 0.0108	 0.0965	 0.3296	 326	 326	 326	 0.0	 0.0	 1	 -30.0	 30.0;
	6501	 6502	 0.0024	 0.00332	 0.5849	 7711	 7711	 7711	 0.0	 0.0	 1	 -30.0	 30.0;
	6501	 6504	 0.0021	 0.00238	 0.3845	 9952	 9952	 9952	 0.0	 0.0	 1	 -30.0	 30.0;
	6501	 6509	 0.0016	 0.00226	 0.381	 11408	 11408	 11408	 0.0	 0.0	 1	 -30.0	 30.0;
	6501	 6509	 0.0016	 0.00226	 0.381	 11408	 11408	 11408	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6503	 0.0052	 0.0602	 1.01	 523	 523	 523	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6503	 0.0049	 0.0537	 0.8843	 586	 586	 586	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6504	 0.0017	 0.00225	 0.3992	 11202	 11202	 11202	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6504	 0.0021	 0.00238	 0.3845	 9952	 9952	 9952	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6504	 0.0017	 0.00225	 0.3992	 11202	 11202	 11202	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6504	 0.0021	 0.00238	 0.3845	 9952	 9952	 9952	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6508	 0.0012	 0.0172	 0.2987	 1833	 1833	 1833	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6509	 0.0008	 0.00106	 0.2039	 23786	 23786	 23786	 0.0	 0.0	 1	 -30.0	 30.0;
	6502	 6509	 0.0008	 0.00106	 0.2039	 23786	 23786	 23786	 0.0	 0.0	 1	 -30.0	 30.0;
	6503	 6504	 0.0032	 0.0349	 0.5722	 902	 902	 902	 0.0	 0.0	 1	 -30.0	 30.0;
	6503	 6505	 0.0096	 0.0878	 1.4265	 358	 358	 358	 0.0	 0.0	 1	 -30.0	 30.0;
	6503	 6507	 0.0034	 0.0374	 0.6208	 842	 842	 842	 0.0	 0.0	 1	 -30.0	 30.0;
	6503	 6507	 0.0034	 0.0372	 0.6182	 846	 846	 846	 0.0	 0.0	 1	 -30.0	 30.0;
	6503	 6508	 0.0034	 0.0392	 0.6524	 803	 803	 803	 0.0	 0.0	 1	 -30.0	 30.0;
	6504	 6507	 0.0038	 0.034	 0.5824	 924	 924	 924	 0.0	 0.0	 1	 -30.0	 30.0;
	6504	 6507	 0.0032	 0.0349	 0.5722	 902	 902	 902	 0.0	 0.0	 1	 -30.0	 30.0;
	6504	 7002	 0.00811	 0.1369	 2.4348	 231	 231	 231	 0.0	 0.0	 1	 -30.0	 30.0;
	7001	 7002	 0.0	 0.0046	 0.0	 6867	 6867	 6867	 0.0	 0.0	 1	 -30.0	 30.0;
	8001	 8002	 0.00159	 0.0111	 0.0	 2817	 2817	 2817	 0.0	 0.0	 1	 -30.0	 30.0;
	8003	 8004	 0.01952	 0.13702	 0.15536	 229	 229	 229	 0.0	 0.0	 1	 -30.0	 30.0;
	8003	 8005	 0.03903	 0.27403	 0.31072	 115	 115	 115	 0.0	 0.0	 1	 -30.0	 30.0;
	8003	 8005	 0.03903	 0.27403	 0.31072	 115	 115	 115	 0.0	 0.0	 1	 -30.0	 30.0;
	8004	 8005	 0.01952	 0.13702	 0.15536	 229	 229	 229	 0.0	 0.0	 1	 -30.0	 30.0;
	1001	 1002	 0.0	 0.011	 0.0	 2872	 2872	 2872	 1.0	 0.0	 1	 -30.0	 30.0;
	1001	 1002	 0.0	 0.011	 0.0	 2872	 2872	 2872	 1.0	 0.0	 1	 -30.0	 30.0;
	1002	 1003	 0.00028	 0.0138	 0.0	 2289	 2289	 2289	 1.0	 0.0	 1	 -30.0	 30.0;
	1002	 1003	 0.00029	 0.0139	 0.0	 2272	 2272	 2272	 1.0	 0.0	 1	 -30.0	 30.0;
	1101	 1102	 0.0	 0.0146	 0.0	 2164	 2164	 2164	 1.0	 0.0	 1	 -30.0	 30.0;
	1101	 1102	 0.0	 0.0146	 0.0	 2164	 2164	 2164	 1.0	 0.0	 1	 -30.0	 30.0;
	1302	 1303	 0.0	 0.0072	 0.0	 4388	 4388	 4388	 1.0	 0.0	 1	 -30.0	 30.0;
	1401	 1403	 0.00028	 0.0138	 0.0	 2289	 2289	 2289	 1.0	 0.0	 1	 -30.0	 30.0;
	2100	 2400	 0.00028	 0.0138	 0.0	 2289	 2289	 2289	 1.0	 0.0	 1	 -30.0	 30.0;
	2201	 2202	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2201	 2202	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2301	 2302	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2301	 2302	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2402	 2409	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2404	 2411	 0.0	 0.01149	 0.0	 2750	 2750	 2750	 1.0	 0.0	 1	 -30.0	 30.0;
	2404	 2411	 0.0	 0.01149	 0.0	 2750	 2750	 2750	 1.0	 0.0	 1	 -30.0	 30.0;
	2404	 2411	 0.0	 0.01149	 0.0	 2750	 2750	 2750	 1.0	 0.0	 1	 -30.0	 30.0;
	2405	 2619	 0.0	 0.00115	 0.0	 27468	 27468	 27468	 0.0	 0.0	 1	 -30.0	 30.0;
	2501	 2502	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2501	 2502	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2501	 2502	 0.0	 0.005	 0.0	 6318	 6318	 6318	 1.0	 0.0	 1	 -30.0	 30.0;
	2601	 2612	 0.00026	 0.01386	 0.0	 2279	 2279	 2279	 1.0	 0.0	 1	 -30.0	 30.0;
	2602	 2615	 0.00013	 0.01386	 0.0	 2279	 2279	 2279	 1.0	 0.0	 1	 -30.0	 30.0;
	2602	 2615	 0.00013	 0.01386	 0.0	 2279	 2279	 2279	 1.0	 0.0	 1	 -30.0	 30.0;
	2603	 2607	 0.0002	 0.02338	 0.0	 1351	 1351	 1351	 1.0	 0.0	 1	 -30.0	 30.0;
	2605	 2621	 0.00059	 0.01491	 0.0	 2117	 2117	 2117	 1.0	 0.0	 1	 -30.0	 30.0;
	2606	 2621	 0.00059	 0.01491	 0.0	 2117	 2117	 2117	 1.0	 0.0	 1	 -30.0	 30.0;
	2614	 2621	 0.0003	 0.0133	 0.0	 2375	 2375	 2375	 1.0	 0.0	 1	 -30.0	 30.0;
	2614	 2621	 0.0003	 0.0134	 0.0	 2357	 2357	 2357	 1.0	 0.0	 1	 -30.0	 30.0;
	3102	 3104	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 1.0	 0.0	 1	 -30.0	 30.0;
	3301	 3303	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3301	 3303	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3301	 3303	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3701	 6402	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 0.0	 0.0	 1	 -30.0	 30.0;
	3701	 6402	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 0.0	 0.0	 1	 -30.0	 30.0;
	3802	 3804	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3803	 3805	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3803	 3805	 0.0002	 0.0119	 0.0	 2655	 2655	 2655	 1.0	 0.0	 1	 -30.0	 30.0;
	3901	 3917	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3902	 3918	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3903	 3923	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3904	 3924	 0.0002	 0.0125	 0.0	 2527	 2527	 2527	 1.0	 0.0	 1	 -30.0	 30.0;
	3905	 3922	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3906	 3921	 0.0001	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	3911	 3925	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 1.0	 0.0	 1	 -30.0	 30.0;
	3920	 3926	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 1.0	 0.0	 1	 -30.0	 30.0;
	3920	 3926	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 1.0	 0.0	 1	 -30.0	 30.0;
	4001	 4008	 0.0	 0.0072	 0.0	 4388	 4388	 4388	 1.0	 0.0	 1	 -30.0	 30.0;
	4006	 4009	 0.0002	 0.01181	 0.0	 2675	 2675	 2675	 1.0	 0.0	 1	 -30.0	 30.0;
	4006	 4009	 9e-05	 0.00735	 0.0	 4298	 4298	 4298	 1.0	 0.0	 1	 -30.0	 30.0;
	4007	 4010	 0.0	 0.00221	 0.0	 14293	 14293	 14293	 1.0	 0.0	 1	 -30.0	 30.0;
	4103	 4104	 0.0	 0.01	 0.0	 3159	 3159	 3159	 1.0	 0.0	 1	 -30.0	 30.0;
	5002	 5003	 0.0	 0.01	 0.0	 3159	 3159	 3159	 1.0	 0.0	 1	 -30.0	 30.0;
	6101	 6102	 0.0	 0.0072	 0.0	 4388	 4388	 4388	 1.0	 0.0	 1	 -30.0	 30.0;
	6103	 6104	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6201	 6203	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6202	 6204	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6301	 6303	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6302	 6304	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6401	 6402	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 1.0	 0.0	 1	 -30.0	 30.0;
	6401	 6402	 0.00089	 0.0299	 0.0	 1056	 1056	 1056	 1.0	 0.0	 1	 -30.0	 30.0;
	6501	 6510	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6501	 6510	 0.0003	 0.0181	 0.0	 1745	 1745	 1745	 1.0	 0.0	 1	 -30.0	 30.0;
	6505	 6506	 0.0	 0.0195	 0.0	 1620	 1620	 1620	 0.0	 0.0	 1	 -30.0	 30.0;
	8001	 8003	 0.0001	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	8002	 8005	 0.0003	 0.0174	 0.0	 1816	 1816	 1816	 1.0	 0.0	 1	 -30.0	 30.0;
	1002	 1032	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	1004	 1034	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	1101	 1131	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	1202	 1232	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	1301	 1331	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	1303	 1333	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	1401	 1431	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2000	 2030	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2100	 2130	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2203	 2233	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2302	 2332	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2408	 2438	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2503	 2533	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2604	 2634	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2608	 2638	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2610	 2630	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2611	 2631	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	2612	 2637	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3103	 3133	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3105	 3135	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3204	 3234	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3303	 3333	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3402	 3432	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3403	 3433	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3501	 3531	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3601	 3631	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3701	 3731	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3801	 3831	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3805	 3835	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3806	 3836	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3902	 3932	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3921	 3931	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	3923	 3933	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4001	 4031	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4005	 4035	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4009	 4039	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4101	 4131	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4102	 4132	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4201	 4231	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	4202	 4232	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	5001	 5031	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	5002	 5032	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6102	 6132	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6201	 6231	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6205	 6235	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6303	 6333	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6305	 6335	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6403	 6433	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	6503	 6533	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	7001	 7031	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	7002	 7032	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	8003	 8033	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
	8004	 8034	 0.0	 0.0005	 0.0	 63175	 63175	 63175	 1.0	 0.0	 1	 -30.0	 30.0;
];

% INFO    : === Translation Options ===
% INFO    : Phase Angle Bound:           30.0 (deg.)
% INFO    : Line Capacity Model:         ub
% INFO    : Gen Active Cost Model:       stat
% INFO    : Setting Flat Start
% INFO    : Line Capacity PAB:           15.0 (deg.)
% WARNING : No active generation at the slack bus, assigning type - NUC
% INFO    :
% INFO    : === Generator Classification Notes ===
% INFO    : PEL    9   -     2.89
% INFO    : SYNC   2   -     0.00
% INFO    : NUC    7   -     8.52
% INFO    : COW    78  -    78.04
% INFO    : NG     47  -    10.54
% INFO    :
% INFO    : === Generator Active Cost Stat Model Notes ===
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 23.5525299191 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 17.5257402556 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 50.253547919 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 7.78454029284 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 7.16410472563 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 32.4369581155 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 31.1564686471 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 22.7374989793 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 19.9521835962 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 31.2421367117 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.8077842077 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 28.3839684791 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 34.7554306607 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 7.69801397425 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 105.404953555 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 40.0826060888 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 25.6300895715 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 103.348768321 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 6.76998700285 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 11.5083098137 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 37.856831093 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 36.1081158818 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 49.8602469688 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 19.8632815077 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 28.2160087108 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 25.247026613 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 39.4357178616 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 22.418634133 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 25.3957072679 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 112.919982805 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 29.4470958533 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 27.3601869668 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 43.0545538323 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 21.9548801883 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 21.935046809 0
% INFO    : Updated Generator Cost: SYNC - 0.0 1.0 0.0 -> 0 0.0 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 32.7386347459 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.6428913147 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 17.3865010737 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 25.6239839673 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 36.0082607475 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 33.6388778915 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 60.2951920482 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 115.784251999 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 19.7477575753 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 139.406670934 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 40.6268401904 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 33.3904114687 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 9.11680927355 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 22.5992356659 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 36.5573792994 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 29.6005472737 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 23.1271149734 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 19.0290252232 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 26.6286649122 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 23.0691696065 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 19.7551580172 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 111.468782821 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 37.3643299461 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 29.3055938143 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 43.487945521 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 18.0090892578 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 27.1867955853 0
% INFO    : Updated Generator Cost: SYNC - 0.0 1.0 0.0 -> 0 0.0 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 39.855612773 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 52.2914712473 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 32.8215022484 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 22.4341421793 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 35.0602507146 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 58.6409534498 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 40.1115830432 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 10.7240756495 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 29.6046016486 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 7.14809787545 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 14.1202796842 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 32.4897442801 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 32.9205214883 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 28.8793135532 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 7.79526189151 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 14.4957896254 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 33.5296286339 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 14.1486326031 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 22.3600859646 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 23.1539733445 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 32.0766944744 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 31.7996682367 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 48.3752190348 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 20.0485107042 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 13.5815545543 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 31.5847903028 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 45.1957959204 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 39.7591270206 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 14.530332461 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 15.1368331973 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 42.8283235531 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 14.3895697916 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 38.9664658307 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 15.4865780821 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 41.4926107266 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 28.4662949213 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 27.2556500258 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.8375466254 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 28.0192412656 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 11.7869358964 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 29.9857386143 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 28.8159757665 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 37.6984324637 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 48.8312927109 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 32.2118877177 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 105.104656437 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 37.8792729637 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 33.634935177 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 30.1078342123 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 37.7932354919 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 31.2394175092 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 28.6632736117 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.4058607519 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 38.0166695812 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 32.2478458181 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.3889598632 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 11.8161600653 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 29.8528679639 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 28.2521732966 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 102.698216355 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 23.7075274767 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 26.9351328238 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 19.2664011416 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 27.8895400167 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 20.4567414688 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 26.0929540711 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 37.2103111231 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 27.338560896 0
% INFO    : Updated Generator Cost: NUC - 0.0 1.0 0.0 -> 0 7.15712928343 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 38.9561124383 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 40.6423516358 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 18.7815777443 0
% INFO    : Updated Generator Cost: NG - 0.0 1.0 0.0 -> 0 43.3308587026 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 31.9053346847 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 9.59443441229 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 25.215165498 0
% INFO    : Updated Generator Cost: PEL - 0.0 1.0 0.0 -> 0 114.365662855 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.1491495276 0
% INFO    : Updated Generator Cost: COW - 0.0 1.0 0.0 -> 0 24.9487785587 0
% INFO    :
% INFO    : === Generator Bounds Update Notes ===
% INFO    :
% INFO    : === Base KV Replacement Notes ===
% INFO    :
% INFO    : === Transformer Setting Replacement Notes ===
% WARNING : Transformer 2405-2619 connects the same voltage levels (230.0, 230.0) and has no phase shift, changing tap ratio 1.0 => 0.0
% WARNING : Transformer 3701-6402 connects the same voltage levels (115.0, 115.0) and has no phase shift, changing tap ratio 1.0 => 0.0
% WARNING : Transformer 3701-6402 connects the same voltage levels (115.0, 115.0) and has no phase shift, changing tap ratio 1.0 => 0.0
% WARNING : Transformer 6505-6506 connects the same voltage levels (345.0, 345.0) and has no phase shift, changing tap ratio 1.0 => 0.0
% INFO    :
% INFO    : === Line Capacity UB Model Notes ===
% INFO    : Updated Thermal Rating: on line 1001-1201 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 996
% INFO    : Updated Thermal Rating: on line 1001-1202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 1002-1004 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 5934
% INFO    : Updated Thermal Rating: on line 1002-1102 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1583
% INFO    : Updated Thermal Rating: on line 1002-1102 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1583
% INFO    : Updated Thermal Rating: on line 1002-6506 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 721
% INFO    : Updated Thermal Rating: on line 1004-7001 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 115
% INFO    : Updated Thermal Rating: on line 1004-7002 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 287
% INFO    : Updated Thermal Rating: on line 1101-1401 : Rate A, Rate B, Rate C , 0.0, 0.0, 1630.0 -> 1485
% INFO    : Updated Thermal Rating: on line 1101-1401 : Rate A, Rate B, Rate C , 0.0, 0.0, 1630.0 -> 1485
% INFO    : Updated Thermal Rating: on line 1201-1202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 5834
% INFO    : Updated Thermal Rating: on line 1201-1402 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1216
% INFO    : Updated Thermal Rating: on line 1201-2901 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2282
% INFO    : Updated Thermal Rating: on line 1202-1302 : Rate A, Rate B, Rate C , 0.0, 0.0, 1630.0 -> 1485
% INFO    : Updated Thermal Rating: on line 1202-1402 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 904
% INFO    : Updated Thermal Rating: on line 1301-1302 : Rate A, Rate B, Rate C , 0.0, 0.0, 1630.0 -> 1485
% INFO    : Updated Thermal Rating: on line 1301-1402 : Rate A, Rate B, Rate C , 0.0, 0.0, 1630.0 -> 1485
% INFO    : Updated Thermal Rating: on line 1301-1402 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 1301-2603 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1249
% INFO    : Updated Thermal Rating: on line 1301-2901 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 1303-6507 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 231
% INFO    : Updated Thermal Rating: on line 1401-1402 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3288
% INFO    : Updated Thermal Rating: on line 1401-1402 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3288
% INFO    : Updated Thermal Rating: on line 1401-2301 : Rate A, Rate B, Rate C , 0.0, 0.0, 1800.0 -> 1061
% INFO    : Updated Thermal Rating: on line 1401-2400 : Rate A, Rate B, Rate C , 0.0, 0.0, 1800.0 -> 1061
% INFO    : Updated Thermal Rating: on line 1403-2100 : Rate A, Rate B, Rate C , 0.0, 0.0, 1160.0 -> 446
% INFO    : Updated Thermal Rating: on line 2000-2202 : Rate A, Rate B, Rate C , 0.0, 986.0, 986.0 -> 585
% INFO    : Updated Thermal Rating: on line 2000-2302 : Rate A, Rate B, Rate C , 0.0, 986.0, 986.0 -> 585
% INFO    : Updated Thermal Rating: on line 2100-2302 : Rate A, Rate B, Rate C , 0.0, 0.0, 1160.0 -> 446
% INFO    : Updated Thermal Rating: on line 2201-2301 : Rate A, Rate B, Rate C , 0.0, 0.0, 1800.0 -> 1249
% INFO    : Updated Thermal Rating: on line 2202-2203 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2202-2203 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2202-2503 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2203-2503 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2203-2503 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2400-2403 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 3487
% INFO    : Updated Thermal Rating: on line 2401-2402 : Rate A, Rate B , 0.0, 0.0 -> 4192
% INFO    : Updated Thermal Rating: on line 2401-2402 : Rate A, Rate B , 0.0, 0.0 -> 4208
% INFO    : Updated Thermal Rating: on line 2401-2404 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 2806
% INFO    : Updated Thermal Rating: on line 2401-2404 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 2806
% INFO    : Updated Thermal Rating: on line 2401-2501 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 2466
% INFO    : Updated Thermal Rating: on line 2401-2603 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 7696
% INFO    : Updated Thermal Rating: on line 2401-2901 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 1134
% INFO    : Updated Thermal Rating: on line 2401-2902 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 1018
% INFO    : Updated Thermal Rating: on line 2402-2501 : Rate A, Rate B , 0.0, 0.0 -> 6905
% INFO    : Updated Thermal Rating: on line 2403-2501 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 3394
% INFO    : Updated Thermal Rating: on line 2404-3893 : Rate A, Rate B , 0.0, 0.0 -> 3379
% INFO    : Updated Thermal Rating: on line 2404-3895 : Rate A, Rate B , 0.0, 0.0 -> 3379
% INFO    : Updated Thermal Rating: on line 2404-3897 : Rate A, Rate B , 0.0, 0.0 -> 3761
% INFO    : Updated Thermal Rating: on line 2405-2406 : Rate A, Rate B, Rate C , 0.0, 0.0, 3070.0 -> 1195
% INFO    : Updated Thermal Rating: on line 2405-2410 : Rate A, Rate B, Rate C , 0.0, 0.0, 3070.0 -> 2658
% INFO    : Updated Thermal Rating: on line 2405-2410 : Rate A, Rate B, Rate C , 0.0, 0.0, 3070.0 -> 2658
% INFO    : Updated Thermal Rating: on line 2406-2408 : Rate A, Rate B, Rate C , 0.0, 0.0, 2320.0 -> 1222
% INFO    : Updated Thermal Rating: on line 2406-2410 : Rate A, Rate B, Rate C , 0.0, 0.0, 1160.0 -> 446
% INFO    : Updated Thermal Rating: on line 2407-2408 : Rate A, Rate B , 0.0, 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 2408-2409 : Rate A, Rate B, Rate C , 0.0, 0.0, 2320.0 -> 585
% INFO    : Updated Thermal Rating: on line 2408-2409 : Rate A, Rate B, Rate C , 0.0, 0.0, 2320.0 -> 585
% INFO    : Updated Thermal Rating: on line 2408-2411 : Rate A, Rate B, Rate C , 0.0, 0.0, 2320.0 -> 798
% INFO    : Updated Thermal Rating: on line 2408-2502 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2409-2502 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2409-2503 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2410-2411 : Rate A, Rate B, Rate C , 0.0, 0.0, 2320.0 -> 864
% INFO    : Updated Thermal Rating: on line 2410-2411 : Rate A, Rate B, Rate C , 0.0, 0.0, 2320.0 -> 929
% INFO    : Updated Thermal Rating: on line 2502-2503 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2502-2503 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 2901-2902 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 2231
% INFO    : Updated Thermal Rating: on line 2600-2602 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1892
% INFO    : Updated Thermal Rating: on line 2600-2603 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 19867
% INFO    : Updated Thermal Rating: on line 2600-2603 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 19867
% INFO    : Updated Thermal Rating: on line 2600-2601 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1696
% INFO    : Updated Thermal Rating: on line 2601-2603 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1675
% INFO    : Updated Thermal Rating: on line 2603-2901 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1249
% INFO    : Updated Thermal Rating: on line 2604-6404 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 2604-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1286
% INFO    : Updated Thermal Rating: on line 2604-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1286
% INFO    : Updated Thermal Rating: on line 2605-2607 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 396
% INFO    : Updated Thermal Rating: on line 2606-2607 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 396
% INFO    : Updated Thermal Rating: on line 2608-2611 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 942
% INFO    : Updated Thermal Rating: on line 2608-2612 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 829
% INFO    : Updated Thermal Rating: on line 2608-2618 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 674
% INFO    : Updated Thermal Rating: on line 2608-2619 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 922
% INFO    : Updated Thermal Rating: on line 2609-2615 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 4360
% INFO    : Updated Thermal Rating: on line 2609-2617 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 5881
% INFO    : Updated Thermal Rating: on line 2610-2613 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 922
% INFO    : Updated Thermal Rating: on line 2610-2613 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 860
% INFO    : Updated Thermal Rating: on line 2610-2616 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1026
% INFO    : Updated Thermal Rating: on line 2610-2617 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 734
% INFO    : Updated Thermal Rating: on line 2611-2612 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 7262
% INFO    : Updated Thermal Rating: on line 2612-2615 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1975
% INFO    : Updated Thermal Rating: on line 2612-2615 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1975
% INFO    : Updated Thermal Rating: on line 2612-2618 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3233
% INFO    : Updated Thermal Rating: on line 2612-2618 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3233
% INFO    : Updated Thermal Rating: on line 2612-2618 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3210
% INFO    : Updated Thermal Rating: on line 2612-2618 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3210
% INFO    : Updated Thermal Rating: on line 2612-2619 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 8019
% INFO    : Updated Thermal Rating: on line 2612-2619 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 8019
% INFO    : Updated Thermal Rating: on line 2612-2619 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 8019
% INFO    : Updated Thermal Rating: on line 2612-2620 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2810
% INFO    : Updated Thermal Rating: on line 2612-2620 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2810
% INFO    : Updated Thermal Rating: on line 2613-2616 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 8587
% INFO    : Updated Thermal Rating: on line 2613-2617 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 5367
% INFO    : Updated Thermal Rating: on line 2614-2616 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3074
% INFO    : Updated Thermal Rating: on line 2614-2616 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3074
% INFO    : Updated Thermal Rating: on line 2615-2617 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2528
% INFO    : Updated Thermal Rating: on line 2615-2617 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2528
% INFO    : Updated Thermal Rating: on line 2615-2620 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3200
% INFO    : Updated Thermal Rating: on line 2616-2617 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2646
% INFO    : Updated Thermal Rating: on line 3101-3102 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3101-3102 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3102-3103 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3102-3103 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3102-3103 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3102-3302 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3103-3204 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3103-3204 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3103-3305 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3103-3305 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3104-3105 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3201-3202 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3201-3202 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3201-3203 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3201-3203 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3201-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3201-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3201-3924 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3201-3924 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3202-3203 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3202-3203 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3202-3204 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3202-3205 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3202-3924 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3202-3924 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3203-3204 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3203-3303 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3203-3303 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3203-3305 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3203-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3203-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3204-3205 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3204-3205 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3204-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3204-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3205-3914 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3205-3915 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3301-3902 : Rate A, Rate B, Rate C , 0.0, 0.0, 2450.0 -> 2434
% INFO    : Updated Thermal Rating: on line 3301-3903 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 4184
% INFO    : Updated Thermal Rating: on line 3302-3304 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3302-3304 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3303-3304 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3303-3304 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3303-3304 : Rate A , 0.0 -> 2478
% INFO    : Updated Thermal Rating: on line 3303-3918 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3303-3918 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3305-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3401-3402 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3401-3402 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3401-3404 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3401-3405 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3401-3405 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3401-3804 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3403-3404 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3403-3804 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3404-3804 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3404-3804 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3404-3917 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3404-3918 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3405-3907 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3405-3907 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3501-3914 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3501-3915 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3601-3925 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3701-3926 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3701-3926 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3801-3802 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1630
% INFO    : Updated Thermal Rating: on line 3801-3803 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1513
% INFO    : Updated Thermal Rating: on line 3801-3803 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1513
% INFO    : Updated Thermal Rating: on line 3802-3891 : Rate A, Rate B, Rate C , 0.0, 0.0, 2450.0 -> 1973
% INFO    : Updated Thermal Rating: on line 3802-3901 : Rate A, Rate B, Rate C , 0.0, 0.0, 2450.0 -> 1590
% INFO    : Updated Thermal Rating: on line 3803-3891 : Rate A, Rate B , 0.0, 0.0 -> 3166
% INFO    : Updated Thermal Rating: on line 3803-3892 : Rate A, Rate B , 0.0, 0.0 -> 3379
% INFO    : Updated Thermal Rating: on line 3803-3894 : Rate A, Rate B , 0.0, 0.0 -> 3347
% INFO    : Updated Thermal Rating: on line 3803-3896 : Rate A, Rate B , 0.0, 0.0 -> 3379
% INFO    : Updated Thermal Rating: on line 3803-3901 : Rate A, Rate B , 0.0, 0.0 -> 2138
% INFO    : Updated Thermal Rating: on line 3804-3806 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3805-3806 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3892-3893 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 1187
% INFO    : Updated Thermal Rating: on line 3894-3895 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 1186
% INFO    : Updated Thermal Rating: on line 3896-3897 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 1254
% INFO    : Updated Thermal Rating: on line 3901-3902 : Rate A, Rate B, Rate C , 0.0, 0.0, 2450.0 -> 2434
% INFO    : Updated Thermal Rating: on line 3901-3903 : Rate A, Rate B, Rate C , 0.0, 0.0, 2450.0 -> 867
% INFO    : Updated Thermal Rating: on line 3901-8002 : Rate A, Rate B , 0.0, 0.0 -> 2374
% INFO    : Updated Thermal Rating: on line 3903-3904 : Rate A, Rate B , 0.0, 0.0 -> 2877
% INFO    : Updated Thermal Rating: on line 3903-3905 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3039
% INFO    : Updated Thermal Rating: on line 3903-8002 : Rate A, Rate B, Rate C , 0.0, 0.0, 2450.0 -> 553
% INFO    : Updated Thermal Rating: on line 3904-3905 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2549
% INFO    : Updated Thermal Rating: on line 3905-3906 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 8938
% INFO    : Updated Thermal Rating: on line 3906-4001 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 6881
% INFO    : Updated Thermal Rating: on line 3906-4001 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 6881
% INFO    : Updated Thermal Rating: on line 3907-3908 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3907-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3907-8004 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 3908-3920 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3909-3919 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3909-3920 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3910-3911 : Rate A, Rate B, Rate C , 0.0, 0.0, 838.0 -> 185
% INFO    : Updated Thermal Rating: on line 3910-3924 : Rate A, Rate B, Rate C , 0.0, 0.0, 838.0 -> 310
% INFO    : Updated Thermal Rating: on line 3911-3912 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 3911-3916 : Rate A, Rate B, Rate C , 0.0, 0.0, 838.0 -> 275
% INFO    : Updated Thermal Rating: on line 3911-3921 : Rate A, Rate B, Rate C , 0.0, 0.0, 752.0 -> 467
% INFO    : Updated Thermal Rating: on line 3911-3921 : Rate A, Rate B, Rate C , 0.0, 0.0, 602.0 -> 477
% INFO    : Updated Thermal Rating: on line 3911-3921 : Rate A, Rate B, Rate C , 0.0, 0.0, 752.0 -> 470
% INFO    : Updated Thermal Rating: on line 3911-3924 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 115
% INFO    : Updated Thermal Rating: on line 3911-8003 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 3911-8003 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 3912-3924 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 153
% INFO    : Updated Thermal Rating: on line 3913-3920 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3913-3920 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3913-3923 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3913-8004 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 3915-3924 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3916-3924 : Rate A, Rate B, Rate C , 0.0, 0.0, 838.0 -> 195
% INFO    : Updated Thermal Rating: on line 3919-3922 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3920-3922 : Rate A , 0.0 -> 1089
% INFO    : Updated Thermal Rating: on line 3923-8005 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 3923-8005 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 338
% INFO    : Updated Thermal Rating: on line 4001-4204 : Rate A, Rate B , 0.0, 0.0 -> 12565
% INFO    : Updated Thermal Rating: on line 4001-4090 : Rate A, Rate B, Rate C , 0.0, 0.0, 3600.0 -> 2283
% INFO    : Updated Thermal Rating: on line 4001-4094 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 2101
% INFO    : Updated Thermal Rating: on line 4001-4097 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 2233
% INFO    : Updated Thermal Rating: on line 4001-8001 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2435
% INFO    : Updated Thermal Rating: on line 4002-4003 : Rate A, Rate B, Rate C , 0.0, 0.0, 1732.0 -> 1330
% INFO    : Updated Thermal Rating: on line 4002-4090 : Rate A, Rate B , 0.0, 0.0 -> 13256
% INFO    : Updated Thermal Rating: on line 4002-4091 : Rate A, Rate B , 0.0, 0.0 -> 3044
% INFO    : Updated Thermal Rating: on line 4003-6101 : Rate A, Rate B, Rate C , 0.0, 0.0, 1732.0 -> 1170
% INFO    : Updated Thermal Rating: on line 4004-4005 : Rate A, Rate B, Rate C , 0.0, 0.0, 3450.0 -> 2235
% INFO    : Updated Thermal Rating: on line 4004-4005 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 1311
% INFO    : Updated Thermal Rating: on line 4004-4005 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 1310
% INFO    : Updated Thermal Rating: on line 4004-4091 : Rate A, Rate B , 0.0, 0.0 -> 4280
% INFO    : Updated Thermal Rating: on line 4004-4092 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 2492
% INFO    : Updated Thermal Rating: on line 4004-4095 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 2492
% INFO    : Updated Thermal Rating: on line 4005-4006 : Rate A, Rate B , 0.0, 0.0 -> 6995
% INFO    : Updated Thermal Rating: on line 4005-4006 : Rate A, Rate B , 0.0, 0.0 -> 7076
% INFO    : Updated Thermal Rating: on line 4005-4102 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1363
% INFO    : Updated Thermal Rating: on line 4005-4102 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1580
% INFO    : Updated Thermal Rating: on line 4005-4202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4005-6202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 955
% INFO    : Updated Thermal Rating: on line 4006-4007 : Rate A, Rate B , 0.0, 0.0 -> 105233
% INFO    : Updated Thermal Rating: on line 4006-4007 : Rate A, Rate B , 0.0, 0.0 -> 105233
% INFO    : Updated Thermal Rating: on line 4006-4202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4008-6401 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 4009-4010 : Rate A, Rate B , 0.0, 0.0 -> 24088
% INFO    : Updated Thermal Rating: on line 4009-4010 : Rate A, Rate B , 0.0, 0.0 -> 27195
% INFO    : Updated Thermal Rating: on line 4009-4104 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1572
% INFO    : Updated Thermal Rating: on line 4092-4093 : Rate A, Rate B , 0.0, 0.0 -> 19144
% INFO    : Updated Thermal Rating: on line 4093-4094 : Rate A, Rate B , 0.0, 0.0 -> 2501
% INFO    : Updated Thermal Rating: on line 4095-4096 : Rate A, Rate B , 0.0, 0.0 -> 19144
% INFO    : Updated Thermal Rating: on line 4096-4097 : Rate A, Rate B , 0.0, 0.0 -> 2501
% INFO    : Updated Thermal Rating: on line 4101-4102 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1525
% INFO    : Updated Thermal Rating: on line 4101-4102 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1525
% INFO    : Updated Thermal Rating: on line 4101-4103 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 427
% INFO    : Updated Thermal Rating: on line 4101-4103 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1572
% INFO    : Updated Thermal Rating: on line 4101-4201 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4101-4201 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4102-4201 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4102-4201 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4102-4202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4102-4202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 3851
% INFO    : Updated Thermal Rating: on line 4102-6202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1397
% INFO    : Updated Thermal Rating: on line 4103-6202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 427
% INFO    : Updated Thermal Rating: on line 4104-5004 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1572
% INFO    : Updated Thermal Rating: on line 4201-4202 : Rate A, Rate B, Rate C , 0.0, 0.0, 3020.0 -> 1311
% INFO    : Updated Thermal Rating: on line 4201-5001 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1321
% INFO    : Updated Thermal Rating: on line 4202-4203 : Rate A, Rate B , 0.0, 0.0 -> 17775
% INFO    : Updated Thermal Rating: on line 4203-4204 : Rate A, Rate B , 0.0, 0.0 -> 2491
% INFO    : Updated Thermal Rating: on line 5001-5002 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 451
% INFO    : Updated Thermal Rating: on line 5003-5004 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1572
% INFO    : Updated Thermal Rating: on line 6102-6103 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1363
% INFO    : Updated Thermal Rating: on line 6102-6301 : Rate A, Rate B , 0.0, 0.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6102-6403 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 6103-6301 : Rate A, Rate B , 0.0, 0.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6103-6301 : Rate A, Rate B , 0.0, 0.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6103-6501 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 6103-6501 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 6104-6204 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6104-6305 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6201-6202 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2231
% INFO    : Updated Thermal Rating: on line 6203-6205 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 427
% INFO    : Updated Thermal Rating: on line 6204-6205 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1263
% INFO    : Updated Thermal Rating: on line 6203-6303 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6203-6303 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6203-6304 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6302-7001 : Rate A, Rate B , 0.0, 0.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6303-6304 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6303-6305 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6303-6305 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6305-6510 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6305-6510 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6401-6403 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 6401-6403 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 6401-6404 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6403-6404 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 468
% INFO    : Updated Thermal Rating: on line 6404-6507 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 326
% INFO    : Updated Thermal Rating: on line 6501-6502 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 7711
% INFO    : Updated Thermal Rating: on line 6501-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 9952
% INFO    : Updated Thermal Rating: on line 6501-6509 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 11408
% INFO    : Updated Thermal Rating: on line 6501-6509 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 11408
% INFO    : Updated Thermal Rating: on line 6502-6503 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 523
% INFO    : Updated Thermal Rating: on line 6502-6503 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 586
% INFO    : Updated Thermal Rating: on line 6502-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 11202
% INFO    : Updated Thermal Rating: on line 6502-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 9952
% INFO    : Updated Thermal Rating: on line 6502-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 11202
% INFO    : Updated Thermal Rating: on line 6502-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 9952
% INFO    : Updated Thermal Rating: on line 6502-6508 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 1833
% INFO    : Updated Thermal Rating: on line 6502-6509 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 23786
% INFO    : Updated Thermal Rating: on line 6502-6509 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 23786
% INFO    : Updated Thermal Rating: on line 6503-6504 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 902
% INFO    : Updated Thermal Rating: on line 6503-6505 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 358
% INFO    : Updated Thermal Rating: on line 6503-6507 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 842
% INFO    : Updated Thermal Rating: on line 6503-6507 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 846
% INFO    : Updated Thermal Rating: on line 6503-6508 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 803
% INFO    : Updated Thermal Rating: on line 6504-6507 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 924
% INFO    : Updated Thermal Rating: on line 6504-6507 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 902
% INFO    : Updated Thermal Rating: on line 6504-7002 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 231
% INFO    : Updated Thermal Rating: on line 7001-7002 : Rate A, Rate B , 0.0, 0.0 -> 6867
% INFO    : Updated Thermal Rating: on line 8001-8002 : Rate A, Rate B, Rate C , 0.0, 0.0, 0.0 -> 2817
% INFO    : Updated Thermal Rating: on line 8003-8004 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 229
% INFO    : Updated Thermal Rating: on line 8003-8005 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 115
% INFO    : Updated Thermal Rating: on line 8003-8005 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 115
% INFO    : Updated Thermal Rating: on line 8004-8005 : Rate A, Rate B, Rate C , 0.0, 0.0, 747.0 -> 229
% INFO    : Updated Thermal Rating: on transformer 1001-1002 : Rate A, Rate B , 0.0, 0.0 -> 2872
% INFO    : Updated Thermal Rating: on transformer 1001-1002 : Rate A, Rate B , 0.0, 0.0 -> 2872
% INFO    : Updated Thermal Rating: on transformer 1002-1003 : Rate A, Rate B , 0.0, 0.0 -> 2289
% INFO    : Updated Thermal Rating: on transformer 1002-1003 : Rate A, Rate B , 0.0, 0.0 -> 2272
% INFO    : Updated Thermal Rating: on transformer 1101-1102 : Rate A, Rate B , 0.0, 0.0 -> 2164
% INFO    : Updated Thermal Rating: on transformer 1101-1102 : Rate A, Rate B , 0.0, 0.0 -> 2164
% INFO    : Updated Thermal Rating: on transformer 1302-1303 : Rate A, Rate B , 0.0, 0.0 -> 4388
% INFO    : Updated Thermal Rating: on transformer 1401-1403 : Rate A, Rate B , 0.0, 0.0 -> 2289
% INFO    : Updated Thermal Rating: on transformer 2100-2400 : Rate A, Rate B , 0.0, 0.0 -> 2289
% INFO    : Updated Thermal Rating: on transformer 2201-2202 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2201-2202 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2301-2302 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2301-2302 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2402-2409 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2404-2411 : Rate A, Rate B , 0.0, 0.0 -> 2750
% INFO    : Updated Thermal Rating: on transformer 2404-2411 : Rate A, Rate B , 0.0, 0.0 -> 2750
% INFO    : Updated Thermal Rating: on transformer 2404-2411 : Rate A, Rate B , 0.0, 0.0 -> 2750
% INFO    : Updated Thermal Rating: on line 2405-2619 : Rate A, Rate B , 0.0, 0.0 -> 27468
% INFO    : Updated Thermal Rating: on transformer 2501-2502 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2501-2502 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2501-2502 : Rate A, Rate B , 0.0, 0.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2601-2612 : Rate A, Rate B , 0.0, 0.0 -> 2279
% INFO    : Updated Thermal Rating: on transformer 2602-2615 : Rate A, Rate B , 0.0, 0.0 -> 2279
% INFO    : Updated Thermal Rating: on transformer 2602-2615 : Rate A, Rate B , 0.0, 0.0 -> 2279
% INFO    : Updated Thermal Rating: on transformer 2603-2607 : Rate A, Rate B , 0.0, 0.0 -> 1351
% INFO    : Updated Thermal Rating: on transformer 2605-2621 : Rate A, Rate B , 0.0, 0.0 -> 2117
% INFO    : Updated Thermal Rating: on transformer 2606-2621 : Rate A, Rate B , 0.0, 0.0 -> 2117
% INFO    : Updated Thermal Rating: on transformer 2614-2621 : Rate A, Rate B , 0.0, 0.0 -> 2375
% INFO    : Updated Thermal Rating: on transformer 2614-2621 : Rate A, Rate B , 0.0, 0.0 -> 2357
% INFO    : Updated Thermal Rating: on transformer 3102-3104 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3301-3303 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3301-3303 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3301-3303 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on line 3701-6402 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on line 3701-6402 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3802-3804 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3803-3805 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3803-3805 : Rate A, Rate B , 0.0, 0.0 -> 2655
% INFO    : Updated Thermal Rating: on transformer 3901-3917 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3902-3918 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3903-3923 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3904-3924 : Rate A, Rate B , 0.0, 0.0 -> 2527
% INFO    : Updated Thermal Rating: on transformer 3905-3922 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3906-3921 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3911-3925 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3920-3926 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3920-3926 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 4001-4008 : Rate A, Rate B , 0.0, 0.0 -> 4388
% INFO    : Updated Thermal Rating: on transformer 4006-4009 : Rate A, Rate B , 0.0, 0.0 -> 2675
% INFO    : Updated Thermal Rating: on transformer 4006-4009 : Rate A, Rate B , 0.0, 0.0 -> 4298
% INFO    : Updated Thermal Rating: on transformer 4007-4010 : Rate A, Rate B , 0.0, 0.0 -> 14293
% INFO    : Updated Thermal Rating: on transformer 4103-4104 : Rate A, Rate B , 0.0, 0.0 -> 3159
% INFO    : Updated Thermal Rating: on transformer 5002-5003 : Rate A, Rate B , 0.0, 0.0 -> 3159
% INFO    : Updated Thermal Rating: on transformer 6101-6102 : Rate A, Rate B , 0.0, 0.0 -> 4388
% INFO    : Updated Thermal Rating: on transformer 6103-6104 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6201-6203 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6202-6204 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6301-6303 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6302-6304 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6401-6402 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 6401-6402 : Rate A, Rate B , 0.0, 0.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 6501-6510 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6501-6510 : Rate A, Rate B , 0.0, 0.0 -> 1745
% INFO    : Updated Thermal Rating: on line 6505-6506 : Rate A, Rate B , 0.0, 0.0 -> 1620
% INFO    : Updated Thermal Rating: on transformer 8001-8003 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 8002-8005 : Rate A, Rate B , 0.0, 0.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 1002-1032 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1004-1034 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1101-1131 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1202-1232 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1301-1331 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1303-1333 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1401-1431 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2000-2030 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2100-2130 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2203-2233 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2302-2332 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2408-2438 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2503-2533 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2604-2634 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2608-2638 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2610-2630 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2611-2631 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2612-2637 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3103-3133 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3105-3135 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3204-3234 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3303-3333 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3402-3432 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3403-3433 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3501-3531 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3601-3631 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3701-3731 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3801-3831 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3805-3835 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3806-3836 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3902-3932 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3921-3931 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3923-3933 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4001-4031 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4005-4035 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4009-4039 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4101-4131 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4102-4132 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4201-4231 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4202-4232 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 5001-5031 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 5002-5032 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6102-6132 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6201-6231 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6205-6235 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6303-6333 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6305-6335 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6403-6433 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6503-6533 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 7001-7031 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 7002-7032 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 8003-8033 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 8004-8034 : Rate A, Rate B , 0.0, 0.0 -> 63175
% INFO    :
% INFO    : === Line Capacity Monotonicity Notes ===
% INFO    : Updated Thermal Rating: on line 2202-2203 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2202-2203 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2202-2503 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2203-2503 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2203-2503 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2401-2402 : Rate C - 3600.0 -> 4192
% INFO    : Updated Thermal Rating: on line 2401-2402 : Rate C - 3600.0 -> 4208
% INFO    : Updated Thermal Rating: on line 2402-2501 : Rate C - 3600.0 -> 6905
% INFO    : Updated Thermal Rating: on line 2404-3893 : Rate C - 2134.0 -> 3379
% INFO    : Updated Thermal Rating: on line 2404-3895 : Rate C - 2134.0 -> 3379
% INFO    : Updated Thermal Rating: on line 2404-3897 : Rate C - 2100.0 -> 3761
% INFO    : Updated Thermal Rating: on line 2407-2408 : Rate C - 2320.0 -> 2478
% INFO    : Updated Thermal Rating: on line 2408-2502 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2409-2502 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2409-2503 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2502-2503 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 2502-2503 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3101-3102 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3101-3102 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3102-3103 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3102-3103 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3102-3103 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3102-3302 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3103-3204 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3103-3204 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3103-3305 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3103-3305 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3104-3105 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3201-3202 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3201-3202 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3201-3203 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3201-3203 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3201-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3201-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3201-3924 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3201-3924 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3202-3203 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3202-3203 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3202-3204 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3202-3205 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3202-3924 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3202-3924 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3203-3204 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3203-3303 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3203-3303 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3203-3305 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3203-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3203-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3204-3205 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3204-3205 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3204-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3204-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3205-3914 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3205-3915 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3302-3304 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3302-3304 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3303-3304 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3303-3304 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3303-3304 : Rate B, Rate C - 1120.0, 1120.0 -> 2478, 2478
% INFO    : Updated Thermal Rating: on line 3303-3918 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3303-3918 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3305-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3401-3402 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3401-3402 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3401-3404 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3401-3405 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3401-3405 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3401-3804 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3403-3404 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3403-3804 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3404-3804 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3404-3804 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3404-3917 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3404-3918 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3405-3907 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3405-3907 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3501-3914 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3501-3915 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3601-3925 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3701-3926 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3701-3926 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3803-3891 : Rate C - 2450.0 -> 3166
% INFO    : Updated Thermal Rating: on line 3803-3892 : Rate C - 2134.0 -> 3379
% INFO    : Updated Thermal Rating: on line 3803-3894 : Rate C - 2134.0 -> 3347
% INFO    : Updated Thermal Rating: on line 3803-3896 : Rate C - 2134.0 -> 3379
% INFO    : Updated Thermal Rating: on line 3803-3901 : Rate C - 1560.0 -> 2138
% INFO    : Updated Thermal Rating: on line 3804-3806 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3805-3806 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3901-8002 : Rate C - 1800.0 -> 2374
% INFO    : Updated Thermal Rating: on line 3903-3904 : Rate C - 2450.0 -> 2877
% INFO    : Updated Thermal Rating: on line 3907-3908 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3907-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3908-3920 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3909-3919 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3909-3920 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3913-3920 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3913-3920 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3913-3923 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3915-3924 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3919-3922 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 3920-3922 : Rate B, Rate C - 986.0, 986.0 -> 1089, 1089
% INFO    : Updated Thermal Rating: on line 4001-4204 : Rate C - 2400.0 -> 12565
% INFO    : Updated Thermal Rating: on line 4002-4090 : Rate C - 2000.0 -> 13256
% INFO    : Updated Thermal Rating: on line 4002-4091 : Rate C - 2000.0 -> 3044
% INFO    : Updated Thermal Rating: on line 4004-4091 : Rate C - 3450.0 -> 4280
% INFO    : Updated Thermal Rating: on line 4005-4006 : Rate C - 2175.0 -> 6995
% INFO    : Updated Thermal Rating: on line 4005-4006 : Rate C - 2175.0 -> 7076
% INFO    : Updated Thermal Rating: on line 4006-4007 : Rate C - 3450.0 -> 105233
% INFO    : Updated Thermal Rating: on line 4006-4007 : Rate C - 3450.0 -> 105233
% INFO    : Updated Thermal Rating: on line 4009-4010 : Rate C - 3020.0 -> 24088
% INFO    : Updated Thermal Rating: on line 4009-4010 : Rate C - 3020.0 -> 27195
% INFO    : Updated Thermal Rating: on line 4092-4093 : Rate C - 2400.0 -> 19144
% INFO    : Updated Thermal Rating: on line 4093-4094 : Rate C - 2400.0 -> 2501
% INFO    : Updated Thermal Rating: on line 4095-4096 : Rate C - 2000.0 -> 19144
% INFO    : Updated Thermal Rating: on line 4096-4097 : Rate C - 2000.0 -> 2501
% INFO    : Updated Thermal Rating: on line 4202-4203 : Rate C - 3020.0 -> 17775
% INFO    : Updated Thermal Rating: on line 4203-4204 : Rate C - 2400.0 -> 2491
% INFO    : Updated Thermal Rating: on line 6102-6301 : Rate C - 2000.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6103-6301 : Rate C - 2000.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6103-6301 : Rate C - 2000.0 -> 6867
% INFO    : Updated Thermal Rating: on line 6302-7001 : Rate C - 2000.0 -> 6867
% INFO    : Updated Thermal Rating: on line 7001-7002 : Rate C - 2000.0 -> 6867
% INFO    : Updated Thermal Rating: on transformer 1001-1002 : Rate C - 747.0 -> 2872
% INFO    : Updated Thermal Rating: on transformer 1001-1002 : Rate C - 747.0 -> 2872
% INFO    : Updated Thermal Rating: on transformer 1002-1003 : Rate C - 747.0 -> 2289
% INFO    : Updated Thermal Rating: on transformer 1002-1003 : Rate C - 747.0 -> 2272
% INFO    : Updated Thermal Rating: on transformer 1101-1102 : Rate C - 747.0 -> 2164
% INFO    : Updated Thermal Rating: on transformer 1101-1102 : Rate C - 747.0 -> 2164
% INFO    : Updated Thermal Rating: on transformer 1302-1303 : Rate C - 747.0 -> 4388
% INFO    : Updated Thermal Rating: on transformer 1401-1403 : Rate C - 747.0 -> 2289
% INFO    : Updated Thermal Rating: on transformer 2100-2400 : Rate C - 747.0 -> 2289
% INFO    : Updated Thermal Rating: on transformer 2201-2202 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2201-2202 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2301-2302 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2301-2302 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2402-2409 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2404-2411 : Rate C - 747.0 -> 2750
% INFO    : Updated Thermal Rating: on transformer 2404-2411 : Rate C - 747.0 -> 2750
% INFO    : Updated Thermal Rating: on transformer 2404-2411 : Rate C - 747.0 -> 2750
% INFO    : Updated Thermal Rating: on line 2405-2619 : Rate C - 747.0 -> 27468
% INFO    : Updated Thermal Rating: on transformer 2501-2502 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2501-2502 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2501-2502 : Rate C - 747.0 -> 6318
% INFO    : Updated Thermal Rating: on transformer 2601-2612 : Rate C - 747.0 -> 2279
% INFO    : Updated Thermal Rating: on transformer 2602-2615 : Rate C - 747.0 -> 2279
% INFO    : Updated Thermal Rating: on transformer 2602-2615 : Rate C - 747.0 -> 2279
% INFO    : Updated Thermal Rating: on transformer 2603-2607 : Rate C - 747.0 -> 1351
% INFO    : Updated Thermal Rating: on transformer 2605-2621 : Rate C - 747.0 -> 2117
% INFO    : Updated Thermal Rating: on transformer 2606-2621 : Rate C - 747.0 -> 2117
% INFO    : Updated Thermal Rating: on transformer 2614-2621 : Rate C - 747.0 -> 2375
% INFO    : Updated Thermal Rating: on transformer 2614-2621 : Rate C - 747.0 -> 2357
% INFO    : Updated Thermal Rating: on transformer 3102-3104 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3301-3303 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3301-3303 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3301-3303 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on line 3701-6402 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on line 3701-6402 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3802-3804 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3803-3805 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3803-3805 : Rate C - 747.0 -> 2655
% INFO    : Updated Thermal Rating: on transformer 3901-3917 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3902-3918 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3903-3923 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3904-3924 : Rate C - 747.0 -> 2527
% INFO    : Updated Thermal Rating: on transformer 3905-3922 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3906-3921 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 3911-3925 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3920-3926 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 3920-3926 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 4001-4008 : Rate C - 747.0 -> 4388
% INFO    : Updated Thermal Rating: on transformer 4006-4009 : Rate C - 747.0 -> 2675
% INFO    : Updated Thermal Rating: on transformer 4006-4009 : Rate C - 747.0 -> 4298
% INFO    : Updated Thermal Rating: on transformer 4007-4010 : Rate C - 747.0 -> 14293
% INFO    : Updated Thermal Rating: on transformer 4103-4104 : Rate C - 747.0 -> 3159
% INFO    : Updated Thermal Rating: on transformer 5002-5003 : Rate C - 747.0 -> 3159
% INFO    : Updated Thermal Rating: on transformer 6101-6102 : Rate C - 747.0 -> 4388
% INFO    : Updated Thermal Rating: on transformer 6103-6104 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6201-6203 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6202-6204 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6301-6303 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6302-6304 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6401-6402 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 6401-6402 : Rate C - 747.0 -> 1056
% INFO    : Updated Thermal Rating: on transformer 6501-6510 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on transformer 6501-6510 : Rate C - 747.0 -> 1745
% INFO    : Updated Thermal Rating: on line 6505-6506 : Rate C - 747.0 -> 1620
% INFO    : Updated Thermal Rating: on transformer 8001-8003 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 8002-8005 : Rate C - 747.0 -> 1816
% INFO    : Updated Thermal Rating: on transformer 1002-1032 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1004-1034 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1101-1131 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1202-1232 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1301-1331 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1303-1333 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 1401-1431 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2000-2030 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2100-2130 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2203-2233 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2302-2332 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2408-2438 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2503-2533 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2604-2634 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2608-2638 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2610-2630 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2611-2631 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 2612-2637 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3103-3133 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3105-3135 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3204-3234 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3303-3333 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3402-3432 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3403-3433 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3501-3531 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3601-3631 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3701-3731 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3801-3831 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3805-3835 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3806-3836 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3902-3932 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3921-3931 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 3923-3933 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4001-4031 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4005-4035 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4009-4039 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4101-4131 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4102-4132 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4201-4231 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 4202-4232 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 5001-5031 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 5002-5032 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6102-6132 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6201-6231 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6205-6235 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6303-6333 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6305-6335 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6403-6433 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 6503-6533 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 7001-7031 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 7002-7032 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 8003-8033 : Rate C - 747.0 -> 63175
% INFO    : Updated Thermal Rating: on transformer 8004-8034 : Rate C - 747.0 -> 63175
% INFO    :
% INFO    : === Voltage Setpoint Replacement Notes ===
% INFO    : Bus 1001	: V=1.02984, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1002	: V=1.014, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1003	: V=0.97318, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1004	: V=1.06648, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1032	: V=1.01659, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1034	: V=1.07305, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1101	: V=1.01, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1102	: V=0.97727, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1131	: V=1.01126, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1201	: V=1.08433, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1202	: V=1.08, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1232	: V=1.0807, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1301	: V=1.045, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1302	: V=1.02783, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1303	: V=1.005, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1331	: V=1.04552, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1333	: V=1.00803, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1401	: V=1.035, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1402	: V=1.05631, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1403	: V=1.03567, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 1431	: V=1.04034, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2000	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2030	: V=1.00143, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2100	: V=1.03405, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2130	: V=1.03491, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2201	: V=0.98831, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2202	: V=0.98575, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2203	: V=1.005, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2233	: V=1.00732, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2301	: V=1.03448, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2302	: V=1.035, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2332	: V=1.03543, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2400	: V=1.0205, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2401	: V=1.02999, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2402	: V=1.01312, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2403	: V=1.0129, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2404	: V=1.01543, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2405	: V=1.01124, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2406	: V=1.00189, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2407	: V=0.96838, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2408	: V=1.009, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2409	: V=1.00678, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2410	: V=1.00274, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2411	: V=1.00888, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2438	: V=1.01283, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2501	: V=1.00884, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2502	: V=1.00515, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2503	: V=1.009, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2533	: V=1.01077, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2600	: V=1.04252, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2601	: V=1.0403, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2602	: V=1.01689, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2603	: V=1.0427, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2604	: V=1.06, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2605	: V=1.01617, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2606	: V=1.01617, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2607	: V=1.03742, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2608	: V=1.02295, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2609	: V=0.99753, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2610	: V=1.004, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2611	: V=1.02086, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2612	: V=1.015, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2613	: V=0.99259, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2614	: V=0.99908, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2615	: V=1.00325, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2616	: V=0.9943, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2617	: V=0.99561, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2618	: V=1.01246, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2619	: V=1.01337, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2620	: V=1.00929, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2621	: V=1.00909, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2630	: V=1.00498, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2631	: V=1.0215, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2634	: V=1.06065, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2637	: V=1.01545, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2638	: V=1.02336, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2901	: V=1.09191, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 2902	: V=1.09971, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3101	: V=0.98526, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3102	: V=0.9905, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3103	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3104	: V=0.98667, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3105	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3133	: V=1.00118, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3135	: V=1.00047, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3201	: V=1.00705, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3202	: V=1.00507, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3203	: V=1.00164, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3204	: V=1.01, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3205	: V=1.0019, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3234	: V=1.01185, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3301	: V=0.99283, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3302	: V=0.98505, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3303	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3304	: V=0.98953, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3305	: V=0.99781, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3333	: V=1.00266, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3401	: V=0.9703, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3402	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3403	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3404	: V=0.97523, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3405	: V=0.95898, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3432	: V=1.00095, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3433	: V=1.00072, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3501	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3531	: V=1.00035, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3601	: V=1.015, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3631	: V=1.01483, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3701	: V=1.004, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3731	: V=1.00499, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3801	: V=1.049, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3802	: V=1.00676, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3803	: V=1.02038, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3804	: V=0.98982, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3805	: V=1.035, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3806	: V=1.019, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3831	: V=1.05081, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3835	: V=1.03719, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3836	: V=1.0192, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3891	: V=1.04164, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3892	: V=1.01052, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3893	: V=1.02256, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3894	: V=1.01028, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3895	: V=1.02289, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3896	: V=1.01089, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3897	: V=1.02386, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3901	: V=0.93761, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3902	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3903	: V=1.00147, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3904	: V=1.08142, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3905	: V=1.03509, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3906	: V=1.06427, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3907	: V=0.9615, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3908	: V=0.96379, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3909	: V=0.96839, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3910	: V=0.97886, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3911	: V=1.03652, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3912	: V=1.02038, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3913	: V=0.978, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3914	: V=0.99051, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3915	: V=1.00124, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3916	: V=1.01995, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3917	: V=0.94562, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3918	: V=0.99024, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3919	: V=0.97393, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3920	: V=0.9771, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3921	: V=1.07, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3922	: V=0.99452, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3923	: V=1.012, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3924	: V=1.02114, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3925	: V=1.0268, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3926	: V=0.98959, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3931	: V=1.07075, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3932	: V=1.00337, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 3933	: V=1.01339, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4001	: V=1.08, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4002	: V=1.14175, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4003	: V=1.20872, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4004	: V=1.11615, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4005	: V=1.121, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4006	: V=1.1101, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4007	: V=1.10993, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4008	: V=1.06829, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4009	: V=1.10948, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4010	: V=1.10915, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4031	: V=1.08102, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4035	: V=1.126, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4039	: V=1.11258, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4090	: V=1.13412, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4091	: V=1.13015, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4092	: V=1.09959, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4093	: V=1.09844, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4094	: V=1.11332, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4095	: V=1.0981, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4096	: V=1.09693, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4097	: V=1.1127, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4101	: V=1.128, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4102	: V=1.096, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4103	: V=1.09056, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4104	: V=1.06153, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4131	: V=1.13184, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4132	: V=1.09413, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4201	: V=1.12, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4202	: V=1.08, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4203	: V=1.03563, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4204	: V=1.07149, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4231	: V=1.12648, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 4232	: V=1.08376, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 5001	: V=1.05, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 5002	: V=1.055, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 5003	: V=1.0482, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 5004	: V=1.05346, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 5031	: V=1.05527, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 5032	: V=1.06129, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6101	: V=1.16458, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6102	: V=1.13, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6103	: V=1.09911, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6104	: V=1.03189, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6132	: V=1.1286, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6201	: V=1.12, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6202	: V=1.144, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6203	: V=1.11276, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6204	: V=1.16459, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6205	: V=1.21767, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6231	: V=1.11876, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6235	: V=1.21683, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6301	: V=1.1068, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6302	: V=0.98175, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6303	: V=1.13, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6304	: V=0.95069, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6305	: V=1.06, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6333	: V=1.13399, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6335	: V=1.06168, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6401	: V=0.98376, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6402	: V=0.98962, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6403	: V=1.11, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6404	: V=1.06825, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6433	: V=1.11155, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6501	: V=1.03619, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6502	: V=1.03772, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6503	: V=1.065, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6504	: V=1.03989, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6505	: V=1.06709, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6506	: V=1.05691, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6507	: V=1.04416, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6508	: V=1.03611, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6509	: V=1.03741, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6510	: V=1.00043, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 6533	: V=1.06674, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 7001	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 7002	: V=1.015, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 7031	: V=1.00629, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 7032	: V=1.01616, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8001	: V=1.11369, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8002	: V=1.20872, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8003	: V=1.075, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8004	: V=1.0, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8005	: V=1.09554, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8033	: V=1.07493, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 8034	: V=1.00328, theta=0.0 -> V=1.0, theta=0.0
% INFO    :
% INFO    : === Generator Setpoint Replacement Notes ===
% INFO    : Gen at bus 1032	: Pg=1825.0, Qg=398.34 -> Pg=1030.0, Qg=0.0
% INFO    : Gen at bus 1032	: Vg=1.014 -> Vg=1.0
% INFO    : Gen at bus 1032	: Pg=262.8, Qg=138.07 -> Pg=357.0, Qg=0.0
% INFO    : Gen at bus 1032	: Vg=1.014 -> Vg=1.0
% INFO    : Gen at bus 1034	: Pg=4064.0, Qg=887.19 -> Pg=2293.5, Qg=0.0
% INFO    : Gen at bus 1034	: Vg=1.014 -> Vg=1.0
% INFO    : Gen at bus 1034	: Pg=1402.0, Qg=355.03 -> Pg=917.5, Qg=0.0
% INFO    : Gen at bus 1034	: Vg=1.014 -> Vg=1.0
% INFO    : Gen at bus 1034	: Pg=1370.0, Qg=270.72 -> Pg=700.0, Qg=0.0
% INFO    : Gen at bus 1034	: Vg=1.014 -> Vg=1.0
% INFO    : Gen at bus 1131	: Pg=545.0, Qg=34.69 -> Pg=307.5, Qg=0.0
% INFO    : Gen at bus 1131	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 1131	: Pg=1287.15, Qg=215.79 -> Pg=1915.4, Qg=0.0
% INFO    : Gen at bus 1131	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 1131	: Pg=48.0, Qg=13.52 -> Pg=120.0, Qg=0.0
% INFO    : Gen at bus 1131	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 1232	: Pg=2140.0, Qg=115.89 -> Pg=1207.5, Qg=0.0
% INFO    : Gen at bus 1232	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 1232	: Pg=1244.4, Qg=60.25 -> Pg=628.0, Qg=0.0
% INFO    : Gen at bus 1232	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 1331	: Pg=1682.0, Qg=60.55 -> Pg=841.0, Qg=0.0
% INFO    : Gen at bus 1331	: Vg=1.045 -> Vg=1.0
% INFO    : Gen at bus 1331	: Pg=2438.0, Qg=87.76 -> Pg=1219.0, Qg=0.0
% INFO    : Gen at bus 1331	: Vg=1.045 -> Vg=1.0
% INFO    : Gen at bus 1333	: Pg=536.0, Qg=66.45 -> Pg=302.5, Qg=0.0
% INFO    : Gen at bus 1333	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 1333	: Pg=4534.44, Qg=602.24 -> Pg=2745.5, Qg=0.0
% INFO    : Gen at bus 1333	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 1333	: Pg=75.0, Qg=8.33 -> Pg=37.5, Qg=0.0
% INFO    : Gen at bus 1333	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 1431	: Pg=5012.16, Qg=817.62 -> Pg=3559.35, Qg=0.0
% INFO    : Gen at bus 1431	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 1431	: Pg=3825.0, Qg=472.56 -> Pg=2056.5, Qg=0.0
% INFO    : Gen at bus 1431	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 1431	: Pg=30.0, Qg=3.45 -> Pg=15.0, Qg=0.0
% INFO    : Gen at bus 1431	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 2030	: Pg=1829.04, Qg=227.48 -> Pg=1070.0, Qg=0.0
% INFO    : Gen at bus 2030	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 2030	: Pg=629.0, Qg=74.41 -> Pg=349.5, Qg=0.0
% INFO    : Gen at bus 2030	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 2130	: Pg=171.4, Qg=45.95 -> Pg=200.0, Qg=0.0
% INFO    : Gen at bus 2130	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 2130	: Pg=507.0, Qg=58.35 -> Pg=253.5, Qg=0.0
% INFO    : Gen at bus 2130	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 2130	: Pg=477.8, Qg=57.43 -> Pg=250.0, Qg=0.0
% INFO    : Gen at bus 2130	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 2130	: Pg=172.0, Qg=19.76 -> Pg=86.0, Qg=0.0
% INFO    : Gen at bus 2130	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 2233	: Pg=418.71, Qg=127.19 -> Pg=353.0, Qg=93.0
% INFO    : Gen at bus 2233	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 2233	: Pg=344.13, Qg=255.64 -> Pg=626.5, Qg=215.0
% INFO    : Gen at bus 2233	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 2233	: Pg=231.0, Qg=86.19 -> Pg=250.0, Qg=25.5
% INFO    : Gen at bus 2233	: Vg=1.005 -> Vg=1.0
% INFO    : Gen at bus 2332	: Pg=878.0, Qg=91.48 -> Pg=559.0, Qg=113.0
% INFO    : Gen at bus 2332	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=1043.27, Qg=77.83 -> Pg=781.5, Qg=137.0
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=1816.96, Qg=203.33 -> Pg=1859.0, Qg=367.0
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=761.99, Qg=245.98 -> Pg=1401.5, Qg=624.0
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=670.0, Qg=70.45 -> Pg=670.0, Qg=68.0
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=473.0, Qg=46.61 -> Pg=473.0, Qg=119.5
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=255.0, Qg=59.97 -> Pg=636.5, Qg=4.0
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=2316.2, Qg=204.18 -> Pg=1983.5, Qg=380.0
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2438	: Pg=0.0, Qg=0.0 -> Pg=-503.0, Qg=0.25
% INFO    : Gen at bus 2438	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2533	: Pg=2076.0, Qg=367.95 -> Pg=1116.0, Qg=140.0
% INFO    : Gen at bus 2533	: Vg=1.009 -> Vg=1.0
% INFO    : Gen at bus 2630	: Pg=2281.8, Qg=209.93 -> Pg=1346.0, Qg=0.0
% INFO    : Gen at bus 2630	: Vg=1.004 -> Vg=1.0
% INFO    : Gen at bus 2631	: Pg=232.31, Qg=131.92 -> Pg=159.0, Qg=0.0
% INFO    : Gen at bus 2631	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 2634	: Pg=1683.0, Qg=145.08 -> Pg=950.0, Qg=0.0
% INFO    : Gen at bus 2634	: Vg=1.06 -> Vg=1.0
% INFO    : Gen at bus 2637	: Pg=110.0, Qg=91.26 -> Pg=55.0, Qg=0.0
% INFO    : Gen at bus 2637	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 2638	: Pg=0.0, Qg=82.97 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 2638	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 3133	: Pg=30.8, Qg=18.29 -> Pg=21.0, Qg=6.5
% INFO    : Gen at bus 3133	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3133	: Pg=0.0, Qg=217.73 -> Pg=0.05, Qg=0.0
% INFO    : Gen at bus 3133	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3135	: Pg=173.0, Qg=65.81 -> Pg=184.5, Qg=19.0
% INFO    : Gen at bus 3135	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3135	: Pg=19.6, Qg=27.54 -> Pg=13.0, Qg=7.5
% INFO    : Gen at bus 3135	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3234	: Pg=73.6, Qg=21.79 -> Pg=60.5, Qg=13.0
% INFO    : Gen at bus 3234	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 3234	: Pg=1864.0, Qg=268.34 -> Pg=1314.0, Qg=5.0
% INFO    : Gen at bus 3234	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 3234	: Pg=294.4, Qg=82.4 -> Pg=353.5, Qg=85.0
% INFO    : Gen at bus 3234	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 3234	: Pg=138.0, Qg=16.18 -> Pg=345.0, Qg=10.0
% INFO    : Gen at bus 3234	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 3333	: Pg=674.8, Qg=354.54 -> Pg=345.0, Qg=86.0
% INFO    : Gen at bus 3333	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3333	: Pg=136.4, Qg=179.94 -> Pg=106.5, Qg=29.5
% INFO    : Gen at bus 3333	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3432	: Pg=0.0, Qg=190.76 -> Pg=147.0, Qg=102.0
% INFO    : Gen at bus 3432	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3433	: Pg=42.04, Qg=29.16 -> Pg=314.0, Qg=28.0
% INFO    : Gen at bus 3433	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3433	: Pg=1008.0, Qg=118.53 -> Pg=1008.0, Qg=188.5
% INFO    : Gen at bus 3433	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3531	: Pg=781.0, Qg=58.43 -> Pg=434.0, Qg=202.5
% INFO    : Gen at bus 3531	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3531	: Pg=293.0, Qg=14.72 -> Pg=162.5, Qg=36.0
% INFO    : Gen at bus 3531	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3531	: Pg=15.0, Qg=0.76 -> Pg=15.0, Qg=1.5
% INFO    : Gen at bus 3531	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3631	: Pg=45.0, Qg=-9.82 -> Pg=26.5, Qg=3.0
% INFO    : Gen at bus 3631	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 3631	: Pg=52.4, Qg=-23.84 -> Pg=71.5, Qg=20.0
% INFO    : Gen at bus 3631	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 3731	: Pg=222.0, Qg=200.03 -> Pg=127.5, Qg=39.5
% INFO    : Gen at bus 3731	: Vg=1.004 -> Vg=1.0
% INFO    : Gen at bus 3831	: Pg=2108.0, Qg=390.23 -> Pg=1133.5, Qg=97.5
% INFO    : Gen at bus 3831	: Vg=1.049 -> Vg=1.0
% INFO    : Gen at bus 3835	: Pg=279.2, Qg=453.76 -> Pg=690.5, Qg=91.5
% INFO    : Gen at bus 3835	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 3835	: Pg=0.0, Qg=0.0 -> Pg=-255.0, Qg=0.25
% INFO    : Gen at bus 3835	: Vg=1.035 -> Vg=1.0
% INFO    : Gen at bus 3836	: Pg=679.0, Qg=42.71 -> Pg=510.5, Qg=62.0
% INFO    : Gen at bus 3836	: Vg=1.019 -> Vg=1.0
% INFO    : Gen at bus 3931	: Pg=267.0, Qg=17.39 -> Pg=157.0, Qg=18.0
% INFO    : Gen at bus 3931	: Vg=1.07 -> Vg=1.0
% INFO    : Gen at bus 3931	: Pg=1057.0, Qg=147.9 -> Pg=1848.0, Qg=169.0
% INFO    : Gen at bus 3931	: Vg=1.07 -> Vg=1.0
% INFO    : Gen at bus 3932	: Pg=1478.0, Qg=682.25 -> Pg=739.0, Qg=325.0
% INFO    : Gen at bus 3932	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 3933	: Pg=555.2, Qg=54.04 -> Pg=295.0, Qg=140.5
% INFO    : Gen at bus 3933	: Vg=1.012 -> Vg=1.0
% INFO    : Gen at bus 3933	: Pg=162.0, Qg=11.46 -> Pg=95.5, Qg=11.0
% INFO    : Gen at bus 3933	: Vg=1.012 -> Vg=1.0
% INFO    : Gen at bus 3933	: Pg=154.8, Qg=74.44 -> Pg=657.0, Qg=96.5
% INFO    : Gen at bus 3933	: Vg=1.012 -> Vg=1.0
% INFO    : Gen at bus 3933	: Pg=3467.0, Qg=186.98 -> Pg=1752.5, Qg=107.5
% INFO    : Gen at bus 3933	: Vg=1.012 -> Vg=1.0
% INFO    : Gen at bus 3933	: Pg=59.0, Qg=1.94 -> Pg=146.5, Qg=1.0
% INFO    : Gen at bus 3933	: Vg=1.012 -> Vg=1.0
% INFO    : Gen at bus 3933	: Pg=0.0, Qg=0.0 -> Pg=-224.5, Qg=0.25
% INFO    : Gen at bus 3933	: Vg=1.012 -> Vg=1.0
% INFO    : Gen at bus 4039	: Pg=185.2, Qg=41.01 -> Pg=102.0, Qg=0.0
% INFO    : Gen at bus 4039	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4039	: Pg=2461.43, Qg=586.55 -> Pg=1459.0, Qg=0.0
% INFO    : Gen at bus 4039	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4039	: Pg=75.0, Qg=75.58 -> Pg=187.5, Qg=0.0
% INFO    : Gen at bus 4039	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4031	: Pg=953.2, Qg=99.59 -> Pg=501.5, Qg=0.0
% INFO    : Gen at bus 4031	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 4031	: Pg=878.42, Qg=97.01 -> Pg=489.0, Qg=0.0
% INFO    : Gen at bus 4031	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 4031	: Pg=75.0, Qg=7.54 -> Pg=37.5, Qg=0.0
% INFO    : Gen at bus 4031	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 4031	: Pg=48.0, Qg=23.81 -> Pg=120.0, Qg=0.0
% INFO    : Gen at bus 4031	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 4035	: Pg=452.0, Qg=102.51 -> Pg=255.0, Qg=0.0
% INFO    : Gen at bus 4035	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4035	: Pg=445.34, Qg=123.42 -> Pg=306.5, Qg=0.0
% INFO    : Gen at bus 4035	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4035	: Pg=3075.2, Qg=738.11 -> Pg=1835.5, Qg=0.0
% INFO    : Gen at bus 4035	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4035	: Pg=195.0, Qg=196.19 -> Pg=488.0, Qg=0.0
% INFO    : Gen at bus 4035	: Vg=1.121 -> Vg=1.0
% INFO    : Gen at bus 4131	: Pg=10082.0, Qg=1050.64 -> Pg=6481.5, Qg=0.0
% INFO    : Gen at bus 4131	: Vg=1.128 -> Vg=1.0
% INFO    : Gen at bus 4131	: Pg=48.0, Qg=19.45 -> Pg=120.0, Qg=0.0
% INFO    : Gen at bus 4131	: Vg=1.128 -> Vg=1.0
% INFO    : Gen at bus 4132	: Pg=575.8, Qg=-88.3 -> Pg=1472.5, Qg=0.0
% INFO    : Gen at bus 4132	: Vg=1.096 -> Vg=1.0
% INFO    : Gen at bus 4132	: Pg=4619.0, Qg=-170.66 -> Pg=2846.5, Qg=0.0
% INFO    : Gen at bus 4132	: Vg=1.096 -> Vg=1.0
% INFO    : Gen at bus 4132	: Pg=1079.0, Qg=-34.77 -> Pg=580.0, Qg=0.0
% INFO    : Gen at bus 4132	: Vg=1.096 -> Vg=1.0
% INFO    : Gen at bus 4132	: Pg=461.0, Qg=-13.85 -> Pg=230.5, Qg=0.0
% INFO    : Gen at bus 4132	: Vg=1.096 -> Vg=1.0
% INFO    : Gen at bus 4132	: Pg=35.0, Qg=-5.27 -> Pg=87.5, Qg=0.0
% INFO    : Gen at bus 4132	: Vg=1.096 -> Vg=1.0
% INFO    : Gen at bus 4231	: Pg=1290.0, Qg=339.68 -> Pg=728.0, Qg=0.0
% INFO    : Gen at bus 4231	: Vg=1.12 -> Vg=1.0
% INFO    : Gen at bus 4231	: Pg=364.6, Qg=307.49 -> Pg=658.5, Qg=0.0
% INFO    : Gen at bus 4231	: Vg=1.12 -> Vg=1.0
% INFO    : Gen at bus 4231	: Pg=2901.8, Qg=843.61 -> Pg=1807.5, Qg=0.0
% INFO    : Gen at bus 4231	: Vg=1.12 -> Vg=1.0
% INFO    : Gen at bus 4231	: Pg=47.0, Qg=11.2 -> Pg=23.5, Qg=0.0
% INFO    : Gen at bus 4231	: Vg=1.12 -> Vg=1.0
% INFO    : Gen at bus 4232	: Pg=496.8, Qg=489.95 -> Pg=592.0, Qg=0.0
% INFO    : Gen at bus 4232	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 4232	: Pg=496.2, Qg=237.53 -> Pg=286.5, Qg=0.0
% INFO    : Gen at bus 4232	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 4232	: Pg=43.0, Qg=89.38 -> Pg=107.5, Qg=0.0
% INFO    : Gen at bus 4232	: Vg=1.08 -> Vg=1.0
% INFO    : Gen at bus 5031	: Pg=478.06, Qg=150.07 -> Pg=605.0, Qg=0.0
% INFO    : Gen at bus 5031	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 5031	: Pg=7074.88, Qg=1091.2 -> Pg=4399.4, Qg=0.0
% INFO    : Gen at bus 5031	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 5032	: Pg=5275.0, Qg=610.58 -> Pg=2977.0, Qg=0.0
% INFO    : Gen at bus 5032	: Vg=1.055 -> Vg=1.0
% INFO    : Gen at bus 5032	: Pg=1422.32, Qg=451.22 -> Pg=2200.0, Qg=0.0
% INFO    : Gen at bus 5032	: Vg=1.055 -> Vg=1.0
% INFO    : Gen at bus 5032	: Pg=3576.8, Qg=452.24 -> Pg=2205.1, Qg=0.0
% INFO    : Gen at bus 5032	: Vg=1.055 -> Vg=1.0
% INFO    : Gen at bus 5032	: Pg=108.0, Qg=11.08 -> Pg=54.0, Qg=0.0
% INFO    : Gen at bus 5032	: Vg=1.055 -> Vg=1.0
% INFO    : Gen at bus 5032	: Pg=108.0, Qg=55.58 -> Pg=270.5, Qg=0.0
% INFO    : Gen at bus 5032	: Vg=1.055 -> Vg=1.0
% INFO    : Gen at bus 6132	: Pg=13.0, Qg=-1.8 -> Pg=7.5, Qg=0.0
% INFO    : Gen at bus 6132	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6132	: Pg=203.6, Qg=-33.04 -> Pg=146.5, Qg=0.0
% INFO    : Gen at bus 6132	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6132	: Pg=1849.0, Qg=-240.98 -> Pg=1072.0, Qg=0.0
% INFO    : Gen at bus 6132	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6132	: Pg=35.0, Qg=-4.05 -> Pg=17.5, Qg=0.0
% INFO    : Gen at bus 6132	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6132	: Pg=46.0, Qg=-26.53 -> Pg=118.0, Qg=0.0
% INFO    : Gen at bus 6132	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6231	: Pg=2225.0, Qg=-253.67 -> Pg=1255.5, Qg=0.0
% INFO    : Gen at bus 6231	: Vg=1.12 -> Vg=1.0
% INFO    : Gen at bus 6231	: Pg=43.4, Qg=-14.14 -> Pg=70.0, Qg=0.0
% INFO    : Gen at bus 6231	: Vg=1.12 -> Vg=1.0
% INFO    : Gen at bus 6235	: Pg=82.0, Qg=-25.87 -> Pg=63.5, Qg=0.0
% INFO    : Gen at bus 6235	: Vg=1.144 -> Vg=1.0
% INFO    : Gen at bus 6235	: Pg=580.6, Qg=-140.28 -> Pg=346.5, Qg=0.0
% INFO    : Gen at bus 6235	: Vg=1.144 -> Vg=1.0
% INFO    : Gen at bus 6235	: Pg=38.0, Qg=-38.4 -> Pg=95.0, Qg=0.0
% INFO    : Gen at bus 6235	: Vg=1.144 -> Vg=1.0
% INFO    : Gen at bus 6333	: Pg=2961.0, Qg=859.4 -> Pg=1671.0, Qg=0.0
% INFO    : Gen at bus 6333	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6333	: Pg=50.0, Qg=63.77 -> Pg=124.0, Qg=0.0
% INFO    : Gen at bus 6333	: Vg=1.13 -> Vg=1.0
% INFO    : Gen at bus 6335	: Pg=1714.0, Qg=209.96 -> Pg=967.5, Qg=0.0
% INFO    : Gen at bus 6335	: Vg=1.06 -> Vg=1.0
% INFO    : Gen at bus 6335	: Pg=293.32, Qg=71.58 -> Pg=329.5, Qg=0.0
% INFO    : Gen at bus 6335	: Vg=1.06 -> Vg=1.0
% INFO    : Gen at bus 6335	: Pg=417.2, Qg=88.06 -> Pg=406.0, Qg=0.0
% INFO    : Gen at bus 6335	: Vg=1.06 -> Vg=1.0
% INFO    : Gen at bus 6433	: Pg=501.0, Qg=107.69 -> Pg=282.5, Qg=0.0
% INFO    : Gen at bus 6433	: Vg=1.11 -> Vg=1.0
% INFO    : Gen at bus 6433	: Pg=106.0, Qg=22.45 -> Pg=59.0, Qg=0.0
% INFO    : Gen at bus 6433	: Vg=1.11 -> Vg=1.0
% INFO    : Gen at bus 6433	: Pg=713.48, Qg=203.95 -> Pg=536.0, Qg=0.0
% INFO    : Gen at bus 6433	: Vg=1.11 -> Vg=1.0
% INFO    : Gen at bus 6433	: Pg=23.0, Qg=4.57 -> Pg=11.5, Qg=0.0
% INFO    : Gen at bus 6433	: Vg=1.11 -> Vg=1.0
% INFO    : Gen at bus 6433	: Pg=10.0, Qg=9.51 -> Pg=25.0, Qg=0.0
% INFO    : Gen at bus 6433	: Vg=1.11 -> Vg=1.0
% INFO    : Gen at bus 6533	: Pg=3408.0, Qg=278.88 -> Pg=1923.5, Qg=0.0
% INFO    : Gen at bus 6533	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 6533	: Pg=33.0, Qg=2.75 -> Pg=18.5, Qg=0.0
% INFO    : Gen at bus 6533	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 6533	: Pg=1006.6, Qg=127.55 -> Pg=880.0, Qg=0.0
% INFO    : Gen at bus 6533	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 6533	: Pg=31.2, Qg=2.9 -> Pg=19.5, Qg=0.0
% INFO    : Gen at bus 6533	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 6533	: Pg=60.4, Qg=4.49 -> Pg=30.5, Qg=0.0
% INFO    : Gen at bus 6533	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 7031	: Pg=2514.0, Qg=379.19 -> Pg=1418.5, Qg=0.0
% INFO    : Gen at bus 7031	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 7031	: Pg=2462.6, Qg=559.03 -> Pg=2092.0, Qg=0.0
% INFO    : Gen at bus 7031	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 7031	: Pg=0.0, Qg=44.63 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 7031	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 7031	: Pg=119.0, Qg=79.9 -> Pg=298.5, Qg=0.0
% INFO    : Gen at bus 7031	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 7031	: Pg=0.0, Qg=267.22 -> Pg=0.05, Qg=0.0
% INFO    : Gen at bus 7031	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 7032	: Pg=1464.0, Qg=126.68 -> Pg=826.0, Qg=0.0
% INFO    : Gen at bus 7032	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 7032	: Pg=885.6, Qg=75.0 -> Pg=489.0, Qg=0.0
% INFO    : Gen at bus 7032	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 7032	: Pg=691.0, Qg=53.07 -> Pg=345.5, Qg=0.0
% INFO    : Gen at bus 7032	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 7032	: Pg=0.0, Qg=3.53 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 7032	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 8033	: Pg=1532.4, Qg=-10.12 -> Pg=786.0, Qg=0.0
% INFO    : Gen at bus 8033	: Vg=1.075 -> Vg=1.0
% INFO    : Gen at bus 8034	: Pg=2358.8, Qg=536.88 -> Pg=1280.0, Qg=0.0
% INFO    : Gen at bus 8034	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 8034	: Pg=663.8, Qg=144.29 -> Pg=344.0, Qg=0.0
% INFO    : Gen at bus 8034	: Vg=1.0 -> Vg=1.0
% INFO    :
% INFO    : === Writing Matpower Case File Notes ===

% INFO    :
% INFO    : === PSSE-23 to Matpower Translation Notes ===
% WARNING : No voltage bounds given, using 1.1 - 0.9
% WARNING : Removing minus from to bus on branch 5 between 1002 - 6506
% WARNING : Removing minus from to bus on branch 6 between 1004 - 7001
% WARNING : Removing minus from to bus on branch 7 between 1004 - 7002
% WARNING : Removing minus from to bus on branch 18 between 1301 - 2603
% WARNING : Removing minus from to bus on branch 20 between 1303 - 6507
% WARNING : Removing minus from to bus on branch 41 between 2401 - 2603
% WARNING : Removing minus from to bus on branch 46 between 2404 - 3893
% WARNING : Removing minus from to bus on branch 47 between 2404 - 3895
% WARNING : Removing minus from to bus on branch 48 between 2404 - 3897
% WARNING : Removing minus from to bus on branch 49 between 2405 - 2406
% WARNING : Removing minus from to bus on branch 50 between 2405 - 2410
% WARNING : Removing minus from to bus on branch 51 between 2405 - 2410
% WARNING : Removing minus from to bus on branch 55 between 2408 - 2409
% WARNING : Removing minus from to bus on branch 56 between 2408 - 2409
% WARNING : Removing minus from to bus on branch 57 between 2408 - 2411
% WARNING : Removing minus from to bus on branch 60 between 2409 - 2503
% WARNING : Removing minus from to bus on branch 65 between 2901 - 2902
% WARNING : Removing minus from to bus on branch 70 between 2601 - 2603
% WARNING : Removing minus from to bus on branch 71 between 2603 - 2901
% WARNING : Removing minus from to bus on branch 81 between 2609 - 2615
% WARNING : Removing minus from to bus on branch 83 between 2610 - 2613
% WARNING : Removing minus from to bus on branch 84 between 2610 - 2613
% WARNING : Removing minus from to bus on branch 85 between 2610 - 2616
% WARNING : Removing minus from to bus on branch 87 between 2611 - 2612
% WARNING : Removing minus from to bus on branch 101 between 2614 - 2616
% WARNING : Removing minus from to bus on branch 102 between 2614 - 2616
% WARNING : Removing minus from to bus on branch 105 between 2615 - 2620
% WARNING : Removing minus from to bus on branch 129 between 3202 - 3205
% WARNING : Removing minus from to bus on branch 138 between 3204 - 3205
% WARNING : Removing minus from to bus on branch 139 between 3204 - 3205
% WARNING : Removing minus from to bus on branch 157 between 3401 - 3405
% WARNING : Removing minus from to bus on branch 158 between 3401 - 3405
% WARNING : Removing minus from to bus on branch 164 between 3404 - 3917
% WARNING : Removing minus from to bus on branch 165 between 3404 - 3918
% WARNING : Removing minus from to bus on branch 173 between 3801 - 3802
% WARNING : Removing minus from to bus on branch 177 between 3802 - 3901
% WARNING : Removing minus from to bus on branch 178 between 3803 - 3891
% WARNING : Removing minus from to bus on branch 183 between 3804 - 3806
% WARNING : Removing minus from to bus on branch 184 between 3805 - 3806
% WARNING : Removing minus from to bus on branch 188 between 3901 - 3902
% WARNING : Removing minus from to bus on branch 189 between 3901 - 3903
% WARNING : Removing minus from to bus on branch 190 between 3901 - 8002
% WARNING : Removing minus from to bus on branch 204 between 3910 - 3911
% WARNING : Removing minus from to bus on branch 219 between 3915 - 3924
% WARNING : Removing minus from to bus on branch 222 between 3920 - 3922
% WARNING : Removing minus from to bus on branch 225 between 4001 - 4204
% WARNING : Removing minus from to bus on branch 227 between 4001 - 4094
% WARNING : Removing minus from to bus on branch 228 between 4001 - 4097
% WARNING : Removing minus from to bus on branch 230 between 4002 - 4003
% WARNING : Removing minus from to bus on branch 231 between 4002 - 4090
% WARNING : Removing minus from to bus on branch 232 between 4002 - 4091
% WARNING : Removing minus from to bus on branch 234 between 4004 - 4005
% WARNING : Removing minus from to bus on branch 235 between 4004 - 4005
% WARNING : Removing minus from to bus on branch 236 between 4004 - 4005
% WARNING : Removing minus from to bus on branch 242 between 4005 - 4102
% WARNING : Removing minus from to bus on branch 243 between 4005 - 4102
% WARNING : Removing minus from to bus on branch 244 between 4005 - 4202
% WARNING : Removing minus from to bus on branch 248 between 4006 - 4202
% WARNING : Removing minus from to bus on branch 249 between 4008 - 6401
% WARNING : Removing minus from to bus on branch 257 between 4101 - 4102
% WARNING : Removing minus from to bus on branch 258 between 4101 - 4102
% WARNING : Removing minus from to bus on branch 259 between 4101 - 4103
% WARNING : Removing minus from to bus on branch 261 between 4101 - 4201
% WARNING : Removing minus from to bus on branch 262 between 4101 - 4201
% WARNING : Removing minus from to bus on branch 263 between 4102 - 4201
% WARNING : Removing minus from to bus on branch 264 between 4102 - 4201
% WARNING : Removing minus from to bus on branch 265 between 4102 - 4202
% WARNING : Removing minus from to bus on branch 266 between 4102 - 4202
% WARNING : Removing minus from to bus on branch 268 between 4103 - 6202
% WARNING : Removing minus from to bus on branch 270 between 4201 - 4202
% WARNING : Removing minus from to bus on branch 276 between 6102 - 6103
% WARNING : Removing minus from to bus on branch 278 between 6102 - 6403
% WARNING : Removing minus from to bus on branch 281 between 6103 - 6501
% WARNING : Removing minus from to bus on branch 282 between 6103 - 6501
% WARNING : Removing minus from to bus on branch 285 between 6201 - 6202
% WARNING : Removing minus from to bus on branch 286 between 6203 - 6205
% WARNING : Removing minus from to bus on branch 287 between 6204 - 6205
% WARNING : Removing minus from to bus on branch 297 between 6401 - 6403
% WARNING : Removing minus from to bus on branch 298 between 6401 - 6403
% WARNING : Removing minus from to bus on branch 300 between 6403 - 6404
% WARNING : Removing minus from to bus on branch 302 between 6501 - 6502
