%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%                                                                  %%%%%
%%%%    IEEE PES Power Grid Library - Optimal Power Flow - v21.07     %%%%%
%%%%          (https://github.com/power-grid-lib/pglib-opf)           %%%%%
%%%%               Benchmark Group - Typical Operations               %%%%%
%%%%                         29 - July - 2021                         %%%%%
%%%%                                                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   Power flow data for IEEE 300 bus test case.
%   This data was converted from IEEE Common Data Format
%   (ieee300cdf.txt) on 20-Sep-2004 by cdf2matp, rev. 1.11
%
%   Converted from IEEE CDF file from:
%       http://www.ee.washington.edu/research/pstca/
%
%   Copyright (c) 1999 by Richard D. Christie, University of Washington
%   Electrical Engineering Licensed under the Creative Commons Attribution 4.0
%   International license, http://creativecommons.org/licenses/by/4.0/
%
%   CDF Header:
%   13/05/91 CYME INTERNATIONAL    100.0 1991 S IEEE 300-BUS TEST SYSTEM
%
function mpc = pglib_opf_case300_ieee
mpc.version = '2';
mpc.baseMVA = 100.0;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	 1	 90.0	 49.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	2	 1	 56.0	 15.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	3	 1	 20.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	4	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	5	 1	 353.0	 130.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	6	 1	 120.0	 41.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	7	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	8	 2	 63.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	9	 1	 96.0	 43.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	10	 2	 153.0	 33.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	11	 1	 83.0	 21.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	12	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	13	 1	 58.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	14	 1	 160.0	 60.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	15	 1	 126.7	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	16	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	17	 1	 561.0	 220.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	19	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	20	 2	 605.0	 120.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	21	 1	 77.0	 1.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	22	 1	 81.0	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	23	 1	 21.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	24	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	25	 1	 45.0	 12.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	26	 1	 28.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	27	 1	 69.0	 13.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	33	 1	 55.0	 6.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	34	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	35	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	36	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	37	 1	 85.0	 32.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	38	 1	 155.0	 18.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	39	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	40	 1	 46.0	 -21.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	41	 1	 86.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	42	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	43	 1	 39.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	44	 1	 195.0	 29.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	45	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	46	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	47	 1	 58.0	 11.8	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	48	 1	 41.0	 19.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	49	 1	 92.0	 26.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	51	 1	 -5.0	 5.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	52	 1	 61.0	 28.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	53	 1	 69.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	54	 1	 10.0	 1.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	55	 1	 22.0	 10.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	57	 1	 98.0	 20.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	58	 1	 14.0	 1.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	59	 1	 218.0	 106.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	60	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	61	 1	 227.0	 110.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	62	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	63	 2	 70.0	 30.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	64	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	69	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	70	 1	 56.0	 20.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	71	 1	 116.0	 38.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	72	 1	 57.0	 19.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	73	 1	 224.0	 71.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	74	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	76	 2	 208.0	 107.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	77	 1	 74.0	 28.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	78	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	79	 1	 48.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	80	 1	 28.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	81	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 1	    1.06000	    0.94000;
	84	 2	 37.0	 13.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	85	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	86	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	87	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	88	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	89	 1	 44.2	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	90	 1	 66.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	91	 2	 17.4	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	92	 2	 15.8	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	94	 1	 60.3	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	97	 1	 39.9	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	98	 2	 66.7	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	99	 1	 83.5	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	100	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	102	 1	 77.8	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	103	 1	 32.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	104	 1	 8.6	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	105	 1	 49.6	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	107	 1	 4.6	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	108	 2	 112.1	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	109	 1	 30.7	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	110	 1	 63.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	112	 1	 19.6	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	113	 1	 26.2	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	114	 1	 18.2	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	115	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	116	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	117	 1	 0.0	 0.0	 0.0	 325.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	118	 1	 14.1	 650.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	119	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	120	 1	 777.0	 215.0	 0.0	 55.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	121	 1	 535.0	 55.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	122	 1	 229.1	 11.8	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	123	 1	 78.0	 1.4	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	124	 2	 276.4	 59.3	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	125	 2	 514.8	 82.7	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	126	 1	 57.9	 5.1	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	127	 1	 380.8	 37.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	128	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	129	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	130	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	131	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	132	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	133	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	134	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	135	 1	 169.2	 41.6	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	136	 1	 55.2	 18.2	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	137	 1	 273.6	 99.8	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	138	 2	 1019.2	 135.2	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	139	 1	 595.0	 83.3	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	140	 1	 387.7	 114.7	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	141	 2	 145.0	 58.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	142	 1	 56.5	 24.5	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	143	 2	 89.5	 35.5	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	144	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	145	 1	 24.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	146	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	147	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	148	 1	 63.0	 25.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	149	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	150	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	151	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	152	 2	 17.0	 9.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	153	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	154	 1	 70.0	 5.0	 0.0	 34.5	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	155	 1	 200.0	 50.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	156	 2	 75.0	 50.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	157	 1	 123.5	 -24.3	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	158	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	159	 1	 33.0	 16.5	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	160	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	161	 1	 35.0	 15.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	162	 1	 85.0	 24.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	163	 1	 0.0	 0.4	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	164	 1	 0.0	 0.0	 0.0	 -212.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	165	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	166	 1	 0.0	 0.0	 0.0	 -103.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	167	 1	 299.9	 95.7	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	168	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	169	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	170	 2	 481.8	 205.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	171	 2	 763.6	 291.1	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	172	 1	 26.5	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	173	 1	 163.5	 43.0	 0.0	 53.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	174	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	175	 1	 176.0	 83.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	176	 2	 5.0	 4.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	177	 2	 28.0	 12.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	178	 1	 427.4	 173.6	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	179	 1	 74.0	 29.0	 0.0	 45.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	180	 1	 69.5	 49.3	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	181	 1	 73.4	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	182	 1	 240.7	 89.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	183	 1	 40.0	 4.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	184	 1	 136.8	 16.6	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	185	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	186	 2	 59.8	 24.3	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	187	 2	 59.8	 24.3	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	188	 1	 182.6	 43.6	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 2	    1.06000	    0.94000;
	189	 1	 7.0	 2.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	190	 2	 0.0	 0.0	 0.0	 -150.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	191	 2	 489.0	 53.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	192	 1	 800.0	 72.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	193	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	194	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	195	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	196	 1	 10.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	197	 1	 43.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	198	 2	 64.0	 21.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	199	 1	 35.0	 12.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	200	 1	 27.0	 12.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	201	 1	 41.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 1	    1.06000	    0.94000;
	202	 1	 38.0	 13.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	203	 1	 42.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	204	 1	 72.0	 24.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	205	 1	 0.0	 -5.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	206	 1	 12.0	 2.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	207	 1	 -21.0	 -14.2	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 1	    1.06000	    0.94000;
	208	 1	 7.0	 2.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	209	 1	 38.0	 13.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	210	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	211	 1	 96.0	 7.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	212	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	213	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 16.5	 3	    1.06000	    0.94000;
	214	 1	 22.0	 16.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	215	 1	 47.0	 26.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	216	 1	 176.0	 105.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	217	 1	 100.0	 75.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	218	 1	 131.0	 96.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	219	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	220	 2	 285.0	 100.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	221	 2	 171.0	 70.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	222	 2	 328.0	 188.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 3	    1.06000	    0.94000;
	223	 1	 428.0	 232.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	224	 1	 173.0	 99.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	225	 1	 410.0	 40.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	226	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	227	 2	 538.0	 369.0	 0.0	 0.0	 1	    1.00000	    0.00000	 27.0	 3	    1.06000	    0.94000;
	228	 1	 223.0	 148.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	229	 1	 96.0	 46.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	230	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 3	    1.06000	    0.94000;
	231	 1	 159.0	 107.0	 0.0	 -300.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	232	 1	 448.0	 143.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	233	 2	 404.0	 212.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	234	 1	 572.0	 244.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	235	 1	 269.0	 157.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	236	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 3	    1.06000	    0.94000;
	237	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	238	 2	 255.0	 149.0	 0.0	 -150.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	239	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	240	 1	 0.0	 0.0	 0.0	 -140.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	241	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 3	    1.06000	    0.94000;
	242	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 138.0	 3	    1.06000	    0.94000;
	243	 2	 8.0	 3.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	244	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	245	 1	 61.0	 30.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	246	 1	 77.0	 33.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	247	 1	 61.0	 30.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	248	 1	 29.0	 14.0	 0.0	 45.6	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	249	 1	 29.0	 14.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	250	 1	 -23.0	 -17.0	 0.0	 0.0	 1	    1.00000	    0.00000	 66.0	 3	    1.06000	    0.94000;
	281	 1	 -33.1	 -29.4	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 3	    1.06000	    0.94000;
	319	 1	 115.8	 -24.0	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	320	 1	 2.4	 -12.6	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	322	 1	 2.4	 -3.9	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	323	 1	 -14.9	 26.5	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	324	 1	 24.7	 -1.2	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	526	 1	 145.3	 -34.9	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	528	 1	 28.1	 -20.5	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	531	 1	 14.0	 2.5	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	552	 1	 -11.1	 -1.4	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	562	 1	 50.5	 17.4	 0.0	 0.0	 1	    1.00000	    0.00000	 230.0	 1	    1.06000	    0.94000;
	609	 1	 29.6	 0.6	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 1	    1.06000	    0.94000;
	664	 1	 -113.7	 76.7	 0.0	 0.0	 1	    1.00000	    0.00000	 345.0	 3	    1.06000	    0.94000;
	1190	 1	 100.31	 29.17	 0.0	 0.0	 1	    1.00000	    0.00000	 86.0	 2	    1.06000	    0.94000;
	1200	 1	 -100.0	 34.17	 0.0	 0.0	 1	    1.00000	    0.00000	 86.0	 2	    1.06000	    0.94000;
	1201	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 2	    1.06000	    0.94000;
	2040	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 3	    1.06000	    0.94000;
	7001	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7002	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7003	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7011	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7012	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7017	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7023	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7024	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7039	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 20.0	 1	    1.06000	    0.94000;
	7044	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7049	 3	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7055	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7057	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7061	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7062	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7071	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 1	    1.06000	    0.94000;
	7130	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 2	    1.06000	    0.94000;
	7139	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 2	    1.06000	    0.94000;
	7166	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 2	    1.06000	    0.94000;
	9001	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 9	    1.06000	    0.94000;
	9002	 2	 4.2	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9003	 1	 2.71	 0.94	 0.14	 2.4	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9004	 1	 0.86	 0.28	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9005	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 115.0	 9	    1.06000	    0.94000;
	9006	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9007	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9012	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9021	 1	 4.75	 1.56	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9022	 1	 1.53	 0.53	 0.08	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9023	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9024	 1	 1.35	 0.47	 0.07	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9025	 1	 0.45	 0.16	 0.02	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9026	 1	 0.45	 0.16	 0.02	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9031	 1	 1.84	 0.64	 0.1	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9032	 1	 1.39	 0.48	 0.07	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9033	 1	 1.89	 0.65	 0.1	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9034	 1	 1.55	 0.54	 0.08	 1.72	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9035	 1	 1.66	 0.58	 0.09	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9036	 1	 3.03	 1.0	 0.0	 0.0	 1	    1.00000	    0.00000	 2.3	 9	    1.06000	    0.94000;
	9037	 1	 1.86	 0.64	 0.1	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9038	 1	 2.58	 0.89	 0.14	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9041	 1	 1.01	 0.35	 0.05	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9042	 1	 0.81	 0.28	 0.04	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9043	 1	 1.6	 0.52	 0.0	 0.0	 1	    1.00000	    0.00000	 2.3	 9	    1.06000	    0.94000;
	9044	 1	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9051	 2	 35.81	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 9	    1.06000	    0.94000;
	9052	 1	 30.0	 23.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 9	    1.06000	    0.94000;
	9053	 2	 26.48	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 9	    1.06000	    0.94000;
	9054	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 9	    1.06000	    0.94000;
	9055	 2	 0.0	 0.0	 0.0	 0.0	 1	    1.00000	    0.00000	 13.8	 9	    1.06000	    0.94000;
	9071	 1	 1.02	 0.35	 0.05	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9072	 1	 1.02	 0.35	 0.05	 0.0	 1	    1.00000	    0.00000	 0.6	 9	    1.06000	    0.94000;
	9121	 1	 3.8	 1.25	 0.0	 0.0	 1	    1.00000	    0.00000	 6.6	 9	    1.06000	    0.94000;
	9533	 1	 1.19	 0.41	 0.1	 0.0	 1	    1.00000	    0.00000	 2.3	 9	    1.06000	    0.94000;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin
mpc.gen = [
	8	 0.0	 0.0	 10.0	 -10.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	10	 0.0	 0.0	 20.0	 -20.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	20	 0.0	 0.0	 20.0	 -20.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	63	 0.0	 0.0	 25.0	 -25.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	76	 0.0	 23.5	 35.0	 12.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	84	 724.0	 0.0	 240.0	 -240.0	 1.0	 100.0	 1	 1448	 0.0; % COW
	91	 92.5	 41.0	 93.0	 -11.0	 1.0	 100.0	 1	 185	 0.0; % NG
	92	 180.0	 0.0	 153.0	 -153.0	 1.0	 100.0	 1	 360	 0.0; % NG
	98	 46.5	 8.5	 47.0	 -30.0	 1.0	 100.0	 1	 93	 0.0; % NG
	108	 98.5	 26.5	 77.0	 -24.0	 1.0	 100.0	 1	 197	 0.0; % NG
	119	 1020.5	 260.5	 1021.0	 -500.0	 1.0	 100.0	 1	 2041	 0.0; % NUC
	124	 160.5	 30.0	 120.0	 -60.0	 1.0	 100.0	 1	 321	 0.0; % NG
	125	 0.0	 87.5	 200.0	 -25.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	138	 0.0	 112.5	 350.0	 -125.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	141	 148.5	 12.5	 75.0	 -50.0	 1.0	 100.0	 1	 297	 0.0; % NG
	143	 400.0	 100.0	 300.0	 -100.0	 1.0	 100.0	 1	 800	 0.0; % COW
	146	 45.5	 10.0	 35.0	 -15.0	 1.0	 100.0	 1	 91	 0.0; % COW
	147	 160.0	 25.0	 100.0	 -50.0	 1.0	 100.0	 1	 320	 0.0; % NG
	149	 138.5	 12.5	 50.0	 -25.0	 1.0	 100.0	 1	 277	 0.0; % NG
	152	 303.0	 62.5	 175.0	 -50.0	 1.0	 100.0	 1	 606	 0.0; % COW
	153	 121.0	 20.0	 90.0	 -50.0	 1.0	 100.0	 1	 242	 0.0; % NG
	156	 0.0	 2.5	 15.0	 -10.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	170	 165.0	 25.0	 90.0	 -40.0	 1.0	 100.0	 1	 330	 0.0; % NG
	171	 0.0	 50.0	 150.0	 -50.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	176	 139.0	 22.5	 90.0	 -45.0	 1.0	 100.0	 1	 278	 0.0; % NG
	177	 62.5	 10.0	 35.0	 -15.0	 1.0	 100.0	 1	 125	 0.0; % NG
	185	 125.0	 15.0	 80.0	 -50.0	 1.0	 100.0	 1	 250	 0.0; % NG
	186	 1232.5	 150.0	 400.0	 -100.0	 1.0	 100.0	 1	 2465	 0.0; % COW
	187	 812.0	 150.0	 400.0	 -100.0	 1.0	 100.0	 1	 1624	 0.0; % COW
	190	 257.5	 0.0	 258.0	 -258.0	 1.0	 100.0	 1	 515	 0.0; % NG
	191	 1070.0	 0.0	 1000.0	 -1000.0	 1.0	 100.0	 1	 2140	 0.0; % COW
	198	 215.0	 0.0	 215.0	 -215.0	 1.0	 100.0	 1	 430	 0.0; % NG
	213	 144.0	 0.0	 144.0	 -144.0	 1.0	 100.0	 1	 288	 0.0; % NG
	220	 230.0	 0.0	 60.0	 -60.0	 1.0	 100.0	 1	 460	 0.0; % NG
	221	 277.0	 0.0	 277.0	 -277.0	 1.0	 100.0	 1	 554	 0.0; % NG
	222	 261.5	 0.0	 262.0	 -262.0	 1.0	 100.0	 1	 523	 0.0; % NG
	227	 218.0	 0.0	 218.0	 -218.0	 1.0	 100.0	 1	 436	 0.0; % NG
	230	 229.0	 0.0	 229.0	 -229.0	 1.0	 100.0	 1	 458	 0.0; % NG
	233	 170.5	 0.0	 171.0	 -171.0	 1.0	 100.0	 1	 341	 0.0; % NG
	236	 440.5	 0.0	 300.0	 -300.0	 1.0	 100.0	 1	 881	 0.0; % COW
	238	 133.5	 0.0	 134.0	 -134.0	 1.0	 100.0	 1	 267	 0.0; % NG
	239	 310.5	 0.0	 311.0	 -311.0	 1.0	 100.0	 1	 621	 0.0; % NG
	241	 563.5	 0.0	 564.0	 -564.0	 1.0	 100.0	 1	 1127	 0.0; % COW
	242	 106.0	 70.0	 100.0	 40.0	 1.0	 100.0	 1	 212	 0.0; % PEL
	243	 171.0	 60.0	 80.0	 40.0	 1.0	 100.0	 1	 342	 0.0; % NG
	7001	 284.0	 0.0	 210.0	 -210.0	 1.0	 100.0	 1	 568	 0.0; % NG
	7002	 335.0	 0.0	 280.0	 -280.0	 1.0	 100.0	 1	 670	 0.0; % COW
	7003	 700.5	 0.0	 420.0	 -420.0	 1.0	 100.0	 1	 1401	 0.0; % NUC
	7011	 334.0	 0.0	 100.0	 -100.0	 1.0	 100.0	 1	 668	 0.0; % COW
	7012	 313.0	 0.0	 224.0	 -224.0	 1.0	 100.0	 1	 626	 0.0; % NG
	7017	 245.0	 122.5	 245.0	 0.0	 1.0	 100.0	 1	 490	 0.0; % NG
	7023	 110.0	 55.0	 110.0	 0.0	 1.0	 100.0	 1	 220	 0.0; % NG
	7024	 271.5	 0.0	 224.0	 -224.0	 1.0	 100.0	 1	 543	 0.0; % NG
	7039	 290.0	 0.0	 200.0	 -200.0	 1.0	 100.0	 1	 580	 0.0; % PEL
	7044	 66.0	 21.0	 42.0	 0.0	 1.0	 100.0	 1	 132	 0.0; % NG
	7049	 359.0	 5.0	 10.0	 0.0	 1.0	 100.0	 1	 718	 0.0; % NUC
	7055	 79.0	 12.5	 25.0	 0.0	 1.0	 100.0	 1	 158	 0.0; % NG
	7057	 167.0	 0.0	 90.0	 -90.0	 1.0	 100.0	 1	 334	 0.0; % NG
	7061	 878.5	 0.0	 150.0	 -150.0	 1.0	 100.0	 1	 1757	 0.0; % COW
	7062	 284.0	 75.0	 150.0	 0.0	 1.0	 100.0	 1	 568	 0.0; % NG
	7071	 101.5	 43.5	 87.0	 0.0	 1.0	 100.0	 1	 203	 0.0; % NG
	7130	 863.0	 250.0	 600.0	 -100.0	 1.0	 100.0	 1	 1726	 0.0; % COW
	7139	 1012.5	 100.0	 325.0	 -125.0	 1.0	 100.0	 1	 2025	 0.0; % COW
	7166	 312.0	 50.0	 300.0	 -200.0	 1.0	 100.0	 1	 624	 0.0; % NG
	9002	 0.0	 0.0	 2.0	 -2.0	 1.0	 100.0	 1	 0	 0.0; % SYNC
	9051	 0.0	 0.0	 17.35	 -17.35	 1.0	 100.0	 1	 0	 0.0; % SYNC
	9053	 0.0	 0.015	 12.83	 -12.8	 1.0	 100.0	 1	 0	 0.0; % SYNC
	9054	 42.0	 0.0	 38.0	 -38.0	 1.0	 100.0	 1	 84	 0.0; % NG
	9055	 18.5	 0.0	 6.0	 -6.0	 1.0	 100.0	 1	 37	 0.0; % PEL
];

%% generator cost data
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  22.409835	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  46.100054	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  54.164939	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  27.238416	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  38.430722	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   7.698908	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  26.754128	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  30.597916	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  30.758666	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  19.292281	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  49.861855	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  35.842363	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  34.955965	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  22.762722	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  35.375974	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  33.868524	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  29.031265	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  28.391517	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   1.000203	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  27.278538	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  49.155710	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  24.062655	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  31.016664	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  49.721799	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  21.291665	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  31.437031	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  50.842869	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  28.010460	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  39.828572	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  35.650779	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  32.621266	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  39.657688	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  41.223312	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  39.064721	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	 116.939409	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  34.336562	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  38.274878	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  23.466762	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	   7.509959	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  26.682965	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  28.434868	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  35.126651	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  51.062397	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  29.992015	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	 103.987496	   0.000000; % PEL
	2	 0.0	 0.0	 3	   0.000000	  38.825689	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   6.843072	   0.000000; % NUC
	2	 0.0	 0.0	 3	   0.000000	  29.772562	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  62.427103	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  20.811515	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  26.507890	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  31.587517	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  29.759924	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  36.179055	   0.000000; % COW
	2	 0.0	 0.0	 3	   0.000000	  36.908367	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	   0.000000	   0.000000; % SYNC
	2	 0.0	 0.0	 3	   0.000000	  32.961473	   0.000000; % NG
	2	 0.0	 0.0	 3	   0.000000	  94.758209	   0.000000; % PEL
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	37	 9001	 6e-05	 0.00046	 0.0	 9900.0	 63230	 63230	 1.0082	 0.0	 1	 -30.0	 30.0;
	9001	 9005	 0.0008	 0.00348	 0.0	 8215	 8215	 8215	 0.0	 0.0	 1	 -30.0	 30.0;
	9001	 9006	 0.02439	 0.43682	 0.0	 68	 68	 68	 0.9668	 0.0	 1	 -30.0	 30.0;
	9001	 9012	 0.03624	 0.64898	 0.0	 46	 46	 46	 0.9796	 0.0	 1	 -30.0	 30.0;
	9005	 9051	 0.01578	 0.37486	 0.0	 79	 79	 79	 1.0435	 0.0	 1	 -30.0	 30.0;
	9005	 9052	 0.01578	 0.37486	 0.0	 79	 79	 79	 0.9391	 0.0	 1	 -30.0	 30.0;
	9005	 9053	 0.01602	 0.38046	 0.0	 78	 78	 78	 1.0435	 0.0	 1	 -30.0	 30.0;
	9005	 9054	 0.0	 0.152	 0.0	 193	 193	 193	 1.0435	 0.0	 1	 -30.0	 30.0;
	9005	 9055	 0.0	 0.8	 0.0	 37	 37	 37	 1.0435	 0.0	 1	 -30.0	 30.0;
	9006	 9007	 0.05558	 0.24666	 0.0	 117	 117	 117	 0.0	 0.0	 1	 -30.0	 30.0;
	9006	 9003	 0.11118	 0.49332	 0.0	 59	 59	 59	 0.0	 0.0	 1	 -30.0	 30.0;
	9006	 9003	 0.11118	 0.49332	 0.0	 59	 59	 59	 0.0	 0.0	 1	 -30.0	 30.0;
	9012	 9002	 0.07622	 0.43286	 0.0	 67	 67	 67	 0.0	 0.0	 1	 -30.0	 30.0;
	9012	 9002	 0.07622	 0.43286	 0.0	 67	 67	 67	 0.0	 0.0	 1	 -30.0	 30.0;
	9002	 9021	 0.0537	 0.07026	 0.0	 332	 332	 332	 0.0	 0.0	 1	 -30.0	 30.0;
	9021	 9023	 1.1068	 0.95278	 0.0	 21	 21	 21	 0.0	 0.0	 1	 -30.0	 30.0;
	9021	 9022	 0.44364	 2.8152	 0.0	 11	 11	 11	 1.0	 0.0	 1	 -30.0	 30.0;
	9002	 9024	 0.50748	 3.2202	 0.0	 9	 9	 9	 1.0	 0.0	 1	 -30.0	 30.0;
	9023	 9025	 0.66688	 3.944	 0.0	 8	 8	 8	 1.0	 0.0	 1	 -30.0	 30.0;
	9023	 9026	 0.6113	 3.6152	 0.0	 8	 8	 8	 1.0	 0.0	 1	 -30.0	 30.0;
	9007	 9071	 0.4412	 2.9668	 0.0	 10	 10	 10	 1.0	 0.0	 1	 -30.0	 30.0;
	9007	 9072	 0.30792	 2.057	 0.0	 15	 15	 15	 1.0	 0.0	 1	 -30.0	 30.0;
	9007	 9003	 0.0558	 0.24666	 0.0	 116	 116	 116	 0.0	 0.0	 1	 -30.0	 30.0;
	9003	 9031	 0.73633	 4.6724	 0.0	 7	 7	 7	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9032	 0.76978	 4.8846	 0.0	 6	 6	 6	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9033	 0.75732	 4.8056	 0.0	 7	 7	 7	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9044	 0.07378	 0.06352	 0.0	 302	 302	 302	 0.0	 0.0	 1	 -30.0	 30.0;
	9044	 9004	 0.03832	 0.02894	 0.0	 611	 611	 611	 0.0	 0.0	 1	 -30.0	 30.0;
	9004	 9041	 0.36614	 2.456	 0.0	 12	 12	 12	 1.0	 0.0	 1	 -30.0	 30.0;
	9004	 9042	 1.0593	 5.4536	 0.0	 6	 6	 6	 1.0	 0.0	 1	 -30.0	 30.0;
	9004	 9043	 0.1567	 1.6994	 0.0	 18	 18	 18	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9034	 0.13006	 1.3912	 0.0	 21	 21	 21	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9035	 0.54484	 3.4572	 0.0	 9	 9	 9	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9036	 0.15426	 1.6729	 0.0	 18	 18	 18	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9037	 0.3849	 2.5712	 0.0	 12	 12	 12	 1.0	 0.0	 1	 -30.0	 30.0;
	9003	 9038	 0.4412	 2.9668	 0.0	 10	 10	 10	 1.0	 0.0	 1	 -30.0	 30.0;
	9012	 9121	 0.23552	 0.99036	 0.0	 29	 29	 29	 0.0	 0.0	 1	 -30.0	 30.0;
	9053	 9533	 0.0	 0.75	 0.0	 40	 40	 40	 0.9583	 0.0	 1	 -30.0	 30.0;
	1	 5	 0.001	 0.006	 0.0	 4823	 4823	 4823	 0.0	 0.0	 1	 -30.0	 30.0;
	2	 6	 0.001	 0.009	 0.0	 3240	 3240	 3240	 0.0	 0.0	 1	 -30.0	 30.0;
	2	 8	 0.006	 0.027	 0.054	 1061	 1061	 1061	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 7	 0.0	 0.003	 0.0	 9778	 9778	 9778	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 19	 0.008	 0.069	 0.139	 423	 423	 423	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 150	 0.001	 0.007	 0.0	 4149	 4149	 4149	 0.0	 0.0	 1	 -30.0	 30.0;
	4	 16	 0.002	 0.019	 1.127	 1536	 1536	 1536	 0.0	 0.0	 1	 -30.0	 30.0;
	5	 9	 0.006	 0.029	 0.018	 991	 991	 991	 0.0	 0.0	 1	 -30.0	 30.0;
	7	 12	 0.001	 0.009	 0.07	 3240	 3240	 3240	 0.0	 0.0	 1	 -30.0	 30.0;
	7	 131	 0.001	 0.007	 0.014	 4149	 4149	 4149	 0.0	 0.0	 1	 -30.0	 30.0;
	8	 11	 0.013	 0.0595	 0.033	 482	 482	 482	 0.0	 0.0	 1	 -30.0	 30.0;
	8	 14	 0.013	 0.042	 0.081	 668	 668	 668	 0.0	 0.0	 1	 -30.0	 30.0;
	9	 11	 0.006	 0.027	 0.013	 1061	 1061	 1061	 0.0	 0.0	 1	 -30.0	 30.0;
	11	 13	 0.008	 0.034	 0.018	 840	 840	 840	 0.0	 0.0	 1	 -30.0	 30.0;
	12	 21	 0.002	 0.015	 0.118	 1939	 1939	 1939	 0.0	 0.0	 1	 -30.0	 30.0;
	13	 20	 0.006	 0.034	 0.016	 850	 850	 850	 0.0	 0.0	 1	 -30.0	 30.0;
	14	 15	 0.014	 0.042	 0.097	 663	 663	 663	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 37	 0.065	 0.248	 0.121	 115	 115	 115	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 89	 0.099	 0.248	 0.035	 110	 110	 110	 0.0	 0.0	 1	 -30.0	 30.0;
	15	 90	 0.096	 0.363	 0.048	 79	 79	 79	 0.0	 0.0	 1	 -30.0	 30.0;
	16	 42	 0.002	 0.022	 1.28	 1328	 1328	 1328	 0.0	 0.0	 1	 -30.0	 30.0;
	19	 21	 0.002	 0.018	 0.036	 1620	 1620	 1620	 0.0	 0.0	 1	 -30.0	 30.0;
	19	 87	 0.013	 0.08	 0.151	 362	 362	 362	 0.0	 0.0	 1	 -30.0	 30.0;
	20	 22	 0.016	 0.033	 0.015	 800	 800	 800	 0.0	 0.0	 1	 -30.0	 30.0;
	20	 27	 0.069	 0.186	 0.098	 148	 148	 148	 0.0	 0.0	 1	 -30.0	 30.0;
	21	 24	 0.004	 0.034	 0.28	 857	 857	 857	 0.0	 0.0	 1	 -30.0	 30.0;
	22	 23	 0.052	 0.111	 0.05	 240	 240	 240	 0.0	 0.0	 1	 -30.0	 30.0;
	23	 25	 0.019	 0.039	 0.018	 677	 677	 677	 0.0	 0.0	 1	 -30.0	 30.0;
	24	 319	 0.007	 0.068	 0.134	 430	 430	 430	 0.0	 0.0	 1	 -30.0	 30.0;
	25	 26	 0.036	 0.071	 0.034	 369	 369	 369	 0.0	 0.0	 1	 -30.0	 30.0;
	26	 27	 0.045	 0.12	 0.065	 229	 229	 229	 0.0	 0.0	 1	 -30.0	 30.0;
	26	 320	 0.043	 0.13	 0.014	 215	 215	 215	 0.0	 0.0	 1	 -30.0	 30.0;
	33	 34	 0.0	 0.063	 0.0	 466	 466	 466	 1.0	 0.0	 1	 -30.0	 30.0;
	33	 38	 0.0025	 0.012	 0.013	 2393	 2393	 2393	 0.0	 0.0	 1	 -30.0	 30.0;
	33	 40	 0.006	 0.029	 0.02	 991	 991	 991	 0.0	 0.0	 1	 -30.0	 30.0;
	33	 41	 0.007	 0.043	 0.026	 674	 674	 674	 0.0	 0.0	 1	 -30.0	 30.0;
	34	 42	 0.001	 0.008	 0.042	 3639	 3639	 3639	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 72	 0.012	 0.06	 0.008	 480	 480	 480	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 76	 0.006	 0.014	 0.002	 1926	 1926	 1926	 0.0	 0.0	 1	 -30.0	 30.0;
	35	 77	 0.01	 0.029	 0.003	 957	 957	 957	 0.0	 0.0	 1	 -30.0	 30.0;
	36	 88	 0.004	 0.027	 0.043	 1075	 1075	 1075	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 38	 0.008	 0.047	 0.008	 616	 616	 616	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 40	 0.022	 0.064	 0.007	 434	 434	 434	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 41	 0.01	 0.036	 0.02	 786	 786	 786	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 49	 0.017	 0.081	 0.048	 355	 355	 355	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 89	 0.102	 0.254	 0.033	 108	 108	 108	 0.0	 0.0	 1	 -30.0	 30.0;
	37	 90	 0.047	 0.127	 0.016	 217	 217	 217	 0.0	 0.0	 1	 -30.0	 30.0;
	38	 41	 0.008	 0.037	 0.02	 775	 775	 775	 0.0	 0.0	 1	 -30.0	 30.0;
	38	 43	 0.032	 0.087	 0.04	 317	 317	 317	 0.0	 0.0	 1	 -30.0	 30.0;
	39	 42	 0.0006	 0.0064	 0.404	 4564	 4564	 4564	 0.0	 0.0	 1	 -30.0	 30.0;
	40	 48	 0.026	 0.154	 0.022	 188	 188	 188	 0.0	 0.0	 1	 -30.0	 30.0;
	41	 42	 0.0	 0.029	 0.0	 1012	 1012	 1012	 1.0	 0.0	 1	 -30.0	 30.0;
	41	 49	 0.065	 0.191	 0.02	 146	 146	 146	 0.0	 0.0	 1	 -30.0	 30.0;
	41	 51	 0.031	 0.089	 0.036	 312	 312	 312	 0.0	 0.0	 1	 -30.0	 30.0;
	42	 46	 0.002	 0.014	 0.806	 2075	 2075	 2075	 0.0	 0.0	 1	 -30.0	 30.0;
	43	 44	 0.026	 0.072	 0.035	 384	 384	 384	 0.0	 0.0	 1	 -30.0	 30.0;
	43	 48	 0.095	 0.262	 0.032	 106	 106	 106	 0.0	 0.0	 1	 -30.0	 30.0;
	43	 53	 0.013	 0.039	 0.016	 714	 714	 714	 0.0	 0.0	 1	 -30.0	 30.0;
	44	 47	 0.027	 0.084	 0.039	 333	 333	 333	 0.0	 0.0	 1	 -30.0	 30.0;
	44	 54	 0.028	 0.084	 0.037	 332	 332	 332	 0.0	 0.0	 1	 -30.0	 30.0;
	45	 60	 0.007	 0.041	 0.312	 706	 706	 706	 0.0	 0.0	 1	 -30.0	 30.0;
	45	 74	 0.009	 0.054	 0.411	 536	 536	 536	 0.0	 0.0	 1	 -30.0	 30.0;
	46	 81	 0.005	 0.042	 0.69	 694	 694	 694	 0.0	 0.0	 1	 -30.0	 30.0;
	47	 73	 0.052	 0.145	 0.073	 191	 191	 191	 0.0	 0.0	 1	 -30.0	 30.0;
	47	 113	 0.043	 0.118	 0.013	 234	 234	 234	 0.0	 0.0	 1	 -30.0	 30.0;
	48	 107	 0.025	 0.062	 0.007	 439	 439	 439	 0.0	 0.0	 1	 -30.0	 30.0;
	49	 51	 0.031	 0.094	 0.043	 297	 297	 297	 0.0	 0.0	 1	 -30.0	 30.0;
	51	 52	 0.037	 0.109	 0.049	 255	 255	 255	 0.0	 0.0	 1	 -30.0	 30.0;
	52	 55	 0.027	 0.08	 0.036	 348	 348	 348	 0.0	 0.0	 1	 -30.0	 30.0;
	53	 54	 0.025	 0.073	 0.035	 381	 381	 381	 0.0	 0.0	 1	 -30.0	 30.0;
	54	 55	 0.035	 0.103	 0.047	 270	 270	 270	 0.0	 0.0	 1	 -30.0	 30.0;
	55	 57	 0.065	 0.169	 0.082	 162	 162	 162	 0.0	 0.0	 1	 -30.0	 30.0;
	57	 58	 0.046	 0.08	 0.036	 318	 318	 318	 0.0	 0.0	 1	 -30.0	 30.0;
	57	 63	 0.159	 0.537	 0.071	 53	 53	 53	 0.0	 0.0	 1	 -30.0	 30.0;
	58	 59	 0.009	 0.026	 0.005	 1067	 1067	 1067	 0.0	 0.0	 1	 -30.0	 30.0;
	59	 61	 0.002	 0.013	 0.015	 2231	 2231	 2231	 0.0	 0.0	 1	 -30.0	 30.0;
	60	 62	 0.009	 0.065	 0.485	 447	 447	 447	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 64	 0.016	 0.105	 0.203	 277	 277	 277	 0.0	 0.0	 1	 -30.0	 30.0;
	62	 144	 0.001	 0.007	 0.013	 4149	 4149	 4149	 0.0	 0.0	 1	 -30.0	 30.0;
	63	 526	 0.0265	 0.172	 0.026	 169	 169	 169	 0.0	 0.0	 1	 -30.0	 30.0;
	69	 211	 0.051	 0.232	 0.028	 124	 124	 124	 0.0	 0.0	 1	 -30.0	 30.0;
	69	 79	 0.051	 0.157	 0.023	 178	 178	 178	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 71	 0.032	 0.1	 0.062	 280	 280	 280	 0.0	 0.0	 1	 -30.0	 30.0;
	70	 528	 0.02	 0.1234	 0.028	 235	 235	 235	 0.0	 0.0	 1	 -30.0	 30.0;
	71	 72	 0.036	 0.131	 0.068	 216	 216	 216	 0.0	 0.0	 1	 -30.0	 30.0;
	71	 73	 0.034	 0.099	 0.047	 281	 281	 281	 0.0	 0.0	 1	 -30.0	 30.0;
	72	 77	 0.018	 0.087	 0.011	 331	 331	 331	 0.0	 0.0	 1	 -30.0	 30.0;
	72	 531	 0.0256	 0.193	 0.0	 151	 151	 151	 0.0	 0.0	 1	 -30.0	 30.0;
	73	 76	 0.021	 0.057	 0.03	 483	 483	 483	 0.0	 0.0	 1	 -30.0	 30.0;
	73	 79	 0.018	 0.052	 0.018	 534	 534	 534	 0.0	 0.0	 1	 -30.0	 30.0;
	74	 88	 0.004	 0.027	 0.05	 1075	 1075	 1075	 0.0	 0.0	 1	 -30.0	 30.0;
	74	 562	 0.0286	 0.2013	 0.379	 145	 145	 145	 0.0	 0.0	 1	 -30.0	 30.0;
	76	 77	 0.016	 0.043	 0.004	 640	 640	 640	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 78	 0.001	 0.006	 0.007	 4823	 4823	 4823	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 80	 0.014	 0.07	 0.038	 411	 411	 411	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 552	 0.0891	 0.2676	 0.029	 104	 104	 104	 0.0	 0.0	 1	 -30.0	 30.0;
	77	 609	 0.0782	 0.2127	 0.022	 130	 130	 130	 0.0	 0.0	 1	 -30.0	 30.0;
	78	 79	 0.006	 0.022	 0.011	 1287	 1287	 1287	 0.0	 0.0	 1	 -30.0	 30.0;
	78	 84	 0.0	 0.036	 0.0	 815	 815	 815	 0.0	 0.0	 1	 -30.0	 30.0;
	79	 211	 0.099	 0.375	 0.051	 76	 76	 76	 0.0	 0.0	 1	 -30.0	 30.0;
	80	 211	 0.022	 0.107	 0.058	 269	 269	 269	 0.0	 0.0	 1	 -30.0	 30.0;
	81	 194	 0.0035	 0.033	 0.53	 884	 884	 884	 0.0	 0.0	 1	 -30.0	 30.0;
	81	 195	 0.0035	 0.033	 0.53	 884	 884	 884	 0.0	 0.0	 1	 -30.0	 30.0;
	85	 86	 0.008	 0.064	 0.128	 455	 455	 455	 0.0	 0.0	 1	 -30.0	 30.0;
	86	 87	 0.012	 0.093	 0.183	 313	 313	 313	 0.0	 0.0	 1	 -30.0	 30.0;
	86	 323	 0.006	 0.048	 0.092	 607	 607	 607	 0.0	 0.0	 1	 -30.0	 30.0;
	89	 91	 0.047	 0.119	 0.014	 230	 230	 230	 0.0	 0.0	 1	 -30.0	 30.0;
	90	 92	 0.032	 0.174	 0.024	 166	 166	 166	 0.0	 0.0	 1	 -30.0	 30.0;
	91	 94	 0.1	 0.253	 0.031	 108	 108	 108	 0.0	 0.0	 1	 -30.0	 30.0;
	91	 97	 0.022	 0.077	 0.039	 367	 367	 367	 0.0	 0.0	 1	 -30.0	 30.0;
	92	 103	 0.019	 0.144	 0.017	 202	 202	 202	 0.0	 0.0	 1	 -30.0	 30.0;
	92	 105	 0.017	 0.092	 0.012	 314	 314	 314	 0.0	 0.0	 1	 -30.0	 30.0;
	94	 97	 0.278	 0.427	 0.043	 58	 58	 58	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 100	 0.022	 0.053	 0.007	 512	 512	 512	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 102	 0.038	 0.092	 0.012	 295	 295	 295	 0.0	 0.0	 1	 -30.0	 30.0;
	97	 103	 0.048	 0.122	 0.015	 224	 224	 224	 0.0	 0.0	 1	 -30.0	 30.0;
	98	 100	 0.024	 0.064	 0.007	 430	 430	 430	 0.0	 0.0	 1	 -30.0	 30.0;
	98	 102	 0.034	 0.121	 0.015	 234	 234	 234	 0.0	 0.0	 1	 -30.0	 30.0;
	99	 107	 0.053	 0.135	 0.017	 203	 203	 203	 0.0	 0.0	 1	 -30.0	 30.0;
	99	 108	 0.002	 0.004	 0.002	 6559	 6559	 6559	 0.0	 0.0	 1	 -30.0	 30.0;
	99	 109	 0.045	 0.354	 0.044	 83	 83	 83	 0.0	 0.0	 1	 -30.0	 30.0;
	99	 110	 0.05	 0.174	 0.022	 163	 163	 163	 0.0	 0.0	 1	 -30.0	 30.0;
	100	 102	 0.016	 0.038	 0.004	 712	 712	 712	 0.0	 0.0	 1	 -30.0	 30.0;
	102	 104	 0.043	 0.064	 0.027	 381	 381	 381	 0.0	 0.0	 1	 -30.0	 30.0;
	103	 105	 0.019	 0.062	 0.008	 453	 453	 453	 0.0	 0.0	 1	 -30.0	 30.0;
	104	 108	 0.076	 0.13	 0.044	 195	 195	 195	 0.0	 0.0	 1	 -30.0	 30.0;
	104	 322	 0.044	 0.124	 0.015	 223	 223	 223	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 107	 0.012	 0.088	 0.011	 331	 331	 331	 0.0	 0.0	 1	 -30.0	 30.0;
	105	 110	 0.157	 0.4	 0.047	 69	 69	 69	 0.0	 0.0	 1	 -30.0	 30.0;
	108	 324	 0.074	 0.208	 0.026	 133	 133	 133	 0.0	 0.0	 1	 -30.0	 30.0;
	109	 110	 0.07	 0.184	 0.021	 149	 149	 149	 0.0	 0.0	 1	 -30.0	 30.0;
	109	 113	 0.1	 0.274	 0.031	 101	 101	 101	 0.0	 0.0	 1	 -30.0	 30.0;
	109	 114	 0.109	 0.393	 0.036	 72	 72	 72	 0.0	 0.0	 1	 -30.0	 30.0;
	110	 112	 0.142	 0.404	 0.05	 69	 69	 69	 0.0	 0.0	 1	 -30.0	 30.0;
	112	 114	 0.017	 0.042	 0.006	 648	 648	 648	 0.0	 0.0	 1	 -30.0	 30.0;
	115	 122	 0.0036	 0.0199	 0.004	 1451	 1451	 1451	 0.0	 0.0	 1	 -30.0	 30.0;
	116	 120	 0.002	 0.1049	 0.001	 280	 280	 280	 0.0	 0.0	 1	 -30.0	 30.0;
	117	 118	 0.0001	 0.0018	 0.017	 9900.0	 16271	 16271	 0.0	 0.0	 1	 -30.0	 30.0;
	118	 119	 0.0	 0.0271	 0.0	 1083	 1083	 1083	 0.0	 0.0	 1	 -30.0	 30.0;
	118	 1201	 0.0	 0.6163	 0.0	 48	 48	 48	 0.0	 0.0	 1	 -30.0	 30.0;
	1201	 120	 0.0	 -0.3697	 0.0	 80	 80	 80	 0.0	 0.0	 1	 -30.0	 30.0;
	118	 121	 0.0022	 0.2915	 0.0	 101	 101	 101	 0.0	 0.0	 1	 -30.0	 30.0;
	119	 120	 0.0	 0.0339	 0.0	 866	 866	 866	 0.0	 0.0	 1	 -30.0	 30.0;
	119	 121	 0.0	 0.0582	 0.0	 504	 504	 504	 0.0	 0.0	 1	 -30.0	 30.0;
	122	 123	 0.0808	 0.2344	 0.029	 119	 119	 119	 0.0	 0.0	 1	 -30.0	 30.0;
	122	 125	 0.0965	 0.3669	 0.054	 78	 78	 78	 0.0	 0.0	 1	 -30.0	 30.0;
	123	 124	 0.036	 0.1076	 0.117	 259	 259	 259	 0.0	 0.0	 1	 -30.0	 30.0;
	123	 125	 0.0476	 0.1414	 0.149	 197	 197	 197	 0.0	 0.0	 1	 -30.0	 30.0;
	125	 126	 0.0006	 0.0197	 0.0	 1489	 1489	 1489	 0.0	 0.0	 1	 -30.0	 30.0;
	126	 127	 0.0059	 0.0405	 0.25	 717	 717	 717	 1.0	 0.0	 1	 -30.0	 30.0;
	126	 129	 0.0115	 0.1106	 0.185	 264	 264	 264	 1.0	 0.0	 1	 -30.0	 30.0;
	126	 132	 0.0198	 0.1688	 0.321	 173	 173	 173	 1.0	 0.0	 1	 -30.0	 30.0;
	126	 157	 0.005	 0.05	 0.33	 584	 584	 584	 1.0	 0.0	 1	 -30.0	 30.0;
	126	 158	 0.0077	 0.0538	 0.335	 540	 540	 540	 1.0	 0.0	 1	 -30.0	 30.0;
	126	 169	 0.0165	 0.1157	 0.171	 251	 251	 251	 1.0	 0.0	 1	 -30.0	 30.0;
	127	 128	 0.0059	 0.0577	 0.095	 506	 506	 506	 0.0	 0.0	 1	 -30.0	 30.0;
	127	 134	 0.0049	 0.0336	 0.208	 864	 864	 864	 0.0	 0.0	 1	 -30.0	 30.0;
	127	 168	 0.0059	 0.0577	 0.095	 506	 506	 506	 0.0	 0.0	 1	 -30.0	 30.0;
	128	 130	 0.0078	 0.0773	 0.126	 378	 378	 378	 0.0	 0.0	 1	 -30.0	 30.0;
	128	 133	 0.0026	 0.0193	 0.03	 1507	 1507	 1507	 0.0	 0.0	 1	 -30.0	 30.0;
	129	 130	 0.0076	 0.0752	 0.122	 389	 389	 389	 0.0	 0.0	 1	 -30.0	 30.0;
	129	 133	 0.0021	 0.0186	 0.03	 1568	 1568	 1568	 0.0	 0.0	 1	 -30.0	 30.0;
	130	 132	 0.0016	 0.0164	 0.026	 1781	 1781	 1781	 0.0	 0.0	 1	 -30.0	 30.0;
	130	 151	 0.0017	 0.0165	 0.026	 1769	 1769	 1769	 0.0	 0.0	 1	 -30.0	 30.0;
	130	 167	 0.0079	 0.0793	 0.127	 369	 369	 369	 0.0	 0.0	 1	 -30.0	 30.0;
	130	 168	 0.0078	 0.0784	 0.125	 373	 373	 373	 0.0	 0.0	 1	 -30.0	 30.0;
	133	 137	 0.0017	 0.0117	 0.289	 2481	 2481	 2481	 0.0	 0.0	 1	 -30.0	 30.0;
	133	 168	 0.0026	 0.0193	 0.03	 1507	 1507	 1507	 0.0	 0.0	 1	 -30.0	 30.0;
	133	 169	 0.0021	 0.0186	 0.03	 1568	 1568	 1568	 0.0	 0.0	 1	 -30.0	 30.0;
	133	 171	 0.0002	 0.0101	 0.0	 2904	 2904	 2904	 1.0	 0.0	 1	 -30.0	 30.0;
	134	 135	 0.0043	 0.0293	 0.18	 991	 991	 991	 0.0	 0.0	 1	 -30.0	 30.0;
	134	 184	 0.0039	 0.0381	 0.258	 766	 766	 766	 0.0	 0.0	 1	 -30.0	 30.0;
	135	 136	 0.0091	 0.0623	 0.385	 466	 466	 466	 0.0	 0.0	 1	 -30.0	 30.0;
	136	 137	 0.0125	 0.089	 0.54	 327	 327	 327	 0.0	 0.0	 1	 -30.0	 30.0;
	136	 152	 0.0056	 0.039	 0.953	 745	 745	 745	 0.0	 0.0	 1	 -30.0	 30.0;
	137	 140	 0.0015	 0.0114	 0.284	 2551	 2551	 2551	 0.0	 0.0	 1	 -30.0	 30.0;
	137	 181	 0.0005	 0.0034	 0.021	 8536	 8536	 8536	 0.0	 0.0	 1	 -30.0	 30.0;
	137	 186	 0.0007	 0.0151	 0.126	 1941	 1941	 1941	 0.0	 0.0	 1	 -30.0	 30.0;
	137	 188	 0.0005	 0.0034	 0.021	 8536	 8536	 8536	 0.0	 0.0	 1	 -30.0	 30.0;
	139	 172	 0.0562	 0.2248	 0.081	 127	 127	 127	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 141	 0.012	 0.0836	 0.123	 348	 348	 348	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 142	 0.0152	 0.1132	 0.684	 257	 257	 257	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 145	 0.0468	 0.3369	 0.519	 87	 87	 87	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 146	 0.043	 0.3031	 0.463	 96	 96	 96	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 147	 0.0489	 0.3492	 0.538	 84	 84	 84	 0.0	 0.0	 1	 -30.0	 30.0;
	140	 182	 0.0013	 0.0089	 0.119	 3262	 3262	 3262	 0.0	 0.0	 1	 -30.0	 30.0;
	141	 146	 0.0291	 0.2267	 0.342	 129	 129	 129	 0.0	 0.0	 1	 -30.0	 30.0;
	142	 143	 0.006	 0.057	 0.767	 512	 512	 512	 0.0	 0.0	 1	 -30.0	 30.0;
	143	 145	 0.0075	 0.0773	 0.119	 378	 378	 378	 0.0	 0.0	 1	 -30.0	 30.0;
	143	 149	 0.0127	 0.0909	 0.135	 320	 320	 320	 0.0	 0.0	 1	 -30.0	 30.0;
	145	 146	 0.0085	 0.0588	 0.087	 494	 494	 494	 0.0	 0.0	 1	 -30.0	 30.0;
	145	 149	 0.0218	 0.1511	 0.223	 193	 193	 193	 0.0	 0.0	 1	 -30.0	 30.0;
	146	 147	 0.0073	 0.0504	 0.074	 576	 576	 576	 0.0	 0.0	 1	 -30.0	 30.0;
	148	 178	 0.0523	 0.1526	 0.074	 182	 182	 182	 1.0	 0.0	 1	 -30.0	 30.0;
	148	 179	 0.1371	 0.3919	 0.076	 71	 71	 71	 1.0	 0.0	 1	 -30.0	 30.0;
	152	 153	 0.0137	 0.0957	 0.141	 304	 304	 304	 0.0	 0.0	 1	 -30.0	 30.0;
	153	 161	 0.0055	 0.0288	 0.19	 1001	 1001	 1001	 0.0	 0.0	 1	 -30.0	 30.0;
	154	 156	 0.1746	 0.3161	 0.04	 82	 82	 82	 0.0	 0.0	 1	 -30.0	 30.0;
	154	 183	 0.0804	 0.3054	 0.045	 93	 93	 93	 0.0	 0.0	 1	 -30.0	 30.0;
	155	 161	 0.011	 0.0568	 0.388	 507	 507	 507	 0.0	 0.0	 1	 -30.0	 30.0;
	157	 159	 0.0008	 0.0098	 0.069	 2984	 2984	 2984	 0.0	 0.0	 1	 -30.0	 30.0;
	158	 159	 0.0029	 0.0285	 0.19	 1024	 1024	 1024	 0.0	 0.0	 1	 -30.0	 30.0;
	158	 160	 0.0066	 0.0448	 0.277	 648	 648	 648	 0.0	 0.0	 1	 -30.0	 30.0;
	162	 164	 0.0024	 0.0326	 0.236	 898	 898	 898	 0.0	 0.0	 1	 -30.0	 30.0;
	162	 165	 0.0018	 0.0245	 1.662	 1195	 1195	 1195	 0.0	 0.0	 1	 -30.0	 30.0;
	163	 164	 0.0044	 0.0514	 3.597	 569	 569	 569	 0.0	 0.0	 1	 -30.0	 30.0;
	165	 166	 0.0002	 0.0123	 0.0	 2385	 2385	 2385	 0.0	 0.0	 1	 -30.0	 30.0;
	167	 169	 0.0018	 0.0178	 0.029	 1640	 1640	 1640	 0.0	 0.0	 1	 -30.0	 30.0;
	172	 173	 0.0669	 0.4843	 0.063	 60	 60	 60	 0.0	 0.0	 1	 -30.0	 30.0;
	172	 174	 0.0558	 0.221	 0.031	 129	 129	 129	 0.0	 0.0	 1	 -30.0	 30.0;
	173	 174	 0.0807	 0.3331	 0.049	 86	 86	 86	 0.0	 0.0	 1	 -30.0	 30.0;
	173	 175	 0.0739	 0.3071	 0.043	 93	 93	 93	 0.0	 0.0	 1	 -30.0	 30.0;
	173	 176	 0.1799	 0.5017	 0.069	 56	 56	 56	 0.0	 0.0	 1	 -30.0	 30.0;
	175	 176	 0.0904	 0.3626	 0.048	 79	 79	 79	 0.0	 0.0	 1	 -30.0	 30.0;
	175	 179	 0.077	 0.3092	 0.054	 93	 93	 93	 0.0	 0.0	 1	 -30.0	 30.0;
	176	 177	 0.0251	 0.0829	 0.047	 339	 339	 339	 0.0	 0.0	 1	 -30.0	 30.0;
	177	 178	 0.0222	 0.0847	 0.05	 335	 335	 335	 0.0	 0.0	 1	 -30.0	 30.0;
	178	 179	 0.0498	 0.1855	 0.029	 153	 153	 153	 0.0	 0.0	 1	 -30.0	 30.0;
	178	 180	 0.0061	 0.029	 0.084	 990	 990	 990	 0.0	 0.0	 1	 -30.0	 30.0;
	181	 138	 0.0004	 0.0202	 0.0	 1452	 1452	 1452	 0.0	 0.0	 1	 -30.0	 30.0;
	181	 187	 0.0004	 0.0083	 0.115	 3530	 3530	 3530	 0.0	 0.0	 1	 -30.0	 30.0;
	184	 185	 0.0025	 0.0245	 0.164	 1192	 1192	 1192	 0.0	 0.0	 1	 -30.0	 30.0;
	186	 188	 0.0007	 0.0086	 0.115	 3400	 3400	 3400	 0.0	 0.0	 1	 -30.0	 30.0;
	187	 188	 0.0007	 0.0086	 0.115	 3400	 3400	 3400	 0.0	 0.0	 1	 -30.0	 30.0;
	188	 138	 0.0004	 0.0202	 0.0	 1452	 1452	 1452	 0.0	 0.0	 1	 -30.0	 30.0;
	189	 208	 0.033	 0.095	 0.0	 292	 292	 292	 0.0	 0.0	 1	 -30.0	 30.0;
	189	 209	 0.046	 0.069	 0.0	 354	 354	 354	 0.0	 0.0	 1	 -30.0	 30.0;
	190	 231	 0.0004	 0.0022	 6.2	 9900.0	 13118	 13118	 0.0	 0.0	 1	 -30.0	 30.0;
	190	 240	 0.0	 0.0275	 0.0	 1067	 1067	 1067	 1.0	 0.0	 1	 -30.0	 30.0;
	191	 192	 0.003	 0.048	 0.0	 610	 610	 610	 0.0	 0.0	 1	 -30.0	 30.0;
	192	 225	 0.002	 0.009	 0.0	 3182	 3182	 3182	 0.0	 0.0	 1	 -30.0	 30.0;
	193	 205	 0.045	 0.063	 0.0	 379	 379	 379	 0.0	 0.0	 1	 -30.0	 30.0;
	193	 208	 0.048	 0.127	 0.0	 217	 217	 217	 0.0	 0.0	 1	 -30.0	 30.0;
	194	 219	 0.0031	 0.0286	 0.5	 1020	 1020	 1020	 0.0	 0.0	 1	 -30.0	 30.0;
	194	 664	 0.0024	 0.0355	 0.36	 825	 825	 825	 0.0	 0.0	 1	 -30.0	 30.0;
	195	 219	 0.0031	 0.0286	 0.5	 1020	 1020	 1020	 0.0	 0.0	 1	 -30.0	 30.0;
	196	 197	 0.014	 0.04	 0.004	 693	 693	 693	 0.0	 0.0	 1	 -30.0	 30.0;
	196	 210	 0.03	 0.081	 0.01	 340	 340	 340	 0.0	 0.0	 1	 -30.0	 30.0;
	197	 198	 0.01	 0.06	 0.009	 483	 483	 483	 0.0	 0.0	 1	 -30.0	 30.0;
	197	 211	 0.015	 0.04	 0.006	 687	 687	 687	 0.0	 0.0	 1	 -30.0	 30.0;
	198	 202	 0.332	 0.688	 0.0	 39	 39	 39	 1.0	 0.0	 1	 -30.0	 30.0;
	198	 203	 0.009	 0.046	 0.025	 626	 626	 626	 0.0	 0.0	 1	 -30.0	 30.0;
	198	 210	 0.02	 0.073	 0.008	 388	 388	 388	 0.0	 0.0	 1	 -30.0	 30.0;
	198	 211	 0.034	 0.109	 0.032	 257	 257	 257	 0.0	 0.0	 1	 -30.0	 30.0;
	199	 200	 0.076	 0.135	 0.009	 190	 190	 190	 0.0	 0.0	 1	 -30.0	 30.0;
	199	 210	 0.04	 0.102	 0.005	 268	 268	 268	 0.0	 0.0	 1	 -30.0	 30.0;
	200	 210	 0.081	 0.128	 0.014	 194	 194	 194	 0.0	 0.0	 1	 -30.0	 30.0;
	201	 204	 0.124	 0.183	 0.0	 133	 133	 133	 0.0	 0.0	 1	 -30.0	 30.0;
	203	 211	 0.01	 0.059	 0.008	 491	 491	 491	 0.0	 0.0	 1	 -30.0	 30.0;
	204	 205	 0.046	 0.068	 0.0	 358	 358	 358	 0.0	 0.0	 1	 -30.0	 30.0;
	205	 206	 0.302	 0.446	 0.0	 55	 55	 55	 0.0	 0.0	 1	 -30.0	 30.0;
	206	 207	 0.073	 0.093	 0.0	 249	 249	 249	 0.0	 0.0	 1	 -30.0	 30.0;
	206	 208	 0.24	 0.421	 0.0	 61	 61	 61	 0.0	 0.0	 1	 -30.0	 30.0;
	212	 215	 0.0139	 0.0778	 0.086	 372	 372	 372	 0.0	 0.0	 1	 -30.0	 30.0;
	213	 214	 0.0025	 0.038	 0.0	 771	 771	 771	 1.0	 0.0	 1	 -30.0	 30.0;
	214	 215	 0.0017	 0.0185	 0.02	 1579	 1579	 1579	 0.0	 0.0	 1	 -30.0	 30.0;
	214	 242	 0.0015	 0.0108	 0.002	 2691	 2691	 2691	 0.0	 0.0	 1	 -30.0	 30.0;
	215	 216	 0.0045	 0.0249	 0.026	 1160	 1160	 1160	 0.0	 0.0	 1	 -30.0	 30.0;
	216	 217	 0.004	 0.0497	 0.018	 589	 589	 589	 0.0	 0.0	 1	 -30.0	 30.0;
	217	 218	 0.0	 0.0456	 0.0	 644	 644	 644	 0.0	 0.0	 1	 -30.0	 30.0;
	217	 219	 0.0005	 0.0177	 0.02	 1657	 1657	 1657	 1.0	 0.0	 1	 -30.0	 30.0;
	217	 220	 0.0027	 0.0395	 0.832	 741	 741	 741	 0.0	 0.0	 1	 -30.0	 30.0;
	219	 237	 0.0003	 0.0018	 5.2	 9900.0	 16074	 16074	 0.0	 0.0	 1	 -30.0	 30.0;
	220	 218	 0.0037	 0.0484	 0.43	 605	 605	 605	 0.0	 0.0	 1	 -30.0	 30.0;
	220	 221	 0.001	 0.0295	 0.503	 994	 994	 994	 0.0	 0.0	 1	 -30.0	 30.0;
	220	 238	 0.0016	 0.0046	 0.402	 6023	 6023	 6023	 0.0	 0.0	 1	 -30.0	 30.0;
	221	 223	 0.0003	 0.0013	 1.0	 9900.0	 21986	 21986	 0.0	 0.0	 1	 -30.0	 30.0;
	222	 237	 0.0014	 0.0514	 0.33	 571	 571	 571	 1.0	 0.0	 1	 -30.0	 30.0;
	224	 225	 0.01	 0.064	 0.48	 453	 453	 453	 0.0	 0.0	 1	 -30.0	 30.0;
	224	 226	 0.0019	 0.0081	 0.86	 3526	 3526	 3526	 0.0	 0.0	 1	 -30.0	 30.0;
	225	 191	 0.001	 0.061	 0.0	 481	 481	 481	 0.0	 0.0	 1	 -30.0	 30.0;
	226	 231	 0.0005	 0.0212	 0.0	 1384	 1384	 1384	 1.0	 0.0	 1	 -30.0	 30.0;
	227	 231	 0.0009	 0.0472	 0.186	 622	 622	 622	 1.0	 0.0	 1	 -30.0	 30.0;
	228	 229	 0.0019	 0.0087	 1.28	 3294	 3294	 3294	 0.0	 0.0	 1	 -30.0	 30.0;
	228	 231	 0.0026	 0.0917	 0.0	 320	 320	 320	 1.0	 0.0	 1	 -30.0	 30.0;
	228	 234	 0.0013	 0.0288	 0.81	 1018	 1018	 1018	 0.0	 0.0	 1	 -30.0	 30.0;
	229	 190	 0.0	 0.0626	 0.0	 469	 469	 469	 1.0	 0.0	 1	 -30.0	 30.0;
	231	 232	 0.0002	 0.0069	 1.364	 4250	 4250	 4250	 1.0	 0.0	 1	 -30.0	 30.0;
	231	 237	 0.0001	 0.0006	 3.57	 9900.0	 48222	 48222	 0.0	 0.0	 1	 -30.0	 30.0;
	232	 233	 0.0017	 0.0485	 0.0	 605	 605	 605	 1.0	 0.0	 1	 -30.0	 30.0;
	234	 235	 0.0002	 0.0259	 0.144	 1133	 1133	 1133	 0.0	 0.0	 1	 -30.0	 30.0;
	234	 237	 0.0006	 0.0272	 0.0	 1079	 1079	 1079	 1.0	 0.0	 1	 -30.0	 30.0;
	235	 238	 0.0002	 0.0006	 0.8	 9900.0	 46378	 46378	 0.0	 0.0	 1	 -30.0	 30.0;
	241	 237	 0.0005	 0.0154	 0.0	 1904	 1904	 1904	 1.0	 0.0	 1	 -30.0	 30.0;
	240	 281	 0.0003	 0.0043	 0.009	 6805	 6805	 6805	 0.0	 0.0	 1	 -30.0	 30.0;
	242	 245	 0.0082	 0.0851	 0.0	 344	 344	 344	 1.0	 0.0	 1	 -30.0	 30.0;
	242	 247	 0.0112	 0.0723	 0.0	 401	 401	 401	 1.0	 0.0	 1	 -30.0	 30.0;
	243	 244	 0.0127	 0.0355	 0.0	 778	 778	 778	 0.0	 0.0	 1	 -30.0	 30.0;
	243	 245	 0.0326	 0.1804	 0.0	 161	 161	 161	 0.0	 0.0	 1	 -30.0	 30.0;
	244	 246	 0.0195	 0.0551	 0.0	 502	 502	 502	 0.0	 0.0	 1	 -30.0	 30.0;
	245	 246	 0.0157	 0.0732	 0.0	 392	 392	 392	 0.0	 0.0	 1	 -30.0	 30.0;
	245	 247	 0.036	 0.2119	 0.0	 137	 137	 137	 0.0	 0.0	 1	 -30.0	 30.0;
	246	 247	 0.0268	 0.1285	 0.0	 224	 224	 224	 0.0	 0.0	 1	 -30.0	 30.0;
	247	 248	 0.0428	 0.1215	 0.0	 228	 228	 228	 0.0	 0.0	 1	 -30.0	 30.0;
	248	 249	 0.0351	 0.1004	 0.0	 276	 276	 276	 0.0	 0.0	 1	 -30.0	 30.0;
	249	 250	 0.0616	 0.1857	 0.0	 150	 150	 150	 0.0	 0.0	 1	 -30.0	 30.0;
	3	 1	 0.0	 0.052	 0.0	 565	 565	 565	 0.947	 0.0	 1	 -30.0	 30.0;
	3	 2	 0.0	 0.052	 0.0	 565	 565	 565	 0.956	 0.0	 1	 -30.0	 30.0;
	3	 4	 0.0	 0.005	 0.0	 5867	 5867	 5867	 0.971	 0.0	 1	 -30.0	 30.0;
	7	 5	 0.0	 0.039	 0.0	 753	 753	 753	 0.948	 0.0	 1	 -30.0	 30.0;
	7	 6	 0.0	 0.039	 0.0	 753	 753	 753	 0.959	 0.0	 1	 -30.0	 30.0;
	10	 11	 0.0	 0.089	 0.0	 330	 330	 330	 1.046	 0.0	 1	 -30.0	 30.0;
	12	 10	 0.0	 0.053	 0.0	 554	 554	 554	 0.985	 0.0	 1	 -30.0	 30.0;
	15	 17	 0.0194	 0.0311	 0.0	 801	 801	 801	 0.9561	 0.0	 1	 -30.0	 30.0;
	16	 15	 0.001	 0.038	 0.0	 772	 772	 772	 0.971	 0.0	 1	 -30.0	 30.0;
	21	 20	 0.0	 0.014	 0.0	 2096	 2096	 2096	 0.952	 0.0	 1	 -30.0	 30.0;
	24	 23	 0.0	 0.064	 0.0	 459	 459	 459	 0.943	 0.0	 1	 -30.0	 30.0;
	36	 35	 0.0	 0.047	 0.0	 625	 625	 625	 1.01	 0.0	 1	 -30.0	 30.0;
	45	 44	 0.0	 0.02	 0.0	 1467	 1467	 1467	 1.008	 0.0	 1	 -30.0	 30.0;
	45	 46	 0.0	 0.021	 0.0	 1397	 1397	 1397	 1.0	 0.0	 1	 -30.0	 30.0;
	62	 61	 0.0	 0.059	 0.0	 498	 498	 498	 0.975	 0.0	 1	 -30.0	 30.0;
	63	 64	 0.0	 0.038	 0.0	 772	 772	 772	 1.017	 0.0	 1	 -30.0	 30.0;
	73	 74	 0.0	 0.0244	 0.0	 1203	 1203	 1203	 1.0	 0.0	 1	 -30.0	 30.0;
	81	 88	 0.0	 0.02	 0.0	 1467	 1467	 1467	 1.0	 0.0	 1	 -30.0	 30.0;
	85	 99	 0.0	 0.048	 0.0	 612	 612	 612	 1.0	 0.0	 1	 -30.0	 30.0;
	86	 102	 0.0	 0.048	 0.0	 612	 612	 612	 1.0	 0.0	 1	 -30.0	 30.0;
	87	 94	 0.0	 0.046	 0.0	 638	 638	 638	 1.015	 0.0	 1	 -30.0	 30.0;
	114	 207	 0.0	 0.149	 0.0	 197	 197	 197	 0.967	 0.0	 1	 -30.0	 30.0;
	116	 124	 0.0052	 0.0174	 0.0	 1616	 1616	 1616	 1.01	 0.0	 1	 -30.0	 30.0;
	121	 115	 0.0	 0.028	 0.0	 1048	 1048	 1048	 1.05	 0.0	 1	 -30.0	 30.0;
	122	 157	 0.0005	 0.0195	 0.0	 1504	 1504	 1504	 1.0	 0.0	 1	 -30.0	 30.0;
	130	 131	 0.0	 0.018	 0.0	 1630	 1630	 1630	 1.0522	 0.0	 1	 -30.0	 30.0;
	130	 150	 0.0	 0.014	 0.0	 2096	 2096	 2096	 1.0522	 0.0	 1	 -30.0	 30.0;
	132	 170	 0.001	 0.0402	 0.0	 730	 730	 730	 1.05	 0.0	 1	 -30.0	 30.0;
	141	 174	 0.0024	 0.0603	 0.0	 487	 487	 487	 0.975	 0.0	 1	 -30.0	 30.0;
	142	 175	 0.0024	 0.0498	 -0.087	 589	 589	 589	 1.0	 0.0	 1	 -30.0	 30.0;
	143	 144	 0.0	 0.0833	 0.0	 353	 353	 353	 1.035	 0.0	 1	 -30.0	 30.0;
	143	 148	 0.0013	 0.0371	 0.0	 791	 791	 791	 0.9565	 0.0	 1	 -30.0	 30.0;
	145	 180	 0.0005	 0.0182	 0.0	 1612	 1612	 1612	 1.0	 0.0	 1	 -30.0	 30.0;
	151	 170	 0.001	 0.0392	 0.0	 749	 749	 749	 1.05	 0.0	 1	 -30.0	 30.0;
	153	 183	 0.0027	 0.0639	 0.0	 459	 459	 459	 1.073	 0.0	 1	 -30.0	 30.0;
	155	 156	 0.0008	 0.0256	 0.0	 1146	 1146	 1146	 1.05	 0.0	 1	 -30.0	 30.0;
	159	 117	 0.0	 0.016	 0.0	 1834	 1834	 1834	 1.0506	 0.0	 1	 -30.0	 30.0;
	160	 124	 0.0012	 0.0396	 0.0	 741	 741	 741	 0.975	 0.0	 1	 -30.0	 30.0;
	163	 137	 0.0013	 0.0384	 -0.057	 764	 764	 764	 0.98	 0.0	 1	 -30.0	 30.0;
	164	 155	 0.0009	 0.0231	 -0.033	 1269	 1269	 1269	 0.956	 0.0	 1	 -30.0	 30.0;
	182	 139	 0.0003	 0.0131	 0.0	 2239	 2239	 2239	 1.05	 0.0	 1	 -30.0	 30.0;
	189	 210	 0.0	 0.252	 0.0	 117	 117	 117	 1.03	 0.0	 1	 -30.0	 30.0;
	193	 196	 0.0	 0.237	 0.0	 124	 124	 124	 1.03	 0.0	 1	 -30.0	 30.0;
	195	 212	 0.0008	 0.0366	 0.0	 802	 802	 802	 0.985	 0.0	 1	 -30.0	 30.0;
	200	 248	 0.0	 0.22	 0.0	 134	 134	 134	 1.0	 0.0	 1	 -30.0	 30.0;
	201	 69	 0.0	 0.098	 0.0	 300	 300	 300	 1.03	 0.0	 1	 -30.0	 30.0;
	202	 211	 0.0	 0.128	 0.0	 230	 230	 230	 1.01	 0.0	 1	 -30.0	 30.0;
	204	 2040	 0.02	 0.204	 -0.012	 144	 144	 144	 1.05	 0.0	 1	 -30.0	 30.0;
	209	 198	 0.026	 0.211	 0.0	 138	 138	 138	 1.03	 0.0	 1	 -30.0	 30.0;
	211	 212	 0.003	 0.0122	 0.0	 2335	 2335	 2335	 1.0	 0.0	 1	 -30.0	 30.0;
	218	 219	 0.001	 0.0354	 -0.01	 829	 829	 829	 0.97	 0.0	 1	 -30.0	 30.0;
	223	 224	 0.0012	 0.0195	 -0.364	 1502	 1502	 1502	 1.0	 0.0	 1	 -30.0	 30.0;
	229	 230	 0.001	 0.0332	 0.0	 884	 884	 884	 1.02	 0.0	 1	 -30.0	 30.0;
	234	 236	 0.0005	 0.016	 0.0	 1833	 1833	 1833	 1.07	 0.0	 1	 -30.0	 30.0;
	238	 239	 0.0005	 0.016	 0.0	 1833	 1833	 1833	 1.02	 0.0	 1	 -30.0	 30.0;
	196	 2040	 0.0001	 0.02	 0.0	 1467	 1467	 1467	 1.0	 -11.4	 1	 -30.0	 30.0;
	119	 1190	 0.001	 0.023	 0.0	 1275	 1275	 1275	 1.0223	 0.0	 1	 -30.0	 30.0;
	120	 1200	 0.0	 0.023	 0.0	 1276	 1276	 1276	 0.9284	 0.0	 1	 -30.0	 30.0;
	7002	 2	 0.001	 0.0146	 0.0	 2005	 2005	 2005	 1.0	 0.0	 1	 -30.0	 30.0;
	7003	 3	 0.0	 0.01054	 0.0	 2783	 2783	 2783	 1.0	 0.0	 1	 -30.0	 30.0;
	7061	 61	 0.0	 0.0238	 0.0	 1233	 1233	 1233	 1.0	 0.0	 1	 -30.0	 30.0;
	7062	 62	 0.0	 0.03214	 0.0	 913	 913	 913	 0.95	 0.0	 1	 -30.0	 30.0;
	7166	 166	 0.0	 0.0154	 0.0	 1905	 1905	 1905	 1.0	 0.0	 1	 -30.0	 30.0;
	7024	 24	 0.0	 0.0289	 0.0	 1015	 1015	 1015	 1.0	 0.0	 1	 -30.0	 30.0;
	7001	 1	 0.0	 0.01953	 0.0	 1502	 1502	 1502	 1.0	 0.0	 1	 -30.0	 30.0;
	7130	 130	 0.0	 0.0193	 0.0	 1520	 1520	 1520	 1.0	 0.0	 1	 -30.0	 30.0;
	7011	 11	 0.0	 0.01923	 0.0	 1526	 1526	 1526	 1.0	 0.0	 1	 -30.0	 30.0;
	7023	 23	 0.0	 0.023	 0.0	 1276	 1276	 1276	 1.0	 0.0	 1	 -30.0	 30.0;
	7049	 49	 0.0	 0.0124	 0.0	 2366	 2366	 2366	 1.0	 0.0	 1	 -30.0	 30.0;
	7139	 139	 0.0	 0.0167	 0.0	 1757	 1757	 1757	 1.0	 0.0	 1	 -30.0	 30.0;
	7012	 12	 0.0	 0.0312	 0.0	 941	 941	 941	 1.0	 0.0	 1	 -30.0	 30.0;
	7017	 17	 0.0	 0.01654	 0.0	 1774	 1774	 1774	 0.942	 0.0	 1	 -30.0	 30.0;
	7039	 39	 0.0	 0.03159	 0.0	 929	 929	 929	 0.965	 0.0	 1	 -30.0	 30.0;
	7057	 57	 0.0	 0.05347	 0.0	 549	 549	 549	 0.95	 0.0	 1	 -30.0	 30.0;
	7044	 44	 0.0	 0.18181	 0.0	 162	 162	 162	 0.942	 0.0	 1	 -30.0	 30.0;
	7055	 55	 0.0	 0.19607	 0.0	 150	 150	 150	 0.942	 0.0	 1	 -30.0	 30.0;
	7071	 71	 0.0	 0.06896	 0.0	 426	 426	 426	 0.9565	 0.0	 1	 -30.0	 30.0;
];

% INFO    : === Translation Options ===
% INFO    : Phase Angle Bound:           30.0 (deg.)
% INFO    : Line Capacity Model:         ub
% INFO    : Gen Active Capacity Model:   stat
% INFO    : Gen Reactive Capacity Model: am50ag
% INFO    : Gen Active Cost Model:       stat
% INFO    : Setting Flat Start
% INFO    : Line Capacity PAB:           15.0 (deg.)
% WARNING : No active generation at the slack bus, assigning type - NUC
% INFO    :
% INFO    : === Generator Classification Notes ===
% INFO    : NUC    3   -    13.37
% INFO    : PEL    3   -     2.89
% INFO    : SYNC   12  -     0.00
% INFO    : COW    14  -    43.97
% INFO    : NG     37  -    39.77
% INFO    :
% INFO    : === Generator Active Capacity Stat Model Notes ===
% INFO    : Gen at bus 8 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 10 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 20 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 63 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 76 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 84 - COW	: Pg=375.0, Pmax=475.0 -> Pmax=1448   samples: 2
% INFO    : Gen at bus 91 - NG	: Pg=155.0, Pmax=255.0 -> Pmax=185   samples: 2
% INFO    : Gen at bus 92 - NG	: Pg=290.0, Pmax=390.0 -> Pmax=360   samples: 8
% INFO    : Gen at bus 98 - NG	: Pg=68.0, Pmax=168.0 -> Pmax=93   samples: 1
% INFO    : Gen at bus 108 - NG	: Pg=117.0, Pmax=217.0 -> Pmax=197   samples: 4
% WARNING : Failed to find a generator capacity within (1930.0-9650.0) after 100 samples, using percent increase model
% INFO    : Gen at bus 119 - NUC	: Pg=1930.0, Pmax=2030.0 -> Pmax=2041   samples: 100
% INFO    : Gen at bus 124 - NG	: Pg=240.0, Pmax=340.0 -> Pmax=321   samples: 11
% INFO    : Gen at bus 125 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 138 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 141 - NG	: Pg=281.0, Pmax=381.0 -> Pmax=297   samples: 10
% INFO    : Gen at bus 143 - COW	: Pg=696.0, Pmax=796.0 -> Pmax=800   samples: 1
% INFO    : Gen at bus 146 - COW	: Pg=84.0, Pmax=184.0 -> Pmax=91   samples: 1
% INFO    : Gen at bus 147 - NG	: Pg=217.0, Pmax=317.0 -> Pmax=320   samples: 10
% INFO    : Gen at bus 149 - NG	: Pg=103.0, Pmax=203.0 -> Pmax=277   samples: 3
% INFO    : Gen at bus 152 - COW	: Pg=372.0, Pmax=472.0 -> Pmax=606   samples: 13
% INFO    : Gen at bus 153 - NG	: Pg=216.0, Pmax=316.0 -> Pmax=242   samples: 15
% INFO    : Gen at bus 156 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 170 - NG	: Pg=205.0, Pmax=305.0 -> Pmax=330   samples: 9
% INFO    : Gen at bus 171 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 176 - NG	: Pg=228.0, Pmax=328.0 -> Pmax=278   samples: 4
% INFO    : Gen at bus 177 - NG	: Pg=84.0, Pmax=184.0 -> Pmax=125   samples: 1
% INFO    : Gen at bus 185 - NG	: Pg=200.0, Pmax=300.0 -> Pmax=250   samples: 6
% INFO    : Gen at bus 186 - COW	: Pg=1200.0, Pmax=1300.0 -> Pmax=2465   samples: 13
% INFO    : Gen at bus 187 - COW	: Pg=1200.0, Pmax=1300.0 -> Pmax=1624   samples: 6
% INFO    : Gen at bus 190 - NG	: Pg=475.0, Pmax=575.0 -> Pmax=515   samples: 27
% WARNING : Failed to find a generator capacity within (1973.0-9865.0) after 100 samples, using percent increase model
% INFO    : Gen at bus 191 - COW	: Pg=1973.0, Pmax=2073.0 -> Pmax=2140   samples: 100
% INFO    : Gen at bus 198 - NG	: Pg=424.0, Pmax=524.0 -> Pmax=430   samples: 25
% INFO    : Gen at bus 213 - NG	: Pg=272.0, Pmax=372.0 -> Pmax=288   samples: 6
% INFO    : Gen at bus 220 - NG	: Pg=100.0, Pmax=200.0 -> Pmax=460   samples: 2
% INFO    : Gen at bus 221 - NG	: Pg=450.0, Pmax=550.0 -> Pmax=554   samples: 26
% INFO    : Gen at bus 222 - NG	: Pg=250.0, Pmax=350.0 -> Pmax=523   samples: 2
% INFO    : Gen at bus 227 - NG	: Pg=303.0, Pmax=403.0 -> Pmax=436   samples: 11
% INFO    : Gen at bus 230 - NG	: Pg=345.0, Pmax=445.0 -> Pmax=458   samples: 65
% INFO    : Gen at bus 233 - NG	: Pg=300.0, Pmax=400.0 -> Pmax=341   samples: 13
% INFO    : Gen at bus 236 - COW	: Pg=600.0, Pmax=700.0 -> Pmax=881   samples: 7
% INFO    : Gen at bus 238 - NG	: Pg=250.0, Pmax=350.0 -> Pmax=267   samples: 8
% WARNING : Failed to find a generator capacity within (550.0-2750.0) after 100 samples, using percent increase model
% INFO    : Gen at bus 239 - NG	: Pg=550.0, Pmax=650.0 -> Pmax=621   samples: 100
% INFO    : Gen at bus 241 - COW	: Pg=575.43, Pmax=675.43 -> Pmax=1127   samples: 6
% INFO    : Gen at bus 242 - PEL	: Pg=170.0, Pmax=270.0 -> Pmax=212   samples: 38
% INFO    : Gen at bus 243 - NG	: Pg=84.0, Pmax=184.0 -> Pmax=342   samples: 5
% INFO    : Gen at bus 7001 - NG	: Pg=467.0, Pmax=567.0 -> Pmax=568   samples: 99
% INFO    : Gen at bus 7002 - COW	: Pg=623.0, Pmax=723.0 -> Pmax=670   samples: 12
% INFO    : Gen at bus 7003 - NUC	: Pg=1210.0, Pmax=1310.0 -> Pmax=1401   samples: 9
% INFO    : Gen at bus 7011 - COW	: Pg=234.0, Pmax=334.0 -> Pmax=668   samples: 3
% INFO    : Gen at bus 7012 - NG	: Pg=372.0, Pmax=472.0 -> Pmax=626   samples: 68
% INFO    : Gen at bus 7017 - NG	: Pg=330.0, Pmax=430.0 -> Pmax=490   samples: 25
% INFO    : Gen at bus 7023 - NG	: Pg=185.0, Pmax=285.0 -> Pmax=220   samples: 1
% INFO    : Gen at bus 7024 - NG	: Pg=410.0, Pmax=510.0 -> Pmax=543   samples: 87
% WARNING : Failed to find a generator capacity within (500.0-2500.0) after 100 samples, using percent increase model
% INFO    : Gen at bus 7039 - PEL	: Pg=500.0, Pmax=600.0 -> Pmax=580   samples: 100
% INFO    : Gen at bus 7044 - NG	: Pg=37.0, Pmax=137.0 -> Pmax=132   samples: 3
% INFO    : Gen at bus 7049 - NUC	: Pg=0.0, Pmax=2399.01 -> Pmax=718   samples: 1
% INFO    : Gen at bus 7055 - NG	: Pg=45.0, Pmax=145.0 -> Pmax=158   samples: 2
% INFO    : Gen at bus 7057 - NG	: Pg=165.0, Pmax=265.0 -> Pmax=334   samples: 2
% INFO    : Gen at bus 7061 - COW	: Pg=400.0, Pmax=500.0 -> Pmax=1757   samples: 5
% INFO    : Gen at bus 7062 - NG	: Pg=400.0, Pmax=500.0 -> Pmax=568   samples: 23
% INFO    : Gen at bus 7071 - NG	: Pg=116.0, Pmax=216.0 -> Pmax=203   samples: 4
% INFO    : Gen at bus 7130 - COW	: Pg=1292.0, Pmax=1392.0 -> Pmax=1726   samples: 3
% INFO    : Gen at bus 7139 - COW	: Pg=700.0, Pmax=800.0 -> Pmax=2025   samples: 4
% WARNING : Failed to find a generator capacity within (553.0-2765.0) after 100 samples, using percent increase model
% INFO    : Gen at bus 7166 - NG	: Pg=553.0, Pmax=653.0 -> Pmax=624   samples: 100
% INFO    : Gen at bus 9002 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 9051 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 9053 - SYNC	: Pg=0.0, Pmax=100.0 -> Pmax=0   samples: 0
% INFO    : Gen at bus 9054 - NG	: Pg=50.0, Pmax=150.0 -> Pmax=84   samples: 1
% INFO    : Gen at bus 9055 - PEL	: Pg=8.0, Pmax=108.0 -> Pmax=37   samples: 1
% INFO    :
% INFO    : === Generator Reactive Capacity Atmost Max 50 Percent Active Model Notes ===
% INFO    : Gen at bus 91 - NG	: Pmax 185.0, Qmin -11.0, Qmax 96.0 -> Qmin -11.0, Qmax 93.0
% INFO    : Gen at bus 98 - NG	: Pmax 93.0, Qmin -30.0, Qmax 56.0 -> Qmin -30.0, Qmax 47.0
% INFO    : Gen at bus 119 - NUC	: Pmax 2041.0, Qmin -500.0, Qmax 1500.0 -> Qmin -500.0, Qmax 1021.0
% INFO    : Gen at bus 190 - NG	: Pmax 515.0, Qmin -300.0, Qmax 300.0 -> Qmin -258.0, Qmax 258.0
% INFO    : Gen at bus 198 - NG	: Pmax 430.0, Qmin -260.0, Qmax 260.0 -> Qmin -215.0, Qmax 215.0
% INFO    : Gen at bus 213 - NG	: Pmax 288.0, Qmin -150.0, Qmax 150.0 -> Qmin -144.0, Qmax 144.0
% INFO    : Gen at bus 221 - NG	: Pmax 554.0, Qmin -320.0, Qmax 320.0 -> Qmin -277.0, Qmax 277.0
% INFO    : Gen at bus 222 - NG	: Pmax 523.0, Qmin -300.0, Qmax 300.0 -> Qmin -262.0, Qmax 262.0
% INFO    : Gen at bus 227 - NG	: Pmax 436.0, Qmin -300.0, Qmax 300.0 -> Qmin -218.0, Qmax 218.0
% INFO    : Gen at bus 230 - NG	: Pmax 458.0, Qmin -250.0, Qmax 250.0 -> Qmin -229.0, Qmax 229.0
% INFO    : Gen at bus 233 - NG	: Pmax 341.0, Qmin -500.0, Qmax 500.0 -> Qmin -171.0, Qmax 171.0
% INFO    : Gen at bus 238 - NG	: Pmax 267.0, Qmin -200.0, Qmax 200.0 -> Qmin -134.0, Qmax 134.0
% INFO    : Gen at bus 239 - NG	: Pmax 621.0, Qmin -400.0, Qmax 400.0 -> Qmin -311.0, Qmax 311.0
% INFO    : Gen at bus 241 - COW	: Pmax 1127.0, Qmin -600.0, Qmax 600.0 -> Qmin -564.0, Qmax 564.0
% INFO    : Gen at bus 7017 - NG	: Pmax 490.0, Qmin 0.0, Qmax 350.0 -> Qmin 0.0, Qmax 245.0
% INFO    : Gen at bus 7023 - NG	: Pmax 220.0, Qmin 0.0, Qmax 120.0 -> Qmin 0.0, Qmax 110.0
% INFO    :
% INFO    : === Generator Active Cost Stat Model Notes ===
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0266667 -> 0 22.4098347064 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0645161 -> 0 46.1000538955 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0344828 -> 0 54.1649390883 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.147059 -> 0 27.2384159201 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0854701 -> 0 38.4307223234 0
% INFO    : Updated Generator Cost: NUC - 0.0 20.0 0.00518135 -> 0 7.69890795501 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0416667 -> 0 26.7541276871 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0355872 -> 0 30.5979157367 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0143678 -> 0 30.7586659727 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.119048 -> 0 19.2922809396 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0460829 -> 0 49.8618547953 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0970874 -> 0 35.8423627743 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0268817 -> 0 34.9559652667 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0462963 -> 0 22.7627223623 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0487805 -> 0 35.3759736401 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0438596 -> 0 33.8685243329 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.119048 -> 0 29.0312647892 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.05 -> 0 28.3915172515 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.00833333 -> 0 1.00020278828 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.00833333 -> 0 27.2785376131 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0210526 -> 0 49.1557097142 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.00506842 -> 0 24.0626550844 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0235849 -> 0 31.0166636721 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0367647 -> 0 49.721798725 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.1 -> 0 21.2916647901 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0222222 -> 0 31.4370309813 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.04 -> 0 50.8428686002 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0330033 -> 0 28.0104597031 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0289855 -> 0 39.8285724294 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0333333 -> 0 35.6507788821 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0166667 -> 0 32.6212661116 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.04 -> 0 39.6576878063 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0181818 -> 0 41.2233124228 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0173783 -> 0 39.06472056 0
% INFO    : Updated Generator Cost: PEL - 0.0 20.0 0.0588235 -> 0 116.939408599 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.119048 -> 0 34.3365622827 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0214133 -> 0 38.2748782917 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0160514 -> 0 23.466762456 0
% INFO    : Updated Generator Cost: NUC - 0.0 20.0 0.00826446 -> 0 7.50995927659 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.042735 -> 0 26.6829650924 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0268817 -> 0 28.4348675489 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.030303 -> 0 35.1266514816 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0540541 -> 0 51.0623971719 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0243902 -> 0 29.9920150949 0
% INFO    : Updated Generator Cost: PEL - 0.0 20.0 0.02 -> 0 103.987496331 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.27027 -> 0 38.8256893275 0
% INFO    : Updated Generator Cost: NUC - 0.0 40.0 0.01 -> 0 6.8430722092 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.222222 -> 0 29.7725621102 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0606061 -> 0 62.4271028397 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.025 -> 0 20.8115145801 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.025 -> 0 26.5078895412 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0862069 -> 0 31.5875166573 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.00773994 -> 0 29.7599241875 0
% INFO    : Updated Generator Cost: COW - 0.0 20.0 0.0142857 -> 0 36.1790551222 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.0180832 -> 0 36.90836687 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: SYNC - 0.0 40.0 0.01 -> 0 0.0 0
% INFO    : Updated Generator Cost: NG - 0.0 20.0 0.2 -> 0 32.9614726645 0
% INFO    : Updated Generator Cost: PEL - 0.0 20.0 1.25 -> 0 94.7582086867 0
% INFO    :
% INFO    : === Generator Bounds Update Notes ===
% INFO    :
% INFO    : === Base KV Replacement Notes ===
% INFO    :
% INFO    : === Transformer Setting Replacement Notes ===
% WARNING : Branch 33-34 connects two different voltage levels (115.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 41-42 connects two different voltage levels (115.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 126-127 connects two different voltage levels (115.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 126-129 connects two different voltage levels (115.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 126-132 connects two different voltage levels (115.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 126-157 connects two different voltage levels (115.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 126-158 connects two different voltage levels (115.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 126-169 connects two different voltage levels (115.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 133-171 connects two different voltage levels (230.0, 115.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 148-178 connects two different voltage levels (230.0, 115.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 148-179 connects two different voltage levels (230.0, 115.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 190-240 connects two different voltage levels (345.0, 230.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 198-202 connects two different voltage levels (115.0, 66.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 217-219 connects two different voltage levels (138.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 226-231 connects two different voltage levels (230.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 228-231 connects two different voltage levels (138.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 229-190 connects two different voltage levels (138.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 231-232 connects two different voltage levels (345.0, 138.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 232-233 connects two different voltage levels (138.0, 66.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 234-237 connects two different voltage levels (138.0, 345.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 242-245 connects two different voltage levels (138.0, 66.0), changing tap ratio 0.0 => 1.0
% WARNING : Branch 242-247 connects two different voltage levels (138.0, 66.0), changing tap ratio 0.0 => 1.0
% INFO    :
% INFO    : === Line Capacity UB Model Notes ===
% INFO    : Updated Thermal Rating: on transformer 37-9001 : Rate B , 0.0 -> 63230
% INFO    : Updated Thermal Rating: on line 9001-9005 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 8215
% INFO    : Updated Thermal Rating: on transformer 9001-9006 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 68
% INFO    : Updated Thermal Rating: on transformer 9001-9012 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 46
% INFO    : Updated Thermal Rating: on transformer 9005-9051 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 79
% INFO    : Updated Thermal Rating: on transformer 9005-9052 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 79
% INFO    : Updated Thermal Rating: on transformer 9005-9053 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 78
% INFO    : Updated Thermal Rating: on transformer 9005-9054 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 193
% INFO    : Updated Thermal Rating: on transformer 9005-9055 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 37
% INFO    : Updated Thermal Rating: on line 9006-9007 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 117
% INFO    : Updated Thermal Rating: on line 9006-9003 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 59
% INFO    : Updated Thermal Rating: on line 9006-9003 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 59
% INFO    : Updated Thermal Rating: on line 9012-9002 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 67
% INFO    : Updated Thermal Rating: on line 9012-9002 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 67
% INFO    : Updated Thermal Rating: on line 9002-9021 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 332
% INFO    : Updated Thermal Rating: on line 9021-9023 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 21
% INFO    : Updated Thermal Rating: on transformer 9021-9022 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 11
% INFO    : Updated Thermal Rating: on transformer 9002-9024 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 9
% INFO    : Updated Thermal Rating: on transformer 9023-9025 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 8
% INFO    : Updated Thermal Rating: on transformer 9023-9026 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 8
% INFO    : Updated Thermal Rating: on transformer 9007-9071 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 10
% INFO    : Updated Thermal Rating: on transformer 9007-9072 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 15
% INFO    : Updated Thermal Rating: on line 9007-9003 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 116
% INFO    : Updated Thermal Rating: on transformer 9003-9031 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 7
% INFO    : Updated Thermal Rating: on transformer 9003-9032 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 6
% INFO    : Updated Thermal Rating: on transformer 9003-9033 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 7
% INFO    : Updated Thermal Rating: on line 9003-9044 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 302
% INFO    : Updated Thermal Rating: on line 9044-9004 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 611
% INFO    : Updated Thermal Rating: on transformer 9004-9041 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 12
% INFO    : Updated Thermal Rating: on transformer 9004-9042 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 6
% INFO    : Updated Thermal Rating: on transformer 9004-9043 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 18
% INFO    : Updated Thermal Rating: on transformer 9003-9034 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 21
% INFO    : Updated Thermal Rating: on transformer 9003-9035 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 9
% INFO    : Updated Thermal Rating: on transformer 9003-9036 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 18
% INFO    : Updated Thermal Rating: on transformer 9003-9037 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 12
% INFO    : Updated Thermal Rating: on transformer 9003-9038 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 10
% INFO    : Updated Thermal Rating: on line 9012-9121 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 29
% INFO    : Updated Thermal Rating: on transformer 9053-9533 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 40
% INFO    : Updated Thermal Rating: on line 1-5 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4823
% INFO    : Updated Thermal Rating: on line 2-6 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3240
% INFO    : Updated Thermal Rating: on line 2-8 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1061
% INFO    : Updated Thermal Rating: on line 3-7 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 9778
% INFO    : Updated Thermal Rating: on line 3-19 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 423
% INFO    : Updated Thermal Rating: on line 3-150 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4149
% INFO    : Updated Thermal Rating: on line 4-16 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1536
% INFO    : Updated Thermal Rating: on line 5-9 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 991
% INFO    : Updated Thermal Rating: on line 7-12 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3240
% INFO    : Updated Thermal Rating: on line 7-131 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4149
% INFO    : Updated Thermal Rating: on line 8-11 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 482
% INFO    : Updated Thermal Rating: on line 8-14 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 668
% INFO    : Updated Thermal Rating: on line 9-11 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1061
% INFO    : Updated Thermal Rating: on line 11-13 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 840
% INFO    : Updated Thermal Rating: on line 12-21 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1939
% INFO    : Updated Thermal Rating: on line 13-20 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 850
% INFO    : Updated Thermal Rating: on line 14-15 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 663
% INFO    : Updated Thermal Rating: on line 15-37 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 115
% INFO    : Updated Thermal Rating: on line 15-89 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 110
% INFO    : Updated Thermal Rating: on line 15-90 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 79
% INFO    : Updated Thermal Rating: on line 16-42 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1328
% INFO    : Updated Thermal Rating: on line 19-21 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1620
% INFO    : Updated Thermal Rating: on line 19-87 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 362
% INFO    : Updated Thermal Rating: on line 20-22 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 800
% INFO    : Updated Thermal Rating: on line 20-27 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 148
% INFO    : Updated Thermal Rating: on line 21-24 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 857
% INFO    : Updated Thermal Rating: on line 22-23 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 240
% INFO    : Updated Thermal Rating: on line 23-25 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 677
% INFO    : Updated Thermal Rating: on line 24-319 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 430
% INFO    : Updated Thermal Rating: on line 25-26 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 369
% INFO    : Updated Thermal Rating: on line 26-27 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 229
% INFO    : Updated Thermal Rating: on line 26-320 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 215
% INFO    : Updated Thermal Rating: on transformer 33-34 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 466
% INFO    : Updated Thermal Rating: on line 33-38 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2393
% INFO    : Updated Thermal Rating: on line 33-40 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 991
% INFO    : Updated Thermal Rating: on line 33-41 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 674
% INFO    : Updated Thermal Rating: on line 34-42 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3639
% INFO    : Updated Thermal Rating: on line 35-72 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 480
% INFO    : Updated Thermal Rating: on line 35-76 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1926
% INFO    : Updated Thermal Rating: on line 35-77 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 957
% INFO    : Updated Thermal Rating: on line 36-88 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1075
% INFO    : Updated Thermal Rating: on line 37-38 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 616
% INFO    : Updated Thermal Rating: on line 37-40 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 434
% INFO    : Updated Thermal Rating: on line 37-41 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 786
% INFO    : Updated Thermal Rating: on line 37-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 355
% INFO    : Updated Thermal Rating: on line 37-89 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 108
% INFO    : Updated Thermal Rating: on line 37-90 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 217
% INFO    : Updated Thermal Rating: on line 38-41 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 775
% INFO    : Updated Thermal Rating: on line 38-43 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 317
% INFO    : Updated Thermal Rating: on line 39-42 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4564
% INFO    : Updated Thermal Rating: on line 40-48 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 188
% INFO    : Updated Thermal Rating: on transformer 41-42 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1012
% INFO    : Updated Thermal Rating: on line 41-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 146
% INFO    : Updated Thermal Rating: on line 41-51 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 312
% INFO    : Updated Thermal Rating: on line 42-46 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2075
% INFO    : Updated Thermal Rating: on line 43-44 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 384
% INFO    : Updated Thermal Rating: on line 43-48 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 106
% INFO    : Updated Thermal Rating: on line 43-53 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 714
% INFO    : Updated Thermal Rating: on line 44-47 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 333
% INFO    : Updated Thermal Rating: on line 44-54 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 332
% INFO    : Updated Thermal Rating: on line 45-60 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 706
% INFO    : Updated Thermal Rating: on line 45-74 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 536
% INFO    : Updated Thermal Rating: on line 46-81 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 694
% INFO    : Updated Thermal Rating: on line 47-73 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 191
% INFO    : Updated Thermal Rating: on line 47-113 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 234
% INFO    : Updated Thermal Rating: on line 48-107 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 439
% INFO    : Updated Thermal Rating: on line 49-51 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 297
% INFO    : Updated Thermal Rating: on line 51-52 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 255
% INFO    : Updated Thermal Rating: on line 52-55 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 348
% INFO    : Updated Thermal Rating: on line 53-54 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 381
% INFO    : Updated Thermal Rating: on line 54-55 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 270
% INFO    : Updated Thermal Rating: on line 55-57 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 162
% INFO    : Updated Thermal Rating: on line 57-58 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 318
% INFO    : Updated Thermal Rating: on line 57-63 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 53
% INFO    : Updated Thermal Rating: on line 58-59 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1067
% INFO    : Updated Thermal Rating: on line 59-61 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2231
% INFO    : Updated Thermal Rating: on line 60-62 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 447
% INFO    : Updated Thermal Rating: on line 62-64 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 277
% INFO    : Updated Thermal Rating: on line 62-144 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4149
% INFO    : Updated Thermal Rating: on line 63-526 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 169
% INFO    : Updated Thermal Rating: on line 69-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 124
% INFO    : Updated Thermal Rating: on line 69-79 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 178
% INFO    : Updated Thermal Rating: on line 70-71 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 280
% INFO    : Updated Thermal Rating: on line 70-528 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 235
% INFO    : Updated Thermal Rating: on line 71-72 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 216
% INFO    : Updated Thermal Rating: on line 71-73 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 281
% INFO    : Updated Thermal Rating: on line 72-77 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 331
% INFO    : Updated Thermal Rating: on line 72-531 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 151
% INFO    : Updated Thermal Rating: on line 73-76 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 483
% INFO    : Updated Thermal Rating: on line 73-79 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 534
% INFO    : Updated Thermal Rating: on line 74-88 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1075
% INFO    : Updated Thermal Rating: on line 74-562 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 145
% INFO    : Updated Thermal Rating: on line 76-77 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 640
% INFO    : Updated Thermal Rating: on line 77-78 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4823
% INFO    : Updated Thermal Rating: on line 77-80 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 411
% INFO    : Updated Thermal Rating: on line 77-552 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 104
% INFO    : Updated Thermal Rating: on line 77-609 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 130
% INFO    : Updated Thermal Rating: on line 78-79 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1287
% INFO    : Updated Thermal Rating: on line 78-84 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 815
% INFO    : Updated Thermal Rating: on line 79-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 76
% INFO    : Updated Thermal Rating: on line 80-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 269
% INFO    : Updated Thermal Rating: on line 81-194 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 884
% INFO    : Updated Thermal Rating: on line 81-195 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 884
% INFO    : Updated Thermal Rating: on line 85-86 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 455
% INFO    : Updated Thermal Rating: on line 86-87 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 313
% INFO    : Updated Thermal Rating: on line 86-323 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 607
% INFO    : Updated Thermal Rating: on line 89-91 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 230
% INFO    : Updated Thermal Rating: on line 90-92 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 166
% INFO    : Updated Thermal Rating: on line 91-94 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 108
% INFO    : Updated Thermal Rating: on line 91-97 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 367
% INFO    : Updated Thermal Rating: on line 92-103 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 202
% INFO    : Updated Thermal Rating: on line 92-105 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 314
% INFO    : Updated Thermal Rating: on line 94-97 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 58
% INFO    : Updated Thermal Rating: on line 97-100 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 512
% INFO    : Updated Thermal Rating: on line 97-102 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 295
% INFO    : Updated Thermal Rating: on line 97-103 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 224
% INFO    : Updated Thermal Rating: on line 98-100 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 430
% INFO    : Updated Thermal Rating: on line 98-102 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 234
% INFO    : Updated Thermal Rating: on line 99-107 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 203
% INFO    : Updated Thermal Rating: on line 99-108 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 6559
% INFO    : Updated Thermal Rating: on line 99-109 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 83
% INFO    : Updated Thermal Rating: on line 99-110 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 163
% INFO    : Updated Thermal Rating: on line 100-102 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 712
% INFO    : Updated Thermal Rating: on line 102-104 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 381
% INFO    : Updated Thermal Rating: on line 103-105 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 453
% INFO    : Updated Thermal Rating: on line 104-108 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 195
% INFO    : Updated Thermal Rating: on line 104-322 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 223
% INFO    : Updated Thermal Rating: on line 105-107 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 331
% INFO    : Updated Thermal Rating: on line 105-110 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 69
% INFO    : Updated Thermal Rating: on line 108-324 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 133
% INFO    : Updated Thermal Rating: on line 109-110 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 149
% INFO    : Updated Thermal Rating: on line 109-113 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 101
% INFO    : Updated Thermal Rating: on line 109-114 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 72
% INFO    : Updated Thermal Rating: on line 110-112 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 69
% INFO    : Updated Thermal Rating: on line 112-114 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 648
% INFO    : Updated Thermal Rating: on line 115-122 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1451
% INFO    : Updated Thermal Rating: on line 116-120 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 280
% INFO    : Updated Thermal Rating: on line 117-118 : Rate B, Rate C , 0.0, 0.0 -> 16271
% INFO    : Updated Thermal Rating: on line 118-119 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1083
% INFO    : Updated Thermal Rating: on line 118-1201 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 48
% INFO    : Updated Thermal Rating: on line 1201-120 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 80
% INFO    : Updated Thermal Rating: on line 118-121 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 101
% INFO    : Updated Thermal Rating: on line 119-120 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 866
% INFO    : Updated Thermal Rating: on line 119-121 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 504
% INFO    : Updated Thermal Rating: on line 122-123 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 119
% INFO    : Updated Thermal Rating: on line 122-125 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 78
% INFO    : Updated Thermal Rating: on line 123-124 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 259
% INFO    : Updated Thermal Rating: on line 123-125 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 197
% INFO    : Updated Thermal Rating: on line 125-126 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1489
% INFO    : Updated Thermal Rating: on transformer 126-127 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 717
% INFO    : Updated Thermal Rating: on transformer 126-129 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 264
% INFO    : Updated Thermal Rating: on transformer 126-132 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 173
% INFO    : Updated Thermal Rating: on transformer 126-157 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 584
% INFO    : Updated Thermal Rating: on transformer 126-158 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 540
% INFO    : Updated Thermal Rating: on transformer 126-169 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 251
% INFO    : Updated Thermal Rating: on line 127-128 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 506
% INFO    : Updated Thermal Rating: on line 127-134 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 864
% INFO    : Updated Thermal Rating: on line 127-168 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 506
% INFO    : Updated Thermal Rating: on line 128-130 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 378
% INFO    : Updated Thermal Rating: on line 128-133 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1507
% INFO    : Updated Thermal Rating: on line 129-130 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 389
% INFO    : Updated Thermal Rating: on line 129-133 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1568
% INFO    : Updated Thermal Rating: on line 130-132 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1781
% INFO    : Updated Thermal Rating: on line 130-151 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1769
% INFO    : Updated Thermal Rating: on line 130-167 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 369
% INFO    : Updated Thermal Rating: on line 130-168 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 373
% INFO    : Updated Thermal Rating: on line 133-137 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2481
% INFO    : Updated Thermal Rating: on line 133-168 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1507
% INFO    : Updated Thermal Rating: on line 133-169 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1568
% INFO    : Updated Thermal Rating: on transformer 133-171 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2904
% INFO    : Updated Thermal Rating: on line 134-135 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 991
% INFO    : Updated Thermal Rating: on line 134-184 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 766
% INFO    : Updated Thermal Rating: on line 135-136 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 466
% INFO    : Updated Thermal Rating: on line 136-137 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 327
% INFO    : Updated Thermal Rating: on line 136-152 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 745
% INFO    : Updated Thermal Rating: on line 137-140 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2551
% INFO    : Updated Thermal Rating: on line 137-181 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 8536
% INFO    : Updated Thermal Rating: on line 137-186 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1941
% INFO    : Updated Thermal Rating: on line 137-188 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 8536
% INFO    : Updated Thermal Rating: on line 139-172 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 127
% INFO    : Updated Thermal Rating: on line 140-141 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 348
% INFO    : Updated Thermal Rating: on line 140-142 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 257
% INFO    : Updated Thermal Rating: on line 140-145 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 87
% INFO    : Updated Thermal Rating: on line 140-146 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 96
% INFO    : Updated Thermal Rating: on line 140-147 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 84
% INFO    : Updated Thermal Rating: on line 140-182 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3262
% INFO    : Updated Thermal Rating: on line 141-146 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 129
% INFO    : Updated Thermal Rating: on line 142-143 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 512
% INFO    : Updated Thermal Rating: on line 143-145 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 378
% INFO    : Updated Thermal Rating: on line 143-149 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 320
% INFO    : Updated Thermal Rating: on line 145-146 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 494
% INFO    : Updated Thermal Rating: on line 145-149 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 193
% INFO    : Updated Thermal Rating: on line 146-147 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 576
% INFO    : Updated Thermal Rating: on transformer 148-178 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 182
% INFO    : Updated Thermal Rating: on transformer 148-179 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 71
% INFO    : Updated Thermal Rating: on line 152-153 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 304
% INFO    : Updated Thermal Rating: on line 153-161 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1001
% INFO    : Updated Thermal Rating: on line 154-156 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 82
% INFO    : Updated Thermal Rating: on line 154-183 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 93
% INFO    : Updated Thermal Rating: on line 155-161 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 507
% INFO    : Updated Thermal Rating: on line 157-159 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2984
% INFO    : Updated Thermal Rating: on line 158-159 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1024
% INFO    : Updated Thermal Rating: on line 158-160 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 648
% INFO    : Updated Thermal Rating: on line 162-164 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 898
% INFO    : Updated Thermal Rating: on line 162-165 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1195
% INFO    : Updated Thermal Rating: on line 163-164 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 569
% INFO    : Updated Thermal Rating: on line 165-166 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2385
% INFO    : Updated Thermal Rating: on line 167-169 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1640
% INFO    : Updated Thermal Rating: on line 172-173 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 60
% INFO    : Updated Thermal Rating: on line 172-174 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 129
% INFO    : Updated Thermal Rating: on line 173-174 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 86
% INFO    : Updated Thermal Rating: on line 173-175 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 93
% INFO    : Updated Thermal Rating: on line 173-176 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 56
% INFO    : Updated Thermal Rating: on line 175-176 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 79
% INFO    : Updated Thermal Rating: on line 175-179 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 93
% INFO    : Updated Thermal Rating: on line 176-177 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 339
% INFO    : Updated Thermal Rating: on line 177-178 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 335
% INFO    : Updated Thermal Rating: on line 178-179 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 153
% INFO    : Updated Thermal Rating: on line 178-180 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 990
% INFO    : Updated Thermal Rating: on line 181-138 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1452
% INFO    : Updated Thermal Rating: on line 181-187 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3530
% INFO    : Updated Thermal Rating: on line 184-185 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1192
% INFO    : Updated Thermal Rating: on line 186-188 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3400
% INFO    : Updated Thermal Rating: on line 187-188 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3400
% INFO    : Updated Thermal Rating: on line 188-138 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1452
% INFO    : Updated Thermal Rating: on line 189-208 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 292
% INFO    : Updated Thermal Rating: on line 189-209 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 354
% INFO    : Updated Thermal Rating: on line 190-231 : Rate B, Rate C , 0.0, 0.0 -> 13118
% INFO    : Updated Thermal Rating: on transformer 190-240 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1067
% INFO    : Updated Thermal Rating: on line 191-192 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 610
% INFO    : Updated Thermal Rating: on line 192-225 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3182
% INFO    : Updated Thermal Rating: on line 193-205 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 379
% INFO    : Updated Thermal Rating: on line 193-208 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 217
% INFO    : Updated Thermal Rating: on line 194-219 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1020
% INFO    : Updated Thermal Rating: on line 194-664 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 825
% INFO    : Updated Thermal Rating: on line 195-219 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1020
% INFO    : Updated Thermal Rating: on line 196-197 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 693
% INFO    : Updated Thermal Rating: on line 196-210 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 340
% INFO    : Updated Thermal Rating: on line 197-198 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 483
% INFO    : Updated Thermal Rating: on line 197-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 687
% INFO    : Updated Thermal Rating: on transformer 198-202 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 39
% INFO    : Updated Thermal Rating: on line 198-203 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 626
% INFO    : Updated Thermal Rating: on line 198-210 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 388
% INFO    : Updated Thermal Rating: on line 198-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 257
% INFO    : Updated Thermal Rating: on line 199-200 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 190
% INFO    : Updated Thermal Rating: on line 199-210 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 268
% INFO    : Updated Thermal Rating: on line 200-210 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 194
% INFO    : Updated Thermal Rating: on line 201-204 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 133
% INFO    : Updated Thermal Rating: on line 203-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 491
% INFO    : Updated Thermal Rating: on line 204-205 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 358
% INFO    : Updated Thermal Rating: on line 205-206 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 55
% INFO    : Updated Thermal Rating: on line 206-207 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 249
% INFO    : Updated Thermal Rating: on line 206-208 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 61
% INFO    : Updated Thermal Rating: on line 212-215 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 372
% INFO    : Updated Thermal Rating: on transformer 213-214 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 771
% INFO    : Updated Thermal Rating: on line 214-215 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1579
% INFO    : Updated Thermal Rating: on line 214-242 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2691
% INFO    : Updated Thermal Rating: on line 215-216 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1160
% INFO    : Updated Thermal Rating: on line 216-217 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 589
% INFO    : Updated Thermal Rating: on line 217-218 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 644
% INFO    : Updated Thermal Rating: on transformer 217-219 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1657
% INFO    : Updated Thermal Rating: on line 217-220 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 741
% INFO    : Updated Thermal Rating: on line 219-237 : Rate B, Rate C , 0.0, 0.0 -> 16074
% INFO    : Updated Thermal Rating: on line 220-218 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 605
% INFO    : Updated Thermal Rating: on line 220-221 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 994
% INFO    : Updated Thermal Rating: on line 220-238 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 6023
% INFO    : Updated Thermal Rating: on line 221-223 : Rate B, Rate C , 0.0, 0.0 -> 21986
% INFO    : Updated Thermal Rating: on transformer 222-237 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 571
% INFO    : Updated Thermal Rating: on line 224-225 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 453
% INFO    : Updated Thermal Rating: on line 224-226 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3526
% INFO    : Updated Thermal Rating: on line 225-191 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 481
% INFO    : Updated Thermal Rating: on transformer 226-231 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1384
% INFO    : Updated Thermal Rating: on transformer 227-231 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 622
% INFO    : Updated Thermal Rating: on line 228-229 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 3294
% INFO    : Updated Thermal Rating: on transformer 228-231 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 320
% INFO    : Updated Thermal Rating: on line 228-234 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1018
% INFO    : Updated Thermal Rating: on transformer 229-190 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 469
% INFO    : Updated Thermal Rating: on transformer 231-232 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 4250
% INFO    : Updated Thermal Rating: on line 231-237 : Rate B, Rate C , 0.0, 0.0 -> 48222
% INFO    : Updated Thermal Rating: on transformer 232-233 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 605
% INFO    : Updated Thermal Rating: on line 234-235 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1133
% INFO    : Updated Thermal Rating: on transformer 234-237 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1079
% INFO    : Updated Thermal Rating: on line 235-238 : Rate B, Rate C , 0.0, 0.0 -> 46378
% INFO    : Updated Thermal Rating: on transformer 241-237 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1904
% INFO    : Updated Thermal Rating: on line 240-281 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 6805
% INFO    : Updated Thermal Rating: on transformer 242-245 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 344
% INFO    : Updated Thermal Rating: on transformer 242-247 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 401
% INFO    : Updated Thermal Rating: on line 243-244 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 778
% INFO    : Updated Thermal Rating: on line 243-245 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 161
% INFO    : Updated Thermal Rating: on line 244-246 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 502
% INFO    : Updated Thermal Rating: on line 245-246 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 392
% INFO    : Updated Thermal Rating: on line 245-247 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 137
% INFO    : Updated Thermal Rating: on line 246-247 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 224
% INFO    : Updated Thermal Rating: on line 247-248 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 228
% INFO    : Updated Thermal Rating: on line 248-249 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 276
% INFO    : Updated Thermal Rating: on line 249-250 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% INFO    : Updated Thermal Rating: on transformer 3-1 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 565
% INFO    : Updated Thermal Rating: on transformer 3-2 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 565
% INFO    : Updated Thermal Rating: on transformer 3-4 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 5867
% INFO    : Updated Thermal Rating: on transformer 7-5 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 753
% INFO    : Updated Thermal Rating: on transformer 7-6 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 753
% INFO    : Updated Thermal Rating: on transformer 10-11 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 330
% INFO    : Updated Thermal Rating: on transformer 12-10 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 554
% INFO    : Updated Thermal Rating: on transformer 15-17 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 801
% INFO    : Updated Thermal Rating: on transformer 16-15 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 772
% INFO    : Updated Thermal Rating: on transformer 21-20 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2096
% INFO    : Updated Thermal Rating: on transformer 24-23 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 459
% INFO    : Updated Thermal Rating: on transformer 36-35 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 625
% INFO    : Updated Thermal Rating: on transformer 45-44 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1467
% INFO    : Updated Thermal Rating: on transformer 45-46 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1397
% INFO    : Updated Thermal Rating: on transformer 62-61 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 498
% INFO    : Updated Thermal Rating: on transformer 63-64 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 772
% INFO    : Updated Thermal Rating: on transformer 73-74 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1203
% INFO    : Updated Thermal Rating: on transformer 81-88 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1467
% INFO    : Updated Thermal Rating: on transformer 85-99 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 612
% INFO    : Updated Thermal Rating: on transformer 86-102 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 612
% INFO    : Updated Thermal Rating: on transformer 87-94 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 638
% INFO    : Updated Thermal Rating: on transformer 114-207 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 197
% INFO    : Updated Thermal Rating: on transformer 116-124 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1616
% INFO    : Updated Thermal Rating: on transformer 121-115 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1048
% INFO    : Updated Thermal Rating: on transformer 122-157 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1504
% INFO    : Updated Thermal Rating: on transformer 130-131 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1630
% INFO    : Updated Thermal Rating: on transformer 130-150 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2096
% INFO    : Updated Thermal Rating: on transformer 132-170 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 730
% INFO    : Updated Thermal Rating: on transformer 141-174 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 487
% INFO    : Updated Thermal Rating: on transformer 142-175 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 589
% INFO    : Updated Thermal Rating: on transformer 143-144 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 353
% INFO    : Updated Thermal Rating: on transformer 143-148 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 791
% INFO    : Updated Thermal Rating: on transformer 145-180 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1612
% INFO    : Updated Thermal Rating: on transformer 151-170 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 749
% INFO    : Updated Thermal Rating: on transformer 153-183 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 459
% INFO    : Updated Thermal Rating: on transformer 155-156 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1146
% INFO    : Updated Thermal Rating: on transformer 159-117 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1834
% INFO    : Updated Thermal Rating: on transformer 160-124 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 741
% INFO    : Updated Thermal Rating: on transformer 163-137 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 764
% INFO    : Updated Thermal Rating: on transformer 164-155 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1269
% INFO    : Updated Thermal Rating: on transformer 182-139 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2239
% INFO    : Updated Thermal Rating: on transformer 189-210 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 117
% INFO    : Updated Thermal Rating: on transformer 193-196 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 124
% INFO    : Updated Thermal Rating: on transformer 195-212 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 802
% INFO    : Updated Thermal Rating: on transformer 200-248 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 134
% INFO    : Updated Thermal Rating: on transformer 201-69 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 300
% INFO    : Updated Thermal Rating: on transformer 202-211 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 230
% INFO    : Updated Thermal Rating: on transformer 204-2040 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 144
% INFO    : Updated Thermal Rating: on transformer 209-198 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 138
% INFO    : Updated Thermal Rating: on transformer 211-212 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2335
% INFO    : Updated Thermal Rating: on transformer 218-219 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 829
% INFO    : Updated Thermal Rating: on transformer 223-224 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1502
% INFO    : Updated Thermal Rating: on transformer 229-230 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 884
% INFO    : Updated Thermal Rating: on transformer 234-236 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1833
% INFO    : Updated Thermal Rating: on transformer 238-239 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1833
% INFO    : Updated Thermal Rating: on transformer 196-2040 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1467
% INFO    : Updated Thermal Rating: on transformer 119-1190 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1275
% INFO    : Updated Thermal Rating: on transformer 120-1200 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1276
% INFO    : Updated Thermal Rating: on transformer 7002-2 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2005
% INFO    : Updated Thermal Rating: on transformer 7003-3 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2783
% INFO    : Updated Thermal Rating: on transformer 7061-61 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1233
% INFO    : Updated Thermal Rating: on transformer 7062-62 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 913
% INFO    : Updated Thermal Rating: on transformer 7166-166 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1905
% INFO    : Updated Thermal Rating: on transformer 7024-24 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1015
% INFO    : Updated Thermal Rating: on transformer 7001-1 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1502
% INFO    : Updated Thermal Rating: on transformer 7130-130 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1520
% INFO    : Updated Thermal Rating: on transformer 7011-11 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1526
% INFO    : Updated Thermal Rating: on transformer 7023-23 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1276
% INFO    : Updated Thermal Rating: on transformer 7049-49 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 2366
% INFO    : Updated Thermal Rating: on transformer 7139-139 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1757
% INFO    : Updated Thermal Rating: on transformer 7012-12 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 941
% INFO    : Updated Thermal Rating: on transformer 7017-17 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 1774
% INFO    : Updated Thermal Rating: on transformer 7039-39 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 929
% INFO    : Updated Thermal Rating: on transformer 7057-57 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 549
% INFO    : Updated Thermal Rating: on transformer 7044-44 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 162
% INFO    : Updated Thermal Rating: on transformer 7055-55 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 150
% INFO    : Updated Thermal Rating: on transformer 7071-71 : Rate A, Rate B, Rate C , 9900.0, 0.0, 0.0 -> 426
% INFO    :
% INFO    : === Line Capacity Monotonicity Notes ===
% INFO    : Updated Thermal Rating: on transformer 37-9001 : Rate C - 75.0 -> 63230
% INFO    :
% INFO    : === Voltage Setpoint Replacement Notes ===
% INFO    : Bus 1	: V=1.0284, theta=5.95 -> V=1.0, theta=0.0
% INFO    : Bus 2	: V=1.0354, theta=7.74 -> V=1.0, theta=0.0
% INFO    : Bus 3	: V=0.9971, theta=6.64 -> V=1.0, theta=0.0
% INFO    : Bus 4	: V=1.0308, theta=4.71 -> V=1.0, theta=0.0
% INFO    : Bus 5	: V=1.0191, theta=4.68 -> V=1.0, theta=0.0
% INFO    : Bus 6	: V=1.0312, theta=6.99 -> V=1.0, theta=0.0
% INFO    : Bus 7	: V=0.9934, theta=6.19 -> V=1.0, theta=0.0
% INFO    : Bus 8	: V=1.0153, theta=2.4 -> V=1.0, theta=0.0
% INFO    : Bus 9	: V=1.0034, theta=2.85 -> V=1.0, theta=0.0
% INFO    : Bus 10	: V=1.0205, theta=1.35 -> V=1.0, theta=0.0
% INFO    : Bus 11	: V=1.0057, theta=2.46 -> V=1.0, theta=0.0
% INFO    : Bus 12	: V=0.9974, theta=5.21 -> V=1.0, theta=0.0
% INFO    : Bus 13	: V=0.9977, theta=-0.55 -> V=1.0, theta=0.0
% INFO    : Bus 14	: V=0.9991, theta=-4.81 -> V=1.0, theta=0.0
% INFO    : Bus 15	: V=1.0343, theta=-8.59 -> V=1.0, theta=0.0
% INFO    : Bus 16	: V=1.0315, theta=-2.65 -> V=1.0, theta=0.0
% INFO    : Bus 17	: V=1.0649, theta=-13.1 -> V=1.0, theta=0.0
% INFO    : Bus 19	: V=0.982, theta=1.08 -> V=1.0, theta=0.0
% INFO    : Bus 20	: V=1.001, theta=-2.46 -> V=1.0, theta=0.0
% INFO    : Bus 21	: V=0.9752, theta=1.62 -> V=1.0, theta=0.0
% INFO    : Bus 22	: V=0.9963, theta=-1.97 -> V=1.0, theta=0.0
% INFO    : Bus 23	: V=1.0501, theta=3.94 -> V=1.0, theta=0.0
% INFO    : Bus 24	: V=1.0057, theta=6.02 -> V=1.0, theta=0.0
% INFO    : Bus 25	: V=1.0234, theta=1.44 -> V=1.0, theta=0.0
% INFO    : Bus 26	: V=0.9986, theta=-1.73 -> V=1.0, theta=0.0
% INFO    : Bus 27	: V=0.975, theta=-4.9 -> V=1.0, theta=0.0
% INFO    : Bus 33	: V=1.0244, theta=-12.02 -> V=1.0, theta=0.0
% INFO    : Bus 34	: V=1.0414, theta=-7.94 -> V=1.0, theta=0.0
% INFO    : Bus 35	: V=0.9757, theta=-25.72 -> V=1.0, theta=0.0
% INFO    : Bus 36	: V=1.0011, theta=-22.59 -> V=1.0, theta=0.0
% INFO    : Bus 37	: V=1.0201, theta=-11.23 -> V=1.0, theta=0.0
% INFO    : Bus 38	: V=1.0202, theta=-12.56 -> V=1.0, theta=0.0
% INFO    : Bus 39	: V=1.0535, theta=-5.81 -> V=1.0, theta=0.0
% INFO    : Bus 40	: V=1.0216, theta=-12.78 -> V=1.0, theta=0.0
% INFO    : Bus 41	: V=1.0292, theta=-10.45 -> V=1.0, theta=0.0
% INFO    : Bus 42	: V=1.0448, theta=-7.44 -> V=1.0, theta=0.0
% INFO    : Bus 43	: V=1.0006, theta=-16.79 -> V=1.0, theta=0.0
% INFO    : Bus 44	: V=1.0086, theta=-17.47 -> V=1.0, theta=0.0
% INFO    : Bus 45	: V=1.0215, theta=-14.74 -> V=1.0, theta=0.0
% INFO    : Bus 46	: V=1.0344, theta=-11.75 -> V=1.0, theta=0.0
% INFO    : Bus 47	: V=0.9777, theta=-23.17 -> V=1.0, theta=0.0
% INFO    : Bus 48	: V=1.0019, theta=-16.09 -> V=1.0, theta=0.0
% INFO    : Bus 49	: V=1.0475, theta=-2.95 -> V=1.0, theta=0.0
% INFO    : Bus 51	: V=1.0253, theta=-8.15 -> V=1.0, theta=0.0
% INFO    : Bus 52	: V=0.9979, theta=-11.86 -> V=1.0, theta=0.0
% INFO    : Bus 53	: V=0.9959, theta=-17.6 -> V=1.0, theta=0.0
% INFO    : Bus 54	: V=1.005, theta=-16.25 -> V=1.0, theta=0.0
% INFO    : Bus 55	: V=1.015, theta=-12.21 -> V=1.0, theta=0.0
% INFO    : Bus 57	: V=1.0335, theta=-8.0 -> V=1.0, theta=0.0
% INFO    : Bus 58	: V=0.9918, theta=-5.99 -> V=1.0, theta=0.0
% INFO    : Bus 59	: V=0.9789, theta=-5.29 -> V=1.0, theta=0.0
% INFO    : Bus 60	: V=1.0246, theta=-9.56 -> V=1.0, theta=0.0
% INFO    : Bus 61	: V=0.9906, theta=-3.47 -> V=1.0, theta=0.0
% INFO    : Bus 62	: V=1.016, theta=-1.1 -> V=1.0, theta=0.0
% INFO    : Bus 63	: V=0.9583, theta=-17.62 -> V=1.0, theta=0.0
% INFO    : Bus 64	: V=0.948, theta=-12.97 -> V=1.0, theta=0.0
% INFO    : Bus 69	: V=0.963, theta=-25.66 -> V=1.0, theta=0.0
% INFO    : Bus 70	: V=0.9513, theta=-35.16 -> V=1.0, theta=0.0
% INFO    : Bus 71	: V=0.9793, theta=-29.88 -> V=1.0, theta=0.0
% INFO    : Bus 72	: V=0.9696, theta=-27.48 -> V=1.0, theta=0.0
% INFO    : Bus 73	: V=0.9775, theta=-25.77 -> V=1.0, theta=0.0
% INFO    : Bus 74	: V=0.9964, theta=-22.0 -> V=1.0, theta=0.0
% INFO    : Bus 76	: V=0.9632, theta=-26.54 -> V=1.0, theta=0.0
% INFO    : Bus 77	: V=0.9837, theta=-24.94 -> V=1.0, theta=0.0
% INFO    : Bus 78	: V=0.99, theta=-24.05 -> V=1.0, theta=0.0
% INFO    : Bus 79	: V=0.982, theta=-24.97 -> V=1.0, theta=0.0
% INFO    : Bus 80	: V=0.9872, theta=-24.97 -> V=1.0, theta=0.0
% INFO    : Bus 81	: V=1.034, theta=-18.89 -> V=1.0, theta=0.0
% INFO    : Bus 84	: V=1.025, theta=-17.16 -> V=1.0, theta=0.0
% INFO    : Bus 85	: V=0.9872, theta=-17.68 -> V=1.0, theta=0.0
% INFO    : Bus 86	: V=0.9909, theta=-14.19 -> V=1.0, theta=0.0
% INFO    : Bus 87	: V=0.9921, theta=-7.77 -> V=1.0, theta=0.0
% INFO    : Bus 88	: V=1.0151, theta=-20.96 -> V=1.0, theta=0.0
% INFO    : Bus 89	: V=1.0317, theta=-11.13 -> V=1.0, theta=0.0
% INFO    : Bus 90	: V=1.0272, theta=-11.23 -> V=1.0, theta=0.0
% INFO    : Bus 91	: V=1.052, theta=-9.4 -> V=1.0, theta=0.0
% INFO    : Bus 92	: V=1.052, theta=-6.2 -> V=1.0, theta=0.0
% INFO    : Bus 94	: V=0.993, theta=-9.42 -> V=1.0, theta=0.0
% INFO    : Bus 97	: V=1.0183, theta=-13.24 -> V=1.0, theta=0.0
% INFO    : Bus 98	: V=1.0, theta=-14.6 -> V=1.0, theta=0.0
% INFO    : Bus 99	: V=0.9894, theta=-20.27 -> V=1.0, theta=0.0
% INFO    : Bus 100	: V=1.006, theta=-14.45 -> V=1.0, theta=0.0
% INFO    : Bus 102	: V=1.0008, theta=-15.23 -> V=1.0, theta=0.0
% INFO    : Bus 103	: V=1.0288, theta=-12.06 -> V=1.0, theta=0.0
% INFO    : Bus 104	: V=0.9958, theta=-17.33 -> V=1.0, theta=0.0
% INFO    : Bus 105	: V=1.0223, theta=-12.94 -> V=1.0, theta=0.0
% INFO    : Bus 107	: V=1.0095, theta=-16.03 -> V=1.0, theta=0.0
% INFO    : Bus 108	: V=0.99, theta=-20.26 -> V=1.0, theta=0.0
% INFO    : Bus 109	: V=0.9749, theta=-26.06 -> V=1.0, theta=0.0
% INFO    : Bus 110	: V=0.973, theta=-24.72 -> V=1.0, theta=0.0
% INFO    : Bus 112	: V=0.9725, theta=-28.69 -> V=1.0, theta=0.0
% INFO    : Bus 113	: V=0.97, theta=-25.38 -> V=1.0, theta=0.0
% INFO    : Bus 114	: V=0.9747, theta=-28.59 -> V=1.0, theta=0.0
% INFO    : Bus 115	: V=0.9603, theta=-13.57 -> V=1.0, theta=0.0
% INFO    : Bus 116	: V=1.0249, theta=-12.69 -> V=1.0, theta=0.0
% INFO    : Bus 117	: V=0.9348, theta=-4.72 -> V=1.0, theta=0.0
% INFO    : Bus 118	: V=0.9298, theta=-4.12 -> V=1.0, theta=0.0
% INFO    : Bus 119	: V=1.0435, theta=5.17 -> V=1.0, theta=0.0
% INFO    : Bus 120	: V=0.9584, theta=-8.77 -> V=1.0, theta=0.0
% INFO    : Bus 121	: V=0.9871, theta=-12.64 -> V=1.0, theta=0.0
% INFO    : Bus 122	: V=0.9728, theta=-14.36 -> V=1.0, theta=0.0
% INFO    : Bus 123	: V=1.0006, theta=-17.64 -> V=1.0, theta=0.0
% INFO    : Bus 124	: V=1.0233, theta=-13.49 -> V=1.0, theta=0.0
% INFO    : Bus 125	: V=1.0103, theta=-18.43 -> V=1.0, theta=0.0
% INFO    : Bus 126	: V=0.9978, theta=-12.86 -> V=1.0, theta=0.0
% INFO    : Bus 127	: V=1.0001, theta=-10.52 -> V=1.0, theta=0.0
% INFO    : Bus 128	: V=1.0024, theta=-4.78 -> V=1.0, theta=0.0
% INFO    : Bus 129	: V=1.0028, theta=-4.4 -> V=1.0, theta=0.0
% INFO    : Bus 130	: V=1.0191, theta=5.56 -> V=1.0, theta=0.0
% INFO    : Bus 131	: V=0.9861, theta=6.06 -> V=1.0, theta=0.0
% INFO    : Bus 132	: V=1.0045, theta=3.04 -> V=1.0, theta=0.0
% INFO    : Bus 133	: V=1.002, theta=-5.46 -> V=1.0, theta=0.0
% INFO    : Bus 134	: V=1.022, theta=-8.04 -> V=1.0, theta=0.0
% INFO    : Bus 135	: V=1.0193, theta=-6.76 -> V=1.0, theta=0.0
% INFO    : Bus 136	: V=1.0476, theta=1.54 -> V=1.0, theta=0.0
% INFO    : Bus 137	: V=1.0471, theta=-1.45 -> V=1.0, theta=0.0
% INFO    : Bus 138	: V=1.055, theta=-6.35 -> V=1.0, theta=0.0
% INFO    : Bus 139	: V=1.0117, theta=-3.57 -> V=1.0, theta=0.0
% INFO    : Bus 140	: V=1.043, theta=-3.44 -> V=1.0, theta=0.0
% INFO    : Bus 141	: V=1.051, theta=0.05 -> V=1.0, theta=0.0
% INFO    : Bus 142	: V=1.0155, theta=-2.77 -> V=1.0, theta=0.0
% INFO    : Bus 143	: V=1.0435, theta=4.03 -> V=1.0, theta=0.0
% INFO    : Bus 144	: V=1.016, theta=-0.7 -> V=1.0, theta=0.0
% INFO    : Bus 145	: V=1.0081, theta=-0.16 -> V=1.0, theta=0.0
% INFO    : Bus 146	: V=1.0528, theta=4.32 -> V=1.0, theta=0.0
% INFO    : Bus 147	: V=1.0528, theta=8.36 -> V=1.0, theta=0.0
% INFO    : Bus 148	: V=1.0577, theta=0.28 -> V=1.0, theta=0.0
% INFO    : Bus 149	: V=1.0735, theta=5.23 -> V=1.0, theta=0.0
% INFO    : Bus 150	: V=0.9869, theta=6.34 -> V=1.0, theta=0.0
% INFO    : Bus 151	: V=1.0048, theta=4.13 -> V=1.0, theta=0.0
% INFO    : Bus 152	: V=1.0535, theta=9.24 -> V=1.0, theta=0.0
% INFO    : Bus 153	: V=1.0435, theta=10.46 -> V=1.0, theta=0.0
% INFO    : Bus 154	: V=0.9663, theta=-1.8 -> V=1.0, theta=0.0
% INFO    : Bus 155	: V=1.0177, theta=6.75 -> V=1.0, theta=0.0
% INFO    : Bus 156	: V=0.963, theta=5.15 -> V=1.0, theta=0.0
% INFO    : Bus 157	: V=0.9845, theta=-11.93 -> V=1.0, theta=0.0
% INFO    : Bus 158	: V=0.9987, theta=-11.4 -> V=1.0, theta=0.0
% INFO    : Bus 159	: V=0.9867, theta=-9.82 -> V=1.0, theta=0.0
% INFO    : Bus 160	: V=0.9998, theta=-12.55 -> V=1.0, theta=0.0
% INFO    : Bus 161	: V=1.036, theta=8.85 -> V=1.0, theta=0.0
% INFO    : Bus 162	: V=0.9918, theta=18.5 -> V=1.0, theta=0.0
% INFO    : Bus 163	: V=1.041, theta=2.91 -> V=1.0, theta=0.0
% INFO    : Bus 164	: V=0.9839, theta=9.66 -> V=1.0, theta=0.0
% INFO    : Bus 165	: V=1.0002, theta=26.31 -> V=1.0, theta=0.0
% INFO    : Bus 166	: V=0.9973, theta=30.22 -> V=1.0, theta=0.0
% INFO    : Bus 167	: V=0.9715, theta=-6.91 -> V=1.0, theta=0.0
% INFO    : Bus 168	: V=1.0024, theta=-4.8 -> V=1.0, theta=0.0
% INFO    : Bus 169	: V=0.9879, theta=-6.68 -> V=1.0, theta=0.0
% INFO    : Bus 170	: V=0.929, theta=0.09 -> V=1.0, theta=0.0
% INFO    : Bus 171	: V=0.9829, theta=-9.94 -> V=1.0, theta=0.0
% INFO    : Bus 172	: V=1.0244, theta=-6.22 -> V=1.0, theta=0.0
% INFO    : Bus 173	: V=0.9837, theta=-12.75 -> V=1.0, theta=0.0
% INFO    : Bus 174	: V=1.0622, theta=-2.69 -> V=1.0, theta=0.0
% INFO    : Bus 175	: V=0.973, theta=-7.21 -> V=1.0, theta=0.0
% INFO    : Bus 176	: V=1.0522, theta=4.67 -> V=1.0, theta=0.0
% INFO    : Bus 177	: V=1.0077, theta=0.62 -> V=1.0, theta=0.0
% INFO    : Bus 178	: V=0.9397, theta=-6.56 -> V=1.0, theta=0.0
% INFO    : Bus 179	: V=0.9699, theta=-9.37 -> V=1.0, theta=0.0
% INFO    : Bus 180	: V=0.9793, theta=-3.09 -> V=1.0, theta=0.0
% INFO    : Bus 181	: V=1.0518, theta=-1.33 -> V=1.0, theta=0.0
% INFO    : Bus 182	: V=1.0447, theta=-4.19 -> V=1.0, theta=0.0
% INFO    : Bus 183	: V=0.9717, theta=7.12 -> V=1.0, theta=0.0
% INFO    : Bus 184	: V=1.0386, theta=-6.85 -> V=1.0, theta=0.0
% INFO    : Bus 185	: V=1.0522, theta=-4.33 -> V=1.0, theta=0.0
% INFO    : Bus 186	: V=1.065, theta=2.17 -> V=1.0, theta=0.0
% INFO    : Bus 187	: V=1.065, theta=1.4 -> V=1.0, theta=0.0
% INFO    : Bus 188	: V=1.0533, theta=-0.72 -> V=1.0, theta=0.0
% INFO    : Bus 189	: V=0.9975, theta=-25.84 -> V=1.0, theta=0.0
% INFO    : Bus 190	: V=1.0551, theta=-20.62 -> V=1.0, theta=0.0
% INFO    : Bus 191	: V=1.0435, theta=12.25 -> V=1.0, theta=0.0
% INFO    : Bus 192	: V=0.9374, theta=-11.18 -> V=1.0, theta=0.0
% INFO    : Bus 193	: V=0.9897, theta=-26.09 -> V=1.0, theta=0.0
% INFO    : Bus 194	: V=1.0489, theta=-19.21 -> V=1.0, theta=0.0
% INFO    : Bus 195	: V=1.0357, theta=-20.79 -> V=1.0, theta=0.0
% INFO    : Bus 196	: V=0.9695, theta=-25.32 -> V=1.0, theta=0.0
% INFO    : Bus 197	: V=0.9907, theta=-23.72 -> V=1.0, theta=0.0
% INFO    : Bus 198	: V=1.015, theta=-20.58 -> V=1.0, theta=0.0
% INFO    : Bus 199	: V=0.9528, theta=-26.05 -> V=1.0, theta=0.0
% INFO    : Bus 200	: V=0.955, theta=-25.93 -> V=1.0, theta=0.0
% INFO    : Bus 201	: V=0.9692, theta=-27.49 -> V=1.0, theta=0.0
% INFO    : Bus 202	: V=0.9908, theta=-25.33 -> V=1.0, theta=0.0
% INFO    : Bus 203	: V=1.0033, theta=-22.35 -> V=1.0, theta=0.0
% INFO    : Bus 204	: V=0.9718, theta=-25.7 -> V=1.0, theta=0.0
% INFO    : Bus 205	: V=0.9838, theta=-26.07 -> V=1.0, theta=0.0
% INFO    : Bus 206	: V=0.9992, theta=-27.41 -> V=1.0, theta=0.0
% INFO    : Bus 207	: V=1.0137, theta=-27.44 -> V=1.0, theta=0.0
% INFO    : Bus 208	: V=0.9929, theta=-26.28 -> V=1.0, theta=0.0
% INFO    : Bus 209	: V=0.9999, theta=-25.66 -> V=1.0, theta=0.0
% INFO    : Bus 210	: V=0.9788, theta=-24.22 -> V=1.0, theta=0.0
% INFO    : Bus 211	: V=1.0017, theta=-23.31 -> V=1.0, theta=0.0
% INFO    : Bus 212	: V=1.0132, theta=-22.51 -> V=1.0, theta=0.0
% INFO    : Bus 213	: V=1.01, theta=-11.67 -> V=1.0, theta=0.0
% INFO    : Bus 214	: V=0.9919, theta=-17.53 -> V=1.0, theta=0.0
% INFO    : Bus 215	: V=0.9866, theta=-20.23 -> V=1.0, theta=0.0
% INFO    : Bus 216	: V=0.9751, theta=-22.53 -> V=1.0, theta=0.0
% INFO    : Bus 217	: V=1.0215, theta=-22.2 -> V=1.0, theta=0.0
% INFO    : Bus 218	: V=1.0075, theta=-22.63 -> V=1.0, theta=0.0
% INFO    : Bus 219	: V=1.0554, theta=-21.15 -> V=1.0, theta=0.0
% INFO    : Bus 220	: V=1.008, theta=-21.73 -> V=1.0, theta=0.0
% INFO    : Bus 221	: V=1.0, theta=-22.49 -> V=1.0, theta=0.0
% INFO    : Bus 222	: V=1.05, theta=-23.17 -> V=1.0, theta=0.0
% INFO    : Bus 223	: V=0.9965, theta=-22.7 -> V=1.0, theta=0.0
% INFO    : Bus 224	: V=1.0002, theta=-21.55 -> V=1.0, theta=0.0
% INFO    : Bus 225	: V=0.9453, theta=-11.34 -> V=1.0, theta=0.0
% INFO    : Bus 226	: V=1.018, theta=-21.61 -> V=1.0, theta=0.0
% INFO    : Bus 227	: V=1.0, theta=-27.22 -> V=1.0, theta=0.0
% INFO    : Bus 228	: V=1.0423, theta=-20.94 -> V=1.0, theta=0.0
% INFO    : Bus 229	: V=1.0496, theta=-19.94 -> V=1.0, theta=0.0
% INFO    : Bus 230	: V=1.04, theta=-13.82 -> V=1.0, theta=0.0
% INFO    : Bus 231	: V=1.0535, theta=-21.22 -> V=1.0, theta=0.0
% INFO    : Bus 232	: V=1.0414, theta=-23.19 -> V=1.0, theta=0.0
% INFO    : Bus 233	: V=1.0, theta=-25.9 -> V=1.0, theta=0.0
% INFO    : Bus 234	: V=1.0387, theta=-20.89 -> V=1.0, theta=0.0
% INFO    : Bus 235	: V=1.0095, theta=-21.03 -> V=1.0, theta=0.0
% INFO    : Bus 236	: V=1.0165, theta=-15.4 -> V=1.0, theta=0.0
% INFO    : Bus 237	: V=1.0558, theta=-21.1 -> V=1.0, theta=0.0
% INFO    : Bus 238	: V=1.01, theta=-20.94 -> V=1.0, theta=0.0
% INFO    : Bus 239	: V=1.0, theta=-15.86 -> V=1.0, theta=0.0
% INFO    : Bus 240	: V=1.0237, theta=-20.14 -> V=1.0, theta=0.0
% INFO    : Bus 241	: V=1.05, theta=-16.5 -> V=1.0, theta=0.0
% INFO    : Bus 242	: V=0.993, theta=-17.53 -> V=1.0, theta=0.0
% INFO    : Bus 243	: V=1.01, theta=-19.27 -> V=1.0, theta=0.0
% INFO    : Bus 244	: V=0.9921, theta=-20.21 -> V=1.0, theta=0.0
% INFO    : Bus 245	: V=0.9711, theta=-20.9 -> V=1.0, theta=0.0
% INFO    : Bus 246	: V=0.9651, theta=-21.74 -> V=1.0, theta=0.0
% INFO    : Bus 247	: V=0.9688, theta=-21.67 -> V=1.0, theta=0.0
% INFO    : Bus 248	: V=0.976, theta=-25.23 -> V=1.0, theta=0.0
% INFO    : Bus 249	: V=0.9752, theta=-25.65 -> V=1.0, theta=0.0
% INFO    : Bus 250	: V=1.0196, theta=-23.8 -> V=1.0, theta=0.0
% INFO    : Bus 281	: V=1.0251, theta=-20.06 -> V=1.0, theta=0.0
% INFO    : Bus 319	: V=1.0152, theta=1.48 -> V=1.0, theta=0.0
% INFO    : Bus 320	: V=1.0146, theta=-2.23 -> V=1.0, theta=0.0
% INFO    : Bus 322	: V=1.0005, theta=-17.61 -> V=1.0, theta=0.0
% INFO    : Bus 323	: V=0.981, theta=-13.69 -> V=1.0, theta=0.0
% INFO    : Bus 324	: V=0.975, theta=-23.42 -> V=1.0, theta=0.0
% INFO    : Bus 526	: V=0.9429, theta=-34.31 -> V=1.0, theta=0.0
% INFO    : Bus 528	: V=0.9723, theta=-37.58 -> V=1.0, theta=0.0
% INFO    : Bus 531	: V=0.9604, theta=-29.1 -> V=1.0, theta=0.0
% INFO    : Bus 552	: V=1.0009, theta=-23.36 -> V=1.0, theta=0.0
% INFO    : Bus 562	: V=0.9777, theta=-28.0 -> V=1.0, theta=0.0
% INFO    : Bus 609	: V=0.9583, theta=-28.79 -> V=1.0, theta=0.0
% INFO    : Bus 664	: V=1.0309, theta=-17.0 -> V=1.0, theta=0.0
% INFO    : Bus 1190	: V=1.0128, theta=3.9 -> V=1.0, theta=0.0
% INFO    : Bus 1200	: V=1.0244, theta=-7.52 -> V=1.0, theta=0.0
% INFO    : Bus 1201	: V=1.0122, theta=-15.18 -> V=1.0, theta=0.0
% INFO    : Bus 2040	: V=0.9653, theta=-14.94 -> V=1.0, theta=0.0
% INFO    : Bus 7001	: V=1.0507, theta=10.79 -> V=1.0, theta=0.0
% INFO    : Bus 7002	: V=1.0507, theta=12.48 -> V=1.0, theta=0.0
% INFO    : Bus 7003	: V=1.0323, theta=13.76 -> V=1.0, theta=0.0
% INFO    : Bus 7011	: V=1.0145, theta=4.99 -> V=1.0, theta=0.0
% INFO    : Bus 7012	: V=1.0507, theta=11.57 -> V=1.0, theta=0.0
% INFO    : Bus 7017	: V=1.0507, theta=-10.47 -> V=1.0, theta=0.0
% INFO    : Bus 7023	: V=1.0507, theta=6.15 -> V=1.0, theta=0.0
% INFO    : Bus 7024	: V=1.029, theta=12.6 -> V=1.0, theta=0.0
% INFO    : Bus 7039	: V=1.05, theta=2.11 -> V=1.0, theta=0.0
% INFO    : Bus 7044	: V=1.0145, theta=-13.92 -> V=1.0, theta=0.0
% INFO    : Bus 7049	: V=1.0507, theta=0.0 -> V=1.0, theta=0.0
% INFO    : Bus 7055	: V=0.9967, theta=-7.5 -> V=1.0, theta=0.0
% INFO    : Bus 7057	: V=1.0212, theta=-3.44 -> V=1.0, theta=0.0
% INFO    : Bus 7061	: V=1.0145, theta=1.97 -> V=1.0, theta=0.0
% INFO    : Bus 7062	: V=1.0017, theta=5.8 -> V=1.0, theta=0.0
% INFO    : Bus 7071	: V=0.9893, theta=-25.35 -> V=1.0, theta=0.0
% INFO    : Bus 7130	: V=1.0507, theta=19.02 -> V=1.0, theta=0.0
% INFO    : Bus 7139	: V=1.0507, theta=2.75 -> V=1.0, theta=0.0
% INFO    : Bus 7166	: V=1.0145, theta=35.05 -> V=1.0, theta=0.0
% INFO    : Bus 9001	: V=1.0117, theta=-11.25 -> V=1.0, theta=0.0
% INFO    : Bus 9002	: V=0.9945, theta=-18.86 -> V=1.0, theta=0.0
% INFO    : Bus 9003	: V=0.9833, theta=-19.68 -> V=1.0, theta=0.0
% INFO    : Bus 9004	: V=0.9768, theta=-19.82 -> V=1.0, theta=0.0
% INFO    : Bus 9005	: V=1.0117, theta=-11.32 -> V=1.0, theta=0.0
% INFO    : Bus 9006	: V=1.0029, theta=-17.42 -> V=1.0, theta=0.0
% INFO    : Bus 9007	: V=0.9913, theta=-18.69 -> V=1.0, theta=0.0
% INFO    : Bus 9012	: V=1.0023, theta=-17.27 -> V=1.0, theta=0.0
% INFO    : Bus 9021	: V=0.9887, theta=-19.09 -> V=1.0, theta=0.0
% INFO    : Bus 9022	: V=0.9648, theta=-21.67 -> V=1.0, theta=0.0
% INFO    : Bus 9023	: V=0.9747, theta=-19.41 -> V=1.0, theta=0.0
% INFO    : Bus 9024	: V=0.9706, theta=-21.43 -> V=1.0, theta=0.0
% INFO    : Bus 9025	: V=0.9649, theta=-20.48 -> V=1.0, theta=0.0
% INFO    : Bus 9026	: V=0.9657, theta=-20.39 -> V=1.0, theta=0.0
% INFO    : Bus 9031	: V=0.9318, theta=-25.03 -> V=1.0, theta=0.0
% INFO    : Bus 9032	: V=0.9441, theta=-23.84 -> V=1.0, theta=0.0
% INFO    : Bus 9033	: V=0.9286, theta=-25.33 -> V=1.0, theta=0.0
% INFO    : Bus 9034	: V=0.9973, theta=-21.1 -> V=1.0, theta=0.0
% INFO    : Bus 9035	: V=0.9506, theta=-23.19 -> V=1.0, theta=0.0
% INFO    : Bus 9036	: V=0.9598, theta=-22.67 -> V=1.0, theta=0.0
% INFO    : Bus 9037	: V=0.957, theta=-22.58 -> V=1.0, theta=0.0
% INFO    : Bus 9038	: V=0.9391, theta=-24.41 -> V=1.0, theta=0.0
% INFO    : Bus 9041	: V=0.9636, theta=-21.33 -> V=1.0, theta=0.0
% INFO    : Bus 9042	: V=0.9501, theta=-22.5 -> V=1.0, theta=0.0
% INFO    : Bus 9043	: V=0.9646, theta=-21.42 -> V=1.0, theta=0.0
% INFO    : Bus 9044	: V=0.979, theta=-19.78 -> V=1.0, theta=0.0
% INFO    : Bus 9051	: V=1.0, theta=-19.4 -> V=1.0, theta=0.0
% INFO    : Bus 9052	: V=0.9786, theta=-17.25 -> V=1.0, theta=0.0
% INFO    : Bus 9053	: V=1.0, theta=-17.68 -> V=1.0, theta=0.0
% INFO    : Bus 9054	: V=1.0, theta=-6.83 -> V=1.0, theta=0.0
% INFO    : Bus 9055	: V=1.0, theta=-7.54 -> V=1.0, theta=0.0
% INFO    : Bus 9071	: V=0.9752, theta=-20.48 -> V=1.0, theta=0.0
% INFO    : Bus 9072	: V=0.9803, theta=-19.92 -> V=1.0, theta=0.0
% INFO    : Bus 9121	: V=0.9799, theta=-19.3 -> V=1.0, theta=0.0
% INFO    : Bus 9533	: V=1.0402, theta=-18.24 -> V=1.0, theta=0.0
% INFO    :
% INFO    : === Generator Setpoint Replacement Notes ===
% INFO    : Gen at bus 8	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 8	: Vg=1.0153 -> Vg=1.0
% INFO    : Gen at bus 10	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 10	: Vg=1.0205 -> Vg=1.0
% INFO    : Gen at bus 20	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 20	: Vg=1.001 -> Vg=1.0
% INFO    : Gen at bus 63	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 63	: Vg=0.9583 -> Vg=1.0
% INFO    : Gen at bus 76	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=23.5
% INFO    : Gen at bus 76	: Vg=0.9632 -> Vg=1.0
% INFO    : Gen at bus 84	: Pg=375.0, Qg=0.0 -> Pg=724.0, Qg=0.0
% INFO    : Gen at bus 84	: Vg=1.025 -> Vg=1.0
% INFO    : Gen at bus 91	: Pg=155.0, Qg=0.0 -> Pg=92.5, Qg=41.0
% INFO    : Gen at bus 91	: Vg=1.052 -> Vg=1.0
% INFO    : Gen at bus 92	: Pg=290.0, Qg=0.0 -> Pg=180.0, Qg=0.0
% INFO    : Gen at bus 92	: Vg=1.052 -> Vg=1.0
% INFO    : Gen at bus 98	: Pg=68.0, Qg=0.0 -> Pg=46.5, Qg=8.5
% INFO    : Gen at bus 98	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 108	: Pg=117.0, Qg=0.0 -> Pg=98.5, Qg=26.5
% INFO    : Gen at bus 108	: Vg=0.99 -> Vg=1.0
% INFO    : Gen at bus 119	: Pg=1930.0, Qg=0.0 -> Pg=1020.5, Qg=260.5
% INFO    : Gen at bus 119	: Vg=1.0435 -> Vg=1.0
% INFO    : Gen at bus 124	: Pg=240.0, Qg=0.0 -> Pg=160.5, Qg=30.0
% INFO    : Gen at bus 124	: Vg=1.0233 -> Vg=1.0
% INFO    : Gen at bus 125	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=87.5
% INFO    : Gen at bus 125	: Vg=1.0103 -> Vg=1.0
% INFO    : Gen at bus 138	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=112.5
% INFO    : Gen at bus 138	: Vg=1.055 -> Vg=1.0
% INFO    : Gen at bus 141	: Pg=281.0, Qg=0.0 -> Pg=148.5, Qg=12.5
% INFO    : Gen at bus 141	: Vg=1.051 -> Vg=1.0
% INFO    : Gen at bus 143	: Pg=696.0, Qg=0.0 -> Pg=400.0, Qg=100.0
% INFO    : Gen at bus 143	: Vg=1.0435 -> Vg=1.0
% INFO    : Gen at bus 146	: Pg=84.0, Qg=0.0 -> Pg=45.5, Qg=10.0
% INFO    : Gen at bus 146	: Vg=1.0528 -> Vg=1.0
% INFO    : Gen at bus 147	: Pg=217.0, Qg=0.0 -> Pg=160.0, Qg=25.0
% INFO    : Gen at bus 147	: Vg=1.0528 -> Vg=1.0
% INFO    : Gen at bus 149	: Pg=103.0, Qg=0.0 -> Pg=138.5, Qg=12.5
% INFO    : Gen at bus 149	: Vg=1.0735 -> Vg=1.0
% INFO    : Gen at bus 152	: Pg=372.0, Qg=0.0 -> Pg=303.0, Qg=62.5
% INFO    : Gen at bus 152	: Vg=1.0535 -> Vg=1.0
% INFO    : Gen at bus 153	: Pg=216.0, Qg=0.0 -> Pg=121.0, Qg=20.0
% INFO    : Gen at bus 153	: Vg=1.0435 -> Vg=1.0
% INFO    : Gen at bus 156	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=2.5
% INFO    : Gen at bus 156	: Vg=0.963 -> Vg=1.0
% INFO    : Gen at bus 170	: Pg=205.0, Qg=0.0 -> Pg=165.0, Qg=25.0
% INFO    : Gen at bus 170	: Vg=0.929 -> Vg=1.0
% INFO    : Gen at bus 171	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=50.0
% INFO    : Gen at bus 171	: Vg=0.9829 -> Vg=1.0
% INFO    : Gen at bus 176	: Pg=228.0, Qg=0.0 -> Pg=139.0, Qg=22.5
% INFO    : Gen at bus 176	: Vg=1.0522 -> Vg=1.0
% INFO    : Gen at bus 177	: Pg=84.0, Qg=0.0 -> Pg=62.5, Qg=10.0
% INFO    : Gen at bus 177	: Vg=1.0077 -> Vg=1.0
% INFO    : Gen at bus 185	: Pg=200.0, Qg=0.0 -> Pg=125.0, Qg=15.0
% INFO    : Gen at bus 185	: Vg=1.0522 -> Vg=1.0
% INFO    : Gen at bus 186	: Pg=1200.0, Qg=0.0 -> Pg=1232.5, Qg=150.0
% INFO    : Gen at bus 186	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 187	: Pg=1200.0, Qg=0.0 -> Pg=812.0, Qg=150.0
% INFO    : Gen at bus 187	: Vg=1.065 -> Vg=1.0
% INFO    : Gen at bus 190	: Pg=475.0, Qg=0.0 -> Pg=257.5, Qg=0.0
% INFO    : Gen at bus 190	: Vg=1.0551 -> Vg=1.0
% INFO    : Gen at bus 191	: Pg=1973.0, Qg=0.0 -> Pg=1070.0, Qg=0.0
% INFO    : Gen at bus 191	: Vg=1.0435 -> Vg=1.0
% INFO    : Gen at bus 198	: Pg=424.0, Qg=0.0 -> Pg=215.0, Qg=0.0
% INFO    : Gen at bus 198	: Vg=1.015 -> Vg=1.0
% INFO    : Gen at bus 213	: Pg=272.0, Qg=0.0 -> Pg=144.0, Qg=0.0
% INFO    : Gen at bus 213	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 220	: Pg=100.0, Qg=0.0 -> Pg=230.0, Qg=0.0
% INFO    : Gen at bus 220	: Vg=1.008 -> Vg=1.0
% INFO    : Gen at bus 221	: Pg=450.0, Qg=0.0 -> Pg=277.0, Qg=0.0
% INFO    : Gen at bus 221	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 222	: Pg=250.0, Qg=0.0 -> Pg=261.5, Qg=0.0
% INFO    : Gen at bus 222	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 227	: Pg=303.0, Qg=0.0 -> Pg=218.0, Qg=0.0
% INFO    : Gen at bus 227	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 230	: Pg=345.0, Qg=0.0 -> Pg=229.0, Qg=0.0
% INFO    : Gen at bus 230	: Vg=1.04 -> Vg=1.0
% INFO    : Gen at bus 233	: Pg=300.0, Qg=0.0 -> Pg=170.5, Qg=0.0
% INFO    : Gen at bus 233	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 236	: Pg=600.0, Qg=0.0 -> Pg=440.5, Qg=0.0
% INFO    : Gen at bus 236	: Vg=1.0165 -> Vg=1.0
% INFO    : Gen at bus 238	: Pg=250.0, Qg=0.0 -> Pg=133.5, Qg=0.0
% INFO    : Gen at bus 238	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 239	: Pg=550.0, Qg=0.0 -> Pg=310.5, Qg=0.0
% INFO    : Gen at bus 239	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 241	: Pg=575.43, Qg=0.0 -> Pg=563.5, Qg=0.0
% INFO    : Gen at bus 241	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 242	: Pg=170.0, Qg=0.0 -> Pg=106.0, Qg=70.0
% INFO    : Gen at bus 242	: Vg=0.993 -> Vg=1.0
% INFO    : Gen at bus 243	: Pg=84.0, Qg=0.0 -> Pg=171.0, Qg=60.0
% INFO    : Gen at bus 243	: Vg=1.01 -> Vg=1.0
% INFO    : Gen at bus 7001	: Pg=467.0, Qg=0.0 -> Pg=284.0, Qg=0.0
% INFO    : Gen at bus 7001	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7002	: Pg=623.0, Qg=0.0 -> Pg=335.0, Qg=0.0
% INFO    : Gen at bus 7002	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7003	: Pg=1210.0, Qg=0.0 -> Pg=700.5, Qg=0.0
% INFO    : Gen at bus 7003	: Vg=1.0323 -> Vg=1.0
% INFO    : Gen at bus 7011	: Pg=234.0, Qg=0.0 -> Pg=334.0, Qg=0.0
% INFO    : Gen at bus 7011	: Vg=1.0145 -> Vg=1.0
% INFO    : Gen at bus 7012	: Pg=372.0, Qg=0.0 -> Pg=313.0, Qg=0.0
% INFO    : Gen at bus 7012	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7017	: Pg=330.0, Qg=0.0 -> Pg=245.0, Qg=122.5
% INFO    : Gen at bus 7017	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7023	: Pg=185.0, Qg=0.0 -> Pg=110.0, Qg=55.0
% INFO    : Gen at bus 7023	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7024	: Pg=410.0, Qg=0.0 -> Pg=271.5, Qg=0.0
% INFO    : Gen at bus 7024	: Vg=1.029 -> Vg=1.0
% INFO    : Gen at bus 7039	: Pg=500.0, Qg=0.0 -> Pg=290.0, Qg=0.0
% INFO    : Gen at bus 7039	: Vg=1.05 -> Vg=1.0
% INFO    : Gen at bus 7044	: Pg=37.0, Qg=0.0 -> Pg=66.0, Qg=21.0
% INFO    : Gen at bus 7044	: Vg=1.0145 -> Vg=1.0
% INFO    : Gen at bus 7049	: Pg=0.0, Qg=0.0 -> Pg=359.0, Qg=5.0
% INFO    : Gen at bus 7049	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7055	: Pg=45.0, Qg=0.0 -> Pg=79.0, Qg=12.5
% INFO    : Gen at bus 7055	: Vg=0.9967 -> Vg=1.0
% INFO    : Gen at bus 7057	: Pg=165.0, Qg=0.0 -> Pg=167.0, Qg=0.0
% INFO    : Gen at bus 7057	: Vg=1.0212 -> Vg=1.0
% INFO    : Gen at bus 7061	: Pg=400.0, Qg=0.0 -> Pg=878.5, Qg=0.0
% INFO    : Gen at bus 7061	: Vg=1.0145 -> Vg=1.0
% INFO    : Gen at bus 7062	: Pg=400.0, Qg=0.0 -> Pg=284.0, Qg=75.0
% INFO    : Gen at bus 7062	: Vg=1.0017 -> Vg=1.0
% INFO    : Gen at bus 7071	: Pg=116.0, Qg=0.0 -> Pg=101.5, Qg=43.5
% INFO    : Gen at bus 7071	: Vg=0.9893 -> Vg=1.0
% INFO    : Gen at bus 7130	: Pg=1292.0, Qg=0.0 -> Pg=863.0, Qg=250.0
% INFO    : Gen at bus 7130	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7139	: Pg=700.0, Qg=0.0 -> Pg=1012.5, Qg=100.0
% INFO    : Gen at bus 7139	: Vg=1.0507 -> Vg=1.0
% INFO    : Gen at bus 7166	: Pg=553.0, Qg=0.0 -> Pg=312.0, Qg=50.0
% INFO    : Gen at bus 7166	: Vg=1.0145 -> Vg=1.0
% INFO    : Gen at bus 9002	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 9002	: Vg=0.9945 -> Vg=1.0
% INFO    : Gen at bus 9051	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.0
% INFO    : Gen at bus 9051	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 9053	: Pg=0.0, Qg=0.0 -> Pg=0.0, Qg=0.015
% INFO    : Gen at bus 9053	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 9054	: Pg=50.0, Qg=0.0 -> Pg=42.0, Qg=0.0
% INFO    : Gen at bus 9054	: Vg=1.0 -> Vg=1.0
% INFO    : Gen at bus 9055	: Pg=8.0, Qg=0.0 -> Pg=18.5, Qg=0.0
% INFO    : Gen at bus 9055	: Vg=1.0 -> Vg=1.0
% INFO    :
% INFO    : === Writing Matpower Case File Notes ===
