# Generated by Plain 0.52.2 on 2025-07-06 02:00

from plain import models, signing
from plain.models import migrations


def copy_sessions(apps, schema_editor):
    """
    Copy data from the old Session2 model to the new Session model.
    """
    Session2 = apps.get_model("plainsessions", "Session2")
    Session = apps.get_model("plainsessions", "Session")

    salt = "plain.sessions.SessionStore"

    to_create = []

    for session in Session2.objects.all():
        session_data = signing.loads(session.session_data, salt=salt)
        to_create.append(
            Session(
                session_key=session.session_key,
                session_data=session_data,
                expires_at=session.expires_at,
            )
        )

    Session.objects.bulk_create(to_create)


class Migration(migrations.Migration):
    dependencies = [
        ("plainsessions", "0004_alter_session_managers_and_more"),
    ]

    operations = [
        migrations.RenameModel(
            old_name="Session",
            new_name="Session2",
        ),
        migrations.RenameIndex(
            model_name="session2",
            new_name="plainsessio_expires_f66c08_idx",
            old_name="plainsessio_expires_d87cb5_idx",
        ),
        migrations.CreateModel(
            name="Session",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True)),
                ("session_key", models.CharField(max_length=40)),
                ("session_data", models.JSONField(default=dict, required=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("expires_at", models.DateTimeField(allow_null=True)),
            ],
        ),
        migrations.AddIndex(
            model_name="session",
            index=models.Index(
                fields=["expires_at"], name="plainsessio_expires_d87cb5_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="session",
            constraint=models.UniqueConstraint(
                fields=("session_key",), name="unique_session_key"
            ),
        ),
        migrations.RunPython(copy_sessions),
        migrations.DeleteModel(
            name="Session2",
        ),
    ]
