# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dropbox_sign.models.account_response_quotas import AccountResponseQuotas
from dropbox_sign.models.account_response_usage import AccountResponseUsage
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class AccountResponse(BaseModel):
    """
    AccountResponse
    """  # noqa: E501

    account_id: Optional[StrictStr] = Field(
        default=None, description="The ID of the Account"
    )
    email_address: Optional[StrictStr] = Field(
        default=None, description="The email address associated with the Account."
    )
    is_locked: Optional[StrictBool] = Field(
        default=None,
        description="Returns `true` if the user has been locked out of their account by a team admin.",
    )
    is_paid_hs: Optional[StrictBool] = Field(
        default=None,
        description="Returns `true` if the user has a paid Dropbox Sign account.",
    )
    is_paid_hf: Optional[StrictBool] = Field(
        default=None,
        description="Returns `true` if the user has a paid HelloFax account.",
    )
    quotas: Optional[AccountResponseQuotas] = None
    callback_url: Optional[StrictStr] = Field(
        default=None, description="The URL that Dropbox Sign events will `POST` to."
    )
    role_code: Optional[StrictStr] = Field(
        default=None, description="The membership role for the team."
    )
    team_id: Optional[StrictStr] = Field(
        default=None, description="The id of the team account belongs to."
    )
    locale: Optional[StrictStr] = Field(
        default=None,
        description="The locale used in this Account. Check out the list of [supported locales](/api/reference/constants/#supported-locales) to learn more about the possible values.",
    )
    usage: Optional[AccountResponseUsage] = None
    __properties: ClassVar[List[str]] = [
        "account_id",
        "email_address",
        "is_locked",
        "is_paid_hs",
        "is_paid_hf",
        "quotas",
        "callback_url",
        "role_code",
        "team_id",
        "locale",
        "usage",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AccountResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of quotas
        if self.quotas:
            _dict["quotas"] = self.quotas.to_dict()
        # override the default output from pydantic by calling `to_dict()` of usage
        if self.usage:
            _dict["usage"] = self.usage.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AccountResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "account_id": obj.get("account_id"),
                "email_address": obj.get("email_address"),
                "is_locked": obj.get("is_locked"),
                "is_paid_hs": obj.get("is_paid_hs"),
                "is_paid_hf": obj.get("is_paid_hf"),
                "quotas": (
                    AccountResponseQuotas.from_dict(obj["quotas"])
                    if obj.get("quotas") is not None
                    else None
                ),
                "callback_url": obj.get("callback_url"),
                "role_code": obj.get("role_code"),
                "team_id": obj.get("team_id"),
                "locale": obj.get("locale"),
                "usage": (
                    AccountResponseUsage.from_dict(obj["usage"])
                    if obj.get("usage") is not None
                    else None
                ),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "account_id": "(str,)",
            "email_address": "(str,)",
            "is_locked": "(bool,)",
            "is_paid_hs": "(bool,)",
            "is_paid_hf": "(bool,)",
            "quotas": "(AccountResponseQuotas,)",
            "callback_url": "(str,)",
            "role_code": "(str,)",
            "team_id": "(str,)",
            "locale": "(str,)",
            "usage": "(AccountResponseUsage,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
