# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from dropbox_sign.models.event_callback_request_event_metadata import (
    EventCallbackRequestEventMetadata,
)
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class EventCallbackRequestEvent(BaseModel):
    """
    Basic information about the event that occurred.
    """  # noqa: E501

    event_time: StrictStr = Field(
        description="Time the event was created (using Unix time)."
    )
    event_type: StrictStr = Field(
        description="Type of callback event that was triggered."
    )
    event_hash: StrictStr = Field(
        description="Generated hash used to verify source of event data."
    )
    event_metadata: Optional[EventCallbackRequestEventMetadata] = None
    __properties: ClassVar[List[str]] = [
        "event_time",
        "event_type",
        "event_hash",
        "event_metadata",
    ]

    @field_validator("event_type")
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(
            [
                "account_confirmed",
                "unknown_error",
                "file_error",
                "sign_url_invalid",
                "signature_request_viewed",
                "signature_request_signed",
                "signature_request_sent",
                "signature_request_all_signed",
                "signature_request_email_bounce",
                "signature_request_remind",
                "signature_request_incomplete_qes",
                "signature_request_destroyed",
                "signature_request_canceled",
                "signature_request_downloadable",
                "signature_request_declined",
                "signature_request_reassigned",
                "signature_request_invalid",
                "signature_request_prepared",
                "signature_request_expired",
                "template_created",
                "template_error",
                "callback_test",
                "signature_request_signer_removed",
            ]
        ):
            raise ValueError(
                "must be one of enum values ('account_confirmed', 'unknown_error', 'file_error', 'sign_url_invalid', 'signature_request_viewed', 'signature_request_signed', 'signature_request_sent', 'signature_request_all_signed', 'signature_request_email_bounce', 'signature_request_remind', 'signature_request_incomplete_qes', 'signature_request_destroyed', 'signature_request_canceled', 'signature_request_downloadable', 'signature_request_declined', 'signature_request_reassigned', 'signature_request_invalid', 'signature_request_prepared', 'signature_request_expired', 'template_created', 'template_error', 'callback_test', 'signature_request_signer_removed')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventCallbackRequestEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of event_metadata
        if self.event_metadata:
            _dict["event_metadata"] = self.event_metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventCallbackRequestEvent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "event_time": obj.get("event_time"),
                "event_type": obj.get("event_type"),
                "event_hash": obj.get("event_hash"),
                "event_metadata": (
                    EventCallbackRequestEventMetadata.from_dict(obj["event_metadata"])
                    if obj.get("event_metadata") is not None
                    else None
                ),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "event_time": "(str,)",
            "event_type": "(str,)",
            "event_hash": "(str,)",
            "event_metadata": "(EventCallbackRequestEventMetadata,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
