# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Tuple, Union
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class FaxSendRequest(BaseModel):
    """
    FaxSendRequest
    """  # noqa: E501

    recipient: StrictStr = Field(
        description="Recipient of the fax  Can be a phone number in E.164 format or email address"
    )
    sender: Optional[StrictStr] = Field(
        default=None, description="Fax Send From Sender (used only with fax number)"
    )
    files: Optional[
        List[Union[StrictBytes, StrictStr, io.IOBase, Tuple[StrictStr, StrictBytes, io.IOBase]]]
    ] = Field(
        default=None,
        description="Use `files[]` to indicate the uploaded file(s) to fax  This endpoint requires either **files** or **file_urls[]**, but not both.",
    )
    file_urls: Optional[List[StrictStr]] = Field(
        default=None,
        description="Use `file_urls[]` to have Dropbox Fax download the file(s) to fax  This endpoint requires either **files** or **file_urls[]**, but not both.",
    )
    test_mode: Optional[StrictBool] = Field(
        default=False, description="API Test Mode Setting"
    )
    cover_page_to: Optional[StrictStr] = Field(
        default=None, description="Fax cover page recipient information"
    )
    cover_page_from: Optional[StrictStr] = Field(
        default=None, description="Fax cover page sender information"
    )
    cover_page_message: Optional[StrictStr] = Field(
        default=None, description="Fax Cover Page Message"
    )
    title: Optional[StrictStr] = Field(default=None, description="Fax Title")
    __properties: ClassVar[List[str]] = [
        "recipient",
        "sender",
        "files",
        "file_urls",
        "test_mode",
        "cover_page_to",
        "cover_page_from",
        "cover_page_message",
        "title",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FaxSendRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FaxSendRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "recipient": obj.get("recipient"),
                "sender": obj.get("sender"),
                "files": obj.get("files"),
                "file_urls": obj.get("file_urls"),
                "test_mode": (
                    obj.get("test_mode") if obj.get("test_mode") is not None else False
                ),
                "cover_page_to": obj.get("cover_page_to"),
                "cover_page_from": obj.get("cover_page_from"),
                "cover_page_message": obj.get("cover_page_message"),
                "title": obj.get("title"),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "recipient": "(str,)",
            "sender": "(str,)",
            "files": "(List[io.IOBase],)",
            "file_urls": "(List[str],)",
            "test_mode": "(bool,)",
            "cover_page_to": "(str,)",
            "cover_page_from": "(str,)",
            "cover_page_message": "(str,)",
            "title": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
            "files",
            "file_urls",
        ]
