# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated
from dropbox_sign.models.sub_bulk_signer_list import SubBulkSignerList
from dropbox_sign.models.sub_cc import SubCC
from dropbox_sign.models.sub_custom_field import SubCustomField
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class SignatureRequestBulkSendWithTemplateRequest(BaseModel):
    """
    SignatureRequestBulkSendWithTemplateRequest
    """  # noqa: E501

    template_ids: List[StrictStr] = Field(
        description="Use `template_ids` to create a SignatureRequest from one or more templates, in the order in which the template will be used."
    )
    signer_file: Optional[
        Union[StrictBytes, StrictStr, io.IOBase, Tuple[StrictStr, StrictBytes, io.IOBase]]
    ] = Field(
        default=None,
        description="`signer_file` is a CSV file defining values and options for signer fields. Required unless a `signer_list` is used, you may not use both. The CSV can have the following columns:  - `name`: the name of the signer filling the role of RoleName - `email_address`: email address of the signer filling the role of RoleName - `pin`: the 4- to 12-character access code that will secure this signer's signature page (optional) - `sms_phone_number`: An E.164 formatted phone number that will receive a code via SMS to access this signer's signature page. (optional)      By using the feature, you agree you are responsible for obtaining a signer's consent to receive text messages from Dropbox Sign related to this signature request and confirm you have obtained such consent from all signers prior to enabling SMS delivery for this signature request. [Learn more](https://faq.hellosign.com/hc/en-us/articles/15815316468877-Dropbox-Sign-SMS-tools-add-on).      **NOTE:** Not available in test mode and requires a Standard plan or higher. - `*_field`: any column with a _field\" suffix will be treated as a custom field (optional)      You may only specify field values here, any other options should be set in the custom_fields request parameter.  Example CSV:  ``` name, email_address, pin, company_field George, george@example.com, d79a3td, ABC Corp Mary, mary@example.com, gd9as5b, 123 LLC ```",
    )
    signer_list: Optional[List[SubBulkSignerList]] = Field(
        default=None,
        description="`signer_list` is an array defining values and options for signer fields. Required unless a `signer_file` is used, you may not use both.",
    )
    allow_decline: Optional[StrictBool] = Field(
        default=False,
        description="Allows signers to decline to sign a document if `true`. Defaults to `false`.",
    )
    ccs: Optional[List[SubCC]] = Field(
        default=None,
        description="Add CC email recipients. Required when a CC role exists for the Template.",
    )
    client_id: Optional[StrictStr] = Field(
        default=None,
        description="The client id of the API App you want to associate with this request. Used to apply the branding and callback url defined for the app.",
    )
    custom_fields: Optional[List[SubCustomField]] = Field(
        default=None,
        description='When used together with merge fields, `custom_fields` allows users to add pre-filled data to their signature requests.  Pre-filled data can be used with "send-once" signature requests by adding merge fields with `form_fields_per_document` or [Text Tags](https://app.hellosign.com/api/textTagsWalkthrough#TextTagIntro) while passing values back with `custom_fields` together in one API call.  For using pre-filled on repeatable signature requests, merge fields are added to templates in the Dropbox Sign UI or by calling [/template/create_embedded_draft](/api/reference/operation/templateCreateEmbeddedDraft) and then passing `custom_fields` on subsequent signature requests referencing that template.',
    )
    message: Optional[Annotated[str, Field(strict=True, max_length=5000)]] = Field(
        default=None,
        description="The custom message in the email that will be sent to the signers.",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Key-value data that should be attached to the signature request. This metadata is included in all API responses and events involving the signature request. For example, use the metadata field to store a signer's order number for look up when receiving events for the signature request.  Each request can include up to 10 metadata keys (or 50 nested metadata keys), with key names up to 40 characters long and values up to 1000 characters long.",
    )
    signing_redirect_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL you want signers redirected to after they successfully sign.",
    )
    subject: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(
        default=None,
        description="The subject in the email that will be sent to the signers.",
    )
    test_mode: Optional[StrictBool] = Field(
        default=False,
        description="Whether this is a test, the signature request will not be legally binding if set to `true`. Defaults to `false`.",
    )
    title: Optional[Annotated[str, Field(strict=True, max_length=255)]] = Field(
        default=None,
        description="The title you want to assign to the SignatureRequest.",
    )
    __properties: ClassVar[List[str]] = [
        "template_ids",
        "signer_file",
        "signer_list",
        "allow_decline",
        "ccs",
        "client_id",
        "custom_fields",
        "message",
        "metadata",
        "signing_redirect_url",
        "subject",
        "test_mode",
        "title",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SignatureRequestBulkSendWithTemplateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in signer_list (list)
        _items = []
        if self.signer_list:
            for _item_signer_list in self.signer_list:
                if _item_signer_list:
                    _items.append(_item_signer_list.to_dict())
            _dict["signer_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in ccs (list)
        _items = []
        if self.ccs:
            for _item_ccs in self.ccs:
                if _item_ccs:
                    _items.append(_item_ccs.to_dict())
            _dict["ccs"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict["custom_fields"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SignatureRequestBulkSendWithTemplateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "template_ids": obj.get("template_ids"),
                "signer_file": obj.get("signer_file"),
                "signer_list": (
                    [SubBulkSignerList.from_dict(_item) for _item in obj["signer_list"]]
                    if obj.get("signer_list") is not None
                    else None
                ),
                "allow_decline": (
                    obj.get("allow_decline")
                    if obj.get("allow_decline") is not None
                    else False
                ),
                "ccs": (
                    [SubCC.from_dict(_item) for _item in obj["ccs"]]
                    if obj.get("ccs") is not None
                    else None
                ),
                "client_id": obj.get("client_id"),
                "custom_fields": (
                    [SubCustomField.from_dict(_item) for _item in obj["custom_fields"]]
                    if obj.get("custom_fields") is not None
                    else None
                ),
                "message": obj.get("message"),
                "metadata": obj.get("metadata"),
                "signing_redirect_url": obj.get("signing_redirect_url"),
                "subject": obj.get("subject"),
                "test_mode": (
                    obj.get("test_mode") if obj.get("test_mode") is not None else False
                ),
                "title": obj.get("title"),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "template_ids": "(List[str],)",
            "signer_file": "(io.IOBase,)",
            "signer_list": "(List[SubBulkSignerList],)",
            "allow_decline": "(bool,)",
            "ccs": "(List[SubCC],)",
            "client_id": "(str,)",
            "custom_fields": "(List[SubCustomField],)",
            "message": "(str,)",
            "metadata": "(Dict[str, object],)",
            "signing_redirect_url": "(str,)",
            "subject": "(str,)",
            "test_mode": "(bool,)",
            "title": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
            "template_ids",
            "signer_list",
            "ccs",
            "custom_fields",
        ]
