# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from dropbox_sign.models.signature_request_response_custom_field_checkbox import (
        SignatureRequestResponseCustomFieldCheckbox,
    )
    from dropbox_sign.models.signature_request_response_custom_field_text import (
        SignatureRequestResponseCustomFieldText,
    )


class SignatureRequestResponseCustomFieldBase(BaseModel):
    """
    An array of Custom Field objects containing the name and type of each custom field.  * Text Field uses `SignatureRequestResponseCustomFieldText` * Checkbox Field uses `SignatureRequestResponseCustomFieldCheckbox`
    """  # noqa: E501

    type: StrictStr = Field(
        description="The type of this Custom Field. Only 'text' and 'checkbox' are currently supported."
    )
    name: StrictStr = Field(description="The name of the Custom Field.")
    required: Optional[StrictBool] = Field(
        default=None, description="A boolean value denoting if this field is required."
    )
    api_id: Optional[StrictStr] = Field(
        default=None, description="The unique ID for this field."
    )
    editor: Optional[StrictStr] = Field(
        default=None,
        description="The name of the Role that is able to edit this field.",
    )
    __properties: ClassVar[List[str]] = ["type", "name", "required", "api_id", "editor"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "checkbox": "SignatureRequestResponseCustomFieldCheckbox",
        "text": "SignatureRequestResponseCustomFieldText",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            SignatureRequestResponseCustomFieldCheckbox,
            SignatureRequestResponseCustomFieldText,
        ]
    ]:
        """Create an instance of SignatureRequestResponseCustomFieldBase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            SignatureRequestResponseCustomFieldCheckbox,
            SignatureRequestResponseCustomFieldText,
        ]
    ]:
        """Create an instance of SignatureRequestResponseCustomFieldBase from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "SignatureRequestResponseCustomFieldCheckbox":
            return import_module(
                "dropbox_sign.models.signature_request_response_custom_field_checkbox"
            ).SignatureRequestResponseCustomFieldCheckbox.from_dict(obj)
        if object_type == "SignatureRequestResponseCustomFieldText":
            return import_module(
                "dropbox_sign.models.signature_request_response_custom_field_text"
            ).SignatureRequestResponseCustomFieldText.from_dict(obj)

        raise ValueError(
            "SignatureRequestResponseCustomFieldBase failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "type": "(str,)",
            "name": "(str,)",
            "required": "(bool,)",
            "api_id": "(str,)",
            "editor": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
