# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class SignatureRequestResponseSignatures(BaseModel):
    """
    An array of signature objects, 1 for each signer.
    """  # noqa: E501

    signature_id: Optional[StrictStr] = Field(
        default=None, description="Signature identifier."
    )
    signer_group_guid: Optional[StrictStr] = Field(
        default=None, description="Signer Group GUID"
    )
    signer_email_address: Optional[StrictStr] = Field(
        default=None, description="The email address of the signer."
    )
    signer_name: Optional[StrictStr] = Field(
        default=None, description="The name of the signer."
    )
    signer_role: Optional[StrictStr] = Field(
        default=None, description="The role of the signer."
    )
    order: Optional[StrictInt] = Field(
        default=None,
        description="If signer order is assigned this is the 0-based index for this signer.",
    )
    status_code: Optional[StrictStr] = Field(
        default=None,
        description="The current status of the signature. eg: awaiting_signature, signed, declined.",
    )
    decline_reason: Optional[StrictStr] = Field(
        default=None,
        description="The reason provided by the signer for declining the request.",
    )
    signed_at: Optional[StrictInt] = Field(
        default=None, description="Time that the document was signed or null."
    )
    last_viewed_at: Optional[StrictInt] = Field(
        default=None,
        description="The time that the document was last viewed by this signer or null.",
    )
    last_reminded_at: Optional[StrictInt] = Field(
        default=None,
        description="The time the last reminder email was sent to the signer or null.",
    )
    has_pin: Optional[StrictBool] = Field(
        default=None,
        description="Boolean to indicate whether this signature requires a PIN to access.",
    )
    has_sms_auth: Optional[StrictBool] = Field(
        default=None,
        description="Boolean to indicate whether this signature has SMS authentication enabled.",
    )
    has_sms_delivery: Optional[StrictBool] = Field(
        default=None,
        description="Boolean to indicate whether this signature has SMS delivery enabled.",
    )
    sms_phone_number: Optional[StrictStr] = Field(
        default=None,
        description="The SMS phone number used for authentication or signature request delivery.",
    )
    reassigned_by: Optional[StrictStr] = Field(
        default=None,
        description="Email address of original signer who reassigned to this signer.",
    )
    reassignment_reason: Optional[StrictStr] = Field(
        default=None,
        description="Reason provided by original signer who reassigned to this signer.",
    )
    reassigned_from: Optional[StrictStr] = Field(
        default=None, description="Previous signature identifier."
    )
    error: Optional[StrictStr] = Field(
        default=None, description="Error message pertaining to this signer, or null."
    )
    __properties: ClassVar[List[str]] = [
        "signature_id",
        "signer_group_guid",
        "signer_email_address",
        "signer_name",
        "signer_role",
        "order",
        "status_code",
        "decline_reason",
        "signed_at",
        "last_viewed_at",
        "last_reminded_at",
        "has_pin",
        "has_sms_auth",
        "has_sms_delivery",
        "sms_phone_number",
        "reassigned_by",
        "reassignment_reason",
        "reassigned_from",
        "error",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SignatureRequestResponseSignatures from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SignatureRequestResponseSignatures from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "signature_id": obj.get("signature_id"),
                "signer_group_guid": obj.get("signer_group_guid"),
                "signer_email_address": obj.get("signer_email_address"),
                "signer_name": obj.get("signer_name"),
                "signer_role": obj.get("signer_role"),
                "order": obj.get("order"),
                "status_code": obj.get("status_code"),
                "decline_reason": obj.get("decline_reason"),
                "signed_at": obj.get("signed_at"),
                "last_viewed_at": obj.get("last_viewed_at"),
                "last_reminded_at": obj.get("last_reminded_at"),
                "has_pin": obj.get("has_pin"),
                "has_sms_auth": obj.get("has_sms_auth"),
                "has_sms_delivery": obj.get("has_sms_delivery"),
                "sms_phone_number": obj.get("sms_phone_number"),
                "reassigned_by": obj.get("reassigned_by"),
                "reassignment_reason": obj.get("reassignment_reason"),
                "reassigned_from": obj.get("reassigned_from"),
                "error": obj.get("error"),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "signature_id": "(str,)",
            "signer_group_guid": "(str,)",
            "signer_email_address": "(str,)",
            "signer_name": "(str,)",
            "signer_role": "(str,)",
            "order": "(int,)",
            "status_code": "(str,)",
            "decline_reason": "(str,)",
            "signed_at": "(int,)",
            "last_viewed_at": "(int,)",
            "last_reminded_at": "(int,)",
            "has_pin": "(bool,)",
            "has_sms_auth": "(bool,)",
            "has_sms_delivery": "(bool,)",
            "sms_phone_number": "(str,)",
            "reassigned_by": "(str,)",
            "reassignment_reason": "(str,)",
            "reassigned_from": "(str,)",
            "error": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
