# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from dropbox_sign.models.sub_form_fields_per_document_checkbox import (
        SubFormFieldsPerDocumentCheckbox,
    )
    from dropbox_sign.models.sub_form_fields_per_document_checkbox_merge import (
        SubFormFieldsPerDocumentCheckboxMerge,
    )
    from dropbox_sign.models.sub_form_fields_per_document_date_signed import (
        SubFormFieldsPerDocumentDateSigned,
    )
    from dropbox_sign.models.sub_form_fields_per_document_dropdown import (
        SubFormFieldsPerDocumentDropdown,
    )
    from dropbox_sign.models.sub_form_fields_per_document_hyperlink import (
        SubFormFieldsPerDocumentHyperlink,
    )
    from dropbox_sign.models.sub_form_fields_per_document_initials import (
        SubFormFieldsPerDocumentInitials,
    )
    from dropbox_sign.models.sub_form_fields_per_document_radio import (
        SubFormFieldsPerDocumentRadio,
    )
    from dropbox_sign.models.sub_form_fields_per_document_signature import (
        SubFormFieldsPerDocumentSignature,
    )
    from dropbox_sign.models.sub_form_fields_per_document_text import (
        SubFormFieldsPerDocumentText,
    )
    from dropbox_sign.models.sub_form_fields_per_document_text_merge import (
        SubFormFieldsPerDocumentTextMerge,
    )


class SubFormFieldsPerDocumentBase(BaseModel):
    """
    The fields that should appear on the document, expressed as an array of objects. (For more details you can read about it here: [Using Form Fields per Document](/docs/openapi/form-fields-per-document).)  **NOTE:** Fields like **text**, **dropdown**, **checkbox**, **radio**, and **hyperlink** have additional required and optional parameters. Check out the list of [additional parameters](/api/reference/constants/#form-fields-per-document) for these field types.  * Text Field use `SubFormFieldsPerDocumentText` * Dropdown Field use `SubFormFieldsPerDocumentDropdown` * Hyperlink Field use `SubFormFieldsPerDocumentHyperlink` * Checkbox Field use `SubFormFieldsPerDocumentCheckbox` * Radio Field use `SubFormFieldsPerDocumentRadio` * Signature Field use `SubFormFieldsPerDocumentSignature` * Date Signed Field use `SubFormFieldsPerDocumentDateSigned` * Initials Field use `SubFormFieldsPerDocumentInitials` * Text Merge Field use `SubFormFieldsPerDocumentTextMerge` * Checkbox Merge Field use `SubFormFieldsPerDocumentCheckboxMerge`
    """  # noqa: E501

    document_index: StrictInt = Field(
        description="Represents the integer index of the `file` or `file_url` document the field should be attached to."
    )
    api_id: StrictStr = Field(
        description="An identifier for the field that is unique across all documents in the request."
    )
    height: StrictInt = Field(description="Size of the field in pixels.")
    required: StrictBool = Field(description="Whether this field is required.")
    signer: Union[StrictStr, StrictInt] = Field(
        description="Signer index identified by the offset in the signers parameter (0-based indexing), indicating which signer should fill out the field.  **NOTE:** To set the value of the field as the preparer you must set this to `me_now`  **NOTE:** If type is `text-merge` or `checkbox-merge`, you must set this to sender in order to use pre-filled data."
    )
    type: StrictStr
    width: StrictInt = Field(description="Size of the field in pixels.")
    x: StrictInt = Field(description="Location coordinates of the field in pixels.")
    y: StrictInt = Field(description="Location coordinates of the field in pixels.")
    name: Optional[StrictStr] = Field(
        default=None, description="Display name for the field."
    )
    page: Optional[StrictInt] = Field(
        default=None,
        description="Page in the document where the field should be placed (requires documents be PDF files).  - When the page number parameter is supplied, the API will use the new coordinate system. - Check out the differences between both [coordinate systems](https://faq.hellosign.com/hc/en-us/articles/217115577) and how to use them.",
    )
    __properties: ClassVar[List[str]] = [
        "document_index",
        "api_id",
        "height",
        "required",
        "signer",
        "type",
        "width",
        "x",
        "y",
        "name",
        "page",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = "type"

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        "checkbox": "SubFormFieldsPerDocumentCheckbox",
        "checkbox-merge": "SubFormFieldsPerDocumentCheckboxMerge",
        "date_signed": "SubFormFieldsPerDocumentDateSigned",
        "dropdown": "SubFormFieldsPerDocumentDropdown",
        "hyperlink": "SubFormFieldsPerDocumentHyperlink",
        "initials": "SubFormFieldsPerDocumentInitials",
        "radio": "SubFormFieldsPerDocumentRadio",
        "signature": "SubFormFieldsPerDocumentSignature",
        "text": "SubFormFieldsPerDocumentText",
        "text-merge": "SubFormFieldsPerDocumentTextMerge",
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[
        Union[
            SubFormFieldsPerDocumentCheckbox,
            SubFormFieldsPerDocumentCheckboxMerge,
            SubFormFieldsPerDocumentDateSigned,
            SubFormFieldsPerDocumentDropdown,
            SubFormFieldsPerDocumentHyperlink,
            SubFormFieldsPerDocumentInitials,
            SubFormFieldsPerDocumentRadio,
            SubFormFieldsPerDocumentSignature,
            SubFormFieldsPerDocumentText,
            SubFormFieldsPerDocumentTextMerge,
        ]
    ]:
        """Create an instance of SubFormFieldsPerDocumentBase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[
        Union[
            SubFormFieldsPerDocumentCheckbox,
            SubFormFieldsPerDocumentCheckboxMerge,
            SubFormFieldsPerDocumentDateSigned,
            SubFormFieldsPerDocumentDropdown,
            SubFormFieldsPerDocumentHyperlink,
            SubFormFieldsPerDocumentInitials,
            SubFormFieldsPerDocumentRadio,
            SubFormFieldsPerDocumentSignature,
            SubFormFieldsPerDocumentText,
            SubFormFieldsPerDocumentTextMerge,
        ]
    ]:
        """Create an instance of SubFormFieldsPerDocumentBase from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type == "SubFormFieldsPerDocumentCheckbox":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_checkbox"
            ).SubFormFieldsPerDocumentCheckbox.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentCheckboxMerge":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_checkbox_merge"
            ).SubFormFieldsPerDocumentCheckboxMerge.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentDateSigned":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_date_signed"
            ).SubFormFieldsPerDocumentDateSigned.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentDropdown":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_dropdown"
            ).SubFormFieldsPerDocumentDropdown.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentHyperlink":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_hyperlink"
            ).SubFormFieldsPerDocumentHyperlink.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentInitials":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_initials"
            ).SubFormFieldsPerDocumentInitials.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentRadio":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_radio"
            ).SubFormFieldsPerDocumentRadio.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentSignature":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_signature"
            ).SubFormFieldsPerDocumentSignature.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentText":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_text"
            ).SubFormFieldsPerDocumentText.from_dict(obj)
        if object_type == "SubFormFieldsPerDocumentTextMerge":
            return import_module(
                "dropbox_sign.models.sub_form_fields_per_document_text_merge"
            ).SubFormFieldsPerDocumentTextMerge.from_dict(obj)

        raise ValueError(
            "SubFormFieldsPerDocumentBase failed to lookup discriminator value from "
            + json.dumps(obj)
            + ". Discriminator property name: "
            + cls.__discriminator_property_name
            + ", mapping: "
            + json.dumps(cls.__discriminator_value_class_map)
        )

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "document_index": "(int,)",
            "api_id": "(str,)",
            "height": "(int,)",
            "required": "(bool,)",
            "signer": "(int, str,)",
            "type": "(str,)",
            "width": "(int,)",
            "x": "(int,)",
            "y": "(int,)",
            "name": "(str,)",
            "page": "(int,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
