# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class TeamRemoveMemberRequest(BaseModel):
    """
    TeamRemoveMemberRequest
    """  # noqa: E501

    account_id: Optional[StrictStr] = Field(
        default=None,
        description="**account_id** or **email_address** is required. If both are provided, the account id prevails.  Account id to remove from your Team.",
    )
    email_address: Optional[StrictStr] = Field(
        default=None,
        description="**account_id** or **email_address** is required. If both are provided, the account id prevails.  Email address of the Account to remove from your Team.",
    )
    new_owner_email_address: Optional[StrictStr] = Field(
        default=None,
        description="The email address of an Account on this Team to receive all documents, templates, and API apps (if applicable) from the removed Account. If not provided, and on an Enterprise plan, this data will remain with the removed Account.  **NOTE:** Only available for Enterprise plans.",
    )
    new_team_id: Optional[StrictStr] = Field(
        default=None, description="Id of the new Team."
    )
    new_role: Optional[StrictStr] = Field(
        default=None,
        description="A new role member will take in a new Team.  **NOTE:** This parameter is used only if `new_team_id` is provided.",
    )
    __properties: ClassVar[List[str]] = [
        "account_id",
        "email_address",
        "new_owner_email_address",
        "new_team_id",
        "new_role",
    ]

    @field_validator("new_role")
    def new_role_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["Member", "Developer", "Team Manager", "Admin"]):
            raise ValueError(
                "must be one of enum values ('Member', 'Developer', 'Team Manager', 'Admin')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TeamRemoveMemberRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TeamRemoveMemberRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "account_id": obj.get("account_id"),
                "email_address": obj.get("email_address"),
                "new_owner_email_address": obj.get("new_owner_email_address"),
                "new_team_id": obj.get("new_team_id"),
                "new_role": obj.get("new_role"),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "account_id": "(str,)",
            "email_address": "(str,)",
            "new_owner_email_address": "(str,)",
            "new_team_id": "(str,)",
            "new_role": "(str,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
