# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dropbox_sign.models.template_response_document_custom_field_base import (
    TemplateResponseDocumentCustomFieldBase,
)
from dropbox_sign.models.template_response_document_field_group import (
    TemplateResponseDocumentFieldGroup,
)
from dropbox_sign.models.template_response_document_form_field_base import (
    TemplateResponseDocumentFormFieldBase,
)
from dropbox_sign.models.template_response_document_static_field_base import (
    TemplateResponseDocumentStaticFieldBase,
)
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class TemplateResponseDocument(BaseModel):
    """
    TemplateResponseDocument
    """  # noqa: E501

    name: Optional[StrictStr] = Field(
        default=None, description="Name of the associated file."
    )
    index: Optional[StrictInt] = Field(
        default=None,
        description="Document ordering, the lowest index is displayed first and the highest last (0-based indexing).",
    )
    field_groups: Optional[List[TemplateResponseDocumentFieldGroup]] = Field(
        default=None, description="An array of Form Field Group objects."
    )
    form_fields: Optional[List[TemplateResponseDocumentFormFieldBase]] = Field(
        default=None,
        description="An array of Form Field objects containing the name and type of each named field.",
    )
    custom_fields: Optional[List[TemplateResponseDocumentCustomFieldBase]] = Field(
        default=None,
        description="An array of Form Field objects containing the name and type of each named field.",
    )
    static_fields: Optional[List[TemplateResponseDocumentStaticFieldBase]] = Field(
        default=None,
        description="An array describing static overlay fields. **NOTE:** Only available for certain subscriptions.",
    )
    __properties: ClassVar[List[str]] = [
        "name",
        "index",
        "field_groups",
        "form_fields",
        "custom_fields",
        "static_fields",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TemplateResponseDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in field_groups (list)
        _items = []
        if self.field_groups:
            for _item_field_groups in self.field_groups:
                if _item_field_groups:
                    _items.append(_item_field_groups.to_dict())
            _dict["field_groups"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in form_fields (list)
        _items = []
        if self.form_fields:
            for _item_form_fields in self.form_fields:
                if _item_form_fields:
                    _items.append(_item_form_fields.to_dict())
            _dict["form_fields"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item_custom_fields in self.custom_fields:
                if _item_custom_fields:
                    _items.append(_item_custom_fields.to_dict())
            _dict["custom_fields"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in static_fields (list)
        _items = []
        if self.static_fields:
            for _item_static_fields in self.static_fields:
                if _item_static_fields:
                    _items.append(_item_static_fields.to_dict())
            _dict["static_fields"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TemplateResponseDocument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "index": obj.get("index"),
                "field_groups": (
                    [
                        TemplateResponseDocumentFieldGroup.from_dict(_item)
                        for _item in obj["field_groups"]
                    ]
                    if obj.get("field_groups") is not None
                    else None
                ),
                "form_fields": (
                    [
                        TemplateResponseDocumentFormFieldBase.from_dict(_item)
                        for _item in obj["form_fields"]
                    ]
                    if obj.get("form_fields") is not None
                    else None
                ),
                "custom_fields": (
                    [
                        TemplateResponseDocumentCustomFieldBase.from_dict(_item)
                        for _item in obj["custom_fields"]
                    ]
                    if obj.get("custom_fields") is not None
                    else None
                ),
                "static_fields": (
                    [
                        TemplateResponseDocumentStaticFieldBase.from_dict(_item)
                        for _item in obj["static_fields"]
                    ]
                    if obj.get("static_fields") is not None
                    else None
                ),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "name": "(str,)",
            "index": "(int,)",
            "field_groups": "(List[TemplateResponseDocumentFieldGroup],)",
            "form_fields": "(List[TemplateResponseDocumentFormFieldBase],)",
            "custom_fields": "(List[TemplateResponseDocumentCustomFieldBase],)",
            "static_fields": "(List[TemplateResponseDocumentStaticFieldBase],)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in [
            "field_groups",
            "form_fields",
            "custom_fields",
            "static_fields",
        ]
