# coding: utf-8

"""
Dropbox Sign API

Dropbox Sign v3 API

The version of the OpenAPI document: 3.0.0
Contact: apisupport@hellosign.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dropbox_sign.models.sub_editor_options import SubEditorOptions
from typing import Optional, Set
from typing_extensions import Self
from typing import Tuple, Union
import io
from pydantic import StrictBool


class UnclaimedDraftEditAndResendRequest(BaseModel):
    """
    UnclaimedDraftEditAndResendRequest
    """  # noqa: E501

    client_id: StrictStr = Field(
        description="Client id of the app used to create the draft. Used to apply the branding and callback url defined for the app."
    )
    editor_options: Optional[SubEditorOptions] = None
    is_for_embedded_signing: Optional[StrictBool] = Field(
        default=None,
        description="The request created from this draft will also be signable in embedded mode if set to `true`.",
    )
    requester_email_address: Optional[StrictStr] = Field(
        default=None,
        description="The email address of the user that should be designated as the requester of this draft. If not set, original requester's email address will be used.",
    )
    requesting_redirect_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL you want signers redirected to after they successfully request a signature.",
    )
    show_progress_stepper: Optional[StrictBool] = Field(
        default=True,
        description="When only one step remains in the signature request process and this parameter is set to `false` then the progress stepper will be hidden.",
    )
    signing_redirect_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL you want signers redirected to after they successfully sign.",
    )
    test_mode: Optional[StrictBool] = Field(
        default=False,
        description="Whether this is a test, the signature request created from this draft will not be legally binding if set to `true`. Defaults to `false`.",
    )
    __properties: ClassVar[List[str]] = [
        "client_id",
        "editor_options",
        "is_for_embedded_signing",
        "requester_email_address",
        "requesting_redirect_url",
        "show_progress_stepper",
        "signing_redirect_url",
        "test_mode",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    def to_json_form_params(
        self, excluded_fields: Set[str] = None
    ) -> List[Tuple[str, str]]:
        data: List[Tuple[str, str]] = []

        for key, value in self.to_dict(excluded_fields).items():
            if isinstance(value, (int, str, bool)):
                data.append((key, value))
            else:
                data.append((key, json.dumps(value, ensure_ascii=False)))

        return data

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UnclaimedDraftEditAndResendRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self, excluded_fields: Set[str] = None) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of editor_options
        if self.editor_options:
            _dict["editor_options"] = self.editor_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UnclaimedDraftEditAndResendRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "client_id": obj.get("client_id"),
                "editor_options": (
                    SubEditorOptions.from_dict(obj["editor_options"])
                    if obj.get("editor_options") is not None
                    else None
                ),
                "is_for_embedded_signing": obj.get("is_for_embedded_signing"),
                "requester_email_address": obj.get("requester_email_address"),
                "requesting_redirect_url": obj.get("requesting_redirect_url"),
                "show_progress_stepper": (
                    obj.get("show_progress_stepper")
                    if obj.get("show_progress_stepper") is not None
                    else True
                ),
                "signing_redirect_url": obj.get("signing_redirect_url"),
                "test_mode": (
                    obj.get("test_mode") if obj.get("test_mode") is not None else False
                ),
            }
        )
        return _obj

    @classmethod
    def init(cls, data: Any) -> Self:
        """
        Attempt to instantiate and hydrate a new instance of this class
        """
        if isinstance(data, str):
            data = json.loads(data)

        return cls.from_dict(data)

    @classmethod
    def openapi_types(cls) -> Dict[str, str]:
        return {
            "client_id": "(str,)",
            "editor_options": "(SubEditorOptions,)",
            "is_for_embedded_signing": "(bool,)",
            "requester_email_address": "(str,)",
            "requesting_redirect_url": "(str,)",
            "show_progress_stepper": "(bool,)",
            "signing_redirect_url": "(str,)",
            "test_mode": "(bool,)",
        }

    @classmethod
    def openapi_type_is_array(cls, property_name: str) -> bool:
        return property_name in []
