# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupCompliancePolicyArgs', 'BackupCompliancePolicy']

@pulumi.input_type
class BackupCompliancePolicyArgs:
    def __init__(__self__, *,
                 authorized_email: pulumi.Input[_builtins.str],
                 authorized_user_first_name: pulumi.Input[_builtins.str],
                 authorized_user_last_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 copy_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_rest_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_demand_policy_item: Optional[pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs']] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_item_daily: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs']] = None,
                 policy_item_hourly: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs']] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a BackupCompliancePolicy resource.
        :param pulumi.Input[_builtins.str] authorized_email: Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_first_name: First name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_last_name: Last name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[_builtins.bool] copy_protection_enabled: Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        :param pulumi.Input[_builtins.bool] encryption_at_rest_enabled: Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs'] on_demand_policy_item: Specifications for on-demand policy.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs'] policy_item_daily: Scheduled policy using a daily frequency type, see block fields.
        :param pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs'] policy_item_hourly: Scheduled policy using an hourly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]] policy_item_monthlies: Scheduled policy using a monthly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]] policy_item_weeklies: Scheduled policy using a weekly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]] policy_item_yearlies: Scheduled policy using a yearly frequency type, see block fields.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        """
        pulumi.set(__self__, "authorized_email", authorized_email)
        pulumi.set(__self__, "authorized_user_first_name", authorized_user_first_name)
        pulumi.set(__self__, "authorized_user_last_name", authorized_user_last_name)
        pulumi.set(__self__, "project_id", project_id)
        if copy_protection_enabled is not None:
            pulumi.set(__self__, "copy_protection_enabled", copy_protection_enabled)
        if encryption_at_rest_enabled is not None:
            pulumi.set(__self__, "encryption_at_rest_enabled", encryption_at_rest_enabled)
        if on_demand_policy_item is not None:
            pulumi.set(__self__, "on_demand_policy_item", on_demand_policy_item)
        if pit_enabled is not None:
            pulumi.set(__self__, "pit_enabled", pit_enabled)
        if policy_item_daily is not None:
            pulumi.set(__self__, "policy_item_daily", policy_item_daily)
        if policy_item_hourly is not None:
            pulumi.set(__self__, "policy_item_hourly", policy_item_hourly)
        if policy_item_monthlies is not None:
            pulumi.set(__self__, "policy_item_monthlies", policy_item_monthlies)
        if policy_item_weeklies is not None:
            pulumi.set(__self__, "policy_item_weeklies", policy_item_weeklies)
        if policy_item_yearlies is not None:
            pulumi.set(__self__, "policy_item_yearlies", policy_item_yearlies)
        if restore_window_days is not None:
            pulumi.set(__self__, "restore_window_days", restore_window_days)

    @_builtins.property
    @pulumi.getter(name="authorizedEmail")
    def authorized_email(self) -> pulumi.Input[_builtins.str]:
        """
        Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_email")

    @authorized_email.setter
    def authorized_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorized_email", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUserFirstName")
    def authorized_user_first_name(self) -> pulumi.Input[_builtins.str]:
        """
        First name of the user who authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_user_first_name")

    @authorized_user_first_name.setter
    def authorized_user_first_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorized_user_first_name", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUserLastName")
    def authorized_user_last_name(self) -> pulumi.Input[_builtins.str]:
        """
        Last name of the user who authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_user_last_name")

    @authorized_user_last_name.setter
    def authorized_user_last_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorized_user_last_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="copyProtectionEnabled")
    def copy_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "copy_protection_enabled")

    @copy_protection_enabled.setter
    def copy_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestEnabled")
    def encryption_at_rest_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "encryption_at_rest_enabled")

    @encryption_at_rest_enabled.setter
    def encryption_at_rest_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_rest_enabled", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPolicyItem")
    def on_demand_policy_item(self) -> Optional[pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs']]:
        """
        Specifications for on-demand policy.
        """
        return pulumi.get(self, "on_demand_policy_item")

    @on_demand_policy_item.setter
    def on_demand_policy_item(self, value: Optional[pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs']]):
        pulumi.set(self, "on_demand_policy_item", value)

    @_builtins.property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "pit_enabled")

    @pit_enabled.setter
    def pit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pit_enabled", value)

    @_builtins.property
    @pulumi.getter(name="policyItemDaily")
    def policy_item_daily(self) -> Optional[pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs']]:
        """
        Scheduled policy using a daily frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_daily")

    @policy_item_daily.setter
    def policy_item_daily(self, value: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs']]):
        pulumi.set(self, "policy_item_daily", value)

    @_builtins.property
    @pulumi.getter(name="policyItemHourly")
    def policy_item_hourly(self) -> Optional[pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs']]:
        """
        Scheduled policy using an hourly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_hourly")

    @policy_item_hourly.setter
    def policy_item_hourly(self, value: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs']]):
        pulumi.set(self, "policy_item_hourly", value)

    @_builtins.property
    @pulumi.getter(name="policyItemMonthlies")
    def policy_item_monthlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]]]:
        """
        Scheduled policy using a monthly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_monthlies")

    @policy_item_monthlies.setter
    def policy_item_monthlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]]]):
        pulumi.set(self, "policy_item_monthlies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemWeeklies")
    def policy_item_weeklies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]]]:
        """
        Scheduled policy using a weekly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_weeklies")

    @policy_item_weeklies.setter
    def policy_item_weeklies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]]]):
        pulumi.set(self, "policy_item_weeklies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemYearlies")
    def policy_item_yearlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]]]:
        """
        Scheduled policy using a yearly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_yearlies")

    @policy_item_yearlies.setter
    def policy_item_yearlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]]]):
        pulumi.set(self, "policy_item_yearlies", value)

    @_builtins.property
    @pulumi.getter(name="restoreWindowDays")
    def restore_window_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        """
        return pulumi.get(self, "restore_window_days")

    @restore_window_days.setter
    def restore_window_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_window_days", value)


@pulumi.input_type
class _BackupCompliancePolicyState:
    def __init__(__self__, *,
                 authorized_email: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_user_first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_user_last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_rest_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_demand_policy_item: Optional[pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs']] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_item_daily: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs']] = None,
                 policy_item_hourly: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs']] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_date: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupCompliancePolicy resources.
        :param pulumi.Input[_builtins.str] authorized_email: Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_first_name: First name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_last_name: Last name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.bool] copy_protection_enabled: Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        :param pulumi.Input[_builtins.bool] encryption_at_rest_enabled: Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs'] on_demand_policy_item: Specifications for on-demand policy.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs'] policy_item_daily: Scheduled policy using a daily frequency type, see block fields.
        :param pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs'] policy_item_hourly: Scheduled policy using an hourly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]] policy_item_monthlies: Scheduled policy using a monthly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]] policy_item_weeklies: Scheduled policy using a weekly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]] policy_item_yearlies: Scheduled policy using a yearly frequency type, see block fields.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        :param pulumi.Input[_builtins.str] state: Label that indicates the state of the Backup Compliance Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] updated_date: ISO 8601 timestamp format in UTC that indicates when the user updated the Data Protection Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] updated_user: Email address that identifies the user who updated the Backup Compliance Policy settings. MongoDB Cloud ignores this email setting when you enable or update the Backup Compliance Policy settings.
        """
        if authorized_email is not None:
            pulumi.set(__self__, "authorized_email", authorized_email)
        if authorized_user_first_name is not None:
            pulumi.set(__self__, "authorized_user_first_name", authorized_user_first_name)
        if authorized_user_last_name is not None:
            pulumi.set(__self__, "authorized_user_last_name", authorized_user_last_name)
        if copy_protection_enabled is not None:
            pulumi.set(__self__, "copy_protection_enabled", copy_protection_enabled)
        if encryption_at_rest_enabled is not None:
            pulumi.set(__self__, "encryption_at_rest_enabled", encryption_at_rest_enabled)
        if on_demand_policy_item is not None:
            pulumi.set(__self__, "on_demand_policy_item", on_demand_policy_item)
        if pit_enabled is not None:
            pulumi.set(__self__, "pit_enabled", pit_enabled)
        if policy_item_daily is not None:
            pulumi.set(__self__, "policy_item_daily", policy_item_daily)
        if policy_item_hourly is not None:
            pulumi.set(__self__, "policy_item_hourly", policy_item_hourly)
        if policy_item_monthlies is not None:
            pulumi.set(__self__, "policy_item_monthlies", policy_item_monthlies)
        if policy_item_weeklies is not None:
            pulumi.set(__self__, "policy_item_weeklies", policy_item_weeklies)
        if policy_item_yearlies is not None:
            pulumi.set(__self__, "policy_item_yearlies", policy_item_yearlies)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if restore_window_days is not None:
            pulumi.set(__self__, "restore_window_days", restore_window_days)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if updated_date is not None:
            pulumi.set(__self__, "updated_date", updated_date)
        if updated_user is not None:
            pulumi.set(__self__, "updated_user", updated_user)

    @_builtins.property
    @pulumi.getter(name="authorizedEmail")
    def authorized_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_email")

    @authorized_email.setter
    def authorized_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_email", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUserFirstName")
    def authorized_user_first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        First name of the user who authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_user_first_name")

    @authorized_user_first_name.setter
    def authorized_user_first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_user_first_name", value)

    @_builtins.property
    @pulumi.getter(name="authorizedUserLastName")
    def authorized_user_last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last name of the user who authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_user_last_name")

    @authorized_user_last_name.setter
    def authorized_user_last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_user_last_name", value)

    @_builtins.property
    @pulumi.getter(name="copyProtectionEnabled")
    def copy_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "copy_protection_enabled")

    @copy_protection_enabled.setter
    def copy_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "copy_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestEnabled")
    def encryption_at_rest_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "encryption_at_rest_enabled")

    @encryption_at_rest_enabled.setter
    def encryption_at_rest_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encryption_at_rest_enabled", value)

    @_builtins.property
    @pulumi.getter(name="onDemandPolicyItem")
    def on_demand_policy_item(self) -> Optional[pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs']]:
        """
        Specifications for on-demand policy.
        """
        return pulumi.get(self, "on_demand_policy_item")

    @on_demand_policy_item.setter
    def on_demand_policy_item(self, value: Optional[pulumi.Input['BackupCompliancePolicyOnDemandPolicyItemArgs']]):
        pulumi.set(self, "on_demand_policy_item", value)

    @_builtins.property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "pit_enabled")

    @pit_enabled.setter
    def pit_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pit_enabled", value)

    @_builtins.property
    @pulumi.getter(name="policyItemDaily")
    def policy_item_daily(self) -> Optional[pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs']]:
        """
        Scheduled policy using a daily frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_daily")

    @policy_item_daily.setter
    def policy_item_daily(self, value: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemDailyArgs']]):
        pulumi.set(self, "policy_item_daily", value)

    @_builtins.property
    @pulumi.getter(name="policyItemHourly")
    def policy_item_hourly(self) -> Optional[pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs']]:
        """
        Scheduled policy using an hourly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_hourly")

    @policy_item_hourly.setter
    def policy_item_hourly(self, value: Optional[pulumi.Input['BackupCompliancePolicyPolicyItemHourlyArgs']]):
        pulumi.set(self, "policy_item_hourly", value)

    @_builtins.property
    @pulumi.getter(name="policyItemMonthlies")
    def policy_item_monthlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]]]:
        """
        Scheduled policy using a monthly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_monthlies")

    @policy_item_monthlies.setter
    def policy_item_monthlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemMonthlyArgs']]]]):
        pulumi.set(self, "policy_item_monthlies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemWeeklies")
    def policy_item_weeklies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]]]:
        """
        Scheduled policy using a weekly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_weeklies")

    @policy_item_weeklies.setter
    def policy_item_weeklies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemWeeklyArgs']]]]):
        pulumi.set(self, "policy_item_weeklies", value)

    @_builtins.property
    @pulumi.getter(name="policyItemYearlies")
    def policy_item_yearlies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]]]:
        """
        Scheduled policy using a yearly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_yearlies")

    @policy_item_yearlies.setter
    def policy_item_yearlies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupCompliancePolicyPolicyItemYearlyArgs']]]]):
        pulumi.set(self, "policy_item_yearlies", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreWindowDays")
    def restore_window_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        """
        return pulumi.get(self, "restore_window_days")

    @restore_window_days.setter
    def restore_window_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_window_days", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Label that indicates the state of the Backup Compliance Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ISO 8601 timestamp format in UTC that indicates when the user updated the Data Protection Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "updated_date")

    @updated_date.setter
    def updated_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_date", value)

    @_builtins.property
    @pulumi.getter(name="updatedUser")
    def updated_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address that identifies the user who updated the Backup Compliance Policy settings. MongoDB Cloud ignores this email setting when you enable or update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "updated_user")

    @updated_user.setter
    def updated_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_user", value)


@pulumi.type_token("mongodbatlas:index/backupCompliancePolicy:BackupCompliancePolicy")
class BackupCompliancePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_email: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_user_first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_user_last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_rest_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_demand_policy_item: Optional[pulumi.Input[Union['BackupCompliancePolicyOnDemandPolicyItemArgs', 'BackupCompliancePolicyOnDemandPolicyItemArgsDict']]] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_item_daily: Optional[pulumi.Input[Union['BackupCompliancePolicyPolicyItemDailyArgs', 'BackupCompliancePolicyPolicyItemDailyArgsDict']]] = None,
                 policy_item_hourly: Optional[pulumi.Input[Union['BackupCompliancePolicyPolicyItemHourlyArgs', 'BackupCompliancePolicyPolicyItemHourlyArgsDict']]] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemMonthlyArgs', 'BackupCompliancePolicyPolicyItemMonthlyArgsDict']]]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemWeeklyArgs', 'BackupCompliancePolicyPolicyItemWeeklyArgsDict']]]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemYearlyArgs', 'BackupCompliancePolicyPolicyItemYearlyArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="clusterTest",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": region,
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test_cloud_backup_schedule = mongodbatlas.CloudBackupSchedule("test",
            project_id=my_cluster.project_id,
            cluster_name=my_cluster.name,
            reference_hour_of_day=3,
            reference_minute_of_hour=45,
            restore_window_days=4,
            policy_item_hourly={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_daily={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_weeklies=[{
                "frequency_interval": 1,
                "retention_unit": "weeks",
                "retention_value": 4,
            }],
            policy_item_monthlies=[{
                "frequency_interval": 1,
                "retention_unit": "months",
                "retention_value": 12,
            }],
            policy_item_yearlies=[{
                "frequency_interval": 1,
                "retention_unit": "years",
                "retention_value": 1,
            }])
        test = mongodbatlas.get_cloud_backup_schedule_output(project_id=test_cloud_backup_schedule.project_id,
            cluster_name=test_cloud_backup_schedule.cluster_name)
        backup_policy = mongodbatlas.get_backup_compliance_policy_output(project_id=test_cloud_backup_schedule.project_id)
        backup_policy_backup_compliance_policy = mongodbatlas.BackupCompliancePolicy("backup_policy",
            project_id="<PROJECT-ID>",
            authorized_email="user@email.com",
            authorized_user_first_name="First",
            authorized_user_last_name="Last",
            copy_protection_enabled=False,
            pit_enabled=False,
            encryption_at_rest_enabled=False,
            restore_window_days=7,
            on_demand_policy_item={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 3,
            },
            policy_item_hourly={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_daily={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_weeklies=[{
                "frequency_interval": 1,
                "retention_unit": "weeks",
                "retention_value": 4,
            }],
            policy_item_monthlies=[{
                "frequency_interval": 1,
                "retention_unit": "months",
                "retention_value": 12,
            }],
            policy_item_yearlies=[{
                "frequency_interval": 1,
                "retention_unit": "years",
                "retention_value": 1,
            }])
        ```

        ## Import

        Backup Compliance Policy entries can be imported using project project_id  in the format `project_id`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/backupCompliancePolicy:BackupCompliancePolicy backup_policy 5d0f1f73cf09a29120e173cf
        ```
        For more information see: [MongoDB Atlas API Reference](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Cloud-Backups/operation/updateDataProtectionSettings) and [Backup Compliance Policy Prohibited Actions](https://www.mongodb.com/docs/atlas/backup/cloud-backup/backup-compliance-policy/#prohibited-actions).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorized_email: Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_first_name: First name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_last_name: Last name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.bool] copy_protection_enabled: Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        :param pulumi.Input[_builtins.bool] encryption_at_rest_enabled: Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input[Union['BackupCompliancePolicyOnDemandPolicyItemArgs', 'BackupCompliancePolicyOnDemandPolicyItemArgsDict']] on_demand_policy_item: Specifications for on-demand policy.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input[Union['BackupCompliancePolicyPolicyItemDailyArgs', 'BackupCompliancePolicyPolicyItemDailyArgsDict']] policy_item_daily: Scheduled policy using a daily frequency type, see block fields.
        :param pulumi.Input[Union['BackupCompliancePolicyPolicyItemHourlyArgs', 'BackupCompliancePolicyPolicyItemHourlyArgsDict']] policy_item_hourly: Scheduled policy using an hourly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemMonthlyArgs', 'BackupCompliancePolicyPolicyItemMonthlyArgsDict']]]] policy_item_monthlies: Scheduled policy using a monthly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemWeeklyArgs', 'BackupCompliancePolicyPolicyItemWeeklyArgsDict']]]] policy_item_weeklies: Scheduled policy using a weekly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemYearlyArgs', 'BackupCompliancePolicyPolicyItemYearlyArgsDict']]]] policy_item_yearlies: Scheduled policy using a yearly frequency type, see block fields.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupCompliancePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="clusterTest",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": region,
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test_cloud_backup_schedule = mongodbatlas.CloudBackupSchedule("test",
            project_id=my_cluster.project_id,
            cluster_name=my_cluster.name,
            reference_hour_of_day=3,
            reference_minute_of_hour=45,
            restore_window_days=4,
            policy_item_hourly={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_daily={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_weeklies=[{
                "frequency_interval": 1,
                "retention_unit": "weeks",
                "retention_value": 4,
            }],
            policy_item_monthlies=[{
                "frequency_interval": 1,
                "retention_unit": "months",
                "retention_value": 12,
            }],
            policy_item_yearlies=[{
                "frequency_interval": 1,
                "retention_unit": "years",
                "retention_value": 1,
            }])
        test = mongodbatlas.get_cloud_backup_schedule_output(project_id=test_cloud_backup_schedule.project_id,
            cluster_name=test_cloud_backup_schedule.cluster_name)
        backup_policy = mongodbatlas.get_backup_compliance_policy_output(project_id=test_cloud_backup_schedule.project_id)
        backup_policy_backup_compliance_policy = mongodbatlas.BackupCompliancePolicy("backup_policy",
            project_id="<PROJECT-ID>",
            authorized_email="user@email.com",
            authorized_user_first_name="First",
            authorized_user_last_name="Last",
            copy_protection_enabled=False,
            pit_enabled=False,
            encryption_at_rest_enabled=False,
            restore_window_days=7,
            on_demand_policy_item={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 3,
            },
            policy_item_hourly={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_daily={
                "frequency_interval": 1,
                "retention_unit": "days",
                "retention_value": 7,
            },
            policy_item_weeklies=[{
                "frequency_interval": 1,
                "retention_unit": "weeks",
                "retention_value": 4,
            }],
            policy_item_monthlies=[{
                "frequency_interval": 1,
                "retention_unit": "months",
                "retention_value": 12,
            }],
            policy_item_yearlies=[{
                "frequency_interval": 1,
                "retention_unit": "years",
                "retention_value": 1,
            }])
        ```

        ## Import

        Backup Compliance Policy entries can be imported using project project_id  in the format `project_id`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/backupCompliancePolicy:BackupCompliancePolicy backup_policy 5d0f1f73cf09a29120e173cf
        ```
        For more information see: [MongoDB Atlas API Reference](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Cloud-Backups/operation/updateDataProtectionSettings) and [Backup Compliance Policy Prohibited Actions](https://www.mongodb.com/docs/atlas/backup/cloud-backup/backup-compliance-policy/#prohibited-actions).

        :param str resource_name: The name of the resource.
        :param BackupCompliancePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupCompliancePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_email: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_user_first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_user_last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_at_rest_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 on_demand_policy_item: Optional[pulumi.Input[Union['BackupCompliancePolicyOnDemandPolicyItemArgs', 'BackupCompliancePolicyOnDemandPolicyItemArgsDict']]] = None,
                 pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_item_daily: Optional[pulumi.Input[Union['BackupCompliancePolicyPolicyItemDailyArgs', 'BackupCompliancePolicyPolicyItemDailyArgsDict']]] = None,
                 policy_item_hourly: Optional[pulumi.Input[Union['BackupCompliancePolicyPolicyItemHourlyArgs', 'BackupCompliancePolicyPolicyItemHourlyArgsDict']]] = None,
                 policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemMonthlyArgs', 'BackupCompliancePolicyPolicyItemMonthlyArgsDict']]]]] = None,
                 policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemWeeklyArgs', 'BackupCompliancePolicyPolicyItemWeeklyArgsDict']]]]] = None,
                 policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemYearlyArgs', 'BackupCompliancePolicyPolicyItemYearlyArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupCompliancePolicyArgs.__new__(BackupCompliancePolicyArgs)

            if authorized_email is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_email'")
            __props__.__dict__["authorized_email"] = authorized_email
            if authorized_user_first_name is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_user_first_name'")
            __props__.__dict__["authorized_user_first_name"] = authorized_user_first_name
            if authorized_user_last_name is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_user_last_name'")
            __props__.__dict__["authorized_user_last_name"] = authorized_user_last_name
            __props__.__dict__["copy_protection_enabled"] = copy_protection_enabled
            __props__.__dict__["encryption_at_rest_enabled"] = encryption_at_rest_enabled
            __props__.__dict__["on_demand_policy_item"] = on_demand_policy_item
            __props__.__dict__["pit_enabled"] = pit_enabled
            __props__.__dict__["policy_item_daily"] = policy_item_daily
            __props__.__dict__["policy_item_hourly"] = policy_item_hourly
            __props__.__dict__["policy_item_monthlies"] = policy_item_monthlies
            __props__.__dict__["policy_item_weeklies"] = policy_item_weeklies
            __props__.__dict__["policy_item_yearlies"] = policy_item_yearlies
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["restore_window_days"] = restore_window_days
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_date"] = None
            __props__.__dict__["updated_user"] = None
        super(BackupCompliancePolicy, __self__).__init__(
            'mongodbatlas:index/backupCompliancePolicy:BackupCompliancePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_email: Optional[pulumi.Input[_builtins.str]] = None,
            authorized_user_first_name: Optional[pulumi.Input[_builtins.str]] = None,
            authorized_user_last_name: Optional[pulumi.Input[_builtins.str]] = None,
            copy_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_at_rest_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            on_demand_policy_item: Optional[pulumi.Input[Union['BackupCompliancePolicyOnDemandPolicyItemArgs', 'BackupCompliancePolicyOnDemandPolicyItemArgsDict']]] = None,
            pit_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            policy_item_daily: Optional[pulumi.Input[Union['BackupCompliancePolicyPolicyItemDailyArgs', 'BackupCompliancePolicyPolicyItemDailyArgsDict']]] = None,
            policy_item_hourly: Optional[pulumi.Input[Union['BackupCompliancePolicyPolicyItemHourlyArgs', 'BackupCompliancePolicyPolicyItemHourlyArgsDict']]] = None,
            policy_item_monthlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemMonthlyArgs', 'BackupCompliancePolicyPolicyItemMonthlyArgsDict']]]]] = None,
            policy_item_weeklies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemWeeklyArgs', 'BackupCompliancePolicyPolicyItemWeeklyArgsDict']]]]] = None,
            policy_item_yearlies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemYearlyArgs', 'BackupCompliancePolicyPolicyItemYearlyArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            restore_window_days: Optional[pulumi.Input[_builtins.int]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            updated_date: Optional[pulumi.Input[_builtins.str]] = None,
            updated_user: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupCompliancePolicy':
        """
        Get an existing BackupCompliancePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorized_email: Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_first_name: First name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] authorized_user_last_name: Last name of the user who authorized to update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.bool] copy_protection_enabled: Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        :param pulumi.Input[_builtins.bool] encryption_at_rest_enabled: Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input[Union['BackupCompliancePolicyOnDemandPolicyItemArgs', 'BackupCompliancePolicyOnDemandPolicyItemArgsDict']] on_demand_policy_item: Specifications for on-demand policy.
        :param pulumi.Input[_builtins.bool] pit_enabled: Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        :param pulumi.Input[Union['BackupCompliancePolicyPolicyItemDailyArgs', 'BackupCompliancePolicyPolicyItemDailyArgsDict']] policy_item_daily: Scheduled policy using a daily frequency type, see block fields.
        :param pulumi.Input[Union['BackupCompliancePolicyPolicyItemHourlyArgs', 'BackupCompliancePolicyPolicyItemHourlyArgsDict']] policy_item_hourly: Scheduled policy using an hourly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemMonthlyArgs', 'BackupCompliancePolicyPolicyItemMonthlyArgsDict']]]] policy_item_monthlies: Scheduled policy using a monthly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemWeeklyArgs', 'BackupCompliancePolicyPolicyItemWeeklyArgsDict']]]] policy_item_weeklies: Scheduled policy using a weekly frequency type, see block fields.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupCompliancePolicyPolicyItemYearlyArgs', 'BackupCompliancePolicyPolicyItemYearlyArgsDict']]]] policy_item_yearlies: Scheduled policy using a yearly frequency type, see block fields.
        :param pulumi.Input[_builtins.str] project_id: Unique 24-hexadecimal digit string that identifies your project.
        :param pulumi.Input[_builtins.int] restore_window_days: Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        :param pulumi.Input[_builtins.str] state: Label that indicates the state of the Backup Compliance Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] updated_date: ISO 8601 timestamp format in UTC that indicates when the user updated the Data Protection Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        :param pulumi.Input[_builtins.str] updated_user: Email address that identifies the user who updated the Backup Compliance Policy settings. MongoDB Cloud ignores this email setting when you enable or update the Backup Compliance Policy settings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupCompliancePolicyState.__new__(_BackupCompliancePolicyState)

        __props__.__dict__["authorized_email"] = authorized_email
        __props__.__dict__["authorized_user_first_name"] = authorized_user_first_name
        __props__.__dict__["authorized_user_last_name"] = authorized_user_last_name
        __props__.__dict__["copy_protection_enabled"] = copy_protection_enabled
        __props__.__dict__["encryption_at_rest_enabled"] = encryption_at_rest_enabled
        __props__.__dict__["on_demand_policy_item"] = on_demand_policy_item
        __props__.__dict__["pit_enabled"] = pit_enabled
        __props__.__dict__["policy_item_daily"] = policy_item_daily
        __props__.__dict__["policy_item_hourly"] = policy_item_hourly
        __props__.__dict__["policy_item_monthlies"] = policy_item_monthlies
        __props__.__dict__["policy_item_weeklies"] = policy_item_weeklies
        __props__.__dict__["policy_item_yearlies"] = policy_item_yearlies
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["restore_window_days"] = restore_window_days
        __props__.__dict__["state"] = state
        __props__.__dict__["updated_date"] = updated_date
        __props__.__dict__["updated_user"] = updated_user
        return BackupCompliancePolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizedEmail")
    def authorized_email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of a security or legal representative for the Backup Compliance Policy who is authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_email")

    @_builtins.property
    @pulumi.getter(name="authorizedUserFirstName")
    def authorized_user_first_name(self) -> pulumi.Output[_builtins.str]:
        """
        First name of the user who authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_user_first_name")

    @_builtins.property
    @pulumi.getter(name="authorizedUserLastName")
    def authorized_user_last_name(self) -> pulumi.Output[_builtins.str]:
        """
        Last name of the user who authorized to update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "authorized_user_last_name")

    @_builtins.property
    @pulumi.getter(name="copyProtectionEnabled")
    def copy_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that indicates whether to enable additional backup copies for the cluster. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "copy_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionAtRestEnabled")
    def encryption_at_rest_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that indicates whether Encryption at Rest using Customer Key Management is required for all clusters with a Backup Compliance Policy. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "encryption_at_rest_enabled")

    @_builtins.property
    @pulumi.getter(name="onDemandPolicyItem")
    def on_demand_policy_item(self) -> pulumi.Output[Optional['outputs.BackupCompliancePolicyOnDemandPolicyItem']]:
        """
        Specifications for on-demand policy.
        """
        return pulumi.get(self, "on_demand_policy_item")

    @_builtins.property
    @pulumi.getter(name="pitEnabled")
    def pit_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that indicates whether the cluster uses Continuous Cloud Backups with a Backup Compliance Policy. If unspecified, this value defaults to false.
        """
        return pulumi.get(self, "pit_enabled")

    @_builtins.property
    @pulumi.getter(name="policyItemDaily")
    def policy_item_daily(self) -> pulumi.Output[Optional['outputs.BackupCompliancePolicyPolicyItemDaily']]:
        """
        Scheduled policy using a daily frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_daily")

    @_builtins.property
    @pulumi.getter(name="policyItemHourly")
    def policy_item_hourly(self) -> pulumi.Output[Optional['outputs.BackupCompliancePolicyPolicyItemHourly']]:
        """
        Scheduled policy using an hourly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_hourly")

    @_builtins.property
    @pulumi.getter(name="policyItemMonthlies")
    def policy_item_monthlies(self) -> pulumi.Output[Optional[Sequence['outputs.BackupCompliancePolicyPolicyItemMonthly']]]:
        """
        Scheduled policy using a monthly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_monthlies")

    @_builtins.property
    @pulumi.getter(name="policyItemWeeklies")
    def policy_item_weeklies(self) -> pulumi.Output[Optional[Sequence['outputs.BackupCompliancePolicyPolicyItemWeekly']]]:
        """
        Scheduled policy using a weekly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_weeklies")

    @_builtins.property
    @pulumi.getter(name="policyItemYearlies")
    def policy_item_yearlies(self) -> pulumi.Output[Optional[Sequence['outputs.BackupCompliancePolicyPolicyItemYearly']]]:
        """
        Scheduled policy using a yearly frequency type, see block fields.
        """
        return pulumi.get(self, "policy_item_yearlies")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique 24-hexadecimal digit string that identifies your project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="restoreWindowDays")
    def restore_window_days(self) -> pulumi.Output[_builtins.int]:
        """
        Number of previous days that you can restore back to with Continuous Cloud Backup with a Backup Compliance Policy. You must specify a positive, non-zero integer, and the maximum retention window can't exceed the hourly retention time. This parameter applies only to Continuous Cloud Backups with a Backup Compliance Policy.
        """
        return pulumi.get(self, "restore_window_days")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Label that indicates the state of the Backup Compliance Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updatedDate")
    def updated_date(self) -> pulumi.Output[_builtins.str]:
        """
        ISO 8601 timestamp format in UTC that indicates when the user updated the Data Protection Policy settings. MongoDB Cloud ignores this setting when you enable or update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "updated_date")

    @_builtins.property
    @pulumi.getter(name="updatedUser")
    def updated_user(self) -> pulumi.Output[_builtins.str]:
        """
        Email address that identifies the user who updated the Backup Compliance Policy settings. MongoDB Cloud ignores this email setting when you enable or update the Backup Compliance Policy settings.
        """
        return pulumi.get(self, "updated_user")

