# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudBackupSnapshotRestoreJobArgs', 'CloudBackupSnapshotRestoreJob']

@pulumi.input_type
class CloudBackupSnapshotRestoreJobArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 delivery_type_config: Optional[pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs']] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudBackupSnapshotRestoreJob resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs'] delivery_type_config: Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
               * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
               * `delivery_type_config.download` - Set to `true` to use the download configuration.
               * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
               * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
               * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
               * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        :param pulumi.Input[_builtins.str] snapshot_id: Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "project_id", project_id)
        if delivery_type_config is not None:
            pulumi.set(__self__, "delivery_type_config", delivery_type_config)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Atlas cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="deliveryTypeConfig")
    def delivery_type_config(self) -> Optional[pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs']]:
        """
        Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
        * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
        * `delivery_type_config.download` - Set to `true` to use the download configuration.
        * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
        * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
        * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
        * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
        * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
        * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        """
        return pulumi.get(self, "delivery_type_config")

    @delivery_type_config.setter
    def delivery_type_config(self, value: Optional[pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs']]):
        pulumi.set(self, "delivery_type_config", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class _CloudBackupSnapshotRestoreJobState:
    def __init__(__self__, *,
                 cancelled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_type_config: Optional[pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs']] = None,
                 delivery_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 expired: Optional[pulumi.Input[_builtins.bool]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 failed: Optional[pulumi.Input[_builtins.bool]] = None,
                 finished_at: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudBackupSnapshotRestoreJob resources.
        :param pulumi.Input[_builtins.bool] cancelled: Indicates whether the restore job was canceled.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs'] delivery_type_config: Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
               * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
               * `delivery_type_config.download` - Set to `true` to use the download configuration.
               * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
               * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
               * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
               * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delivery_urls: One or more URLs for the compressed snapshot files for manual download. Only visible if deliveryType is download.
        :param pulumi.Input[_builtins.bool] expired: Indicates whether the restore job expired.
        :param pulumi.Input[_builtins.str] expires_at: UTC ISO 8601 formatted point in time when the restore job expires.
        :param pulumi.Input[_builtins.bool] failed: Indicates whether the restore job failed.
        :param pulumi.Input[_builtins.str] finished_at: UTC ISO 8601 formatted point in time when the restore job completed.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input[_builtins.str] snapshot_id: Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        :param pulumi.Input[_builtins.str] snapshot_restore_job_id: The unique identifier of the restore job.
        :param pulumi.Input[_builtins.str] timestamp: Timestamp in ISO 8601 date and time format in UTC when the snapshot associated to snapshotId was taken.
               * `oplogTs` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot.
               Three conditions apply to this parameter:
               * Enable Continuous Cloud Backup on your cluster.
               * Specify oplogInc.
               * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
               * `oplogInc` - Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp.
               Three conditions apply to this parameter:
               * Enable Continuous Cloud Backup on your cluster.
               * Specify oplogTs.
               * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
               * `pointInTimeUTCSeconds` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot.
               Two conditions apply to this parameter:
               * Enable Continuous Cloud Backup on your cluster.
               * Specify either pointInTimeUTCSeconds or oplogTs and oplogInc, but not both.
        """
        if cancelled is not None:
            pulumi.set(__self__, "cancelled", cancelled)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if delivery_type_config is not None:
            pulumi.set(__self__, "delivery_type_config", delivery_type_config)
        if delivery_urls is not None:
            pulumi.set(__self__, "delivery_urls", delivery_urls)
        if expired is not None:
            pulumi.set(__self__, "expired", expired)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if failed is not None:
            pulumi.set(__self__, "failed", failed)
        if finished_at is not None:
            pulumi.set(__self__, "finished_at", finished_at)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if snapshot_restore_job_id is not None:
            pulumi.set(__self__, "snapshot_restore_job_id", snapshot_restore_job_id)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @_builtins.property
    @pulumi.getter
    def cancelled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the restore job was canceled.
        """
        return pulumi.get(self, "cancelled")

    @cancelled.setter
    def cancelled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cancelled", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Atlas cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="deliveryTypeConfig")
    def delivery_type_config(self) -> Optional[pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs']]:
        """
        Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
        * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
        * `delivery_type_config.download` - Set to `true` to use the download configuration.
        * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
        * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
        * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
        * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
        * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
        * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        """
        return pulumi.get(self, "delivery_type_config")

    @delivery_type_config.setter
    def delivery_type_config(self, value: Optional[pulumi.Input['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs']]):
        pulumi.set(self, "delivery_type_config", value)

    @_builtins.property
    @pulumi.getter(name="deliveryUrls")
    def delivery_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more URLs for the compressed snapshot files for manual download. Only visible if deliveryType is download.
        """
        return pulumi.get(self, "delivery_urls")

    @delivery_urls.setter
    def delivery_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "delivery_urls", value)

    @_builtins.property
    @pulumi.getter
    def expired(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the restore job expired.
        """
        return pulumi.get(self, "expired")

    @expired.setter
    def expired(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "expired", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC ISO 8601 formatted point in time when the restore job expires.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def failed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the restore job failed.
        """
        return pulumi.get(self, "failed")

    @failed.setter
    def failed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "failed", value)

    @_builtins.property
    @pulumi.getter(name="finishedAt")
    def finished_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UTC ISO 8601 formatted point in time when the restore job completed.
        """
        return pulumi.get(self, "finished_at")

    @finished_at.setter
    def finished_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "finished_at", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotRestoreJobId")
    def snapshot_restore_job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the restore job.
        """
        return pulumi.get(self, "snapshot_restore_job_id")

    @snapshot_restore_job_id.setter
    def snapshot_restore_job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_restore_job_id", value)

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp in ISO 8601 date and time format in UTC when the snapshot associated to snapshotId was taken.
        * `oplogTs` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot.
        Three conditions apply to this parameter:
        * Enable Continuous Cloud Backup on your cluster.
        * Specify oplogInc.
        * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
        * `oplogInc` - Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp.
        Three conditions apply to this parameter:
        * Enable Continuous Cloud Backup on your cluster.
        * Specify oplogTs.
        * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
        * `pointInTimeUTCSeconds` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot.
        Two conditions apply to this parameter:
        * Enable Continuous Cloud Backup on your cluster.
        * Specify either pointInTimeUTCSeconds or oplogTs and oplogInc, but not both.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp", value)


@pulumi.type_token("mongodbatlas:index/cloudBackupSnapshotRestoreJob:CloudBackupSnapshotRestoreJob")
class CloudBackupSnapshotRestoreJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_type_config: Optional[pulumi.Input[Union['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs', 'CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Example automated delivery type

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="MyCluster",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": "EU_WEST_2",
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test = mongodbatlas.index.CloudProviderSnapshot("test",
            project_id=my_cluster.project_id,
            cluster_name=my_cluster.name,
            description=myDescription,
            retention_in_days=1)
        test_cloud_backup_snapshot_restore_job = mongodbatlas.CloudBackupSnapshotRestoreJob("test",
            project_id=test["projectId"],
            cluster_name=test["clusterName"],
            snapshot_id=test["snapshotId"],
            delivery_type_config={
                "automated": True,
                "target_cluster_name": "MyCluster",
                "target_project_id": "5cf5a45a9ccf6400e60981b6",
            })
        ```

        ### Example download delivery type

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="MyCluster",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": "EU_WEST_2",
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test = mongodbatlas.index.CloudProviderSnapshot("test",
            project_id=my_cluster.project_id,
            cluster_name=my_cluster.name,
            description=myDescription,
            retention_in_days=1)
        test_cloud_backup_snapshot_restore_job = mongodbatlas.CloudBackupSnapshotRestoreJob("test",
            project_id=test["projectId"],
            cluster_name=test["clusterName"],
            snapshot_id=test["snapshotId"],
            delivery_type_config={
                "download": True,
            })
        ```

        ### Example of a point in time restore
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="MyCluster",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": "EU_WEST_2",
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test = mongodbatlas.CloudBackupSnapshot("test",
            project_id=cluster_test["projectId"],
            cluster_name=cluster_test["name"],
            description="My description",
            retention_in_days=1)
        test_cloud_backup_snapshot_restore_job = []
        for range in [{"value": i} for i in range(0, 0 if point_in_time_utc_seconds == 0 else 1)]:
            test_cloud_backup_snapshot_restore_job.append(mongodbatlas.CloudBackupSnapshotRestoreJob(f"test-{range['value']}",
                project_id=test.project_id,
                cluster_name=test.cluster_name,
                snapshot_id=test.id,
                delivery_type_config={
                    "point_in_time": True,
                    "target_cluster_name": cluster_test["name"],
                    "target_project_id": cluster_test["projectId"],
                    "point_in_time_utc_seconds": point_in_time_utc_seconds,
                }))
        ```

        ### Available complete examples
        - Restore from backup snapshot at point in time
        - Restore from backup snapshot using an advanced cluster resource

        ## Import

        Cloud Backup Snapshot Restore Job entries can be imported using project project_id, cluster_name and snapshot_id (Unique identifier of the snapshot), in the format `PROJECTID-CLUSTERNAME-JOBID`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cloudBackupSnapshotRestoreJob:CloudBackupSnapshotRestoreJob test 5cf5a45a9ccf6400e60981b6-MyCluster-5d1b654ecf09a24b888f4c79
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/cloud-backup/restore/restores/)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input[Union['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs', 'CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgsDict']] delivery_type_config: Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
               * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
               * `delivery_type_config.download` - Set to `true` to use the download configuration.
               * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
               * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
               * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
               * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input[_builtins.str] snapshot_id: Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudBackupSnapshotRestoreJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Example automated delivery type

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="MyCluster",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": "EU_WEST_2",
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test = mongodbatlas.index.CloudProviderSnapshot("test",
            project_id=my_cluster.project_id,
            cluster_name=my_cluster.name,
            description=myDescription,
            retention_in_days=1)
        test_cloud_backup_snapshot_restore_job = mongodbatlas.CloudBackupSnapshotRestoreJob("test",
            project_id=test["projectId"],
            cluster_name=test["clusterName"],
            snapshot_id=test["snapshotId"],
            delivery_type_config={
                "automated": True,
                "target_cluster_name": "MyCluster",
                "target_project_id": "5cf5a45a9ccf6400e60981b6",
            })
        ```

        ### Example download delivery type

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="MyCluster",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": "EU_WEST_2",
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test = mongodbatlas.index.CloudProviderSnapshot("test",
            project_id=my_cluster.project_id,
            cluster_name=my_cluster.name,
            description=myDescription,
            retention_in_days=1)
        test_cloud_backup_snapshot_restore_job = mongodbatlas.CloudBackupSnapshotRestoreJob("test",
            project_id=test["projectId"],
            cluster_name=test["clusterName"],
            snapshot_id=test["snapshotId"],
            delivery_type_config={
                "download": True,
            })
        ```

        ### Example of a point in time restore
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        my_cluster = mongodbatlas.AdvancedCluster("my_cluster",
            project_id="<PROJECT-ID>",
            name="MyCluster",
            cluster_type="REPLICASET",
            backup_enabled=True,
            replication_specs=[{
                "region_configs": [{
                    "priority": 7,
                    "provider_name": "AWS",
                    "region_name": "EU_WEST_2",
                    "electable_specs": {
                        "instance_size": "M10",
                        "node_count": 3,
                    },
                }],
            }])
        test = mongodbatlas.CloudBackupSnapshot("test",
            project_id=cluster_test["projectId"],
            cluster_name=cluster_test["name"],
            description="My description",
            retention_in_days=1)
        test_cloud_backup_snapshot_restore_job = []
        for range in [{"value": i} for i in range(0, 0 if point_in_time_utc_seconds == 0 else 1)]:
            test_cloud_backup_snapshot_restore_job.append(mongodbatlas.CloudBackupSnapshotRestoreJob(f"test-{range['value']}",
                project_id=test.project_id,
                cluster_name=test.cluster_name,
                snapshot_id=test.id,
                delivery_type_config={
                    "point_in_time": True,
                    "target_cluster_name": cluster_test["name"],
                    "target_project_id": cluster_test["projectId"],
                    "point_in_time_utc_seconds": point_in_time_utc_seconds,
                }))
        ```

        ### Available complete examples
        - Restore from backup snapshot at point in time
        - Restore from backup snapshot using an advanced cluster resource

        ## Import

        Cloud Backup Snapshot Restore Job entries can be imported using project project_id, cluster_name and snapshot_id (Unique identifier of the snapshot), in the format `PROJECTID-CLUSTERNAME-JOBID`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/cloudBackupSnapshotRestoreJob:CloudBackupSnapshotRestoreJob test 5cf5a45a9ccf6400e60981b6-MyCluster-5d1b654ecf09a24b888f4c79
        ```
        For more information see: [MongoDB Atlas API Reference.](https://docs.atlas.mongodb.com/reference/api/cloud-backup/restore/restores/)

        :param str resource_name: The name of the resource.
        :param CloudBackupSnapshotRestoreJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudBackupSnapshotRestoreJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_type_config: Optional[pulumi.Input[Union['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs', 'CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudBackupSnapshotRestoreJobArgs.__new__(CloudBackupSnapshotRestoreJobArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["delivery_type_config"] = delivery_type_config
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["cancelled"] = None
            __props__.__dict__["delivery_urls"] = None
            __props__.__dict__["expired"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["failed"] = None
            __props__.__dict__["finished_at"] = None
            __props__.__dict__["snapshot_restore_job_id"] = None
            __props__.__dict__["timestamp"] = None
        super(CloudBackupSnapshotRestoreJob, __self__).__init__(
            'mongodbatlas:index/cloudBackupSnapshotRestoreJob:CloudBackupSnapshotRestoreJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cancelled: Optional[pulumi.Input[_builtins.bool]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_type_config: Optional[pulumi.Input[Union['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs', 'CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgsDict']]] = None,
            delivery_urls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            expired: Optional[pulumi.Input[_builtins.bool]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            failed: Optional[pulumi.Input[_builtins.bool]] = None,
            finished_at: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
            snapshot_restore_job_id: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp: Optional[pulumi.Input[_builtins.str]] = None) -> 'CloudBackupSnapshotRestoreJob':
        """
        Get an existing CloudBackupSnapshotRestoreJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] cancelled: Indicates whether the restore job was canceled.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input[Union['CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgs', 'CloudBackupSnapshotRestoreJobDeliveryTypeConfigArgsDict']] delivery_type_config: Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
               * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
               * `delivery_type_config.download` - Set to `true` to use the download configuration.
               * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
               * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
               * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
               * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
               * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] delivery_urls: One or more URLs for the compressed snapshot files for manual download. Only visible if deliveryType is download.
        :param pulumi.Input[_builtins.bool] expired: Indicates whether the restore job expired.
        :param pulumi.Input[_builtins.str] expires_at: UTC ISO 8601 formatted point in time when the restore job expires.
        :param pulumi.Input[_builtins.bool] failed: Indicates whether the restore job failed.
        :param pulumi.Input[_builtins.str] finished_at: UTC ISO 8601 formatted point in time when the restore job completed.
        :param pulumi.Input[_builtins.str] project_id: The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        :param pulumi.Input[_builtins.str] snapshot_id: Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        :param pulumi.Input[_builtins.str] snapshot_restore_job_id: The unique identifier of the restore job.
        :param pulumi.Input[_builtins.str] timestamp: Timestamp in ISO 8601 date and time format in UTC when the snapshot associated to snapshotId was taken.
               * `oplogTs` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot.
               Three conditions apply to this parameter:
               * Enable Continuous Cloud Backup on your cluster.
               * Specify oplogInc.
               * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
               * `oplogInc` - Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp.
               Three conditions apply to this parameter:
               * Enable Continuous Cloud Backup on your cluster.
               * Specify oplogTs.
               * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
               * `pointInTimeUTCSeconds` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot.
               Two conditions apply to this parameter:
               * Enable Continuous Cloud Backup on your cluster.
               * Specify either pointInTimeUTCSeconds or oplogTs and oplogInc, but not both.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudBackupSnapshotRestoreJobState.__new__(_CloudBackupSnapshotRestoreJobState)

        __props__.__dict__["cancelled"] = cancelled
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["delivery_type_config"] = delivery_type_config
        __props__.__dict__["delivery_urls"] = delivery_urls
        __props__.__dict__["expired"] = expired
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["failed"] = failed
        __props__.__dict__["finished_at"] = finished_at
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["snapshot_id"] = snapshot_id
        __props__.__dict__["snapshot_restore_job_id"] = snapshot_restore_job_id
        __props__.__dict__["timestamp"] = timestamp
        return CloudBackupSnapshotRestoreJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cancelled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the restore job was canceled.
        """
        return pulumi.get(self, "cancelled")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Atlas cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="deliveryTypeConfig")
    def delivery_type_config(self) -> pulumi.Output[Optional['outputs.CloudBackupSnapshotRestoreJobDeliveryTypeConfig']]:
        """
        Type of restore job to create. Possible configurations are: **download**, **automated**, or **pointInTime** only one must be set it in ``true``.
        * `delivery_type_config.automated` - Set to `true` to use the automated configuration.
        * `delivery_type_config.download` - Set to `true` to use the download configuration.
        * `delivery_type_config.pointInTime` - Set to `true` to use the pointInTime configuration. If using pointInTime configuration, you must also specify either `oplog_ts` and `oplog_inc`, or `point_in_time_utc_seconds`.
        * `delivery_type_config.target_cluster_name` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
        * `delivery_type_config.target_project_id` - Name of the target Atlas cluster to which the restore job restores the snapshot. Required for **automated** and **pointInTime**.
        * `delivery_type_config.oplog_ts` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot. This is the first part of an Oplog timestamp.
        * `delivery_type_config.oplog_inc` - Optional setting for **pointInTime** configuration. Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp. Used in conjunction with `oplog_ts`.
        * `delivery_type_config.point_in_time_utc_seconds` - Optional setting for **pointInTime** configuration. Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot. Used instead of oplog settings.
        """
        return pulumi.get(self, "delivery_type_config")

    @_builtins.property
    @pulumi.getter(name="deliveryUrls")
    def delivery_urls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        One or more URLs for the compressed snapshot files for manual download. Only visible if deliveryType is download.
        """
        return pulumi.get(self, "delivery_urls")

    @_builtins.property
    @pulumi.getter
    def expired(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the restore job expired.
        """
        return pulumi.get(self, "expired")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        """
        UTC ISO 8601 formatted point in time when the restore job expires.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter
    def failed(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the restore job failed.
        """
        return pulumi.get(self, "failed")

    @_builtins.property
    @pulumi.getter(name="finishedAt")
    def finished_at(self) -> pulumi.Output[_builtins.str]:
        """
        UTC ISO 8601 formatted point in time when the restore job completed.
        """
        return pulumi.get(self, "finished_at")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the project for the Atlas cluster whose snapshot you want to restore.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional setting for **pointInTime** configuration. Unique identifier of the snapshot to restore.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="snapshotRestoreJobId")
    def snapshot_restore_job_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the restore job.
        """
        return pulumi.get(self, "snapshot_restore_job_id")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp in ISO 8601 date and time format in UTC when the snapshot associated to snapshotId was taken.
        * `oplogTs` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which to you want to restore this snapshot.
        Three conditions apply to this parameter:
        * Enable Continuous Cloud Backup on your cluster.
        * Specify oplogInc.
        * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
        * `oplogInc` - Oplog operation number from which to you want to restore this snapshot. This is the second part of an Oplog timestamp.
        Three conditions apply to this parameter:
        * Enable Continuous Cloud Backup on your cluster.
        * Specify oplogTs.
        * Specify either oplogTs and oplogInc or pointInTimeUTCSeconds, but not both.
        * `pointInTimeUTCSeconds` - Timestamp in the number of seconds that have elapsed since the UNIX epoch from which you want to restore this snapshot.
        Two conditions apply to this parameter:
        * Enable Continuous Cloud Backup on your cluster.
        * Specify either pointInTimeUTCSeconds or oplogTs and oplogInc, but not both.
        """
        return pulumi.get(self, "timestamp")

