# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCustomDbRoleResult',
    'AwaitableGetCustomDbRoleResult',
    'get_custom_db_role',
    'get_custom_db_role_output',
]

@pulumi.output_type
class GetCustomDbRoleResult:
    """
    A collection of values returned by getCustomDbRole.
    """
    def __init__(__self__, actions=None, id=None, inherited_roles=None, project_id=None, role_name=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inherited_roles and not isinstance(inherited_roles, list):
            raise TypeError("Expected argument 'inherited_roles' to be a list")
        pulumi.set(__self__, "inherited_roles", inherited_roles)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetCustomDbRoleActionResult']:
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inheritedRoles")
    def inherited_roles(self) -> Optional[Sequence['outputs.GetCustomDbRoleInheritedRoleResult']]:
        return pulumi.get(self, "inherited_roles")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> _builtins.str:
        """
        (Required) Name of the inherited role. This can either be another custom role or a built-in role.
        """
        return pulumi.get(self, "role_name")


class AwaitableGetCustomDbRoleResult(GetCustomDbRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomDbRoleResult(
            actions=self.actions,
            id=self.id,
            inherited_roles=self.inherited_roles,
            project_id=self.project_id,
            role_name=self.role_name)


def get_custom_db_role(inherited_roles: Optional[Sequence[Union['GetCustomDbRoleInheritedRoleArgs', 'GetCustomDbRoleInheritedRoleArgsDict']]] = None,
                       project_id: Optional[_builtins.str] = None,
                       role_name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomDbRoleResult:
    """
    ## # Data Source: CustomDbRole

    `CustomDbRole` describes a Custom DB Role. This represents a custom db role.

    > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_role = mongodbatlas.CustomDbRole("test_role",
        project_id="<PROJECT-ID>",
        role_name="myCustomRole",
        actions=[
            {
                "action": "UPDATE",
                "resources": [{
                    "collection_name": "",
                    "database_name": "anyDatabase",
                }],
            },
            {
                "action": "INSERT",
                "resources": [{
                    "collection_name": "",
                    "database_name": "anyDatabase",
                }],
            },
        ])
    test = mongodbatlas.get_custom_db_role_output(project_id=test_role.project_id,
        role_name=test_role.role_name)
    ```


    :param _builtins.str project_id: The unique ID for the project.
    :param _builtins.str role_name: Name of the custom role.
    """
    __args__ = dict()
    __args__['inheritedRoles'] = inherited_roles
    __args__['projectId'] = project_id
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getCustomDbRole:getCustomDbRole', __args__, opts=opts, typ=GetCustomDbRoleResult).value

    return AwaitableGetCustomDbRoleResult(
        actions=pulumi.get(__ret__, 'actions'),
        id=pulumi.get(__ret__, 'id'),
        inherited_roles=pulumi.get(__ret__, 'inherited_roles'),
        project_id=pulumi.get(__ret__, 'project_id'),
        role_name=pulumi.get(__ret__, 'role_name'))
def get_custom_db_role_output(inherited_roles: Optional[pulumi.Input[Optional[Sequence[Union['GetCustomDbRoleInheritedRoleArgs', 'GetCustomDbRoleInheritedRoleArgsDict']]]]] = None,
                              project_id: Optional[pulumi.Input[_builtins.str]] = None,
                              role_name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCustomDbRoleResult]:
    """
    ## # Data Source: CustomDbRole

    `CustomDbRole` describes a Custom DB Role. This represents a custom db role.

    > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_role = mongodbatlas.CustomDbRole("test_role",
        project_id="<PROJECT-ID>",
        role_name="myCustomRole",
        actions=[
            {
                "action": "UPDATE",
                "resources": [{
                    "collection_name": "",
                    "database_name": "anyDatabase",
                }],
            },
            {
                "action": "INSERT",
                "resources": [{
                    "collection_name": "",
                    "database_name": "anyDatabase",
                }],
            },
        ])
    test = mongodbatlas.get_custom_db_role_output(project_id=test_role.project_id,
        role_name=test_role.role_name)
    ```


    :param _builtins.str project_id: The unique ID for the project.
    :param _builtins.str role_name: Name of the custom role.
    """
    __args__ = dict()
    __args__['inheritedRoles'] = inherited_roles
    __args__['projectId'] = project_id
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('mongodbatlas:index/getCustomDbRole:getCustomDbRole', __args__, opts=opts, typ=GetCustomDbRoleResult)
    return __ret__.apply(lambda __response__: GetCustomDbRoleResult(
        actions=pulumi.get(__response__, 'actions'),
        id=pulumi.get(__response__, 'id'),
        inherited_roles=pulumi.get(__response__, 'inherited_roles'),
        project_id=pulumi.get(__response__, 'project_id'),
        role_name=pulumi.get(__response__, 'role_name')))
