# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-10-20 08:12
from __future__ import unicode_literals

from django.db import migrations

from resolwe.flow.models.utils import hydrate_size


def calculate_size(apps, schema_editor):
    """Compute ``size`` attribute in Data model."""
    Data = apps.get_model("flow", "Data")
    for data in Data.objects.all():
        hydrate_size(data, force=True)
        data.save()


def reverse_migration(apps, schema_editor):
    """
    Reverse migration.

    This function can be emty, since ``size`` field will be deleted in
    next step i.e. previous migration.
    """
    pass


class Migration(migrations.Migration):

    dependencies = [
        ("flow", "0007_data_size"),
    ]

    operations = [
        migrations.RunPython(calculate_size, reverse_migration),
    ]
