# Generated by Django 2.2.10 on 2020-05-12 08:44
from django.db import migrations


def assign_referenced_paths(apps, schema_editor):
    """Assign referenced paths to storage locations."""
    FileStorage = apps.get_model("storage", "FileStorage")
    ids = set()
    for file_storage in FileStorage.objects.all():
        for storage_location in file_storage.storage_locations.all():
            storage_location.files.add(*file_storage.files.all())
            for rp in file_storage.files.all():
                ids.add(rp.id)


class Migration(migrations.Migration):
    dependencies = [
        ("storage", "0005_referencedpath_storage_locations"),
    ]

    operations = [
        migrations.RunPython(assign_referenced_paths),
    ]
