"""Fixtures that return paths to jabs .h5 files."""

import pytest


@pytest.fixture
def jabs_real_data_v2():
    """A real data example containing predicted single mouse poses.

    This project:
    - Was generated by the Kumar lab group at Jax
    - Contains 100 frames worth of predictions from a video (not included)
    - Provides pose data and keypoint confidences

    """
    return "tests/data/jabs/example_pose_est_v2.h5"


@pytest.fixture
def jabs_real_data_v5():
    """A real data example containing predicted multi mouse poses.

    This project:
    - Was generated by the Kumar lab group at Jax
    - Contains 250 frames worth of predictions from a video (not included)
    - Provides pose data, keypoint confidences, assigned identities, and static objects
    - Included static objects are arena corners
    - Tracklet from frame 228 -> 232 do not get assigned a longterm ID, but still
      contain pose data

    """
    return "tests/data/jabs/example_pose_est_v5.h5"
